
{ ******************************************************


              Swallow Turbo Vision 1 Adapter v1.0


    (c) 1995 by Topical Software

  ****************************************************** }


unit SwaTV1;

interface

{$X+,G+,F+,R-,S+}

implementation

uses
  Swallow, Drivers, Dialogs, Views, Editors, Memory, Objects, Menus,
  Buffers;

{ unit memory }

type
  PMemBuffer = ^TMemBuffer;
  TMemBuffer = record
    Size: Word;
    Master: ^Pointer;
    Data: record end;
  end;

const
  BufferPtr: Pointer = nil;

var
  Equipment: Word absolute $40:$10;
  CrtRows: Byte absolute $40:$84;
  CrtInfo: Byte absolute $40:$87;

{ Save registers and call video interrupt }

procedure Swallow_VideoInt; near; assembler;
asm
	PUSH	BP
	PUSH	ES
	INT	10H
	POP	ES
	POP	BP
end;

{ Return CRT mode in AX and dimensions in DX }

procedure Swallow_GetCrtMode; near; assembler;
asm
	MOV	AH,0FH
	CALL	Swallow_VideoInt
	PUSH	AX
	MOV	AX,1130H
	MOV	BH,0
	MOV	DL,0
	CALL	Swallow_VideoInt
	POP	AX
	MOV	DH,AH
	CMP	DL,25
	SBB	AH,AH
	INC	AH
end;

{ Set CRT mode to value in AX }

procedure Swallow_SetCrtMode; near; assembler;
asm
	MOV	BX,SEG Equipment
	MOV	ES,BX
	MOV	BL,20H
	CMP	AL,smMono
	JNE	@@1
	MOV	BL,30H
@@1:	AND	ES:Equipment.Byte,0CFH
	OR	ES:Equipment.Byte,BL
	AND	ES:CrtInfo,0FEH
	PUSH	AX
	MOV	AH,0
	CALL	Swallow_VideoInt
	POP	AX
	OR	AH,AH
	JE	@@2
	MOV	AX,1112H
	MOV	BL,0
	CALL	Swallow_VideoInt
	MOV	AX,1130H
	MOV	BH,0
	MOV	DL,0
	CALL	Swallow_VideoInt
	CMP	DL,42
	JNE	@@2
	OR	ES:CrtInfo,1
	MOV	AH,1
	MOV	CX,600H
	CALL	Swallow_VideoInt
	MOV	AH,12H
	MOV	BL,20H
	CALL	Swallow_VideoInt
@@2:
end;

{ Fix CRT mode in AX if required }

procedure Swallow_FixCrtMode; near; assembler;
asm
	CMP	AL,smMono
	JE	@@1
	CMP	AL,smCO80
	JE	@@1
	CMP	AL,smBW80
	JE	@@1
	MOV	AX,smCO80
@@1:
end;

{ Set CRT data areas and mouse range }

procedure Swallow_SetCrtData; near; assembler;
asm
	CALL	Swallow_GetCrtMode
	MOV	CL,1
	OR	DL,DL
	JNE	@@1
	MOV	CL,0
	MOV	DL,24
@@1:	INC	DL
	MOV	ScreenMode,AX
	MOV	ScreenWidth,DH
	MOV	ScreenHeight,DL
	MOV	HiResScreen,CL
	XOR	CL,1
	MOV	BX,SegB800
	CMP	AL,smMono
	JNE	@@2
	MOV	CL,0
	MOV	BX,SegB000
@@2:	MOV	CheckSnow,CL
	XOR	AX,AX
	MOV	ScreenBuffer.Word[0],AX
	MOV	ScreenBuffer.Word[2],BX
	MOV	AH,3
	MOV	BH,0
	CALL	Swallow_VideoInt
	MOV	CursorLines,CX
	MOV	AH,1
	MOV	CX,2000H
	CALL	Swallow_VideoInt
	CMP	ButtonCount,0
	JE	@@4
	MOV	AX,7
	MOV	DL,ScreenWidth
	CALL	@@3
	MOV	AX,8
	MOV	DL,ScreenHeight
@@3:	XOR	DH,DH
	MOV	CL,3
	SHL	DX,CL
	DEC	DX
	XOR	CX,CX
	INT	33H
@@4:
end;

procedure Swallow_InitVideo; assembler;
asm
	CALL	Swallow_GetCrtMode
	MOV	StartupMode,AX
	CMP	AX,ScreenMode
	JE	@@1
	MOV	AX,ScreenMode
	CALL	Swallow_SetCrtMode
@@1:	CALL	Swallow_SetCrtData
end;

procedure Swallow_SetVideoMode(Mode: Word); assembler;
asm
	MOV	AX,Mode
	CALL	Swallow_FixCrtMode
	CALL	Swallow_SetCrtMode
	CALL	Swallow_SetCrtData
end;

function Swallow_HotKey(var S: String): Char;
var
  P: Word;
begin
  P := Pos('~',S);
  if P <> 0 then Swallow_HotKey := UpCase(S[P+1])
  else Swallow_HotKey := #0;
end;

procedure TLabel_HandleEvent(var Event: TEvent; var Self : TLabel);
var
  C: Char;
begin
  asm
        push    word ptr Event + 2
        push    word ptr Event
        push    word ptr Self + 2
        push    word ptr Self
        call    TStaticText.HandleEvent
  end;
{  TStaticText.HandleEvent(Event);}
  if Event.What = evMouseDown then
  begin
    if Self.Link <> nil then Self.Link^.Select;
    Self.ClearEvent(Event);
  end
  else if Event.What = evKeyDown then
  begin
    C := Swallow_HotKey(Self.Text^);
    if (GetAltCode(C) = Event.KeyCode) or
       ((C <> #0) and (Self.Owner^.Phase = phPostProcess) and
        (UpCase(Event.CharCode) = C)) then
    begin
      if Self.Link <> nil then Self.Link^.Select;
      Self.ClearEvent(Event);
    end;
  end
  else if Event.What = evBroadcast then
    if (Event.Command = cmReceivedFocus) or
       (Event.Command = cmReleasedFocus) then
    begin
      if PointerIsValid(Self.Link) then
        Self.Light := Self.Link^.State and sfFocused <> 0;
      Self.DrawView;
    end;
end;

procedure TEditor_UpdateCommands(var Self : TEditor);

  function HasSelection(var Self : TEditor): Boolean;
  begin
    HasSelection := Self.SelStart <> Self.SelEnd;
  end;

begin
  Self.SetCmdState(cmUndo, (Self.DelCount <> 0) or (Self.InsCount <> 0));
  if not (Clipboard = @Self) then
  begin
    Self.SetCmdState(cmCut, HasSelection(Self));
    Self.SetCmdState(cmCopy, HasSelection(Self));
    Self.SetCmdState(cmPaste, (Clipboard <> nil) and PointerIsValid(Clipboard)
      and (HasSelection(Clipboard^)));
  end;
  Self.SetCmdState(cmClear, HasSelection(Self));
  Self.SetCmdState(cmFind, True);
  Self.SetCmdState(cmReplace, True);
  Self.SetCmdState(cmSearchAgain, True);
end;

function Swallow_LowMemory: Boolean;
begin
  if SwallowIsActive = swa_inactive then asm
	MOV	AX,HeapEnd.Word[2]
	SUB	AX,HeapPtr.Word[2]
	SUB	AX,LowMemSize
	SBB	AX,AX
	NEG	AX
        mov     @Result,al
  end else asm
        mov     ax,knf_getlinearmeminfo
        int     32h
        db      66h
        xor     bx,bx
        mov     bx,LowMemSize
        db      66h
        sub     ax,bx
        db      66h
        sub     ax,12*1024
        dw      0
        db      66h
        sbb     ax,ax
        neg     ax
        mov     @Result,al
  end
end;

function Swallow_MemAllocSeg(Size: Word): Pointer;
var
  P, T: Pointer;
begin
  if SwallowIsActive = swa_inactive then begin
    Size := (Size + 7) and $FFF8;
    P := MemAlloc(Size + 8);
    if P <> nil then
    begin
      if PtrRec(P).Ofs = 0 then
      begin
        PtrRec(T).Ofs := Size and 15;
        PtrRec(T).Seg := PtrRec(P).Seg + Size shr 4;
      end else
      begin
        T := P;
        PtrRec(P).Ofs := 0;
        Inc(PtrRec(P).Seg);
      end;
      FreeMem(T, 8);
    end;
    Swallow_MemAllocSeg := P;
  end else begin
    P:= Swallow.MemAllocSeg(Size);
    if LowMemory then begin
      FreeMem(P, Size);
      Swallow_MemAllocSeg := NIL
    end else
      Swallow_MemAllocSeg := P;
  end
end;

procedure Swallow_GetBufMem(var P: Pointer; Size: Word);
var
  Rec : PMemBuffer;

begin
  if SwallowIsActive = swa_inactive then asm
	LES	DI,P
	MOV	AX,Size
	ADD	AX,(TYPE TMemBuffer)+15
	MOV	CL,4
	SHR	AX,CL
	MOV	DX,BufferPtr.Word[2]
	SUB	DX,AX
	JC	@@1
	CMP	DX,HeapPtr.Word[2]
	JBE	@@1
	MOV     CX,HeapEnd.Word[2]
	SUB	CX,DX
	CMP	CX,MaxBufMem
	JA	@@1
	MOV	BufferPtr.Word[2],DX
	PUSH	DS
	MOV	DS,DX
	XOR	SI,SI
	MOV	DS:[SI].TMemBuffer.Size,AX
	MOV	DS:[SI].TMemBuffer.Master.Word[0],DI
	MOV	DS:[SI].TMemBuffer.Master.Word[2],ES
	POP	DS
	MOV	AX,OFFSET TMemBuffer.Data
	JMP	@@2
@@1:	XOR	AX,AX
	CWD
@@2:	CLD
	STOSW
	XCHG	AX,DX
	STOSW
  end else begin
    Rec := MemAllocSeg(Size+sizeof(TMemBuffer));
    if Rec = Nil then
      P := Nil
    else begin
      Rec^.Master := @P;
      Rec^.Size := Size;
      P := @Rec^.Data
    end
  end
end;

procedure Swallow_FreeBufMem(P: Pointer);
var
  Rec : PMemBuffer;

begin
  if SwallowIsActive = swa_Inactive then asm
	MOV	AX,BufferPtr.Word[2]
	XOR	BX,BX
	XOR	CX,CX
	MOV	DX,P.Word[2]
@@1:	MOV	ES,AX
	CMP	AX,DX
	JE	@@2
	ADD	AX,ES:[BX].TMemBuffer.Size
	CMP	AX,HeapEnd.Word[2]
	JE	@@2
	PUSH	ES
	INC	CX
	JMP	@@1
@@2:	PUSH	ES
	LES	DI,ES:[BX].TMemBuffer.Master
	XOR	AX,AX
	CLD
	STOSW
	STOSW
	POP	ES
	MOV	AX,ES:[BX].TMemBuffer.Size
	JCXZ	@@4
@@3:	POP	DX
	PUSH	DS
	PUSH	CX
	MOV	DS,DX
	ADD	DX,AX
	MOV	ES,DX
	MOV	SI,DS:[BX].TMemBuffer.Size
	MOV	CL,3
	SHL	SI,CL
	MOV	CX,SI
	SHL	SI,1
	DEC	SI
	DEC	SI
	MOV	DI,SI
	STD
	REP	MOVSW
	LDS	SI,ES:[BX].TMemBuffer.Master
	MOV	DS:[SI].Word[2],ES
	POP	CX
	POP	DS
	LOOP	@@3
@@4:	ADD	BufferPtr.Word[2],AX
  end else begin
    if P <> NIL then begin
      Rec := Ptr(PtrRec(P).Seg, PtrRec(P).Ofs - sizeof(TMemBuffer));
      Rec^.Master^ := Nil;
      FreeMem(Rec, Rec^.Size + sizeof(TMemBuffer));
    end
  end
end;

procedure Swallow_SetMemTop(MemTop: Pointer);
begin
  if SwallowIsActive = swa_Inactive then asm
	MOV	BX,MemTop.Word[0]
	ADD	BX,15
	MOV	CL,4
	SHR	BX,CL
	ADD	BX,MemTop.Word[2]
	MOV	AX,PrefixSeg
	SUB	BX,AX
	MOV	ES,AX
	MOV	AH,4AH
	INT	21H
  end
end;

function Swallow_NewItem(Name, Param: TMenuStr; KeyCode: Word; Command: Word;
  AHelpCtx: Word; Next: PMenuItem): PMenuItem;
var
  P: PMenuItem;
  T: PView;
begin
  if (Name <> '') and (Command <> 0) then
  begin
    New(P);
    P^.Next := Next;
    P^.Name := NewStr(Name);
    P^.Command := Command;
    T := NIL;                   { only to store a valid value }
    P^.Disabled := not T^.CommandEnabled(Command);
    P^.KeyCode := KeyCode;
    P^.HelpCtx := AHelpCtx;
    P^.Param := NewStr(Param);
    Swallow_NewItem := P;
  end else
  Swallow_NewItem := Next;
end;

{ The constructor "Load" sets "count" to the stored value and "limit" to
  zero and uses "SetLimit" to set correct limit. So this function
  copies "count" entries from nowhere. }

procedure TCollection_SetLimit(ALimit: Integer; var Self : TCollection);
var
  AItems: PItemList;
begin
  if ALimit < Self.Count then ALimit := Self.Count;
  if ALimit > MaxCollectionSize then ALimit := MaxCollectionSize;
  if ALimit <> Self.Limit then
  begin
    if ALimit = 0 then AItems := nil else
    begin
      GetMem(AItems, ALimit * SizeOf(Pointer));
      if (Self.Count <> 0) and (Self.Limit <> 0) then
        Move(Self.Items^, AItems^, Self.Count * SizeOf(Pointer));
    end;
    if Self.Limit <> 0 then FreeMem(Self.Items, Self.Limit * SizeOf(Pointer));
    Self.Items := AItems;
    Self.Limit := ALimit;
  end;
end;

procedure TScroller_SetState(AState: Word; Enable: Boolean; var Self : TScroller);

procedure ShowSBar(SBar: PScrollBar);
begin
  if (SBar <> nil) and PointerIsValid(SBar) then
    if Self.GetState(sfActive + sfSelected) then SBar^.Show
    else SBar^.Hide;
end;

begin
  asm
        push    AState
        push    word ptr Enable
        push    word ptr Self + 2
        push    word ptr Self
        call    TView.SetState
  end;
{  TView.SetState(AState, Enable);}
  if AState and (sfActive + sfSelected) <> 0 then
  begin
    ShowSBar(Self.HScrollBar);
    ShowSBar(Self.VScrollBar);
  end;
end;

procedure TListViewer_SetState(AState: Word; Enable: Boolean; var Self : TListViewer);

procedure ShowSBar(SBar: PScrollBar);
begin
  if (SBar <> nil) and PointerIsValid(SBar) then
    if Self.GetState(sfActive) then SBar^.Show
    else SBar^.Hide;
end;

begin
  asm
        push    AState
        push    word ptr Enable
        push    word ptr Self + 2
        push    word ptr Self
        call    TView.SetState
  end;
{  TView.SetState(AState, Enable);}
  if AState and (sfSelected + sfActive) <> 0 then
  begin
    ShowSBar(Self.HScrollBar);
    ShowSBar(Self.VScrollBar);
    Self.DrawView;
  end;
end;

procedure TWindow_HandleEvent(var Event: TEvent; var Self : TWindow);
var
  Limits: TRect;
  Min, Max: TPoint;
begin
  asm
        push    word ptr Event + 2
        push    word ptr Event
        push    word ptr Self + 2
        push    word ptr Self
        call    TGroup.HandleEvent
  end;
{  TGroup.HandleEvent(Event);}
  if (Event.What = evCommand) then
    case Event.Command of
      cmResize:
        if Self.Flags and (wfMove + wfGrow) <> 0 then
        begin
          Self.Owner^.GetExtent(Limits);
          Self.SizeLimits(Min, Max);
          Self.DragView(Event, Self.DragMode or (Self.Flags and (wfMove + wfGrow)),
            Limits, Min, Max);
          Self.ClearEvent(Event);
        end;
      cmClose:
        if (Self.Flags and wfClose <> 0) and
          ((Event.InfoPtr = nil) or (Event.InfoPtr = @Self)) then
        begin
          if Self.State and sfModal = 0 then begin
            Self.ClearEvent(Event);
            Self.Close
          end else begin
            Event.What := evCommand;
            Event.Command := cmCancel;
            Self.PutEvent(Event);
            Self.ClearEvent(Event)
          end
        end;
      cmZoom:
        if (Self.Flags and wfZoom <> 0) and
          ((Event.InfoPtr = nil) or (Event.InfoPtr = @Self)) then
        begin
          Self.Zoom;
          Self.ClearEvent(Event);
        end;
    end
  else if Event.What = evKeyDown then
    case Event.KeyCode of
      kbTab:
        begin
          Self.SelectNext(False);
          Self.ClearEvent(Event);
        end;
      kbShiftTab:
        begin
          Self.SelectNext(True);
          Self.ClearEvent(Event);
        end;
    end
  else if (Event.What = evBroadcast) and (Event.Command = cmSelectWindowNum)
         and (Event.InfoInt = Self.Number) and (Self.Options and ofSelectable <> 0) then
  begin
    Self.Select;
    Self.ClearEvent(Event);
  end;
end;


{ unit buffers }

const
  BufHeapSize: Word = 0;
  BufHeapPtr: Word = 0;
  BufHeapEnd: Word = 0;

type
  PBufBuffer = ^TBufBuffer;
  TBufBuffer = record
    Master: ^Word;
    Size: Word;
  end;

procedure MoveSeg(Source, Dest, Size: Word); assembler;
asm
	PUSH	DS
	MOV	AX,Source
	MOV	DX,Dest
	MOV	BX,Size
	CMP	AX,DX
	JB	@@3
	CLD
@@1:	MOV	CX,0FFFH
	CMP	CX,BX
	JB	@@2
	MOV	CX,BX
@@2:	MOV	DS,AX
	MOV	ES,DX
	ADD	AX,CX
	ADD	DX,CX
	SUB	BX,CX
	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	XOR	SI,SI
	XOR	DI,DI
	REP	MOVSW
	OR	BX,BX
	JNE	@@1
	JMP	@@6
@@3:	ADD	AX,BX
	ADD	DX,BX
	STD
@@4:	MOV	CX,0FFFH
	CMP	CX,BX
	JB	@@5
	MOV	CX,BX
@@5:    SUB	AX,CX
	SUB	DX,CX
	SUB	BX,CX
	MOV	DS,AX
	MOV	ES,DX
	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	MOV	SI,CX
	DEC	SI
	SHL	SI,1
	MOV	DI,SI
	REP	MOVSW
	OR	BX,BX
	JNE	@@4
@@6:	POP	DS
end;

function Swallow_GetBufSize(P: PBufBuffer): Word;
begin
  Swallow_GetBufSize := (P^.Size + 15) shr 4 + 1;
end;

procedure Swallow_SetBufSize(P: PBufBuffer; NewSize: Word);
var
  CurSize: Word;
begin
  CurSize := Swallow_GetBufSize(P);
  MoveSeg(PtrRec(P).Seg + CurSize, PtrRec(P).Seg + NewSize,
    BufHeapPtr - PtrRec(P).Seg - CurSize);
  Inc(BufHeapPtr, NewSize - CurSize);
  Inc(PtrRec(P).Seg, NewSize);
  while PtrRec(P).Seg < BufHeapPtr do
  begin
    Inc(P^.Master^, NewSize - CurSize);
    Inc(PtrRec(P).Seg, (P^.Size + 15) shr 4 + 1);
  end;
end;

procedure Swallow_InitBuffers;
var
  HeapSize: Word;
begin
  if SwallowIsActive = swa_Inactive then begin
    HeapSize := PtrRec(HeapEnd).Seg - PtrRec(HeapOrg).Seg;
    BufHeapPtr := PtrRec(HeapEnd).Seg - BufHeapSize;
    BufHeapEnd := PtrRec(HeapEnd).Seg;
    PtrRec(HeapEnd).Seg := BufHeapPtr;
  end
end;

procedure Swallow_DoneBuffers;
begin
  if SwallowIsActive = swa_Inactive then
    PtrRec(HeapEnd).Seg := BufHeapEnd;
end;
   
procedure Swallow_NewBuffer(var P: Pointer);
begin
  if SwallowIsActive = swa_Inactive then begin
    if BufHeapPtr = BufHeapEnd then P := nil else
    begin
      with PBufBuffer(Ptr(BufHeapPtr, 0))^ do
      begin
        Master := @PtrRec(P).Seg;
        Size := 0;
      end;
      Inc(BufHeapPtr);
      P := Ptr(BufHeapPtr, 0);
    end;
  end else
    P := MemAllocSeg(1);
end;

procedure Swallow_DisposeBuffer(P: Pointer);
begin
  if SwallowIsActive = swa_Inactive then begin
    Dec(PtrRec(P).Seg);
    Swallow_SetBufSize(P, 0);
  end else
    if P <> Nil then FreeMem(P, 0)      { swallow doesn't need the size }
end;

function Swallow_GetBufferSize(P: Pointer): Word;
begin
  case SwallowIsActive of
    swa_Inactive:
      begin
        Dec(PtrRec(P).Seg);
        Swallow_GetBufferSize := PBufBuffer(P)^.Size;
      end;
    swa_Protected:
      asm
        lsl ax,word ptr P + 2
        mov @Result,ax
      end;
    swa_Emulated:
      Swallow_GetBufferSize :=        { it's only a trick and not reliable }
        PWordArray(Ptr(PtrRec(P).Seg - 1, PtrRec(P).Ofs))^[0];
  end
end;

function Swallow_SetBufferSize(P: Pointer; Size: Word): Boolean;
var
  NewSize: Word;
begin
  if SwallowIsActive = swa_Inactive then begin
    Dec(PtrRec(P).Seg);
    NewSize := (Size + 15) shr 4 + 1;
    Swallow_SetBufferSize := False;
    if BufHeapPtr + NewSize - Swallow_GetBufSize(P) <= BufHeapEnd then
    begin
      Swallow_SetBufSize(P, NewSize);
      PBufBuffer(P)^.Size := Size;
      Swallow_SetBufferSize := True;
    end;
  end else begin
    Swallow_SetBufferSize := true;
    if Size = 0 then Size := 1;
    asm
        mov     bx,word ptr P + 2
        db      66h
        xor     cx,cx
        mov     cx,Size
        mov     ax,knf_resizewatchedmem
        int     32h
        jnc     @@1
        mov     @Result,false
    @@1:
    end
  end
end;

procedure Swallow_InitSysError; external;
procedure Swallow_DoneSysError; external;
{$L SwaSysIn.obj}

const
  PatchNum = 22;
  PatchAddr : array[1..PatchNum] of Pointer =
    (@InitVideo, @SetVideoMode, @TLabel.HandleEvent, @TEditor.UpdateCommands,
     @LowMemory, @MemAllocSeg, @GetBufMem, @FreeBufMem, @SetMemTop, @NewItem,
     @TCollection.SetLimit, @TScroller.SetState, @TListViewer.SetState,
     @TWindow.HandleEvent, @InitBuffers, @DoneBuffers, @NewBuffer,
     @DisposeBuffer, @GetBufferSize, @SetBufferSize, @InitSysError,
     @DoneSysError);
  PatchProc : array[1..PatchNum] of Pointer =
    (@Swallow_InitVideo, @Swallow_SetVideoMode, @TLabel_HandleEvent,
     @TEditor_UpdateCommands, @Swallow_LowMemory, @Swallow_MemAllocSeg,
     @Swallow_GetBufMem, @Swallow_FreeBufMem, @Swallow_SetMemTop,
     @Swallow_NewItem, @TCollection_SetLimit, @TScroller_SetState,
     @TListViewer_SetState, @TWindow_HandleEvent, @Swallow_InitBuffers,
     @Swallow_DoneBuffers, @Swallow_NewBuffer, @Swallow_DisposeBuffer,
     @Swallow_GetBufferSize, @Swallow_SetBufferSize, @Swallow_InitSysError,
     @Swallow_DoneSysError);
  
procedure PatchTurboVision;
var
  Counter : Integer;
  VPatchAddr, VPatchProc : Pointer;

begin
  if SwallowIsActive = swa_Inactive then exit;
  for Counter := 1 to PatchNum do begin
    VPatchAddr := PatchAddr[Counter];
    VPatchProc := PatchProc[Counter];
    asm
        mov     di,word ptr VPatchAddr
        mov     bx,word ptr VPatchAddr + 2
        mov     ax,knf_AllocAliasLD
        int     32h
        mov     es,ax
        mov     bx,ax
        cld
        mov     al,0eah
        stosb
        mov     ax,word ptr VPatchProc
        stosw
        mov     ax,word ptr VPatchProc + 2
        stosw
        mov     ax,knf_FreeLD
        int     32h
    end
  end
end;

begin
  PatchTurboVision
end.