
{ ******************************************************


              Swallow Turbo Pascal Adapter v1.0


    This unit must be linked in your program as
    the first one, because the initialisation code
    of the unit loads the DOS-Extender and switched
    into Protected Mode.

    The command line option "/Real" forces this
    unit to load the Real Mode-Emulator of the
    extender.

    If you compile this unit with the compiler
    option "NoSwallow", nothing of Swallow will be
    loaded and all function calls are redirected
    to the system-unit. In this way you can
    debug your program completely without Swallow.


    (c) 1995 by Topical Software

  ****************************************************** }


unit Swallow;

{$X+,G+,F+,S-,R-,D-}

interface

uses
  Dos,Objects;

procedure GetLockedMem(var p: pointer; size: Word);
procedure InitSwapFile(Drive : Integer; LeftSpace : LongInt);
function MemAllocSeg(Size : word): Pointer;
function PointerIsValid(p : pointer): Boolean;
function SaveGetMem(size: Word): Pointer;
function SetBreakCheck(CheckBreak : Boolean): Boolean;
procedure ShrinkMem;
procedure UseBaseMem;
function UseUnwatchedMem(UseIt : Boolean): Boolean;


{ assembler function codes of Swallow
  additional information offers Swallow.Doc }
const
  knf_AllocLD             = 0;
  knf_FreeLD              = 1;
  knf_Seg2Selector        = 2;
  knf_GetSegBase          = 3;
  knf_SetSegBase          = 4;
  knf_SetSegSize          = 5;
  knf_SetDesRights        = 6;
  knf_SetWholeDes         = 7;
  knf_AllocInitLD         = 8;
  knf_AllocAliasLD        = 9;

  knf_AllocDosMem         = $100;
  knf_FreeDosMem          = $101;
  knf_ResizeDosMem        = $102;

  knf_GetLinearMemInfo    = $200;
  knf_AllocLinearMem      = $201;
  knf_FreeLinearMem       = $202;
  knf_ResizeLinearMem     = $203;
  knf_LockLinearMem       = $204;
  knf_UnlockLinearMem     = $205;
  knf_DiscardLinearMem    = $206;
  knf_CommitLinearMem     = $207;
  knf_UncommitLinearMem   = $208;

  knf_GetWatchedMemInfo   = $300;
  knf_GetWatchedLockedMemInfo = $301;
  knf_AllocWatchedMem     = $302;
  knf_FreeWatchedMem      = $303;
  knf_ResizeWatchedMem    = $304;
  knf_LockWatchedMem      = $305;
  knf_UnlockWatchedMem    = $306;

  knf_GetUnwatchedMemInfo = $400;
  knf_AllocUnwatchedMem   = $401;
  knf_FreeUnwatchedMem    = $402;

  knf_AllocCallBack       = $500;
  knf_ReleaseCallBack     = $501;
  knf_GetProtIntVec       = $502;
  knf_SetProtIntVec       = $503;
  knf_XchgProtIntVec      = $504;
  knf_GetUserIRQ          = $505;
  knf_SetUserIRQ          = $506;
  knf_XchgUserIRQ         = $507;
  knf_GetUserExc          = $508;
  knf_SetUserExc          = $509;
  knf_XchgUserExc         = $50a;
  knf_CallV86Int          = $50b;
  knf_CallV86Proc         = $50c;
  knf_CallV86IRet         = $50d;

  knf_AllocDMABuffer      = $600;
  knf_ReleaseDMABuffer    = $601;

  knf_UseBaseMem          = $700;
  knf_ShrinkMem           = $701;
  knf_Terminate           = $702;
  knf_InitSwapFile        = $703;
  knf_SetBreakCheck       = $704;
  knf_GetSelName          = $705;
  knf_SetSelName          = $706;
  knf_GetPhysAddr         = $707;

  knf_NoCheck             = $8000;

{ Values of variable SwallowIsActive }

  swa_inactive            = 0;
  swa_protected           = 1;
  swa_emulated            = 2;

{ Read only-Variable showing status of Swallow }
const
  SwallowIsActive : Integer = swa_inactive;


{ standard v86-mode segments }
{$ifndef Ver70}
  seg0040 : Word = $0040;
  sega000 : Word = $a000;
  segb000 : Word = $b000;
  segb800 : Word = $b800;
{$endif}


implementation

{ internal flag, wether Unwatched memory should be used }
const
  UseUnwMem : Boolean = false;

{ internal procedures to init and terminate Swallow }
const
  EmulateSwallow : Boolean = false;

var
  DriverEntry : Pointer;
  SystemSeg : Word;

{ reduce base memory used }
procedure SetMemTop(MemTop: Pointer); assembler;
asm
	MOV	BX,MemTop.Word[0]
	ADD	BX,15
	MOV	CL,4
	SHR	BX,CL
	ADD	BX,MemTop.Word[2]
	MOV	AX,PrefixSeg
	SUB	BX,AX
	MOV	ES,AX
	MOV	AH,4AH
	INT	21H
end;

{ terminate Swallow }
procedure TerminateSwallow;
begin
  if DriverEntry <> Nil then begin
    asm
        mov  ax,1
        call [DriverEntry]
    end;
    DriverEntry:= Nil
  end
end;

{ load Swallow and switch into Protected Mode }
function InitSwallow: Boolean; far;
var
  DrvName : PathStr;
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;
  Driver, Segments : TDosStream;
  DriverSize : Word;
  DriverPos : Word;
  ErrorCode : Word;

begin
  InitSwallow:= false;
  DriverEntry:= Nil;
  DrvName:= ParamStr(0);

{ Search Swallow.Drv within current path and "PATH"-environment }
  Fsplit(DrvName, Dir, Name, Ext);
  DrvName:= FSearch('swallow.drv', Dir);
  if DrvName = '' then
    DrvName:= FSearch('swallow.drv', GetEnv('path'));
  Driver.Init(DrvName, stOpenRead);
  if Driver.Status <> stOk then begin
    Writeln('Fatal error: "Swallow.Drv" not found.');
    exit
  end;

{ reduce base memory used and load Swallow.Drv into DOS-memory }
  SetMemTop(HeapPtr);
  DriverSize:= Driver.GetSize shr 4;
  DriverPos:= 0;
  asm
    mov  bx,DriverSize
    mov  ah,48h
    int  21h
    jc   @@Error
    mov  DriverPos,ax
  @@Error:
  end;
  if (Driver.Status = stOk) and (DriverPos = 0) then begin
    Writeln('No temporary DOS-Memory left for Extender.');
    Exit;
  end;
  DriverEntry:= Ptr(DriverPos, 0);
  Driver.Read(DriverEntry^, DriverSize shl 4);
  DriverEntry:= Nil;
  if Driver.Status <> stOk then begin
    Writeln('Fatal error: "Swallow.Drv" not found.');
    exit
  end;
  Driver.Done;

{ open Segment Description File }
  Segments.Init(Dir + Name + '.SEG', stOpenRead);
  if Segments.Status <> stOk then begin
    Writeln('Fatal error: Segment Description file "*.SEG" not found.');
    exit;
  end;

{ initialise Swallow itself }
  DriverEntry:= Ptr(DriverPos, $80);  { Swallow.Drv contains 80h bytes header }
  SwapVectors;
  asm
        mov  al,EmulateSwallow        { flag, wether emulator should be load }
        call [DriverEntry]
        mov  word ptr DriverEntry,ax
        mov  word ptr DriverEntry + 2,dx
        mov  es,DriverPos             { release memory of Swallow.Drv }
        mov  ah,49h
        int  21h
  end;
  if DriverEntry = Nil then begin     { error initialising Swallow }
    TerminateSwallow;                 { error message was shown by Swallow }
    Halt(255)
  end;

{ switch into Protected Mode }
  asm
        xor  ax,ax
        mov  es,PrefixSeg
        mov  bx,Segments.Handle
        call [DriverEntry]
        mov  bx,seg @Data
        mov  ds,bx                    { reload data segment with selector }
        mov  ErrorCode,ax
  end;

{ show any kind of error, because Swallow does not contain error messages
  to save extended memory }
  SwallowIsActive:= Byte(EmulateSwallow) + 1;
  InitSwallow:= ErrorCode = 0;
  case Errorcode of
    1: begin
         Writeln('Segment Description file "*.SEG" is invalid.');
         exit;
       end;
    2: begin
         Writeln('Memory overflow during loading of EXE-file.');
         exit;
       end;
  end;
  Segments.Done;

{ reduce base memory usage }
  if (ErrorCode = 0) and not EmulateSwallow then asm
      mov  bx,PrefixSeg
      mov  ax,knf_Seg2Selector
      int  32h
      mov  es,ax
      mov  ah,4ah
      mov  bx,6                 { 60h byte of PSP }
      int  21h
      mov  @Result,true
  end
end;


{ public functions }

procedure GetLockedMem(var p: pointer; size: Word);
begin
  if SwallowIsActive = swa_inactive then GetMem(p, Size)
  else asm
        db   66h
        xor  bx,bx
        mov  bx,size
        xor  ax,ax
        or   bx,bx
        je   @@Exit
        mov  cl,12h
        mov  ax,knf_allocWatchedmem
        int  32h
@@Exit: les  di,p
        mov  word ptr es:[di],0
        mov  word ptr es:[di+2],ax
  end
end;

procedure InitSwapFile(Drive : Integer; LeftSpace : LongInt);
begin
  if SwallowIsActive <> swa_Inactive then asm
        mov     bl,byte ptr Drive
        db      66h
        mov     cx,word ptr LeftSpace
        mov     ax,knf_InitSwapFile
        int     32h
  end
end;

function MemAllocSeg(Size : word): Pointer;
var
  P, T: Pointer;

begin
  if SwallowIsActive = swa_inactive then begin
    Size := (Size + 7) and $FFF8;
    GetMem(P, Size + 8);
    if PtrRec(P).Ofs = 0 then
    begin
      PtrRec(T).Ofs := Size and 15;
      PtrRec(T).Seg := PtrRec(P).Seg + Size shr 4;
    end else
    begin
      T := P;
      PtrRec(P).Ofs := 0;
      Inc(PtrRec(P).Seg);
    end;
    FreeMem(T, 8);
    MemAllocSeg := P;
  end else asm
        xor  dx,dx
        mov  ax,Size
        or   ax,ax
        je   @@Exit
        db   66h
        xor  bx,bx
        mov  bx,ax
        mov  cl,2
        mov  ax,knf_AllocWatchedMem
        int  32h
@@Exit: mov  word ptr @Result + 2,ax
        mov  word ptr @Result,0
  end
end;

function PointerIsValid(p : pointer): Boolean;
begin
  if SwallowIsActive = swa_Protected then asm
        lar  ax,word ptr p + 2
        jz   @@1
        test ah,80h
        jz   @@1
        mov  al,true
        jmp  @@2
  @@1:  xor  al,al
  @@2:  mov  @Result,al
  end else
    PointerIsValid := true
end;

function SaveGetMem(size: Word): Pointer;
var
  p : Pointer;

begin
  if SwallowIsActive = swa_inactive then begin
    GetMem(p, size);
    SaveGetMem:= p;
  end else asm
        xor  dx,dx
        mov  ax,size
        or   ax,ax
        je   @@Exit
        db   66h
        xor  bx,bx
        mov  bx,ax
        cmp  UseUnwMem,true
        je   @@Unw
        mov  cl,2
        mov  ax,knf_AllocWatchedMem or knf_NoCheck
        int  32h
        jc   @@Error
        mov  dx,ax
        xor  ax,ax
        jmp  @@Exit

@@Unw:  mov  ax,knf_AllocUnwatchedMem or knf_NoCheck
        int  32h
        jc   @@Error
        mov  ax,dx
        mov  dx,cx
        jmp  @@Exit

@@Error:xor  ax,ax
        xor  dx,dx

@@Exit: mov  word ptr @Result,ax
        mov  word ptr @Result + 2,dx
  end
end;

function SetBreakCheck(CheckBreak : Boolean): Boolean;
begin
  if SwallowIsActive <> swa_Inactive then asm
        mov     bl,CheckBreak
        mov     ax,knf_SetBreakCheck
        int     32h
        mov     byte ptr @Result,al
  end else SetBreakCheck:= false
end;

procedure ShrinkMem;
begin
  if SwallowIsActive <> swa_Inactive then asm
        db   66h
        xor  bx,bx
        mov  ax,knf_ShrinkMem
        int  32h
  end
end;

procedure UseBaseMem;
begin
  if SwallowIsActive <> swa_Inactive then asm
	xor  bx,bx
        mov  ax,knf_UseBaseMem
        int  32h
  end
end;

function UseUnwatchedMem(UseIt : Boolean): Boolean;
begin
  UseUnwatchedMem := UseUnwMem;
  UseUnwMem := UseIt
end;


{ patches of system.tpu }

procedure NewGetMem; far; assembler;
asm
        xor  dx,dx
        or   ax,ax
        je   @@Exit
        db   66h
        xor  bx,bx
        mov  bx,ax
@@Retry:db   66h
        push bx
        cmp  UseUnwMem,true
        je   @@Unw
        mov  ax,knf_NoCheck
@@HaltW:or   ax,knf_AllocWatchedMem
        mov  cl,2
        int  32h
        mov  cx,ax
        mov  dx,0
        jmp  @@Check

@@Unw:  mov  ax,knf_NoCheck
@@HaltU:or   ax,knf_AllocUnwatchedMem
        int  32h
@@Check:jnc  @@Ok
        push bx
        call HeapError
        db   66h
        pop  bx
        xor  cx,cx
        xor  dx,dx
        cmp  ax,1
        je   @@Exit1
        jg   @@Retry
@@Error:cmp  UseUnwMem,true
        je   @@HaltU
        jmp  @@HaltW

@@Ok:   add  sp,4
@@Exit1:mov  ax,dx
        mov  dx,cx
@@Exit:
end;

procedure NewFreeMem; far; assembler;
asm
        db   66h
        xor  dx,dx
        mov  dx,cx
        mov  cx,bx
        or   bx,cx
        je   @@Exit
        mov  ax,knf_FreeUnwatchedMem
        int  32h
@@Exit:
end;

function NewMemAvail: LongInt; far; assembler;
asm
        mov  ax,knf_GetUnwatchedMemInfo
        cmp  UseUnwMem,true
        je   @@1
        mov  ax,knf_GetWatchedMemInfo
@@1:    int  32h
        db   66h
        mov  ax,bx
        db   66h,0fh,0a4h,0c2h,10h  { shld edx,eax,10h }
end;

function NewMaxAvail: LongInt; far; assembler;
asm
        mov  ax,knf_GetUnwatchedMemInfo
        cmp  UseUnwMem,true
        je   @@1
        mov  ax,knf_GetWatchedMemInfo
@@1:    int  32h
        db   66h
        mov  ax,cx
        db   66h,0fh,0a4h,0c2h,10h  { shld edx,eax,10h }
end;

{ procedure to patch system.tpu }
procedure PatchSystem;
var
  Tmp : Pointer;
  BufferSize : Word;
  Dummy : LongInt;

begin
  BufferSize:= 0;
  if BufferSize <> 0 then GetMem(Tmp, BufferSize);
  asm
  @1:   lea  si,@1-10
        mov  bx,cs:[si+2]
        mov  SystemSeg,bx
        mov  ax,knf_AllocAliasLD
        int  32h
        mov  es,ax
        mov  bx,ax
        mov  di,cs:[si]
        add  di,9
        add  di,es:[di-2]
        cld
        mov  al,09ah
        stosb
        lea  ax,NewGetMem
        stosw
        mov  ax,cs
        stosw
        mov  ax,0c3h
        stosb
        mov  ax,knf_FreeLD
        int  32h
  end;
  if BufferSize <> 0 then FreeMem(Tmp, BufferSize);
  asm
  @1:   lea  si,@1
        mov  bx,cs:[si-2]
        mov  ax,knf_AllocAliasLD
        int  32h
        mov  es,ax
        mov  bx,ax
        mov  di,cs:[si-4]
        add  di,0eh
        add  di,es:[di-2]
        cld
        mov  al,09ah
        stosb
        lea  ax,NewFreeMem
        stosw
        mov  ax,cs
        stosw
        mov  ax,0c3h
        stosb
        mov  ax,knf_FreeLD
        int  32h
  end;
  if BufferSize <> 0 then Dummy:= MemAvail;
  asm
  @1:   lea  si,@1-6
        mov  bx,cs:[si-2]
        mov  ax,knf_AllocAliasLD
        int  32h
        mov  es,ax
        mov  bx,ax
        mov  di,cs:[si-4]
        cld
        mov  al,0eah
        stosb
        lea  ax,NewMemAvail
        stosw
        mov  ax,cs
        stosw
        mov  ax,0c3h
        stosb
        mov  ax,knf_FreeLD
        int  32h
  end;
  if BufferSize <> 0 then Dummy:= MaxAvail;
  asm
  @1:   lea  si,@1-6
        mov  bx,cs:[si-2]
        mov  ax,knf_AllocAliasLD
        int  32h
        mov  es,ax
        mov  bx,ax
        mov  di,cs:[si-4]
        cld
        mov  al,0eah
        stosb
        lea  ax,NewMaxAvail
        stosw
        mov  ax,cs
        stosw
        mov  ax,0c3h
        stosb
        mov  ax,knf_FreeLD
        int  32h
        mov  ah,62h
        int  21h
        mov  PrefixSeg,bx
  end;
  Assign(Input, '');
  Assign(Output, '');
  Reset(Input);
  Rewrite(Output);
  asm
        mov  bx,040h
        mov  ax,knf_Seg2Selector
        int  32h
        mov  Seg0040,ax
        mov  bx,0a000h
        mov  ax,knf_Seg2Selector
        int  32h
        mov  Sega000,ax
        mov  bx,0b000h
        mov  ax,knf_Seg2Selector
        int  32h
        mov  Segb000,ax
        mov  bx,0b800h
        mov  ax,knf_Seg2Selector
        int  32h
        mov  Segb800,ax
  end;
end;

{ set interrupt vectors

  It has be done in Real Mode by the initialisation code of system.tpu
  and so it must be done again in Protected Mode by ourself. }
procedure AdaptVectors; assembler;
const
  VectTable : array[1..19] of byte =
    (0, 2, $1b, $21,
     $23, $24, $34, $35,
     $36, $37, $38, $39,
     $3a, $3b, $3c, $3d,
     $3e, $3f, $75);

asm
        push word ptr saveint3e
        push word ptr saveint3d
        push word ptr saveint3c
        push word ptr saveint3b
        push word ptr saveint3a
        push word ptr saveint39
        push word ptr saveint38
        push word ptr saveint37
        push word ptr saveint36
        push word ptr saveint35
        push word ptr saveint34
        push word ptr saveint3f
        lea  di,saveint00
        lea  si,VectTable
        mov  cx,19
        cld
@@1:    push cx
        lodsb
        mov  ah,35h
        int  21h
        mov  [di],bx
        mov  [di+2],es
        add  di,4
        pop  cx
        loop @@1
        pop  dx
        mov  cx,SystemSeg
        mov  bl,3fh
        mov  ax,knf_SetProtIntVec
        int  32h
        mov  si,34h
@@2:    pop  dx
        mov  bx,si
        mov  ax,knf_SetProtIntVec
        int  32h
        inc  si
        cmp  si,3fh
        jne  @@2
end;

{ if you want to avoid loading with option "/Real" you simply
  have to change this function to return "false" }
function CheckOption: Boolean;
var
  Counter : Word;
  Pos : Byte;
  S : String;

begin
  CheckOption:= false;
  for Counter:= 1 to ParamCount do begin
    S:= ParamStr(Counter);
    for Pos:= 1 to Length(S) do S[Pos]:= Upcase(S[Pos]);
    if S = '/REAL' then begin
      CheckOption:= true;
      exit
    end
  end
end;

{$ifndef NoSwallow}

begin
  EmulateSwallow:= CheckOption;
  if not InitSwallow then begin
    TerminateSwallow;
    Halt(255)
  end;
  PatchSystem;
  AdaptVectors

{$endif}

end.