;[]------------------------------------------------------------[]
;|      C0.ASM -- Start Up Code for DOS                         |
;|                                                              |
;|                                                              |
;|  expanded by Topical Software to enable use of "Swallow"	|
;|  (c) 1995                                                    |
;|                                                              |
;|  Following constants have to be defined during assembling:	|
;|    __TC10__ - Turbo C++ 1.0                                  |
;|    __TC31__ - Borland/Turbo C++ 3.1                          |
;|                                                              |
;[]------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 5.0
;
;       Copyright (c) 1987, 1992 by Borland International
;       All Rights Reserved.
;

		locals

		__C0__ = 1
INCLUDE         RULES.ASI

; !New! refuse work in tiny model
ifdef		__tiny__
		%OUT  TINY memory model not supported
		.ERR
endif

; check, wether the compiler-specification is correct
ifdef		__TC10__
ifdef		__TC31__
		%OUT  You have to specify only ONE target compiler
		.ERR
endif
else
ifndef		__TC31__
		%OUT  You have to specify a target compiler
		.ERR
endif
endif

; here are the extender calls and structures defined
include		swallow.inc

; definition of constants for "SwallowIsActive"
swa_inactive	equ	0
swa_protected	equ	1
swa_emulated	equ	2

; !EndNew!

;       Segment and Group declarations

_TEXT           SEGMENT BYTE PUBLIC 'CODE'
		ENDS
_FARDATA        SEGMENT PARA PUBLIC 'FAR_DATA'
		ENDS
_FARBSS         SEGMENT PARA PUBLIC 'FAR_BSS'
		ENDS
IFNDEF __TINY__
_OVERLAY_       SEGMENT PARA PUBLIC 'OVRINFO'
	ENDS
_1STUB_     SEGMENT PARA PUBLIC 'STUBSEG'
	ENDS
ENDIF

; !New! nearby all segments get labels for getting the offset of
; the begin and the end of it related to the DGROUP

_DATA           SEGMENT PARA PUBLIC 'DATA'
		ENDS
_INIT_          SEGMENT WORD PUBLIC 'INITDATA'
InitStart       label byte
		ENDS
_INITEND_       SEGMENT BYTE PUBLIC 'INITDATA'
InitEnd         label byte
		ENDS
_EXIT_          SEGMENT WORD PUBLIC 'EXITDATA'
ExitStart       label byte
		ENDS
_EXITEND_       SEGMENT BYTE PUBLIC 'EXITDATA'
ExitEnd         label byte
		ENDS
_CVTSEG         SEGMENT WORD PUBLIC 'DATA'
EndOfData	equ   this byte
		ENDS
_SCNSEG         SEGMENT WORD PUBLIC 'DATA'
		ENDS
IFNDEF __HUGE__
  _BSS          SEGMENT WORD PUBLIC 'BSS'
  BeginOf_BSS	equ   this byte
		ENDS
  _BSSEND       SEGMENT BYTE PUBLIC 'BSSEND'
  EndOf_BSS	equ   this byte
		ENDS
ENDIF
IFNDEF __TINY__
  _STACK        SEGMENT STACK 'STACK'
		ENDS
ENDIF

; !EndNew!

	ASSUME  CS:_TEXT, DS:DGROUP

;       External References

extrn       _main:DIST
extrn       _exit:DIST

; !New! several externals are added

; __VRAM is needed for patching __VPTR
extrn	    __VRAM:near

; _VideoInt will be patched too
extrn	    __VideoInt:near
extrn	    _directvideo:word

; nfile exists only in TC++ 3.1
; __exit is extern only in TC++ 3.1
ifdef __TC31__
extrn       __exit:DIST
extrn       __nfile:word
endif

; define externals for TC++ 1.0 exit-proc
ifdef __TC10__

IF      LPROG  EQ  false
extrn	__exitbuf:word
extrn	__exitfopen:word
extrn	__exitopen:word
else
extrn	__exitbuf:dword
extrn	__exitfopen:dword
extrn	__exitopen:dword
endif

endif
; !EndNew!


extrn       __setupio:near          ;required!
extrn       __stklen:word
IF LDATA  EQ  false
extrn       __heaplen:word
ENDIF


	SUBTTL  Start Up Code
	PAGE
;/*                                                     */
;/*-----------------------------------------------------*/
;/*                                                     */
;/*     Start Up Code                                   */
;/*     -------------                                   */
;/*                                                     */
;/*-----------------------------------------------------*/
;/*                                                     */
PSPHigh         equ     00002h
PSPEnv          equ     0002ch
PSPCmd          equ     00080h

		public  __AHINCR
		public  __AHSHIFT
__AHINCR        equ     1000h
__AHSHIFT       equ     12

IFDEF   __NOFLOAT__
MINSTACK        equ     128     ; minimal stack size in words
ELSE
MINSTACK        equ     256     ; minimal stack size in words
ENDIF
;
;       At the start, DS and ES both point to the segment prefix.
;       SS points to the stack segment except in TINY model where
;       SS is equal to CS
;
_TEXT           SEGMENT
IFDEF           __TINY__
		ORG     100h
ENDIF

STARTX          PROC    NEAR

; !NEW!
; At first we have to switch into protected mode because
; we have no chance to do it later and reinitialize the program

LocalStack	struc
@@EnvSeg  	dw	?
@@PSP		dw	?
@@ExeNameOfs	dw	?
@@CurPathOfs	dw	?
@@DrvEntry	dd	?
@@FileHandle	dw	?
@@ExtSize	dw	?
@@ExtSeg	dw	?
@@FileName	db	80 dup (?)
LocalStack	ends

		jumps			; let the assembler make it for us

; first of all patch the __VPTR procedure
; to avoid the emulating of the text-segment
; and then patch __VideoInt to exchange the functions
; GetCursorPos and SetCursorPos to skip Interrupt 10h -Call

		lea	bx,__VRAM	; __VPTR is directly befor __VRAM
		cmp	word ptr cs:[bx-2],4	; check it
		jne	@@DontPatch1
		cmp	word ptr cs:[bx-4],0c25dh
		jne	@@DontPatch1
		mov	ax,offset NewVPTR + 1 	; patch "pop bp; retn 4"
		sub	ax,bx			; with "jmp NewVPTR"
		mov	cs:[bx-3],ax
		mov	byte ptr cs:[bx-4],0e9h
@@DontPatch1:	lea	bx,__VideoInt
		cmp	word ptr cs:[bx],1e55h
		jne	@@DontPatch2
		cmp	byte ptr cs:[bx+2],51h
		jne	@@DontPatch2
		mov	ax,offset NewVideoInt - 3
		sub	ax,bx
		mov	cs:[bx+1],ax
		mov	byte ptr cs:[bx],0e9h
@@DontPatch2:

; search the command line flag "/real"
; if it exists the real mode-emulator of swallow will be loaded

		mov	es,DGROUP@@
		assume  ds:Nothing,es:DGROUP
		mov	_psp@,ds	; save PSP
		mov	si,81h
		cld
@@SearchParam:	lodsb         		; search param beginning with '-'
		cmp     al,'-'
		je	@@CompareOption
		cmp	al,'/'          ; or '/'
		jne	@@NotEqual
@@CompareOption:lea	di,ParReal	; compare option
		mov	cx,ParRealLen
@@CompareChar:	lodsb			; compare char by char
		mov     ah,es:[di]
		inc	di
		and	ax,not 2020h	; explicite upcase
		cmp	al,ah
		jne	@@NotEqual
		loop	@@CompareChar
		jmp	@@WithEmulator	; param exists

@@NotEqual:	dec	si
@@SkipParam:	lodsb           	; skip parameter
		cmp	al,0dh
		je	@@NoEmulator	; end of parameters
		cmp     al,' '
		je	@@SkipGap
		cmp	al,9
		jne	@@SkipParam
@@SkipGap:	lodsb			; skip gap between parameters
		cmp	al,' '
		je	@@SkipGap
		cmp	al,9
		je	@@SkipGap
		cmp	al,0dh
		je	@@NoEmulator	; end of paramters
		dec	si
		jmp	@@SearchParam

; we also accept "/realmode", "/real-mode" and so on

@@WithEmulator:	mov	EmulateSwallow,1
		call	ResizeMemory	; set final memory size
		jmp	@@Emulate

@@NoEmulator:	mov	EmulateSwallow,0
		mov     bx,ss		; minimize memory using
		mov	ax,ds		; PSP
		mov	es,ax
		sub	bx,ax
		mov	cl,4
		mov	dx,sp
		add	dx,0fh
		shr	dx,cl
		add	bx,dx
		mov	ah,4ah
		int	21h
@@Emulate:
		assume  ds:Nothing,es:Nothing

		mov	ds,DGROUP@@
		mov	es,ds:_psp@
		sub	sp,size LocalStack 	; init local stack frame
		mov	bp,sp
		xor	ax,ax
		mov	word ptr @@DrvEntry[bp],ax; extender not loaded yet
		mov	word ptr @@DrvEntry[bp]+2,ax
		mov	@@PSP[bp],es		; save psp
		mov	es,es:[PSPEnv]
		mov	@@EnvSeg[bp],es		; and environment


; at first we search the extender file
; we look into the path of the EXE and then we scan
; the environment entry "path"
; because we can't use any library function it's a little bit difficult

		xor     ax,ax
		xor	di,di
		mov     cx,7fffh	; now find the EXE-Name
		cld                     ; hope, you have DOS 3.3+
@@SearchExeName:repnz   scasb		; (never saw a version below)
		scasb			; (and so I forgot the check)
		jne     @@SearchExeName
		add	di,2		; skip number of left entrys
		mov	@@ExeNameOfs[bp],di
		mov	si,di		; copy path to stack
		lea	di,@@FileName[bp]
		mov	ds,@@EnvSeg[bp]
		mov	ax,ss
		mov	es,ax
@@CopyExePath:	lodsb
		stosb
		cmp	al,'\'
		jne	@@PathEnd
		mov	bx,di		; offset where the filename begins
@@PathEnd:	or	al,al
		jnz	@@CopyExePath
		lea	si,SwallowName	; append name of extender
		mov	ax,seg SwallowName
		mov	ds,ax
		mov	di,bx
		mov	cx,SwallowNameLen
		rep	movsb
		lea	dx,@@FileName[bp]; open extender file
		mov	ax,ss
		mov	ds,ax
		mov	ax,3d00h
		int	21h
		jnc	@@ExtenderFound	; here it is
		mov	es,@@EnvSeg[bp]	; else we search the "path"-env.
		xor	di,di
		mov	ax,seg PathName
		mov	ds,ax
		xor	al,al
@@SearchPath:	lea	si,PathName
		mov	cx,PathNameLen
		repe	cmpsb
		je	@@FoundPath
		dec	di
		mov	cx,7fffh
		repne	scasb
		cmp	al,es:[di]
		jne	@@SearchPath
					; pit: it does not exit

@@NoExtenderFile:lea	dx,MsgNoExtFile	; error: extender not found
		mov	cx,MsgNoExtFileLen
		jmp	@@MsgAbort

@@OutOfMem:	lea	dx,MsgOutOfMem	; error: not enough memory
		mov	cx,MsgOutOfMemLen
		jmp	@@MsgAbort

@@InvalidSegInfo:lea	dx,MsgInvSegInfo; error: invalid seg info file
		mov	cx,MsgInvSegInfoLen
		jmp	@@MsgAbort

@@NoSegInfo:	lea	dx,MsgNoSegInfo	; error: seg info file not found
		mov	cx,MsgNoSegInfoLen
@@MsgAbort:	mov	ds,DGROUP@@
		call	ErrorDisplay	; show message
@@Terminate:	mov	ax,word ptr @@DrvEntry[bp]
		or	ax,word ptr @@DrvEntry[bp]+2
		je	@@NotLoaded
		mov	ax,1
		call	@@DrvEntry[bp]
@@NotLoaded:	mov	ax,4c03h	; and terminate program
		int	21h

@@FoundPath:	mov	@@CurPathOfs[bp],di ; save offset within environment
@@NextPath:	mov	ds,@@EnvSeg[bp]	; check next path
		mov	si,@@CurPathOfs[bp]
		cmp	byte ptr [si],0
		je	@@NoExtenderFile; end of "path"-env.
		mov	ax,ss		; copy wished path
		mov	es,ax
		lea	di,@@FileName[bp]
@@CopyPath:	lodsb
		stosb
		cmp	al,';'
		je	@@EndOfEntry
		or      al,al
		jne	@@CopyPath
		dec	si   		; to point to the zero-byte
@@EndOfEntry:	dec	di		; delete zero-byte
		mov	@@CurPathOfs[bp],si
		mov	al,'\'		; append backslash
		cmp	es:[di-1],al
		je	@@BackslashOk
		lea	bx,offset @@FileName[bp]+2
		cmp	di,bx
		jb	@@BackSlashOk
		cmp	byte ptr es:[di-2],':' ; not after a pure drive name!
		je	@@BackSlashOk
		stosb
@@BackSlashOk:	lea	si,SwallowName	; append extender name
		mov	ax,seg SwallowName
		mov	ds,ax
		mov	cx,SwallowNameLen
		rep	movsb
		lea	dx,@@FileName[bp]; open extender file
		mov	ax,ss
		mov	ds,ax
		mov	ax,3d00h
		int	21h
		jnc	@@ExtenderFound	; here it is
		jmp	@@NextPath	; check the next path

@@ExtenderFound:mov     @@FileHandle[bp],ax

; now we load the whole extender file in an own memory block
; by the way: the entry point of the extender is at [extender:80h]

		mov	bx,ax           ; get size of extender file
		mov	ax,4202h
		xor	cx,cx
		xor	dx,dx
		int	21h
		jc	@@NoExtenderFile
		mov	@@ExtSize[bp],ax
		mov	cl,4		; extender always <64 KB
		add	ax,0fh
		shr	ax,cl
		mov	bx,ax		; allocate memory for extender
		mov	ah,48h
		int	21h
		jc	@@OutOfMem
		mov	@@ExtSeg[bp],ax
		mov	ds,ax
		mov	ax,4200h	; seek to the beginning
		mov	bx,@@FileHandle[bp]
		xor	cx,cx
		xor	dx,dx
		int	21h
		jc	@@NoExtenderFile
		mov	ah,3fh		; load extender file
		xor	dx,dx
		mov	cx,@@ExtSize[bp]
		int	21h
		jc	@@NoExtenderFile
		cmp	ax,cx
		jne	@@NoExtenderFile
		mov	ah,3eh	      	; we can close the file now
		int	21h

; next we open the segment info file
; we will give the handle the extender

		cmp	EmulateSwallow,false
		jne	@@SkipSegFile	; don't need seg infos in real mode
		mov	ds,@@EnvSeg[bp]	; copy EXE-name
		mov	si,@@ExeNameOfs[bp]
		mov	ax,ss
		mov	es,ax
		lea	di,@@FileName[bp]
@@CopyExeName:	lodsb
		stosb
		cmp	al,'.'
		jne	@@NoExt
		mov	bx,di		; here begins the extension
@@NoExt:	or	al,al
		jne	@@CopyExeName
		mov	di,bx		; append "SEG"
		mov	ax,'ES'
		stosw
		mov	ax,'G'
		stosw
		mov	ax,ss           ; open segment info file
		mov	ds,ax
		lea	dx,@@FileName[bp]
		mov	ax,3d00h
		int	21h
		jc	@@NoSegInfo
		mov	@@FileHandle[bp],ax
@@SkipSegFile:

; now the big bang comes:
; we (let) initialize the extender and let it switch to protected mode
; after this the whole program continuos normally, like in real mode
; remember: all DOS-/BIOS-functions are emulated by the extender

@@InitExtender:	mov	ax,@@ExtSeg[bp]
		mov	word ptr @@DrvEntry[bp] + 2,ax
		mov	word ptr @@DrvEntry[bp],80h
		mov	ax,EmulateSwallow
		call	@@DrvEntry[bp]  ; call initialization of extender
		mov	word ptr @@DrvEntry[bp],ax ; new entry point
		mov	word ptr @@DrvEntry[bp] + 2,dx
		or	ax,dx
		jz	@@Terminate
		.386			; it must be a 386+
					; else the extender would refuse
		mov	es,@@ExtSeg[bp]	; free memory of extender because
		mov	ah,49h		; it allocated its own blocks
		int	21h
		xor	ax,ax      	; call switch routine of the extender
		mov	es,@@psp[bp]
		mov	bx,@@FileHandle[bp]
		push	bx
		push	bp
		mov	si,bp
		xor	bp,bp           ; no stack chain to adapt
		call	@@DrvEntry[ss:si]
		pop	bp
		pop	bx		; now we are in protected mode!
		or	ax,ax           ; (we hope)
		jnz	@@InvalidSegInfo
		mov	ds,DGROUP@

		assume  ds:DGROUP

		mov	ax,EmulateSwallow ; set activation flag
		inc	ax
		mov	_SwallowIsActive,ax
		cmp	ax,swa_Emulated
		je	@@InRealmode	; no seg info file in emulation mode
		mov	ah,3eh		; close segment info file
		int	21h

; set Segxxxx to PM-selectors
; and sign ldt-selector (look at "@PubSym _LDT")

		mov	bx,40h
		mov	ax,knf_Seg2Selector or knf_NoCheck
		int	32h
		jc	@@OutOfMem
		mov	_Seg0040,ax
		mov	bx,0a000h
		mov	ax,knf_Seg2Selector or knf_NoCheck
		int	32h
		jc	@@OutOfMem
		mov	_SegA000,ax
		mov	bx,0b000h
		mov	ax,knf_Seg2Selector or knf_NoCheck
		int	32h
		jc	@@OutOfMem
		mov	_SegB000,ax
		mov	bx,0b800h
		mov	ax,knf_Seg2Selector or knf_NoCheck
		int	32h
		jc	@@OutOfMem
		mov	_SegB800,ax
		mov	bl,21h
		mov	ax,knf_GetProtIntVec
		int	32h
		mov	__LDT,cx


; at the end we can release nearby all DOS-memory of the EXE-file
; (if we don't use the emulator)

		mov  	bx,@@PSP[bp]	; get selector to real mode psp
		mov  	ax,knf_Seg2Selector or knf_NoCheck
		int  	32h
		jc	@@OutOfMem
		mov  	es,ax
		mov  	ah,4ah		; we can shrink it to 60h bytes
		mov  	bx,6
		int  	21h

; and restore a just-started state

@@InRealmode: 	mov	ah,62h		; get protected mode psp
		int	21h
		mov	ds,bx		; restore registers like at the
		mov	es,bx		; program start
		add	sp,size LocalStack
		cld

		nojumps			; normally it's disabled (why?)
; !EndNew!


;       Save general information, such as :
;               DGROUP segment address
;               DOS version number
;               Program Segment Prefix address
;               Environment address
;               Top of far heap

; !Removed! the DGROUP@@ variable is initialisized static
; !Changed! the bp-register will be loaded within ResizeMemory

		mov     ah, 30h
		int     21h             ; get DOS version number
		mov     bp, ds:[PSPHigh]; BP = Highest Memory Segment Addr
		mov     bx, ds:[PSPEnv] ; BX = Environment Segment address
		mov     ds, DGROUP@@
		mov     _version@, ax   ; Keep major and minor version number
		mov     _psp@, es       ; Keep Program Segment Prefix address
		mov     _envseg@, bx    ; Keep Environment Segment address
		mov     word ptr _heaptop@ + 2, bp
;
;       Save several vectors and install default divide by zero handler.
;
		call    SaveVectors


;       Count the number of environment variables and compute the size.
;       Each variable is ended by a 0 and a zero-length variable stops
;       the environment. The environment can NOT be greater than 32k.

		mov     ax, _envseg@
		mov     es, ax
		xor     ax, ax
		mov     bx, ax
		mov     di, ax

		mov     cx, 07FFFh      ; Environment cannot be > 32 Kbytes
		cld
@@EnvLoop:
		repnz   scasb
		or	cx,cx
		je	InitFailed      ; Bad environment !!!

		inc     bx              ; BX = Nb environment variables
		cmp     es:[di], al
		jne     @@EnvLoop       ; Next variable ...
		or      ch, 10000000b
		neg     cx
		mov     _envLng@, cx    ; Save Environment size
		mov     cx, dPtrSize / 2
		shl     bx, cl
		add     bx, dPtrSize * 4
		and     bx, not ((dPtrSize * 4) - 1)
		mov     _envSize@, bx   ; Save Environment Variables Nb.

		cmp	EmulateSwallow,false
		jne	@@DontResize
		call	ResizeMemory	; resize data segment in P.M.
@@DontResize:

IFNDEF  __HUGE__

;       Reset uninitialized data area

		xor     ax, ax
		mov     es, cs:DGROUP@@
		mov     di, offset DGROUP: bdata@
		mov     cx, offset DGROUP: edata@
		sub     cx, di
		cld
		rep     stosb
ENDIF

;   If default number of file handles have changed then tell DOS

; !!New!! prior TC++ 3.1 __nfile did not exist

ifdef		__TC31__
		cmp     __nfile, 20
		jbe     @@NoChange

		cmp     _osmajor@, 3   ; Check for >= DOS 3.3
		jb      @@NoChange
		ja      @@DoChange
		cmp     _osminor@, 1Eh
		jb      @@NoChange
@@DoChange:
		mov     ax, 5801h      ; Set last fit allocation
		mov     bx, 2
		int     21h
		jc      @@BadInit

		mov     ah, 67h        ; Expand handle table
		mov     bx, __nfile
		int     21h
		jc      @@BadInit

; !New! we need *not* to test memory size ourselve

		cmp	_SwallowIsActive,false
		jne	@@NoMemCheck

; !EndNew!

		mov     ah, 48h        ; Allocate 16 bytes to find new
		mov     bx, 1          ;   top of memory address
		int     21h
		jc      @@BadInit
		inc     ax             ; Adjust address to point after block
		mov     word ptr _heaptop@ + 2, ax

		dec     ax             ; Change back and release block
		mov     es, ax
		mov     ah, 49h
		int     21h
		jc      @@BadInit

@@NoMemCheck:	mov     ax, 5801h      ; Set first fit allocation
		mov     bx, 0
		int     21h
		jnc     @@NoChange

@@BadInit:      jmp near ptr _abort

@@NoChange:

endif

; !!EndNew!!

;       Prepare main arguments

		mov     ah, 0
		int     1ah                     ; get current BIOS time in ticks
		mov     word ptr _StartTime@,dx ; save it for clock() fn
		mov     word ptr _StartTime@+2,cx
		or      al,al                   ; was midnight flag set?
		jz      @@NotMidnight
		mov     ax,40h                  ; set BIOS midnight flag
		mov     es,ax                   ;  at 40:70
		mov     bx,70h
		mov     byte ptr es:[bx],1

@@NotMidnight:
		xor     bp,bp                   ; set BP to 0 for overlay mgr

		mov     es, cs:DGROUP@@
		mov     si,offset DGROUP:InitStart      ;si = start of table
		mov     di,offset DGROUP:InitEnd        ;di = end of table
		call    Initialize

;       ExitCode = main(argc,argv,envp);

IF      LDATA
		push    word ptr __C0environ+2
		push    word ptr __C0environ
		push    word ptr __C0argv+2
		push    word ptr __C0argv
ELSE
		push    word ptr __C0environ
		push    word ptr __C0argv
ENDIF
		push    __C0argc
		call    _main

;       Flush and close streams and files

		push    ax
		call    _exit


;
; !!New!! following initializiation are moved into this new procedure
;  	  - calculating and resizing of needed memory
;	  - resizing of the stack
;

ResizeMemory	proc	near
		pop	si		; return address
		mov	ds,DGROUP@@
		mov	es,_psp@
		mov     bp,es:[PSPHigh]	; BP = Highest Memory Segment Addr

;       Determine the amount of memory that we need to keep

IFDEF _DSSTACK_
		mov     dx, ds
ELSE
		mov     dx, ss
ENDIF
		sub     bp, dx          ; BP = remaining size in paragraphs

; !New! the left memory space size can't be calculated directly
; any memory problems we will see during the allocation

		cmp	_SwallowIsActive,false
		je	@@NoExtender
		mov	bp,0ffffh	; assume as much as possible
@@NoExtender:
; !EndNew!

IF LDATA
		mov     di, seg __stklen
		mov     es, di
		mov     di, es:__stklen ; DI = Requested stack size
ELSE
		mov     di, __stklen    ; DI = Requested stack size
ENDIF
;
; Make sure that the requested stack size is at least MINSTACK words.
;
		cmp     di, 2*MINSTACK  ; requested stack big enough ?
		jae     AskedStackOK
		mov     di, 2*MINSTACK  ; no --> use minimal value
IF LDATA
		mov     es:__stklen, di ; override requested stack size
ELSE
		mov        __stklen, di ; override requested stack size
ENDIF

AskedStackOK    label   near
IFDEF _DSSTACK_
		add     di, offset DGROUP: edata@
		jb      InitFailed      ; DATA segment can NOT be > 64 Kbytes
ENDIF
IF LDATA  EQ  false
		add     di, __heaplen
		jb      InitFailed      ; DATA segment can NOT be > 64 Kbytes
ENDIF
		mov     cl, 4
		shr     di, cl          ; $$$ Do not destroy CL $$$
		inc     di              ; DI = DS size in paragraphs
		cmp     bp, di
IF LDATA  EQ  false
		jb      InitFailed      ; Not enough memory
		cmp     __stklen, 0
		je      ExpandDS        ; Expand DS up to 64 Kb
		cmp     __heaplen, 0
		jne     ExcessOfMemory  ; Much more available than needed
ExpandDS        label   near
		mov     di, 1000h
		cmp     bp, di
		ja      ExcessOfMemory  ; Enough to run the program
		mov     di, bp
		jmp     short ExcessOfMemory  ; Enough to run the program
ELSE
		jnb     ExcessOfMemory  ; Much more available than needed
ENDIF

;       All initialization errors arrive here

InitFailed      label   near
		jmp     near ptr _abort

;       Return to DOS the amount of memory in excess
;       Set far heap base and pointer

ExcessOfMemory  label   near

; !New! within protected mode we are not in the DOS memory space

		cmp	EmulateSwallow,false
		je	@@Swallow
		mov     bx, di
		add     bx, dx
		mov     word ptr _heapbase@ + 2, bx
		mov     word ptr _brklvl@ + 2, bx
		mov     ax, _psp@
		sub     bx, ax          ; BX = Number of paragraphs to keep
		mov     es, ax          ; ES = Program Segment Prefix address
		mov     ah, 04Ah
		push    di              ; preserve DI
		push	si		; !New! and si too
		int     021h            ; this call clobbers SI,DI,BP !!!!!!
		pop	si
		pop     di              ; restore  DI
		shl     di, cl          ; $$$ CX is still equal to 4 $$$
		jmp	@@NoSwallow

@@Swallow:	.386
		movzx   ecx,di		; call protected mode resize
		shl 	ecx,4		; for the data segment
		cmp	ecx,10000h	; Stack can't wrap from 10000h
		jb	@@StackOk	; to 0fffeh, so we must reduce it
		mov	ecx,0fffch
@@StackOk:      mov	bx,dx
		mov	ax,knf_ResizeWatchedMem
		int	32h
		mov	di,cx

		.8086			; we want to be compatible
@@NoSwallow:

; !EndNew!

		cli                     ; req'd for pre-1983 88/86s
		mov     ss, dx          ; Set the program stack
		mov     sp, di
		sti

IFNDEF _DSSTACK_
		mov     ax, seg __stklen
		mov     es, ax
		mov     es:__stklen, di ; If separate stack segment, save size
ENDIF
		jmp	si		; can't use "ret" with new stack
ResizeMemory	endp

;
; !!EndNew!!
;


;---------------------------------------------------------------------------
;       _cleanup()      call all #pragma exit cleanup routines.
;       _checknull()    check for null pointer zapping copyright message
;       _terminate(int) exit program with error code
;
;       These functions are called by exit(), _exit(), _cexit(),
;       and _c_exit().
;---------------------------------------------------------------------------

;       Call cleanup routines

__cleanup       PROC    DIST
		PUBLIC  __cleanup

		mov     es, cs:DGROUP@@
		push    si
		push    di
		mov     si,offset DGROUP:ExitStart
		mov     di,offset DGROUP:ExitEnd
		call    Cleanup
		pop     di
		pop     si
		ret
__cleanup       ENDP

;       Check for null pointers before exit

__checknull     PROC    DIST
		PUBLIC  __checknull

IF      LDATA  EQ  false
  IFNDEF  __TINY__
		push    si
		push    di
		mov     es, cs:DGROUP@@
		xor     ax, ax
		mov     si, ax
		mov     cx, lgth_CopyRight
ComputeChecksum label   near
		add     al, es:[si]
		adc     ah, 0
		inc     si
		loop    ComputeChecksum
		sub     ax, CheckSum
		jz      @@SumOK
		mov     cx, lgth_NullCheck
		mov     dx, offset DGROUP: NullCheck
		call    ErrorDisplay
@@SumOK:        pop     di
		pop     si
  ENDIF
ENDIF
		ret
__checknull     ENDP

;       Exit to DOS

__terminate     PROC    DIST
		PUBLIC  __terminate
		mov     bp,sp
		mov     ah,4Ch
		mov     al,[bp+cPtrSize]
		int     21h                     ; Exit to DOS
__terminate     ENDP


; !New! the procedures __exitclean and __exit are added for
;	compatibility with TC 1.0

ifdef		__TC10__

__exitclean	Proc	Near
		public	__exitclean
		call	__cleanup
		mov	ds,cs:[DGROUP@]
		call	__exitbuf
		call	__exitfopen
		call	__exitopen
IF      LPROG   NE  false
		push	ax
endif
__exitclean	Endp

__exit		Proc	Dist ReturnCode:Byte
		public	__exit
		mov	ds,cs:[DGROUP@]
		call	__restorezero
		push	bp
		mov	bp,sp
		mov	ah,4ch
		mov	al,ReturnCode
		int	21h
__exit		EndP
endif

STARTX          ENDP

	SUBTTL  Vector save/restore & default Zero divide routines
	PAGE
;[]------------------------------------------------------------[]
;|                                                              |
;| Interrupt Save/Restore routines and default divide by zero   |
;| handler.                                                     |
;|                                                              |
;[]------------------------------------------------------------[]

ZeroDivision    PROC    FAR
		mov     cx, lgth_ZeroDivMSG
		mov     dx, offset DGROUP: ZeroDivMSG
		jmp     MsgExit3
ZeroDivision    ENDP

;--------------------------------------------------------------------------
;       savevectors()
;
;       Save vectors for 0, 4, 5 & 6 interrupts.  This is for extended
;       signal()/raise() support as the signal functions can steal these
;       vectors during runtime.
;--------------------------------------------------------------------------
SaveVectors     PROC    NEAR
		push    ds
; Save INT 0
		mov     ax, 3500h
		int     021h
		mov     word ptr _Int0Vector@, bx
		mov     word ptr _Int0Vector@+2, es
; Save INT 4
		mov     ax, 3504h
		int     021h
		mov     word ptr _Int4Vector@, bx
		mov     word ptr _Int4Vector@+2, es
; Save INT 5
		mov     ax, 3505h
		int     021h
		mov     word ptr _Int5Vector@, bx
		mov     word ptr _Int5Vector@+2, es
; Save INT 6
		mov     ax, 3506h
		int     021h
		mov     word ptr _Int6Vector@, bx
		mov     word ptr _Int6Vector@+2, es
;
;       Install default divide by zero handler.
;
		mov     ax, 2500h
		mov     dx, cs
		mov     ds, dx
		mov     dx, offset ZeroDivision
		int     21h

		pop     ds
		ret
SaveVectors     ENDP

;--------------------------------------------------------------------------
;       _restorezero() puts back all the vectors that SaveVectors took.
;
;NOTE : TSRs must BE AWARE that signal() functions which take these
;       vectors will be deactivated if the keep() function is executed.
;       If a TSR wants to use the signal functions when it is active it
;       will have to save/restore these vectors itself when activated and
;       deactivated.
;--------------------------------------------------------------------------
__restorezero   PROC    DIST
		PUBLIC  __restorezero
IFDEF   __HUGE__
		push    ds
		mov     ds, cs: DGROUP@@
ENDIF
		push    ds
		mov     ax, 2500h
		lds     dx, _Int0Vector@
		int     21h
		pop     ds

		push    ds
		mov     ax, 2504h
		lds     dx, _Int4Vector@
		int     21h
		pop     ds

		push    ds
		mov     ax, 2505h
		lds     dx, _Int5Vector@
		int     21h
		pop     ds

IFNDEF   __HUGE__
		push    ds
ENDIF
		mov     ax, 2506h
		lds     dx, _Int6Vector@
		int     21h
		pop     ds

		ret
		ENDP

;------------------------------------------------------------------
;  Loop through a startup/exit (SE) table,
;  calling functions in order of priority.
;  ES:SI is assumed to point to the beginning of the SE table
;  ES:DI is assumed to point to the end of the SE table
;  First 64 priorities are reserved by Borland
;------------------------------------------------------------------
PNEAR           EQU     0
PFAR            EQU     1
NOTUSED         EQU     0ffh

SE              STRUC
calltype        db      ?                       ; 0=near,1=far,ff=not used
priority        db      ?                       ; 0=highest,ff=lowest
addrlow         dw      ?
addrhigh        dw      ?
SE              ENDS

Initialize      proc near
@@Start:        mov     ax,100h                 ;start with lowest priority
		mov     dx,di                   ;set sentinel to end of table
		mov     bx,si                   ;bx = start of table

@@TopOfTable:   cmp     bx,di                   ;and the end of the table?
		je      @@EndOfTable            ;yes, exit the loop
		cmp     es:[bx.calltype],NOTUSED;check the call type
		je      @@Next
		mov     cl, es:[bx.priority]    ;move priority to CX
		xor     ch, ch
		cmp     cx,ax                   ;check the priority
		jae     @@Next                  ;too high?  skip
		mov     ax,cx                   ;keep priority
		mov     dx,bx                   ;keep index in dx
@@Next:         add     bx,SIZE SE              ;bx = next item in table
		jmp     @@TopOfTable

@@EndOfTable:   cmp     dx,di                   ;did we exhaust the table?
		je      @@Done                  ;yes, quit
		mov     bx,dx                   ;bx = highest priority item
		cmp     es:[bx.calltype],PNEAR  ;is it near or far?
		mov     es:[bx.calltype],NOTUSED;wipe the call type
		push    es                      ;save es
		je      @@NearCall

@@FarCall:      call    DWORD PTR es:[bx.addrlow]
		pop     es                      ;restore es
		jmp     short @@Start

@@NearCall:     call    WORD PTR es:[bx.addrlow]
		pop     es                      ;restore es
		jmp     short @@Start

@@Done:         ret
		endp

Cleanup         proc near
@@Start:        mov     ah,0                    ;start with highest priority
		mov     dx,di                   ;set sentinel to end of table
		mov     bx,si                   ;bx = start of table

@@TopOfTable:   cmp     bx,di                   ;and the end of the table?
		je      @@EndOfTable            ;yes, exit the loop
		cmp     es:[bx.calltype],NOTUSED;check the call type
		je      @@Next
		cmp     es:[bx.priority],ah     ;check the priority
		jb      @@Next                  ;too low?  skip
		mov     ah,es:[bx.priority]     ;keep priority
		mov     dx,bx                   ;keep index in dx
@@Next:         add     bx,SIZE SE              ;bx = next item in table
		jmp     @@TopOfTable

@@EndOfTable:   cmp     dx,di                   ;did we exhaust the table?
		je      @@Done                  ;yes, quit
		mov     bx,dx                   ;bx = highest priority item
		cmp     es:[bx.calltype],PNEAR  ;is it near or far?
		mov     es:[bx.calltype],NOTUSED;wipe the call type
		push    es                      ;save es
		je      @@NearCall

@@FarCall:      call    DWORD PTR es:[bx.addrlow]
		pop     es                      ;restore es
		jmp     short @@Start

@@NearCall:     call    WORD PTR es:[bx.addrlow]
		pop     es                      ;restore es
		jmp     short @@Start

@@Done:         ret
		endp

;------------------------------------------------------------------

ErrorDisplay    PROC    NEAR
		mov     ah, 040h
		mov     bx, 2
		int     021h
		ret
ErrorDisplay    ENDP

_abort          PROC    DIST
		PUBLIC  _abort
		mov     cx, lgth_abortMSG
		mov     dx, offset DGROUP: abortMSG
MsgExit3        label   near
		mov     ds, cs: DGROUP@@
		call    ErrorDisplay
CallExit3       label   near
		mov     ax, 3
		push    ax
		call    __exit           ; _exit(3);
		ENDP


; !New! basic memory allocation functions are exchanged

		.386
if LDATA
_malloc		proc 	DIST @@size:word
		public	_malloc
		push	bp
		mov	bp,sp
		movzx	ecx,@@size
		jmp	doalloc
_malloc		endp
endif

_farmalloc	proc 	DIST @@size:dword
		public	_farmalloc
		push	bp
		mov	bp,sp
		mov	ecx,@@size
doalloc:	jecxz	@@Empty
		mov	ebx,ecx
		cmp	UseUnwMem,1
		je	@@Unwatched
		mov	cl,2
		mov	ax,knf_AllocWatchedMem or knf_NoCheck
		int	32h
		jc	@@Error
		mov	dx,ax
		xor	ax,ax
		pop	bp
		ret

@@Unwatched:	mov	ax,knf_AllocUnwatchedMem or knf_NoCheck
		int	32h
		jc	@@Error
		mov	ax,dx
		mov	dx,cx
		pop	bp
		ret

@@Empty:
@@Error:	xor	ax,ax
		xor	dx,dx
		pop	bp
		ret
_farmalloc	endp

_farfree	proc	DIST @@block:dword
if LDATA
_free		equ	this byte
		public	_free,_farfree
else
		public	_farfree
endif
		push	bp
		mov	bp,sp
		mov	cx,word ptr @@block + 2
		movzx	edx,word ptr @@block
dofree:		mov	ax,knf_FreeUnwatchedMem
		int	32h
		xor	ax,ax
		xor	dx,dx
		pop	bp
		ret
_farfree	endp

if LDATA
_realloc	proc	DIST @@block:dword, @@newsize:word
		public	_realloc
		push	bp
		mov	bp,sp
		movzx	ecx,@@newsize
		jmp	dorealloc
_realloc	endp
endif

_farrealloc	proc	far @@block:dword, @@newsize:dword
		public	_farrealloc
		push	bp
		mov	bp,sp
		mov	ecx,@@newsize
dorealloc:	cmp	word ptr @@block,0
		jne	@@Error
		mov	bx,word ptr @@block + 2
		or	bx,bx
		jz	doalloc
		jecxz	dofree
		mov	ax,knf_ResizeWatchedMem
		int	32h
		jnc	@@NoError
		xor	bx,bx
@@NoError:	mov	dx,bx
		xor	ax,ax
		pop	bp
		ret

@@free:		mov	ax,knf_FreeWatchedMem
		int	32h
		xor	ax,ax
		xor	dx,dx
		pop	bp
		ret

; resizing unwatched memory is not implemented
@@Error:	int	3
_farrealloc	endp

_farcoreleft	proc	DIST
if LDATA
_coreleft	equ	this byte
		public	_coreleft,_farcoreleft
else
		public	_farcoreleft
endif
		mov	ax,knf_GetUnwatchedMemInfo
		cmp     UseUnwMem,1
		je	@@Local
		mov	ax,knf_GetWatchedMemInfo
@@Local:	int	32h
		mov	ax,cx
		shld	edx,ecx,16
		ret
_farcoreleft	endp

; the ioctl-function loads ds:dx every time, even if no buffer exists
; because in such case the access can be invalid, we simple exchange
; an invalid segment with the zero-segment

_ioctl		proc    DIST @@handle:word, @@func:word, @@buffer:dword, \
			@@len:word
		public	_ioctl
		extrn	__IOERROR: near

		push	bp
		mov	bp,sp
		push	ds
		mov	ds,DGROUP@@
		cmp	_SwallowIsActive,swa_protected
		mov	ax,_SwallowIsActive
		jne	@@NoSwallow		; only in P.M. needed
		xor	ax,ax
		mov	ds,ax
		.386p
		lar	ax,word ptr @@buffer + 2
		.386
		jnz	@@InvalidBuffer         ; can't access
		test    ah,80h
		jz 	@@InvalidBuffer		; segment is not present
@@NoSwallow:	lds     dx,@@buffer
@@InvalidBuffer:mov	cx,@@len
		mov	ah,44h
		mov	al,byte ptr @@func
		mov	bx,@@handle
		int	21h
		pop	ds
		jc	@@Error
		cmp	@@len,0
		je	@@exit
		mov	ax,dx
		jmp	@@exit

@@Error:	push	ax
		call	__IOERROR
@@exit:		pop	bp
		ret
_ioctl		endp

; the arithmetic of huge-pointers is impossible with swallow
; all consequtive procedures don't destroy registers except segment reg's
; and the second parameter

		.386p

; add [dx:ax],cx:bx with [dx:ax] is a huge_pointer
; near call version

N_PADA@		proc	near
		public	N_PADA@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_PADA@		endp

; far call version

PADA@		proc	far
		public	PADA@
		shl	ecx,16
		mov	cx,bx
PADA1:		mov	es,dx
		mov	bx,ax
		movzx	eax,word ptr es:[bx]
		add	eax,ecx
		cmp	eax,10000h
		jae	SegmentExceeded
		mov	word ptr es:[bx],ax
		ret
PADA@		endp

; sub [dx:ax],cx:bx
;   [dx:ax] is an huge_pointer
;   cx:bx is an offset
; near call version

N_PSBA@		proc	near
		public	N_PSBA@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_PSBA@		endp

; far call version

PSBA@		proc	far
		public	PSBA@
		shl	ecx,16
		mov	cx,bx
		neg	ecx
		jmp	PADA1
PSBA@		endp

; add dx:ax,cx:bx
;   dx:ax is an huge_pointer
;   cx:bx is an offset
; near call version

N_PADD@		proc	near
		public	N_PADD@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_PADD@		endp

; far call version

F_PADD@		proc	far
		public	F_PADD@
		shl	ecx,16
		mov	cx,bx
		movzx	eax,ax
		add	eax,ecx
		cmp	eax,10000h
		jae	SegmentExceeded
		ret
F_PADD@		endp

; sub dx:ax,cx:bx
;   dx:ax is an huge_pointer
;   cx:bx is an offset
; near call version

N_PSUB@		proc	near
		public	N_PSUB@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_PSUB@		endp

; far call version

PSUB@		proc	far
		public	PSUB@
		shl	ecx,16
		mov	cx,bx
		movzx	eax,ax
		sub	eax,ecx
		cmp	eax,10000h
		jae	SegmentExceeded
		ret
PSUB@		endp

; sub dx:ax,cx:bx (Pointer - Pointer)
; -> dx:ax Offset
; near call version

N_PSBP@		proc	near
		public	N_PSBP@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_PSBP@		endp

; far call version

PSBP@		proc    far
		public	PSBP@
		cmp     dx,cx
		jne     SegmentExceeded
		sub	ax,bx
		xor	dx,dx
		ret
PSBP@		endp


; copy Source to Target (they are far pointer)
; cx is the length

N_SCOPY@	proc    near Source:DWord,Target:DWord
		public	N_SCOPY@
		movzx   esp,sp
		push	word ptr [esp]
		mov	[esp+2],cs
N_SCOPY@	endp

; far version

F_SCOPY@	proc	far Source:DWord,Target:DWord
		public  F_SCOPY@

		push	bp
		mov	bp,sp
		push	ds
		push	si
		push	di
		lds	si,Source
		les	di,Target
		ror	ecx,2
		cld
		rep	movsd
		rol	ecx,2
		rep	movsb
		pop	di
		pop	si
		pop	ds
		pop	bp
		retf	8
F_SCOPY@	endp

ifdef  __TC10__

; fast functions for division, modulo

N_LDIV@         proc    near x:dword, y:dword
		public	N_LDIV@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		idiv    y
		shld	edx,eax,16
		pop	bp
		ret     8
N_LDIV@		endp

F_LDIV@         proc    far x:dword, y:dword
		public	F_LDIV@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		idiv    y
		shld	edx,eax,16
		pop	bp
		ret     8
F_LDIV@		endp

N_LUDIV@        proc    near x:dword, y:dword
		public	N_LUDIV@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		div     y
		shld	edx,eax,16
		pop	bp
		ret     8
N_LUDIV@	endp

F_LUDIV@        proc    far x:dword, y:dword
		public	F_LUDIV@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		div     y
		shld	edx,eax,16
		pop	bp
		ret     8
F_LUDIV@	endp


N_LMOD@         proc    near x:dword, y:dword
		public	N_LMOD@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		idiv    y
		mov	eax,edx
		shld	edx,eax,16
		pop	bp
		ret     8
N_LMOD@		endp

F_LMOD@         proc    far x:dword, y:dword
		public	F_LMOD@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		idiv    y
		mov	eax,edx
		shld	edx,eax,16
		pop	bp
		ret     8
F_LMOD@		endp

N_LUMOD@        proc    near x:dword, y:dword
		public	N_LUMOD@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		div     y
		mov	eax,edx
		shld	edx,eax,16
		pop	bp
		ret     8
N_LUMOD@	endp

F_LUMOD@        proc    far x:dword, y:dword
		public	F_LUMOD@
		push	bp
		mov	bp,sp
		mov	eax,x
		cdq
		div     y
		mov	eax,edx
		shld	edx,eax,16
		pop	bp
		ret	8
F_LUMOD@	endp

endif


; error handler if segment bound of 64 KByte is exceeded
; even in real mode emulator this bounds is made of stone
; to be compatible with protected mode version

SegmentExceeded	proc	DIST
		push	bp		; build stack frame for
		mov	bp,sp		; complete stackchain
		push	ds
		mov	bx,seg _SwallowIsActive
		mov	ds,bx
		cmp	_SwallowIsActive,0
		je	@@1
		pop	ds		; within protected mode
		int	4		; raise "Integer Overflow" to let
					; show the stack chain

@@1:		pop	ax		; in real mode set text mode
		mov	ah,0fh
		int	10h
		cmp	ah,3
		je	@@TextMode
		mov	ax,3
		int	10h
@@TextMode:	lea	dx,MsgHugeError	; show a little message
		mov	cx,MsgHugeErrorLen
		call	ErrorDisplay
		mov	ax,3 		; and terminate program
		push	ax
		call	_exit
SegmentExceeded	endp


; public function to convert segment to selector

_Seg2Sel        proc	DIST Segm:Word
		public	_Seg2Sel

		push	bp
		mov	bp,sp
		mov	bx,Segm
		mov	ax,knf_Seg2Selector
		int	32h
		mov	dx,ax
		xor	ax,ax
		pop	bp
		ret
_Seg2Sel	endp


; public function to allocate locked memory

_GetLockedMem	proc    DIST @@Size:Word
		public _GetLockedMem

		push	bp
		mov	bp,sp
		movzx	ecx,@@size
		jecxz	@@Empty
		mov	ebx,ecx
		mov	cl,12h
		mov	ax,knf_AllocWatchedMem or knf_NoCheck
		int	32h
		jnc	@@NoError
@@Empty:	xor	ax,ax
@@NoError:	mov	dx,ax
		xor	ax,ax
		pop	bp
		ret
_GetLockedMem	endp


; public function to init swap file on harddisk

_InitSwapFile	proc    DIST @@Drive:Word, @@LeftSpace:DWord
		public  _InitSwapFile

		push	bp
		mov	bp,sp
		mov	bl,byte ptr @@Drive
		mov	ecx,@@LeftSpace
		mov	ax,knf_InitSwapFile
		int	32h
		pop	bp
		ret
_InitSwapFile	endp


; set flag, wether Ctrl-Alt-Numlock should be checked

_SetBreakCheck	proc    DIST @@CheckBreak:Word
		public	_SetBreakCheck

		push	bp
		mov	bp,sp
		mov	bx,@@CheckBreak
		or	bx,bx
		setnz	bl
		mov	ax,knf_SetBreakCheck
		int	32h
		pop	bp
		ret
_SetBreakCheck	endp


; shrink used extended memory

_ShrinkMem	proc    DIST @@LeftSpace:DWord
		public	_ShrinkMem

		push	bp
		mov	bp,sp
		mov	ebx,@@LeftSpace
		mov	ax,knf_ShrinkMem
		int	32h
		pop	bp
		ret
_ShrinkMem	endp


; use DOS-memory under Swallow

_UseBaseMem	proc    DIST
		public  _UseBaseMem

		xor     bx,bx
		mov	ax,knf_UseBaseMem
		int	32h
		ret
_UseBaseMem	endp


; use even unwatched memory

_UseUnwatchedMem proc   DIST @@UseIt:word
		public  _UseUnwatchedMem

		push	bp
		mov	bp,sp
		mov	ax,@@useIt
		or	ax,ax
		je	@@Not
		mov	ax,1
@@Not:		xchg	al,UseUnwMem
		pop	bp
		ret
_UseUnwatchedMem endp


; Patch for __VPTR, which calculates the textbuffer-address
;
; To NewVPTR will be jumped instead of "pop bp; ret 4"
; This procedure exchanged the segments with the selectors

NewVPTR		proc 	near
		cmp	dx,0b000h
		je	@@b000
		mov	dx,_SEGB800
		pop	bp
		ret	4

@@b000:		mov	dx,_SEGB000
		pop	bp
		ret	4
NewVPTR		endp

; The NewVideoInt emulates Interrupt 10h-Call for
; GetCursorPos and SetCursorPos if directvideo = true

NewVideoInt	proc	near
		push	bp
		push	ds
		push	cx
		mov	cx,seg _directvideo
		mov	ds,cx
		cmp	_directvideo,1
		je	@@direct
		jmp	__VideoInt + 3

@@direct:	cmp	ah,2
		je	@@SetCursorPos
		cmp	ah,3
		je	@@GetCursorPos
		jmp	__VideoInt + 3

@@SetCursorPos: mov	cx,seg _SEG0040
		mov	ds,cx
		mov	ds,_SEG0040
		xor	bx,bx
		movzx	bp,bh
		shl	bp,1
		mov	ds:[50h+bp],dx
		mov	al,dh
		mul	byte ptr ds:[4ah]
		movzx	cx,dl
		add	cx,ax
		push	dx
		mov	dx,ds:[63h]
		mov	al,0eh
		out	dx,al
		jmp	@@1
@@1:		inc	dx
		mov	al,ch
		out	dx,al
		jmp	@@2
@@2:		dec	dx
		mov	al,0fh
		out	dx,al
		jmp	@@3
@@3:		inc	dx
		mov	al,cl
		out	dx,al
		pop	dx
		pop	cx
		pop	ds
		pop	bp
		ret

@@GetCursorPos:	mov	cx,seg _SEG0040
		mov	ds,cx
		mov	ds,_SEG0040
		xor	bx,bx
		movzx	bp,bh
		shl	bp,1
		mov	dx,ds:[50h+bp]
		xor	ax,ax
		pop	cx
		pop	ds
		pop	bp
		ret
NewVideoInt	endp


		.8086

; !!End New!!


; !New! DGROUP@ is initialisized static

; The DGROUP@ variable is used to reload DS with DGROUP

PubSym@         DGROUP@, <dw    DGROUP>, __PASCAL__

; !EndNew!

; __MMODEL is used to determine the memory model or the default
; pointer types at run time.

		public __MMODEL
__MMODEL        dw      MMODEL

; !New! new variable

EmulateSwallow	dw	0	; Flag, wether Emulator will be installed

; !EndNew!

_TEXT           ENDS

		SUBTTL  Start Up Data Area
		PAGE
;[]------------------------------------------------------------[]
;|      Start Up Data Area                                      |
;|                                                              |
;|      WARNING         Do not move any variables in the data   |
;|                      segment unless you're absolutely sure   |
;|                      that it does not matter.                |
;[]------------------------------------------------------------[]

_DATA           SEGMENT

;       Magic symbol used by the debug info to locate the data segment
		public 	DATASEG@
DATASEG@        label   byte

;       The CopyRight string must NOT be moved or changed without
;       changing the null pointer check logic

CopyRight       db      4 dup(0)
		db      'Borland C++ - Copyright 1991 Borland Intl.',0
lgth_CopyRight  equ     $ - CopyRight

IF      LDATA  EQ  false
IFNDEF  __TINY__
CheckSum        equ     00D5Ch
NullCheck       db      'Null pointer assignment', 13, 10
lgth_NullCheck  equ     $ - NullCheck
ENDIF
ENDIF

; !New! here are some names and error messages

SwallowName	db	'SWALLOW.DRV',0
SwallowNameLen	equ	this byte - SwallowName

PathName	db	'PATH='
PathNameLen	equ	this byte - PathName

ParReal		db	'REAL'
ParRealLen	equ	this byte - ParReal

MsgNoExtFile	db	'Fatal error: extender "SWALLOW.DRV" not found.',13,10
MsgNoExtFileLen	equ	this byte - MsgNoExtFile
MsgOutOfMem	db	'Fatal error: not enough memory to load extender.',13,10
MsgOutOfMemLen	equ	this byte - MsgOutOfMem
MsgNoSegInfo	db	'Fatal error: Segment Description File "*.SEG" was not found.',13,10
MsgNoSegInfoLen	equ	this byte - MsgNoSegInfo
MsgInvSegInfo	db	'Fatal error: Segment Description File "*.SEG" is invalid.',13,10
MsgInvSegInfoLen equ	this byte - MsgInvSegInfo
MsgHugeError	db	'Huge pointer exceeded 64 KByte limit.',13,10
MsgHugeErrorLen	equ	this byte - MsgHugeError

; public flag, wether extender is active
PubSym@         SwallowIsActive <dw     0>,            __CDECL__

; internal flag, wether unwatched memory should be used
UseUnwMem	db	false

; Selectors for important segments
; they will be changed only in PM
PubSym@         Seg0040 	<dw   	40h>,          __CDECL__
PubSym@         SegA000 	<dw  0a000h>,          __CDECL__
PubSym@         SegB000 	<dw  0b000h>,          __CDECL__
PubSym@         SegB800 	<dw  0b800h>,          __CDECL__

; !EndNew!

ZeroDivMSG      db      'Divide error', 13, 10
lgth_ZeroDivMSG equ     $ - ZeroDivMSG

abortMSG        db      'Abnormal program termination', 13, 10
lgth_abortMSG   equ     $ - abortMSG

;
;                       Interrupt vector save areas
;
;       Interrupt vectors 0,4,5 & 6 are saved at startup and then restored
;       when the program terminates.  The signal/raise functions might
;       steal these vectors during execution.
;
;       Note: These vectors save area must not be altered
;             without changing the save/restore logic.
;
PubSym@         _Int0Vector     <dd     0>,             __CDECL__
PubSym@         _Int4Vector     <dd     0>,             __CDECL__
PubSym@         _Int5Vector     <dd     0>,             __CDECL__
PubSym@         _Int6Vector     <dd     0>,             __CDECL__
;
;                       Miscellaneous variables
;
PubSym@         _C0argc,        <dw     0>,             __CDECL__
dPtrPub@        _C0argv,        0,                      __CDECL__
dPtrPub@        _C0environ,     0,                      __CDECL__
PubSym@         _envLng,        <dw     0>,             __CDECL__
PubSym@         _envseg,        <dw     0>,             __CDECL__
PubSym@         _envSize,       <dw     0>,             __CDECL__
PubSym@         _psp,           <dw     0>,             __CDECL__
PubSym@         _version,       <label word>,           __CDECL__
PubSym@         _osversion,     <label word>,           __CDECL__
PubSym@         _osmajor,       <db     0>,             __CDECL__
PubSym@         _osminor,       <db     0>,             __CDECL__
PubSym@         errno,          <dw     0>,             __CDECL__
PubSym@         _StartTime,     <dw   0,0>,             __CDECL__

; !!New!!
; we set __LDT to the selector of the int 21 Handler
; so the Swallow-Emulator can find x87-Emulator-Patches
PubSym@         _LDT,     	<dw     0>,             __CDECL__
; !!EndNew!!



;       Memory management variables

IF      LDATA  EQ  false
PubSym@         __heapbase,     <dw   DGROUP:edata@>,   __CDECL__
ENDIF
IFNDEF __HUGE__
PubSym@         __brklvl,       <dw   DGROUP:edata@>,   __CDECL__
ENDIF
PubSym@         _heapbase,      <dd   0>,       __CDECL__
PubSym@         _brklvl,        <dd   0>,       __CDECL__
PubSym@         _heaptop,       <dd   0>,       __CDECL__

;       If stack in DS and Large data model then override location of __emu

IFDEF   _DSSTACK_
IF      LDATA
public  __emu
__emu   db      044h    DUP (0)
	db      0CCh    DUP (?)
ENDIF
ENDIF

_DATA           ENDS


_CVTSEG         SEGMENT
PubSym@         _RealCvtVector, <label  word>,  __CDECL__
		ENDS

_SCNSEG         SEGMENT
PubSym@         _ScanTodVector,  <label word>,  __CDECL__
		ENDS

IFNDEF __HUGE__
_BSS            SEGMENT
bdata@          label   byte
		ENDS

_BSSEND         SEGMENT
edata@          label   byte
                ENDS
ENDIF

IFNDEF __TINY__

; !New! increased because use of local vars and extender stack

_STACK          SEGMENT
		db      512 dup(?)               ; minimum stack size
		ENDS

; !EndNew!

ENDIF  ; __TINY__
		END     STARTX
