	TITLE	SYSINT

        include swallow.inc

	LOCALS	@@

; Keyboard scan codes

scSpaceKey	EQU	39H
scInsKey	EQU	52H
scDelKey	EQU	53H

; Keyboard shift flags

kbShiftKey	EQU	03H
kbCtrlKey	EQU	04H
kbAltKey	EQU	08H

; ROM BIOS workspace

KeyFlags	EQU	(BYTE PTR 17H)
KeyBufHead	EQU	(WORD PTR 1AH)
KeyBufTail	EQU	(WORD PTR 1CH)
KeyBufOrg	EQU	(WORD PTR 1EH)
KeyBufEnd	EQU	(WORD PTR 3EH)

; DOS function call classes

cNothing	EQU	0	;No check needed
cName		EQU	2	;Check name at DS:DX
cHandle		EQU	4	;Check handle in BX
cDrive		EQU	6	;Check drive in DL

; Data segment

_DATA		SEGMENT WORD PUBLIC 'DATA'

; Externals

	EXTRN	SysErrorFunc:DWORD
	EXTRN	CtrlBreakHit:BYTE
	EXTRN	SaveCtrlBreak:BYTE
	EXTRN	SysErrActive:BYTE

        extrn   Seg0040:Word
        extrn   SwallowIsActive:Word

_DATA		ENDS

; Data group

DGROUP		GROUP	_DATA

; Code segment

SYSINT_TEXT	SEGMENT	BYTE PUBLIC 'CODE'

	ASSUME	CS:SYSINT_TEXT,DS:DGROUP

	PUBLIC	Swallow_InitSysError
	PUBLIC	Swallow_DoneSysError

; CS-based variables

SaveInt09	DD	0	;Saved INT 09H vector
SaveInt1B	DD	0	;Saved INT 1BH vector
SaveInt21	DD	0	;Saved INT 21H vector
SaveInt23	DD	0	;Saved INT 23H vector
SaveInt24	DD	0	;Saved INT 24H vector

CopiedSeg0040   dw      ?       ;BIOS-datasegment
AliasCS         dw      ?       ;alias-segment of code

; Keyboard conversion table

KeyConvertTab	LABEL	BYTE

	DB	scSpaceKey,kbAltKey
	DW	0200H
	DB	scInsKey,kbCtrlKey
	DW	0400H
	DB	scInsKey,kbShiftKey
	DW	0500H
	DB	scDelKey,kbCtrlKey
	DW	0600H
	DB	scDelKey,kbShiftKey
	DW	0700H

KeyConvertCnt	EQU	($-KeyConvertTab)/4

; DOS function call class table

FuncClassTab	LABEL	BYTE

	DB	cDrive		;36H - Get disk free space
	DB	cNothing
	DB	cNothing
	DB	cName		;39H - Make directory
	DB	cName		;3AH - Remove directory
	DB	cName		;3BH - Change directory
	DB	cName		;3CH - Create file
	DB	cName		;3DH - Open file
	DB	cHandle		;3EH - Close file
	DB	cHandle		;3FH - Read file
	DB	cHandle		;40H - Write file
	DB	cName		;41H - Delete file
	DB	cHandle		;42H - Seek file
	DB	cName		;43H - Change file attributes
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cDrive		;47H - Get current directory
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cName		;4BH - Load or execute program
	DB	cNothing
	DB	cNothing
	DB	cName		;4EH - Find first
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cName		;56H - Rename file
	DB	cHandle		;57H - Get/Set file date and time

; Function check routines table

FuncCheckTab	LABEL	WORD

	DW	CheckNothing
	DW	CheckName
	DW	CheckHandle
	DW	CheckDrive

; Install system error handlers

Swallow_InitSysError:

	MOV	AX,3300H
	INT	21H
	MOV	SaveCtrlBreak,DL
	MOV	AX,3301H
	MOV	DL,0
	INT	21H
	PUSH	DS
        mov     cx,Seg0040
        mov     ax,cs
        cmp     SwallowIsActive,false
        je      @@NoSwallow
        mov     bx,ax
        mov     ax,knf_allocaliasld
        int     32h
@@NoSwallow:
        mov     ds,ax

        assume  ds:SYSINT_TEXT

        mov     CopiedSeg0040,cx
        mov     AliasCS,ax
        mov     ax,3509h
        int     21h
        mov     word ptr SaveInt09,bx
        mov     word ptr SaveInt09 + 2,es
        mov     al,1bh
        int     21h
        mov     word ptr SaveInt1b,bx
        mov     word ptr SaveInt1b + 2,es
        mov     al,21h
        int     21h
        mov     word ptr SaveInt21,bx
        mov     word ptr SaveInt21 + 2,es
        mov     al,23h
        int     21h
        mov     word ptr SaveInt23,bx
        mov     word ptr SaveInt23 + 2,es

        push    cs
        pop     ds
        lea     dx,Int09Handler
        mov     ax,2509h
        int     21h
        lea     dx,Int1bHandler
        mov     al,1bh
        int     21h
        lea     dx,Int23Handler
        mov     al,23h
        int     21h
        lea     dx,Int24Handler
        mov     al,24h
        int     21h
        mov     es,CopiedSeg0040

        MOV	AX,ES:[410H]
	AND	AX,0C1H
	DEC	AX
	JNE	@@3

        lea     dx,Int21Handler
        mov     ax,2521h
        int     21h
@@3:    MOV	AH,0BH
	INT	21H
        pop     ds

        assume  ds:_Data

	MOV	SysErrActive,1
	RETF

; Remove system error handlers

Swallow_DoneSysError:

	CMP	SysErrActive,0
	JE	@@1
	MOV	SysErrActive,0
	PUSH	DS

        lds     dx,SaveInt09
        mov     ax,2509h
        int     21h
        lds     dx,SaveInt1b
        mov     al,1bh
        int     21h
        lds     dx,SaveInt21
        mov     al,21h
        int     21h
        lds     dx,SaveInt23
        mov     al,23h
        int     21h
        lds     dx,SaveInt24
        mov     al,24h
        int     21h

	POP	DS
	MOV	AX,3301H
	MOV	DL,SaveCtrlBreak
	INT	21H
@@1:	RETF

; INT 09H handler signature

	DB	'TVI9'

; INT 09H handler

Int09Handler:

	PUSH	DS
	PUSH	DI
	PUSH	AX
	MOV	DS,CopiedSeg0040
	MOV	DI,DS:KeyBufTail
	IN	AL,60H
	MOV	AH,DS:KeyFlags
	PUSHF
	CALL	SaveInt09
	TEST	AL,80H
	JNE	@@9
	PUSH	SI
	PUSH	CX
        push    es
        mov     es,AliasCS
	MOV	SI,OFFSET CS:KeyConvertTab
	MOV	CX,KeyConvertCnt
@@1:	CMP	AL,es:[SI]
	JNE	@@2
	TEST	AH,es:[SI+1]
	JNE	@@3
@@2:	ADD	SI,4
	LOOP	@@1
	JMP	SHORT @@8
@@3:	CMP	DI,DS:KeyBufTail
	JNE	@@5
	MOV	AX,DI
	INC	AX
	INC	AX
	CMP	AX,OFFSET KeyBufEnd
	JNE	@@4
	MOV	AX,OFFSET KeyBufOrg
@@4:	CMP	AX,DS:KeyBufHead
	JE	@@8
	MOV	DS:KeyBufTail,AX
	MOV	DI,AX
@@5:	MOV	AX,es:[SI+2]
	MOV	DS:[DI],AX
@@8:	pop     es
        POP	CX
	POP	SI
@@9:	POP	AX
	POP	DI
	POP	DS
	IRET

; INT 1BH handler

Int1BHandler:

	PUSH	DS
	PUSH	AX
	MOV	DS,CopiedSeg0040
	AND	BYTE PTR DS:[71H],7FH
	MOV	AX,SEG DGROUP
	MOV	DS,AX
	MOV	CtrlBreakHit,1
	POP	AX
	POP	DS
	IRET

; INT 21H handler

Int21Handler:

	PUSHF
	STI
	CMP	AH,36H
	JB	@@1
	CMP	AH,57H
	JA	@@1
	PUSH	DX
	PUSH	BX
	MOV	BL,AH
	XOR	BH,BH
	MOV	BL,CS:FuncClassTab[BX-36H]
	CALL	CS:FuncCheckTab[BX]
	POP	BX
	POP	DX
	JC	@@2
@@1:	POPF
	JMP	SaveInt21
@@2:	POPF
	STI
	CMP	AH,36H
	MOV	AX,0FFFFH
	JE	@@3
	MOV	AX,5
@@3:	STC
	RETF	2

; Check filename

CheckName:

	MOV	BX,DX
	MOV	DX,[BX]
	AND	DL,1FH
	DEC	DL
	CMP	DH,':'
	JE	CheckAbsDrive
	JMP	SHORT CheckCurDrive

; Check handle

CheckHandle:

	MOV	BX,SP
	MOV	BX,SS:[BX+2]
	PUSH	AX
	MOV	AX,4400H
	PUSHF
	CALL	SaveInt21
	POP	AX
	OR	DL,DL
	JNS	CheckAbsDrive
	JMP	SHORT CheckNothing

; Check drive

CheckDrive:

	DEC	DL
	JNS	CheckAbsDrive

; Check current drive

CheckCurDrive:

	PUSH	AX
	MOV	AH,19H
	PUSHF
	CALL	SaveInt21
	MOV	DL,AL
	POP	AX

; Check absolute drive
; In	DL = Drive (0=A, 1=B, etc)
; Out	CF = 1 if drive swap failed

CheckAbsDrive:

	CMP	DL,2
	JAE	CheckNothing
	PUSH	DS
	PUSH	AX
	MOV	DS,CopiedSeg0040
	MOV	AL,DS:[104H]
	CMP	AL,0FFH
	JE	@@1
	CMP	DL,AL
	JE	@@1
	PUSH	ES
	PUSH	DS
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	CX
	MOV	AX,SEG DGROUP
	MOV	DS,AX
	MOV	AX,15
	PUSH	AX
	PUSH	DX
	CALL	SysErrorFunc
	POP	CX
	POP	DX
	POP	SI
	POP	DI
	POP	DS
	POP	ES
	NEG	AX
	JC	@@1
	MOV	DS:[104H],DL
@@1:	POP	AX
	POP	DS

; No check required

CheckNothing:

	RET

; INT 23H and temporary INT 10H handler

Int10Handler:
Int23Handler:

	IRET

; INT 24H handler

Int24Handler:

	STI				;Enable interrupts
	PUSH	ES			;Save registers
	PUSH	DS
	PUSH	BP
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	AND	DI,0FFH			;Error code in low byte
	PUSH	DI			;Save error code
	CMP	DI,9			;Printer out of paper
	JE	@@0			;Yes, @@0
	TEST	AH,80H			;Disk error?
	JE	@@1			;Yes, @@1
	MOV	DI,13			;Bad memory image of FAT
	MOV	DS,BP			;Point DS:SI to device header
	TEST	BYTE PTR DS:[SI+5],80H	;Block device?
	JE	@@1			;Yes, @@0
	INC	DI			;Device access error
@@0:	MOV	AL,0FFH			;No drive code
@@1:	MOV	DX,SEG DGROUP		;Setup DS
	MOV	DS,DX
	PUSH	DI			;Push error code
	PUSH	AX			;Push drive code
	CALL	SysErrorFunc		;Call system error handler
	POP	DI			;Restore error code
	OR	AX,AX			;Zero if retry
	MOV	AX,1			;Retry return code
	JE	@@3			;Jump if retry
	ADD	SP,(8+3)*2		;Remove saved regs and INT
	POP	AX			;Get INT 21H AX register
	ADD	DI,19			;Return AX = 19..31
	CMP	AH,39H			;DOS 2.0 style function?
	JAE	@@2			;Yes, @@1
	MOV	DI,0FFFFH		;Return AX = 0FFFFH
@@2:	MOV	AH,54H			;Dummy function call to get
	INT	21H			;DOS into a stable state
	MOV	AX,DI			;Get return code
	MOV	BP,SP			;Set CF in return flags
	OR	BYTE PTR [BP+20],1
@@3:	POP	BX			;Restore registers
	POP	CX
	POP	DX
	POP	SI
	POP	DI
	POP	BP
	POP	DS
	POP	ES
	IRET

SYSINT_TEXT	ENDS

	END
