;
; target information/control structures
;
		even
unit0		db	size unit dup (-1)
		even
unit1		db	size unit dup (-1)
		even
unit2		db	size unit dup (-1)
		even
unit3		db	size unit dup (-1)
		even
unit4		db	size unit dup (-1)
		even
unit5		db	size unit dup (-1)
		even
unit6		db	size unit dup (-1)
		ife reserve_addr
		even
unit7		db	size unit dup (-1)
		endif

		even
bpb0		db	size bpb dup (-1)
		even
bpb1		db	size bpb dup (-1)
		even
bpb2		db	size bpb dup (-1)
		even
bpb3		db	size bpb dup (-1)
		even
bpb4		db	size bpb dup (-1)
		even
bpb5		db	size bpb dup (-1)
		even
bpb6		db	size bpb dup (-1)
		even
bpb7		db	size bpb dup (-1)
		even
bpb8		db	size bpb dup (-1)
		even
bpb9		db	size bpb dup (-1)
		even
bpbA		db	size bpb dup (-1)
		even
bpbB		db	size bpb dup (-1)
		even
bpbC		db	size bpb dup (-1)
		even
bpbD		db	size bpb dup (-1)
		even
bpbE		db	size bpb dup (-1)
		even
bpbF		db	size bpb dup (-1)

		even
unit_array	dw	unit0
		dw	unit1
		dw	unit2
		dw	unit3
		dw	unit4
		dw	unit5
		dw	unit6
		ife reserve_addr
		dw	unit7
		endif

		even
bpb_array	dw	bpb0		;BPB Array for DOS
		dw	bpb1
		dw	bpb2
		dw	bpb3
		dw	bpb4
		dw	bpb5
		dw	bpb6
		dw	bpb7
		dw	bpb8
		dw	bpb9
		dw	bpbA
		dw	bpbB
		dw	bpbC
		dw	bpbD
		dw	bpbE
		dw	bpbF
bpb_hw_mark	dw	bpb_array

tape_unit	dw	-1
cur_unit	dw	unit0
cur_bpb		dw	bpb0

;
; Given the request header in es:bx
; Return a pointer in ds:di to the unit entry
; or 'C' if no such unit exists.
;
; Do not destroy es:bx !!!
;
find_unit	proc	near
		pusha
		mov	ah,es:[bx].rh_unit	;What drive did they want
		lea	di,unit_array
		lea	si,bpb_array
		mov	cx,MAXUNIT		;How many to search
find_loop:	mov	bx,[di]			;Point at a unit	
		mov	al,[bx].unit_num_drv	;Does this SCSI device
		or	al,al			;Have any Drives Defined?
		jz	find_next
		mov	dh,[bx].unit_1st_drv	;Get First Drive Number
find_unit_loop:	cmp	ah,dh			;Is this the correct drive?
		jz	find_match
		inc	si			;Bump to next BPB
		inc	si
		inc	dh			;Bump Drive Number
		dec	al			;Dec Drive count
		jnz	find_unit_loop		;Try next Drive
		jmp	short find_next		;Try next SCSI device
find_match:	mov	cur_unit,bx		;Found a match
		mov	ax,[si]
		mov	cur_bpb,ax
		clc
		jmp	find_exit
find_next:	inc	di
		inc	di
		loop	find_loop
		stc				;No More units, Error
find_exit:	popa
		ret
find_unit	endp

;
; Given the data in a unit entry,
; create the bpb for the unit.
;
make_bpb	proc	near
		mov	di,cur_bpb		;Get the current BPB
		mov	bx,cur_unit		;Get the current Unit
		mov	[di].bpb_ss,P_SECT
		mov	[di].bpb_au,CLUSTSIZE
		mov	[di].bpb_rs,1
		mov	[di].bpb_nf,2
		mov	[di].bpb_de,512
		mov	ah,[bx].unit_cap_buf.cap_sectors_b3
		mov	al,[bx].unit_cap_buf.cap_sectors_b2
		or	ax,ax
		jz	make_bpb_last		;Use up the last few sectors
		dec	ax			;Use up 65536 Sectors
		mov	[bx].unit_cap_buf.cap_sectors_b3,ah
		mov	[bx].unit_cap_buf.cap_sectors_b2,al
		mov	dx,65535		;Max of 32 Meg
		jmp	short make_bpb_ts
make_bpb_last:	mov	dh,[bx].unit_cap_buf.cap_sectors_b1
		mov	[bx].unit_cap_buf.cap_sectors_b1,0
		mov	dl,0			;Round to nearest Cyl
		mov	[bx].unit_cap_buf.cap_sectors_b0,0
		dec	dx			;Make it zero relative
make_bpb_ts:	mov	[di].bpb_ts,dx
		mov	[di].bpb_md,0F8h
		shr	dx,SECT_2_FS
		inc	dx			;Allow for round-off
		mov	[di].bpb_fs,dx
		mov	[di].bpb_st,SECT_TRACK
		mov	[di].bpb_nh,1
		mov	[di].bpb_hs_lsw,0
		mov	[di].bpb_hs_msw,0
		ret
make_bpb	endp
