;
; Allow multi_sector reads and writes.
;
; This means that a read request of less then CHUNK_MAX
; sectors will be done in one request to the drive rather
; then multiple single sector requests.
;
; The disadvantage here is that the code in receive_data()
; and send_data() must keep the transfer from exceding the
; 512 byte buffer on the ST-01 card.
;
multi_sector	=	1	;Enable multi_sector support

;
; Use the extended SCSI commands for reads and writes.
;
; This means that we can access drives larger then 1Gb
; and read/write more then 256 sectors per command.
;
; The disadvantage here is that not all devices support
; the extended command set.
;
extended_io	=	0	;Disable use of extended io commands

;
; Use parity on the SCSI bus
;
scsi_parity	=	1	;Enable use of parity on the SCSI bus

;
; Reserve SCSI Address 7 for card
;
reserve_addr	=	1	;Reserve Address for Card Use

;
; Dump Sense information to the screen
;
dump_sense	=	1	;Dump Sense Message to the Screen

;
; Extended Sense or Normal Sense
;
extended_sense	=	1	;Request Extended Sense

;
; Include the code to kludge the RAW ioctl call after an open
;
use_kludge	=	1	;Enable the ioctl kludge
