/******************************************************************************
 *                                                                            *
 *      Header          :       PTMIK OBJ                                     *
 *      Author          :       Marq/Fit                                      *
 *      Version         :       0.5                                           *
 *      Description     :       Functions for 4-channel PT/NST/ST module      *
 *                              playing with DAC, SB & GUS                    *
 *                              The same as PTMIK.H but in OBJ form           *
 *                                                                            *
 ******************************************************************************/

#include <alloc.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>

#define pt_MASTER_CLK 3546836l
#define pt_ERROR 0
#define pt_OK 1
#define pt_DAC 0
#define pt_SB 1
#define pt_GUS 2
#define pt_LPT1 peek(0x40,0x6+2)
#define pt_LPT2 peek(0x40,0x6+4)
#define pt_LPT3 peek(0x40,0x6+6)
#define pt_LPT4 peek(0x40,0x6+8)

#define GUS_START 2
#define GUS_END 4
#define GUS_CURRENT 0xa
#define GUS_GF1_RESET 0x4c     
#define GUS_VOICE_CONTROL 0
#define GUS_ACTIVE_VOICES 0xe

extern int     pt_curpos,
        pt_index,
        pt_inst,
        pt_itemp,
        pt_mainvol,
        pt_pattdelay,
        pt_curper[4],
        pt_vol[4],
        pt_cvol[4],
        pt_tonedest[4],
        pt_tonespd[4],
        pt_jumpdest[4],
        pt_jumpcnt[4];

extern unsigned        pt_freq,
                pt_device,
                pt_port,
                pt_SB_port,
                pt_counter,
                pt_VBmax,
                pt_VBcnt,
                pt_oldmax,
                pt_speed,
                pt_save_speed,
                pt_row,
                pt_off,
                pt_temp,
                pt_slen[31],
                pt_roff[31],
                pt_rlen[31],
                pt_sseg[31],
                pt_clen[4],
                pt_sdec[4],
                pt_snum[4],
                pt_next[4],
                pt_add_off[4],
                pt_add_dec[4],
                pt_vib_off[4],
                pt_vib_size[4],
                pt_vib_spd[4],
                pt_tre_off[4],
                pt_tre_size[4],
                pt_tre_spd[4],
                pt_note[4],
                pt_per_off[1024],
                pt_per_dec[1024],
                gus_baseaddr,
                gus_maxfrequency;

extern unsigned char   pt_modlen,
                pt_cmd,
                pt_prm,
                pt_ptns,
                pt_on[4],
                pt_pos[128],
                pt_loop[31],
                pt_svol[31],
                pt_finetune[31],
                pt_songname[21],
                *pt_patt[100],
                *pt_smp[31],
                gus_pan[4];

extern unsigned long   pt_address[4],
                gus_start[31],
                gus_end[31],
                gus_repeat[31],
                gus_meminstalled,
                gus_availstart;

extern unsigned pt_period[];

extern int     pt_vib_table[64];

int pt_init(int device,unsigned port);
int pt_load(char *path);
int pt_play(unsigned freq);
void pt_stop(void);
void pt_pause(void);
void pt_continue(void);
void pt_SB_handler(void);
void pt_DAC_handler(void);
void interrupt pt_GUS_handler(void);
void pt_commands(void);
void pt_retrig(int n);
void pt_checkloop(void);
/* void interrupt (*pt_oldfunc)(); */
void pt_calc_inc(void);
void pt_settimer(unsigned freq);
void pt_resettimer(void);
void pt_restoreclock(void);
unsigned pt_bcd2d(unsigned bcd);
int pt_resetSB(int ba);
void gus_pokeb(unsigned addr_hi,unsigned addr_lo,unsigned char data);
unsigned char gus_peekb(unsigned addr_hi,unsigned addr_lo);
void gus_outb(int reg,unsigned char data);
void gus_outw(int reg,unsigned data);
void gus_setperiod(unsigned per);
void gus_resetGF1(void);
void gus_delay(void);
int gus_reset(int portti);
void gus_vol(unsigned vol);
void gus_setlocation(unsigned char l_type,long loca);
void gus_selectvoice(unsigned chan);
void gus_transferblock(unsigned seg0,unsigned ofs0,unsigned adhi,unsigned adlo,unsigned tsize);
void gus_handler(void);
void gus_retrig(int n);

/*** End of File ***/
