unit matrix;
interface
uses loadasc;
type matriisi=array[0..3,0..3] of real;
     fmatriisi=array[0..3,0..3] of longint;

procedure vek_mul_mat(vek:vertextype; var result:vertextype; mat:matriisi);
{vektori*reaalilukumatriisi}

procedure vekF_mul_fmat(vek:vertextype; var result:vertextype; mat:fmatriisi);
{vektori*fixedmatriisi ja tulos ei-fixed-lukuna}

procedure vek_mul_fmat(vek:vertextype; var result:lvertextype; mat:fmatriisi);
{vektori*fixedmatriisi ja tulos .8 fixed-lukuna}

procedure teepyoritysmatriisi(var m:matriisi; sx,sy,sz,cx,cy,cz,x,y,z:real);
{tekee reaalilukumatriisin}

procedure teepyoritysfmatriisi(var m:fmatriisi; sx,sy,sz,cx,cy,cz,x,y,z:longint);
{tekee fixedmatriisin}

procedure fmatmul(m1,m2:fmatriisi; var result:fmatriisi);
{fmatriisi*fmatriisi}

implementation

procedure vek_mul_mat(vek:vertextype; var result:vertextype; mat:matriisi);
type l=longint;
begin
 result.x:=round(mat[0,0]*l(vek.x)+mat[0,1]*l(vek.y)+mat[0,2]*l(vek.z)+mat[0,3]);
 result.y:=round(mat[1,0]*l(vek.x)+mat[1,1]*l(vek.y)+mat[1,2]*l(vek.z)+mat[1,3]);
 result.z:=round(mat[2,0]*l(vek.x)+mat[2,1]*l(vek.y)+mat[2,2]*l(vek.z)+mat[2,3]);
{3dica:
                 a b c 0 
   (Xi+Yj+Zk) *  e f g 0  = (aX+eY+iZ+m)i + (bX+fY+jZ+n)j +
                 i j k 0    (cX+gY+kZ+o)k
                 m n o 1 
}
end;

procedure teepyoritysmatriisi(var m:matriisi; sx,sy,sz,cx,cy,cz,x,y,z:real);
begin
 m[0,0]:=cy*cz;
 m[1,0]:=cy*sz;
 m[2,0]:=-sy;
 m[3,0]:=0;
 m[0,1]:=sx*sy*cz-cx*sz;
 m[1,1]:=sx*sy*sz+cx*cz;
 m[2,1]:=sx*cy;
 m[3,1]:=0;
 m[0,2]:=cx*sy*cz+sx*sz;
 m[1,2]:=cx*sy*sz-sx*cz;
 m[2,2]:=cx*cy;
 m[3,2]:=0;
 m[0,3]:=x;
 m[1,3]:=y;
 m[2,3]:=z;
 m[3,3]:=1;
{3dica:
                      cy*cz          cy*sz          -sy    0 
                      sx*sy*cz-cx*sz sx*sy*sz+cx*cz  sx*cy 0 
       [X]*[Y]*[Z] =  cx*sy*cz+sx*sz cx*sy*sz-sx*cz  cx*cy 0 
                      0              0               0     1 
}
end;

function lmul(op1,op2:longint):longint;
inline($66/$58/             {pop eax}
       $66/$5A/             {pop edx}
       $66/$F7/$EA);         {imul edx}
{       $66/$0F/$A4/$C2/$08);{shld edx,eax,8}

procedure vekF_mul_fmat(vek:vertextype; var result:vertextype; mat:fmatriisi);
type l=longint;
begin
 result.x:=(mat[0,0]*l(vek.x)+mat[0,1]*l(vek.y)+mat[0,2]*l(vek.z)) div 256+mat[0,3];
 result.y:=(mat[1,0]*l(vek.x)+mat[1,1]*l(vek.y)+mat[1,2]*l(vek.z)) div 256+mat[1,3];
 result.z:=(mat[2,0]*l(vek.x)+mat[2,1]*l(vek.y)+mat[2,2]*l(vek.z)) div 256+mat[2,3];
{3dica:
                 a b c 0 
   (Xi+Yj+Zk) *  e f g 0  = (aX+eY+iZ+m)i + (bX+fY+jZ+n)j +
                 i j k 0    (cX+gY+kZ+o)k
                 m n o 1 
}
end;

procedure vek_mul_fmat(vek:vertextype; var result:lvertextype; mat:fmatriisi);
type l=longint;
begin
 asm db $66,$90; end;

 result.x:=mat[0,0]*l(vek.x)+mat[0,1]*l(vek.y)+mat[0,2]*l(vek.z);
 result.y:=mat[1,0]*l(vek.x)+mat[1,1]*l(vek.y)+mat[1,2]*l(vek.z);
 result.z:=mat[2,0]*l(vek.x)+mat[2,1]*l(vek.y)+mat[2,2]*l(vek.z);

 asm db $66,$90; end;

{3dica:
                 a b c 0 
   (Xi+Yj+Zk) *  e f g 0  = (aX+eY+iZ+m)i + (bX+fY+jZ+n)j +
                 i j k 0    (cX+gY+kZ+o)k
                 m n o 1 
}
end;

procedure teepyoritysfmatriisi(var m:fmatriisi; sx,sy,sz,cx,cy,cz,x,y,z:longint);
begin
 m[0,0]:=cy*cz div 256;
 m[1,0]:=cy*sz div 256;
 m[2,0]:=-sy;
 m[3,0]:=0;
 m[0,1]:=sx*sy*cz div 65536-cx*sz div 256;
 m[1,1]:=sx*sy*sz div 65536+cx*cz div 256;
 m[2,1]:=sx*cy div 256;
 m[3,1]:=0;
 m[0,2]:=cx*sy*cz div 65536+sx*sz div 256;
 m[1,2]:=cx*sy*sz div 65536-sx*cz div 256;
 m[2,2]:=cx*cy div 256;
 m[3,2]:=0;
 m[0,3]:=x;
 m[1,3]:=y;
 m[2,3]:=z;
 m[3,3]:=1;
{3dica:
                      cy*cz          cy*sz          -sy    0 
                      sx*sy*cz-cx*sz sx*sy*sz+cx*cz  sx*cy 0 
       [X]*[Y]*[Z] =  cx*sy*cz+sx*sz cx*sy*sz-sx*cz  cx*cy 0 
                      0              0               0     1 
}
end;

procedure fmatmul(m1,m2:fmatriisi; var result:fmatriisi);
var a,b:byte;
begin
 for a:=0 to 3 do
  for b:=0 to 3 do
   result[a,b]:=
    (m1[a,0]*m2[0,b]+m1[a,1]*m2[1,b]+m1[a,2]*m2[2,b]+m1[3,1]*m2[3,b]) div 256;
{
    a b c     k l m     ak+bn+cq al+bo+cr am+bp+cs 
    d e f  *  n o p  =  dk+en+fq dl+eo+fr dm+ep+fs 
    h i j     q r s     hk+in+jq hl+io+jr hm+ip+js 
}
end;

begin
end.