{$M 64000,100000,100000}
program _3dican_pascal_esimerkki_ohjelma_nro_2_by_kaitsu_;
{lambert flat}
uses sumthing,loadasc,polygon,extra,matrix,vector,kello;

const xnopeus=400000; {objektin pyritysnopeus}
      ynopeus=500000;
      znopeus=600000;
      valo:vertextype=(x:0; y:0; z:64);

var torus:objtype; {objecti jota pyritelln}
    nor,rotnor:array[0..maxfaces-1] of vertextype;
    rot:array[0..maxvertices-1] of vertextype; {pyrityksen tulos}
    start_time,finish_time,frames:longint;

procedure rotate(obj:objtype; rx,ry,rz:word; x,y,z:longint);
var i,x1,z1,y1:integer;
    mat:matriisi;
begin
 teepyoritysmatriisi(mat,st[rx]/256,st[ry]/256,st[rz]/256,
                     ct[rx]/256,ct[ry]/256,ct[rz]/256,0,0,0);
 for i:=0 to obj.faces-1 do vek_mul_mat(nor[i],rotnor[i],mat);

 teepyoritysmatriisi(mat,st[rx]/256,st[ry]/256,st[rz]/256,
                     ct[rx]/256,ct[ry]/256,ct[rz]/256,x,y,z);
 for i:=0 to obj.vertices-1 do vek_mul_mat(obj.vertex[i],rot[i],mat);
end;

procedure draw(obj:objtype);
var i,a,c:integer;
    order:array[0..maxfaces-1] of word;
    zval:array[0..maxfaces-1] of longint;

function partition(left,righ:word):word;
var i,j,t:longint;
    x:integer;
begin
 x:=zval[order[left]];
 i:=longint(left)-1;
 j:=longint(righ)+1;
 while (0=0) do begin
  repeat dec(j); until (zval[order[j]]<=x);
  repeat inc(i); until (zval[order[i]]>=x);
  if i<j then begin
   t:=order[i];
   order[i]:=order[j];
   order[j]:=t;
  end else begin
   partition:=j;
   exit;
  end;
 end;
end;

procedure qsort(lef,rig:word);
var gap:word;
begin
 if (lef<rig) then begin
  gap:=partition(lef,rig);
  qsort(lef,gap);
  qsort(gap+1,rig);
 end;
end;

begin
 for i:=0 to obj.faces-1 do order[i]:=i;
 for i:=0 to obj.faces-1 do
  zval[i]:=longint(rot[obj.face[order[i]].a].z)+
           longint(rot[obj.face[order[i]].b].z)+
           longint(rot[obj.face[order[i]].c].z);
 qsort(0,obj.faces-1);
 with obj do
  for a:=0 to faces-1 do begin
   i:=order[a];
   if visable(rot[face[i].a].x,rot[face[i].a].y,
              rot[face[i].b].x,rot[face[i].b].y,
              rot[face[i].c].x,rot[face[i].c].y)
    then begin
     c:=(valo.x*rotnor[i].x+valo.y*rotnor[i].y+valo.z*rotnor[i].z) div 64;
     if c<1 then c:=1 else if c>63 then c:=63;

     kol(rot[face[i].a].x,rot[face[i].a].y,
         rot[face[i].b].x,rot[face[i].b].y,
         rot[face[i].c].x,rot[face[i].c].y,
         c,virt);
    end;
  end;

end;

procedure calc_face_normals(obj:objtype);
var i:integer;
    len:real;
    ox,oy,oz:longint;
begin
 len:=sqrt(valo.x*valo.x+valo.y*valo.y+valo.z*valo.z);
 valo.x:=round(valo.x*64/len); {normalisoidaan valovektori}
 valo.y:=round(valo.y*64/len); {tehrn sen pituudeksi 64}
 valo.z:=round(valo.z*64/len);

 fillchar(nor,sizeof(nor),0);

 with obj do
  for i:=0 to faces-1 do begin
    calcnormal(vertex[face[i].a].x,vertex[face[i].a].y,vertex[face[i].a].z,
               vertex[face[i].b].x,vertex[face[i].b].y,vertex[face[i].b].z,
               vertex[face[i].c].x,vertex[face[i].c].y,vertex[face[i].c].z,
               ox,oy,oz); {lasketaan facelle normaali}
    len:=sqrt(ox*ox+oy*oy+oz*oz);
    if len=0 then len:=1;
    nor[i].x:=round((ox/len)*64);
    nor[i].y:=round((oy/len)*64);
    nor[i].z:=round((oz/len)*64);
  end;

end;

procedure main;
var rx,ry,rz:longint;
    falku,floppu:longint;
begin
 rx:=0;
 ry:=0;
 rz:=0;
 frames:=0;
 start_time:=klo;
 falku:=klo;
 repeat
  inc(frames);
  rotate(torus,(rx shr 22) and 1023,
               (ry shr 22) and 1023,
               (rz shr 22) and 1023,
               160,100,0);
  draw(torus);
  flips(virt);
  clear(virt);
  floppu:=klo;
  inc(rx,(floppu-falku)*xnopeus);
  inc(rz,(floppu-falku)*ynopeus);
  inc(ry,(floppu-falku)*znopeus);
  falku:=floppu;
 until keypressed;
 finish_time:=klo;
end;

procedure pal;
var i,t:integer;
    cosi:real;
begin
 for i:=1 to 63 do begin
  cosi:=(i*pi/128);
  t:=round((1+cosi*40+cosi*cosi*30)/2);
  if t<0 then t:=0;
  if t>63 then t:=63;
  setcolor(i,32+t div 2,t,32+t div 2);
 end;
end;

begin
 init;
 lataa_asc('toorus.asc',torus,1.7);
 calc_face_normals(torus);
 setmode($13);
 pal;
 lataa;
 main;
 while keypressed do readkey;
 poista;
 setmode($3);
 close;
 writeln('average fps ',frames*1000/(finish_time-start_time):0:2);
end.