
/*                                                                       */
/*      Fast classic texturemapping algorithms (c) Ica /Hubris 1997      */
/*                          in djgpp 2.01                                */
/*                                                                       */
/*           These will be optimized even more (lots of ideas)           */
/*                                                                       */

#define v_putpixel(x,y,c) virscr[(x)+(y)*320]=(c)
#define byte unsigned char

byte virscr[64000];
byte tmap[65536]; // texturemap 256*256


// Rutiinille ilmoitetaan x:t ja y normaalisti ja u:t sek v:t kerrottuina
// wordilla.
// X:t sortataan suuruusjrjestykseen jo kolmion init-osassa.
void inline t_hline(long xb,long xe,long y,long ub,long ue,
                    long vb,long ve)
{
  long tmp;
  long dx,du,dv;
  long ku,kv;
  if ((xb>319)||(xe<0)) return;
  if (xb==xe)
  { v_putpixel(xb,y,tmap[(ub+ue)/131072+(vb+ve)/131072*256]);
    return; }
  dx=xe-xb;
  ku=(ue-ub)/dx;
  kv=(ve-vb)/dx;
  if (xe>319) xe=319;
  if (xb<0)
  { du=ub-ku*xb;dv=vb-kv*xb;xb=0; }
  else { du=ub;dv=vb; }
  for (tmp=xb;tmp<=xe;tmp++)
  {
    v_putpixel(tmp,y,tmap[du/65536+dv/65536*256]);
    du+=ku;dv+=kv;
  }
}


void t_triangle(long x1,long y1,long u1,long v1,
                long x2,long y2,long u2,long v2,
                long x3,long y3,long u3,long v3)
{
  long x[3]={x1,x2,x3},y[3]={y1,y2,y3};
  long u[3]={u1,u2,u3},v[3]={v1,v2,v3};
  long tmp;
  long kx[3],ku[3],kv[3];
  long dx[3],dy[3],du[3],dv[3];
  byte b[2];

  if (y[1]<y[0])
  { tmp=y[1];y[1]=y[0];y[0]=tmp;
    tmp=x[1];x[1]=x[0];x[0]=tmp;
    tmp=u[1];u[1]=u[0];u[0]=tmp;
    tmp=v[1];v[1]=v[0];v[0]=tmp; }
  if (y[2]<y[0])
  { tmp=y[2];y[2]=y[0];y[0]=tmp;
    tmp=x[2];x[2]=x[0];x[0]=tmp;
    tmp=u[2];u[2]=u[0];u[0]=tmp;
    tmp=v[2];v[2]=v[0];v[0]=tmp; }
  if (y[2]<y[1])
  { tmp=y[2];y[2]=y[1];y[1]=tmp;
    tmp=x[2];x[2]=x[1];x[1]=tmp;
    tmp=u[2];u[2]=u[1];u[1]=tmp;
    tmp=v[2];v[2]=v[1];v[1]=tmp; }
  if (y[0]>199)return;
  if (y[2]<0)return;
  dx[0]=x[1]-x[0];dx[1]=x[2]-x[1];dx[2]=x[2]-x[0];
  dy[0]=y[1]-y[0];dy[1]=y[2]-y[1];dy[2]=y[2]-y[0];
  du[0]=u[1]-u[0];du[1]=u[2]-u[1];du[2]=u[2]-u[0];
  dv[0]=v[1]-v[0];dv[1]=v[2]-v[1];dv[2]=v[2]-v[0];
  for (tmp=0;tmp<3;tmp++)
    if (dy[tmp]!=0)
    { kx[tmp]=(dx[tmp]*65536)/dy[tmp];
      ku[tmp]=(du[tmp]*65536)/dy[tmp];
      kv[tmp]=(dv[tmp]*65536)/dy[tmp]; }
    else { kx[tmp]=0;ku[tmp]=0;kv[tmp]=0; }
  dx[0]=dx[2]=x[0]*65536;dx[1]=x[1]*65536;
  du[0]=du[2]=u[0]*65536;du[1]=u[1]*65536;
  dv[0]=dv[2]=v[0]*65536;dv[1]=v[1]*65536;
  if (y[1]>199)
  { y[1]=199;y[2]=198; }
  else if (y[2]>199) y[2]=199;
  if (kx[0]<kx[2])
  { b[0]=0;b[1]=2; }
  else
  { b[0]=2;b[1]=0; }

  if (y[1]>=0)
  {
    if (y[0]<0)
    { dx[0]-=kx[0]*y[0];dx[2]-=kx[2]*y[0];
      du[0]-=ku[0]*y[0];du[2]-=ku[2]*y[0];
      dv[0]-=kv[0]*y[0];dv[2]-=kv[2]*y[0];y[0]=0; }
    for (tmp=0;tmp<(y[1]-y[0]);tmp++)
    {
      t_hline(dx[b[0]]/65536,dx[b[1]]/65536,tmp+y[0],
              du[b[0]],du[b[1]],dv[b[0]],dv[b[1]]);
      dx[0]+=kx[0];dx[2]+=kx[2];
      du[0]+=ku[0];du[2]+=ku[2];
      dv[0]+=kv[0];dv[2]+=kv[2];
    }
  }
  else
  { dx[1]-=kx[1]*y[1];dx[2]-=kx[2]*y[0];
    du[1]-=ku[1]*y[1];du[2]-=ku[2]*y[0];
    dv[1]-=kv[1]*y[1];dv[2]-=kv[2]*y[0];y[1]=0; }
  if (kx[1]>kx[2])
  { b[0]=1;b[1]=2; }
  else
  { b[0]=2;b[1]=1; }
  for (tmp=0;tmp<(y[2]-y[1]);tmp++)
  {
    t_hline(dx[b[0]]/65536,dx[b[1]]/65536,tmp+y[1],
            du[b[0]],du[b[1]],dv[b[0]],dv[b[1]]);
    dx[1]+=kx[1];dx[2]+=kx[2];
    du[1]+=ku[1];du[2]+=ku[2];
    dv[1]+=kv[1];dv[2]+=kv[2];
  }
}

