{$M 64000,100000,100000}
program _3dican_pascal_esimerkki_ohjelma_nro_4_by_kaitsu_;
{gouraud, fmatriisi, perspektiivi}
uses sumthing,loadasc,polygon,extra,matrix,vector,kello;

const xnopeus=600000; {objektin pyritysnopeus}
      ynopeus=500000;
      znopeus=400000;
      valo:vertextype=(x:0; y:0; z:64);
      perspektiivi=200;

var torus:objtype; {objecti jota pyritelln}
    vernor, {objektin normaalit}
    rotnor, {rotatoidut normaalit}
    rot:array[0..maxvertices-1] of vertextype; {pyrityksen tulos}
    start_time,finish_time,frames:longint;

procedure rotate(obj:objtype; rx,ry,rz:word; x,y,z:longint);
var i,x1,y1,z1:integer;
    mat:fmatriisi;
    rota:lvertextype;
begin
 teepyoritysfmatriisi(mat,st[rx],st[ry],st[rz],
                      ct[rx],ct[ry],ct[rz],0,0,0);
 for i:=0 to obj.vertices-1 do vekF_mul_fmat(vernor[i],rotnor[i],mat);

 teepyoritysfmatriisi(mat,st[rx],st[ry],st[rz],
                      ct[rx],ct[ry],ct[rz],x,y,z);
 for i:=0 to obj.vertices-1 do begin
  vek_mul_fmat(torus.vertex[i],rota,mat);
  rot[i].z:=rota.z div perspektiivi+z;
  if rot[i].z=256 then rot[i].z:=257;
  rot[i].x:=(rota.x div (256-rot[i].z))+x;
  rot[i].y:=(rota.y div (256-rot[i].z))+y;
 end;
end;

procedure draw(obj:objtype);
var i,a:integer;
    c1,c2,c3:longint;
    order:array[0..maxfaces-1] of word;
    zval:array[0..maxfaces-1] of longint;

function partition(left,righ:word):word;
var i,j,t:longint;
    x:integer;
begin
 x:=zval[order[left]];
 i:=longint(left)-1;
 j:=longint(righ)+1;
 while (0=0) do begin
  repeat dec(j); until (zval[order[j]]<=x);
  repeat inc(i); until (zval[order[i]]>=x);
  if i<j then begin
   t:=order[i];
   order[i]:=order[j];
   order[j]:=t;
  end else begin
   partition:=j;
   exit;
  end;
 end;
end;

procedure qsort(lef,rig:word);
var gap:word;
begin
 if (lef<rig) then begin
  gap:=partition(lef,rig);
  qsort(lef,gap);
  qsort(gap+1,rig);
 end;
end;

begin
 for i:=0 to obj.faces-1 do order[i]:=i;
 for i:=0 to obj.faces-1 do
  zval[i]:=longint(rot[obj.face[order[i]].a].z)+
           longint(rot[obj.face[order[i]].b].z)+
           longint(rot[obj.face[order[i]].c].z);
 qsort(0,obj.faces-1);
 with obj do
  for a:=0 to faces-1 do begin
   i:=order[a];
   if visable(rot[face[i].a].x,rot[face[i].a].y,
              rot[face[i].b].x,rot[face[i].b].y,
              rot[face[i].c].x,rot[face[i].c].y)
    then begin
     c1:=(valo.x*rotnor[face[i].a].x+         {valovektorin ja verteksi-}
          valo.y*rotnor[face[i].a].y+         {normaalin vlisen kulman}
          valo.z*rotnor[face[i].a].z) div 64; {kosini}
     c2:=(valo.x*rotnor[face[i].b].x+
          valo.y*rotnor[face[i].b].y+
          valo.z*rotnor[face[i].b].z) div 64;
     c3:=(valo.x*rotnor[face[i].c].x+
          valo.y*rotnor[face[i].c].y+
          valo.z*rotnor[face[i].c].z) div 64;

     if c1<1 then c1:=1 else if c1>63 then c1:=63;
     if c2<1 then c2:=1 else if c2>63 then c2:=63;
     if c3<1 then c3:=1 else if c3>63 then c3:=63;

     gouraud_kol(rot[face[i].a].x,rot[face[i].a].y,
                 rot[face[i].b].x,rot[face[i].b].y,
                 rot[face[i].c].x,rot[face[i].c].y,
                 c1,c2,c3,virt);
    end;
  end;

end;

procedure main;
var rx,ry,rz:longint;
    falku,floppu:longint;
begin
 rx:=0;
 ry:=0;
 rz:=0;
 frames:=0;
 start_time:=klo;
 falku:=klo;
 repeat
  inc(frames);
  rotate(torus,(rx shr 22) and 1023,
               (ry shr 22) and 1023,
               (rz shr 22) and 1023,
               160,100,0);

  draw(torus);
  flips(virt);
  clear(virt);
  floppu:=klo;
  inc(rx,(floppu-falku)*xnopeus);
  inc(rz,(floppu-falku)*ynopeus);
  inc(ry,(floppu-falku)*znopeus);
  falku:=floppu;
 until keypressed;
 finish_time:=klo;
end;

procedure calc_vertex_normals(obj:objtype);
var i,a:integer;
    cx,cy,cz,len:real;
    cn,ox,oy,oz:longint;
begin
 len:=sqrt(valo.x*valo.x+valo.y*valo.y+valo.z*valo.z);
 valo.x:=round(valo.x*64/len);
 valo.y:=round(valo.y*64/len);
 valo.z:=round(valo.z*64/len);

 fillchar(vernor,sizeof(vernor),0);

 with obj do
  for i:=0 to vertices-1 do begin
   cx:=0; cy:=0; cz:=0; cn:=0;

   for a:=0 to faces-1 do if (face[a].a=i) or (face[a].b=i) or (face[a].c=i) then begin
    calcnormal(vertex[face[a].a].x,vertex[face[a].a].y,vertex[face[a].a].z,
               vertex[face[a].b].x,vertex[face[a].b].y,vertex[face[a].b].z,
               vertex[face[a].c].x,vertex[face[a].c].y,vertex[face[a].c].z,
               ox,oy,oz);
    len:=sqrt(ox*ox+oy*oy+oz*oz);
    if len=0 then len:=1;
    cx:=cx+(ox/len);
    cy:=cy+(oy/len);
    cz:=cz+(oz/len);
    inc(cn,1);
   end;

   if cn>0 then begin
    cx:=cx/cn;
    cy:=cy/cn;
    cz:=cz/cn;
    len:=sqrt(cx*cx+cy*cy+cz*cz);
    if len=0 then len:=1;
    vernor[i].x:=round((cx/len)*64);
    vernor[i].y:=round((cy/len)*64);
    vernor[i].z:=round((cz/len)*64);
   end;

  end;

end;

procedure pal;
var i,t:integer;
    cosi:real;
begin
{ for i:=1 to 63 do setcolor(i,i,i,i);}
 for i:=1 to 63 do begin
  cosi:=(i*pi/128);
  t:=round((1+cosi*40+cosi*cosi*30)/2);
  if t<0 then t:=0;
  if t>63 then t:=63;
  setcolor(i,t,t,32+t div 2);
 end;
end;

begin
 init;
 lataa_asc('toorus.asc',torus,1.3);
 calc_vertex_normals(torus);
 setmode($13);
 pal;
 lataa;
 main;
 while keypressed do readkey;
 poista;
 setmode($3);
 close;
 writeln('average fps ',frames*1000/(finish_time-start_time):0:2);

end.