/*
 * xrect.s - rectangle fill and copy routines
 *
 * DESCRIPTION
 * Includes rectangle fill, and screen-screen memory copy routines
 *
 * USAGE
 *
 * NOTES
 * Based on xlib60 for BC by Themie Goumas, from code in DDJ by M. Abrash
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 * 30 Aug 95    Minor optimizations
 *
 */
        
        .data
        .align  4
Height:
        .long   0
RectAddrW:
        .long   0
SrcNextOffs:
        .long   0
DestNextOffs:
        .long   0
LeftClipPlaneMask:
        .byte   0x0f, 0x0e, 0x0c, 0x08
RightClipPlaneMask:
        .byte   0x0f, 0x01, 0x03, 0x07
DSSave:
        .word   0

        .text
        .globl  _x_rect_fill
        .globl  _x_cp_vid_rect
        .globl  _ScrnLogicalByteWidth
        .extern _core_select

/*************************************************************************/
/* x_rect_fill(int startX, int startY, int endX, int endY, int PageBase,   */
/*              BYTE color);                                             */
/*         %ebp+    8          12         16        20       24     28   */
/*************************************************************************/
_x_rect_fill:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %edi
        pushl   %esi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es

        movl    _ScrnLogicalByteWidth, %eax
        imul    12(%ebp), %eax
        movl    8(%ebp), %edi
        shrl    $2, %edi
        addl    %eax, %edi
        addl    24(%ebp), %edi
        addl    $0xa0000, %edi
        movw    _core_select,%ax
        movw    %ax,%es

        movw    $0x3c4, %dx
        movb    $0x02, %al
        outb    %al, %dx
        incw    %dx
        movl    8(%ebp), %esi
        andl    $0x03, %esi
        
        movl    $LeftClipPlaneMask, %ecx
        addl    %esi, %ecx
        movb    (%ecx), %bh
        
        movl    16(%ebp), %esi
        andl    $3, %esi
        movl    $RightClipPlaneMask, %ecx
        addl    %esi, %ecx
        movb    (%ecx), %bl
        
        movl    16(%ebp), %ecx
        movl    8(%ebp), %esi
        cmpl    %esi, %ecx
        jle     FillDone
        decl    %ecx
        andl    $0xfffc, %esi
        subl    %esi, %ecx
        shrl    $2, %ecx
        jnz     MasksSet
        andb    %bl, %bh
MasksSet:
        movl    20(%ebp), %esi
        subl    12(%ebp), %esi
        jle     FillDone
        movb    28(%ebp), %ah
        movl    _ScrnLogicalByteWidth, %ebp
        subl    %ecx, %ebp
        decl    %ebp
FillRowsLoop:
        pushl   %ecx
        movb    %bh, %al
        outb    %al, %dx
        movb    %ah, %al
        stosb
        decl    %ecx
        js      FillLoopBottom
        jz      DoRightEdge
        movb    $0x0f, %al
        outb    %al, %dx
        movb    %ah, %al
        rep
        stosb
DoRightEdge:
        movb    %bl, %al
        outb    %al, %dx
        movb    %ah, %al
        stosb
FillLoopBottom:
        addl    %ebp, %edi
        popl    %ecx
        decl    %esi
        jnz     FillRowsLoop
FillDone:
        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %esi
        popl    %edi
        popl    %ebp
        ret

/*****************************************************************
** x_cp_vid_rect(int SrcStartX, int SrcStartY, int SrcEndX,
**    %ebp +          8              12            16
**            int SrcEndY, int DestStartX, int DestStartY,
**                  20              24            28
**            int SrcPageBase, int DestPageBase,
**                  32              36
**            int SrcBitmapW, int DestBitmapW);
**                  40              44
*****************************************************************/

_x_cp_vid_rect:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %ds
        pushw   %es
        
        movw    $0x3ce, %dx
        movw    $0x08, %ax
        outw    %ax, %dx

        movl    44(%ebp), %eax
        shrl    $2, %eax
        imul    28(%ebp), %eax
        movl    24(%ebp), %edi
        shrl    $2, %edi
        addl    %eax, %edi
        addl    36(%ebp), %edi
        addl    $0xa0000, %edi
        movw    _core_select, %ax
        movw    %ax, %es
        movw    %ds, %ax
        movw    %ax, DSSave
        andl    $0x0fffffff, %edi

        movl    40(%ebp), %eax
        shrl    $2, %eax
        imul    12(%ebp), %eax
        movl    8(%ebp), %esi
        movl    %esi, %ebx
        shrl    $2, %esi
        addl    %eax, %esi
        addl    32(%ebp), %esi
        addl    $0xa0000, %esi          /* Point esi to screen offset */
        
        andl    $3, %ebx
        movl    %ebx, %ecx
        addl    $LeftClipPlaneMask, %ecx
        movb    (%ecx), %al
        movb    %al, %ah
        
        movl    16(%ebp), %ebx          /* SrcEndX */
        andl    $3, %ebx
        movl    %ebx, %ecx
        addl    $RightClipPlaneMask, %ecx
        movb    (%ecx), %al
        movw    %ax, %bx

        movl    16(%ebp), %ecx
        movl    8(%ebp), %eax
        cmpl    %eax, %ecx
        jle     VRCopyDone
        decl    %ecx
        andl    $0xfffffffc, %eax       /* eax & not 011b */
        subl    %eax, %ecx
        shrl    $2, %ecx
        jnz     VRMasksSet
        andb    %bl, %bh
VRMasksSet:
        movl    20(%ebp), %eax
        subl    12(%ebp), %eax
        jle     VRCopyDone
        movl    %eax, Height
        movl    44(%ebp), %eax
        shrl    $2, %eax
        subl    %ecx, %eax
        decl    %eax
        movl    %eax, DestNextOffs
        movl    40(%ebp), %eax
        shrl    $2, %eax
        subl    %ecx, %eax
        decl    %eax
        movl    %eax, SrcNextOffs
        movl    %ecx, RectAddrW
        movw    $0x3c5, %dx
        movw    DSSave, %bp
VRCopyRowsLoop:
        movl    RectAddrW, %ecx
        pushl   %eax
        movw    _core_select, %ax
        movw    %ax, %ds
        popl    %eax
        movb    %bh, %al
        outb    %al, %dx
        movsb
        decl    %ecx
        js      VRCopyLoopBottom
        jz      VRDoRightEdge
        movb    $0x0f, %al
        outb    %al, %dx
        rep
        movsb
VRDoRightEdge:
        movb    %bl, %al
        outb    %al, %dx
        movsb
VRCopyLoopBottom:
        pushl   %eax
        movw    %bp, %ax
        movw    %ax, %ds                 /* Point ds back to data sel. */
        popl    %eax
        addl    SrcNextOffs, %esi
        addl    DestNextOffs, %edi
        decl    Height
        jnz     VRCopyRowsLoop
VRCopyDone:
        movw    $0x3cf, %dx
        movb    $0xff, %al
        outb    %al, %dx

        popw    %es
        popw    %ds
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret
