/*
 * xprintf.c - formatted character string output, and font utilities
 *
 * DESCRIPTION
 * x_printf() is for monochrome text, and x_cprintf() is for color fonts.
 * monochrome fonts are the same format as XLIB fonts.
 * Color fonts are stored as WORD first char, BYTE height, BYTE width,
 * followed by an array of sequntial PBMs.
 *
 * USAGE
 *
 * NOTES
 * Parts based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 * 17 Jul 95    Moved binary file read/write routines to fileio.c (archive)
 *  3 Aug 95    Changed bitmaps to have word w and h
 * 17 Aug 95    Fixed lousy x_printf code.
 * 31 Aug 95    Added clipping text functions, color text now supports
 *              var width and formatting
 *
 */

#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <sys/stat.h>

#include "defines.h"
#include "xlib.h"
#include "archive.h"

/*****************************************************************
  FONT FORMATS

  Monochrome: (1 bit/pixel)
  
  WORD  first character in set
  BYTE  character height
  BYTE  character width
  font data ...
  Variable width fonts have the width byte right after the data for
  each character.

  New Color Format: (1 byte/pixel)
  
  NOTE:  Although the character has variable width, all of the PBMs
  in the color font must be the same width!

  WORD  first character
  BYTE character height
  BYTE character width (0 => variable)
  font data:  sequential XLIB PBMs for each character
              (WORD width, WORD height, width*height*4 planar data, 
              <BYTE width for var width fonts only>)
  
*****************************************************************/

/***************************************************************
** x_printf();
** monochrome formatted printing like the c printf routine.
** Supports variable width fonts.
***************************************************************/
void x_printf(int x, int y, int ScrnOffs, int color, BYTE * font, 
              char * line, ...)
{
  char dlin[100], *dl=dlin;
  va_list ap;
  
  va_start(ap,line);
  vsprintf(dlin,line,ap);
  va_end(ap);

  while (*dl)
  {
    x += x_char_put(x, y, ScrnOffs, color, font, *dl++);
  }
}

/******************************************************************
** x_cprintf(...) - like x_printf except prints with specified
** color font.
******************************************************************/
void x_cprintf(int x, int y, int ScrnOffs, BYTE * font, char * line, ...)
{
  char dlin[100], *dl=dlin;
  va_list ap;
  
  va_start(ap,line);
  vsprintf(dlin,line,ap);
  va_end(ap);

  while (*dl)
  {
    x += x_color_char_put(x, y, ScrnOffs, font, *dl++);
  }
}

/**************************************************************************** 
**  x_color_char_put() - puts a single color font character at the specified
**  location.
****************************************************************************/
int x_color_char_put(int x, int y, int ScrnOffs, BYTE * font, char Character)
{
  int offset;
  int i;

  i = ((int)(font[4] << 2) + (int)(font[5] << 10)) *
      ((int)font[6]  + (int)(font[7] <<  8));
  
  offset = ((int)Character - (int)font[0]) * (i + 4) + 4;
  if (font[3] == 0)
    offset += ((int)Character - (int)font[0]);
  
  x_put_PBM_masked(x, y, ScrnOffs, &font[offset]);
  
  if (font[3] == 0)
    return((int)font[i+4+offset]);
  else
    return((int)font[3]);
}

/***************************************************************
** x_printf_clipxy();
** monochrome formatted printing like the c printf routine.
** Supports variable width fonts.
***************************************************************/
void x_printf_clipxy(int x, int y, int ScrnOffs, int color, BYTE * font, 
                     char * line, ...)
{
  char dlin[100], *dl=dlin;
  va_list ap;
  
  va_start(ap,line);
  vsprintf(dlin,line,ap);
  va_end(ap);

  while (*dl)
  {
    /* NOT DONE YET */
    x += x_char_put_clipxy(x, y, ScrnOffs, color, font, *dl++);
  }
}

/******************************************************************
** x_cprintf_clipxy() - like x_printf except prints with specified
** color font.
******************************************************************/
void x_cprintf_clipxy(int x, int y, int ScrnOffs, BYTE * font, 
                      char * line, ...)
{
  char dlin[100], *dl=dlin;
  va_list ap;
  
  va_start(ap,line);
  vsprintf(dlin,line,ap);
  va_end(ap);

  while (*dl)
  {
    x += x_color_char_put_clipxy(x, y, ScrnOffs, font, *dl++);
  }
}

/**************************************************************************** 
**  x_color_char_put_clipxy() - puts a single color font character at the
**  specified location.
****************************************************************************/
int x_color_char_put_clipxy(int x, int y, int ScrnOffs, BYTE * font, 
                            char Character)
{
  int offset;
  int i;

  i = ((int)(font[4] << 2) + (int)(font[5] << 10)) *
      ((int)font[6]  + (int)(font[7] <<  8));
  
  offset = ((int)Character - (int)font[0]) * (i + 4) + 4;
  if (font[3] == 0)
    offset += ((int)Character - (int)font[0]);
  
  x_put_PBM_masked_clipxy(x, y, ScrnOffs, &font[offset]);
  
  if (font[3] == 0)
    return((int)font[i+4+offset]);
  else
    return((int)font[3]);
}
