/* test scrolling example - a very slow example because it redraws the
** entire screen every frame, but it demostrates using an oversized page,
** setting starting page offsets, and the HPP register.
** The main reason I did it this way was to keep the writes to video 
** DWORD aligned.
** 13 Jul 95 - added split screen support to demo
*/

#include <stdio.h>
#include <pc.h>
#include <go32.h>
#include <malloc.h>
#include <time.h>
#include <dos.h>

#include "defines.h"
#include "xlib.h"
#include "archive.h"
#include "colors.h"

BYTE * palette;
BYTE * font1;
BYTE * tiles;

BYTE * layer1;
int layer1_xsize = 40;
int layer1_ysize = 280;

void main(int argc, char * argv[])
{
  int i, j, k;
  int y_offs, y_tile;
  int x_offs, x_tile;
  int x_dir = 2;
  int t1, t2;

  read_binary("standard.pal", &palette);
  read_binary("var6x8.fnt", &font1);
  read_binary("advent1.bmp", &tiles);
  
  /* random map */
  layer1 = (BYTE *)malloc(layer1_xsize*layer1_ysize);
  for (i=0; i<(layer1_xsize*layer1_ysize); i++)
    layer1[i] = (BYTE)(random() % 15);

  x_set_mode(X_320X240);
  
  x_set_palette(palette);
  
  /* Increase logical screen size by 16 pixels in each direction */
  x_set_logical_size(4, 0);
  x_set_split_screen(208);

  y_tile = 0;
  y_offs = 0;
  x_tile = 0;
  x_offs = 0;
  for (i=0; i<21; i++)
    for (j=0; j<15; j++)
      x_tile16(i<<4, j<<4, HiddenPageOffs, &tiles[260*layer1[i+j*20]]);
  
  x_rect_fill(0,2,320,32, SplitStartOffset, DK_GREY);
  x_printf(4, 4, SplitStartOffset, YELLOW, font1, "X Tile: %d", x_tile);
  x_printf(4, 14, SplitStartOffset, YELLOW, font1, "Y Tile: %d", y_tile);
  
  x_show_page(HiddenPageOffs + y_offs*84);

  t1 = clock();
  for (k=0; k<(layer1_ysize-20); k++)
  {
    y_offs += 2;
    if (y_offs >= 16)
    {  
      y_offs = 0;
      y_tile ++;
    }
    
    x_offs += x_dir;
    if ((x_offs <= 0) && (x_tile <= 0))
      x_dir = -x_dir;
    if ((x_offs >= 15) && (x_tile >= 6))
      x_dir = -x_dir;

    if (x_offs >=16)
    {
      x_offs = 0;
      x_tile ++;
    }
    if (x_offs < 0)
    {
      x_offs = 14;
      x_tile --;
    }

    for (i=0; i<21; i++)
      for (j=0; j<14; j++)
        x_tile16(i<<4, j<<4, HiddenPageOffs, 
                 &tiles[260*layer1[i+x_tile+(j+y_tile)*20]]);
    
    /* Set HPP here for smooth scroll */
    outportb(0x3c0, 0x33);
    outportb(0x3c0, (x_offs & 3) << 1);
    
    x_show_page(HiddenPageOffs + y_offs*84 + (x_offs >> 2));
    x_rect_fill(0,2,60,32, SplitStartOffset, DK_GREY);
    x_printf(4, 4, SplitStartOffset, YELLOW, font1, "X Tile: %d", x_tile);
    x_printf(4, 14, SplitStartOffset, YELLOW, font1, "Y Tile: %d", y_tile);
  
  }
  
  t2 = clock();
  i = (int)(t2-t1);
  
  getkey();

  x_set_text_mode();
  printf("%d frames in %d clocks.\n", k, i);
  printf("%d FPS\n", (int)(k*CLOCKS_PER_SEC)/i);
  
  free(font1);
  free(palette);
  free(tiles);
  free(layer1);
}
