#include <dos.h>
#include <stdlib.h>
#include <conio.h>
#include <wgtgfx.h>

/* Filled polygons by Chris Egerter
   320x200x256 specific version */

int startx[200];
int endx[200];

typedef struct
    {
     int x,y;
    } point;


void polyline (int x1, int y1, int x2, int y2)
/* Calculates the coordinates of a line given two
   vertices (x1,y1) an (x2,y2).

   We will use fixed point math to speed things up.
   The x coordinate is multiplied by 256 and for each row,
   a constant m is added to x.  This is a simplified version
   of a line algorithm because we only have to store 1 x coordinate
   for every y coordinate.

*/
{
 int tmp,y;
 long x,m;

 if (y2 != y1)      /* This isn't a horizontal line */
 {
   if (y2 < y1)    /* Make sure y2 is greater than y1 */
   {
    tmp = y1;      /* Swap the y coordinate */
    y1 = y2;
    y2 = tmp;

    tmp = x1;      /* Swap the corresponding x coordinates */
    x1 = x2;
    x2 = tmp;
   }

 x = (long)x1<<8;  /* Multiply be 256 */

 m = ((long)(x2 - x1)<<8) / ((long)(y2 - y1));
 /* m is the fractional amount to add to the x coordinate every row.
    m is equal to (delta x) / (delta y).  In other words, the x coordinate
    has to change by (x2 - x1) columns in (y2 - y1) rows. */

 x += m; /* We ALWAYS skip the first point in every line. This is done */
 y1++; /* because we do not want to store the point where two lines
	  meet, twice.  This would result in a single point being drawn. */

 for (y = y1; y <= y2; y++) /* Go through each row */
  {
   if ((y >= 0) & (y < 200)) /* If the coordinate is on the screen */
    if (startx[y] == -16000) /* Store the first coordinate */
      startx[y] = x>>8;
    else
      endx[y] = x>>8;        /* Store the last coordinate */
   x += m;		     /* Add our constant to x */
   }
 }
}



void fillpoly (point *vertexlist, int numvertex)
/* Draws a filled polygon given an array of vertices. */
{
int i;
point *curpt,*nextpt;
  /* Two pointers to a vertex. These are used to connect to vertices
     together in when calling the polyline routine. */

 curpt = vertexlist;      /* Set to the first vertex in the array */
 nextpt = vertexlist + 1; /* and to the second vertex */

 for (i = 0; i < 200; i++)
  {
   startx[i] = -16000;     /* Set up our impossible values */
   endx[i] = -16000;
  }

 for (i = 1; i < numvertex; i++)
  {
   polyline (curpt->x, curpt->y, nextpt->x, nextpt->y);
   /* Calculate the edge of this line. */

   curpt += 1;  /* Go to the next line */
   nextpt += 1;
  }

  nextpt = vertexlist;  /* Now close the polygon by doing a line between
			   the first and last vertex. */
  polyline (curpt->x, curpt->y, nextpt->x, nextpt->y);

  for (i = 0; i < 200; i++)   /* Now draw the horizontal line list */
    if (startx[i] != -16000)  /* Indicates there is a line on this row */
    {
     if (endx[i] == -16000)
	 endx[i] = startx[i]; /* In case there was only one
				 point found on this row */
       horizontal_line (startx[i], endx[i], i);
       /* Draw a line between the two x coordinates, on the row i. */
    }
}



point mypoints[10];

void main (void)
{
int i;

 setvga256 ();

 do
 {
   for (i = 0; i < 3; i++)
    {
     mypoints[i].x = rand () % 320;
     mypoints[i].y = rand () % 200;
    }

   drawcolor (rand () % 256);
   fillpoly (&mypoints, 3);
 } while (!kbhit());

 getch ();
 setvideomode (0x03);  /* 80 column text mode */
}

