MASM
Comment !
ͻ
 Graphics Routines - V1.0a Copyright 1994-95 Phil Carlisle                   
Ķ
 Techie Notes                                                                
                                                                 
 This stuff is just the graphic and palette routines for the interface part  
 of star duels (iron plague) and may or may not be required.............     
ͼ

History of routines


V1.0a - Initial...
V1.2a - Added MANY routines... new fades, sprite routine (needs revision)


Last Revision Date

23-02-95

List of Routines



!

IDEAL
p386
;model flat,c
locals
jumps

;Global Procedures...

MASM
_DATA   SEGMENT PARA PUBLIC USE32 "DATA"                                                                      


public  pal1

ideal
Pal1       db   768 dup (0)     ;first palette
Pal2       db   768 dup (0)     ;second palette
SavePal    db   768 dup (0)     ;saved palette

public _fadepalette1
public _fadepalette2
public _fadecounters
public _fadeadders

_fadepalette1    db      768 dup (0) ; first palette
_fadepalette2    db      768 dup (0) ; second palette
_fadecounters    dw      768 dup (0) ; counter vars for screen fades
_fadeadders      dw      768 dup (0) ; increment vars for screen pal fades

public _fadecomplete
_fadecomplete dd        0            ;flag indicating completion of a fade

palspeed      db        1
paldone       db        1
fadeloop      dw        0
delaycount    dd        0
temp          dw        0
localX        dw        0  
localY        dw        0
loCol         db        0

public _VisualPage              ;Page to display
_VisualPage    dd        0
public  _DrawingPage            ;Page to write to
_DrawingPage   dd        19200
public _HiddenPage              ;first hidden page
_HiddenPage    dd        38400
public SparePage_
SparePage_     dd        0       ;spare page in mode Q 320x200x4
public ScreenHeight_     
ScreenHeight_  dd        0      ;height of the screen        
public  _SavePage
_SavePage      dd        0 




public spritewidth_
spritewidth_   dd        1
spriteheight_  dd        1
spreswidth    dd        1
spresheight   dd        1
splocate      dd        1       ;location in vid mem of each plane start
planekeep      dd       1
;include "pltab.inc"             ; 320 byte table for plane alignment
_cliptop       dd        0
_clipbottom    dd        240
_clipleft      dd        0
_clipright     dd        320
_screenptr      dd      0a0000h

;EQUATES
planeset      equ       (00010001000100010001000100010001b)
seqadd        equ       3c4h
mapmask       equ       02h
InputStatus1  equ       3dah
MISC_OUTPUT   equ       3c2h
READ_MISC     equ       3cch
CRTC_Index    equ       3d4h
Graph_Index   equ       3ceh
Attr_Index    equ       3c0h ;don't forget to clear flipflop & set bit 5 on index
PEL_Write     equ       3c8h
PEL_Read      equ       3c7h
PEL_Data      equ       3c9h
GIdx          equ       3ceh



LABEL YTable DWORD                        ;Ytable of 240 Y offsets into Vidmem
i=0
REPT 240
    dd  80*i
    i=i+1    
ENDM

LABEL YaddTable DWORD
i=0
REPT 240
        dd  320*i
        i=i+1
ENDM    

LABEL PlaneTable DWORD
REPT 80
    dd  0,1,2,3
ENDM

LABEL Planes DWORD
REPT 80
dd   11111111h,22222222h,44444444h,88888888h
ENDM


;include "pltab.inc"

IDEAL
;include "defpal.inc"
MASM

_DATA   ENDS


_TEXT   SEGMENT BYTE PUBLIC USE32 "CODE"  

ASSUME  CS:_TEXT,DS:_DATA


PUBLIC  pSavepalette_      

GLOBAL  _pBlackout       :NEAR
GLOBAL  _pSetPalette     :NEAR
GLOBAL  _pMode13         :NEAR
GLOBAL  _pMode3          :NEAR

IDEAL



;this version doesnt clip yet...
; esi = pointer to sprite
; eax = Y position on screen
; ecx = X     "       "
PUBLIC  pPutSprite_
PROC    pPutSprite_
        pushad
        mov     edi,0a0000h                 ;point edi to screen
        add     edi,[_DrawingPage]          ;add offset for double buffer page
        mov     ebx,[esi]
        add     esi,4                       ;esi now points to data
                                            ;ok ebx contains width (highword) 
                                            ;and height (lowword) 
                                            ;esi points to data 
                                            ;edi points to screen                        
        mov     eax,[eax*4+YTable]          ;
        add     edi,eax                     ;add Y offset to screen ptr
                                            ;now we're aligned 
                                            ;with the Y offset address       
        mov     edx,ecx                     ;save the X value
        shr     edx,2                       ;X div 4 (cus its 4 X per address)
        add     edi,edx                     ;add the X offset to address    
        mov     [splocate],edi              ;save pointer to video mem
        mov     eax,ecx                     ;
        mov     eax,[eax*4+PlaneTable]      ;get the plane start
;        rol     eax,8                       ;dont ask :)    
        mov     ecx,eax                     ;    
        mov     edi,[splocate]
        mov     edx,planeset                ;get the plane setting dword
        rol     edx,cl                      ;set initial plane    
        mov     [planekeep],edx             ;store the plane dword for later
        mov     ah,dh                       ;store it in ah also
        mov     dx,seqadd                   ;sequencer address reg
        mov     al,02h                      ;index 2h map mask
        out     dx,al                       ;write it
        inc     dx                          ;data port
        mov     al,ah                       ;mov the plane we want into al
        out     dx,al                       ;write the map mask
        mov     edx,ebx                     ;save width and height of sprite
        shr     ebx,16                      ;get the height only
        mov     [spriteheight_],ebx         ;save it
        xor     ebx,ebx                     ;
        mov     bx,dx                       ;get width only from edx
        shr     ebx,2                       ;ebx = ebx/4
        mov     [spritewidth_],ebx
        mov     ecx,4                       ;edi=screen esi=data ebx=width  
        mov     eax,0
@@planeblast:
; blast planes worth of sprite to the screen
        push    ecx                                        ;1push
        mov     ecx,[spriteheight_]
@@spvertloop:        
        push    ecx                                        ;2push
        mov     ecx,ebx
@@sprthloop:                                ;horizontal loop
        mov     al,[byte ptr esi]           ;get a byte
        cmp     al,0
        jz      @@skipzero
        mov     [byte ptr edi],al           ;store a byte
@@skipzero:        
        inc     edi
        inc     esi
        loopnz  @@sprthloop
        pop     ecx                         ;vertical loop         ;1push
        add     edi,80                      ;done one line.. go to next line..
        sub     edi,[spritewidth_]
        loopnz  @@spvertloop
;done one planes worth so setup for next plane        
        mov     edx,[planekeep]
        clc                                 ;clear carry flag  
        rol     edx,1                       ;set the next plane to blast
        jnc     @@nocarry                   ;if carry set, bit was set
        add     [splocate],1                ;so start at plane 1 next pixel
@@nocarry:        
        mov     [planekeep],edx
        push    dx
        shr     dl,4
        mov     ah,dl
        mov     dx,seqadd
        mov     al,02h
        out     dx,al                       ;plane seq setup
        inc     dx                          ;data port
        mov     al,ah
        out     dx,al                       ;set the plane
        pop     dx
        mov     eax,0
        mov     edi,[splocate]
        pop     ecx                                          ;all even
        loopnz  @@planeblast
@@dontdraw:                                 ;jmp here if clipped completely
        popad
        ret
ENDP

;this version doesnt clip yet...
; esi = pointer to sprite
; eax = Y position on screen
; ecx = X     "       "

PUBLIC  pPutSpriteY_
PROC    pPutSpriteY_
        pushad
        mov     edi,[_ScreenPtr]            ;point to screen
        mov     ebx,[esi]                   ;put width & height in ebx
        add     esi,4                       ;esi now points to data
                                            ;ok ebx contains width (highword) 
                                            ;and height (lowword) 
                                            ;esi points to data 
                                            ;edi points to screen                        
        mov     eax,[eax*4+YaddTable]       ;get Y line offset
        add     edi,eax                     ;add Y offset to screen ptr
                                            ;now we're aligned 
                                            ;with the Y offset address       
        add     edi,ecx                     ;add X onto the screen ptr
        xor     ecx,ecx                     ;ecx = vert loop counter
;        mov     edx,[_displaywidth]         ;save width and height of sprite
        rol     ebx,16                      ;get the height only
        mov     cx,bx                       ;save it
        shr     ebx,16                      ;
@@pvertloop:        

        push    ebx
@@prthloop:                                ;horizontal loop
        mov     al,[byte ptr esi]           ;get a byte
        cmp     al,0
        jz      @@skipzeroY
        mov     [byte ptr edi],al           ;store a byte
@@skipzeroY:        
        inc     edi
        inc     esi
        dec     ebx
        jnz     @@prthloop
        pop     ebx
        add     edi,320
        sub     edi,ebx
        dec     ecx
        jnz     @@pvertloop
        popad
        ret
ENDP
    
    
; Sets the READ mode
; IN: EAX = read mode (0 or 1)
; OUT: AX is destroyed
Public pSetReadMode_
PROC pSetReadMode_ 
    push    dx ax
    mov     dx,GIdx
    mov     ah,al
    mov     al,5
    out     dx,al
    inc     dx
    in      al,dx
    and     al,11110111b    ;clear out write mode bits
    shl     ah,3            ;move bit to correct position
    and     ah,00001000b
    or      al,ah
    out     dx,al
    pop     ax dx
    ret
ENDP

;IN EBX=X ECX=Y 
;OUT EAX=VALUE
    
public  pGetPixelX_
PROC    pGetPixelX_
        push    edx ebx ecx 
        mov     eax,0
        call    pSetReadMode_
        mov     al,4
        mov     edx,ebx
        mov     ebx,[ebx*4+Planes]   
        mov     ah,bl
        mov     ebx,edx
        mov     edx,3cfh
        out     dx,ax
        mov     esi,0a0000h
        add     esi,[_HiddenPage]
        mov     ecx,[ecx*4+YTable]
        add     esi,ecx    
        shr     ebx,2
        add     esi,ebx
        mov     eax,0
        mov     al,[byte ptr esi]
        pop     ecx ebx edx
        ret
ENDP    
    
public  pPutSprite13_
PROC    pPutSprite13_
        push    edx ebx ecx 
        mov     eax,0
        call    pSetReadMode_
        mov     al,4
        mov     edx,ebx
        mov     ebx,[ebx*4+Planes]   
        mov     ah,bl
        mov     ebx,edx
        mov     edx,3cfh
        out     dx,ax
        mov     esi,0a0000h
        add     esi,[_HiddenPage]
        mov     ecx,[ecx*4+YTable]
        add     esi,ecx    
        shr     ebx,2
        add     esi,ebx
        mov     eax,0
        mov     al,[byte ptr esi]
        pop     ecx ebx edx
        ret
ENDP    
    
    
    
    

;ecx contains Ysize (in scanlines)
;eax has Y start value
;ebx has X offset
;edx has X size
;edi has pointer to save data area

public  pGrabRectX_
PROC    pGrabRectX_
        pushad
        push    eax
        mov     al,00h
        call    pSetReadMode_
        pop     eax
        mov     esi,0a0000h             ;set esi to point to screen
        add     esi,[_VisualPage]       ;add offset of third *hidden* page
        mov     eax,[eax*4+YTable]      ;eax=Y offset
        add     esi,eax                 ;add that to screen pointer
        mov     eax,ebx                 ;save X offset into eax (for plane)
        shr     ebx,2                   ;ebx = X coord (/4 for mode X bytes)
        add     esi,ebx                 ;add the X offset to screen pointer
        rol     edx,16                  ;save X size into high word of edx
        mov     dx,GIdx                 ;graphic cont address
        mov     eax,[eax*4+Planes]      ;get the plane to read into eax
        mov     al,04h                  ;index 4 = plane mask (ah holds plane)
        out     dx,ax                   ;set the plane we want
        mov     al,ah                   ;set eax = all plane data ie 11111111h
        shr     edx,18                  ;dx now holds X size again (/4)
        push    esi                     ;save pointer to sprite start offset
        mov     ebx,ecx                 ;store ecx for later (Ysize=scanlines)
@@grabvloop1:                           ;loop through Ysize times
        push    ecx                     ;remove this later
        mov     ecx,edx                 ;ecx = Horizontal number of bytes
        rep     movsb                   ;to transfer (from edx)(/4)
        add     esi,80                  ;next line
        sub     esi,edx                 ;reset width start of H line
        pop     ecx                     ;get back Ysize
        loopnz  @@grabvloop1            ;continue if done looping (done plane)                                          
;done one loop now set the plane to next plane, reset and do it again        
        pop     esi                     ;set source back to start of plane
        rol     eax,1                   ;next plane
        mov     ecx,ebx                 ;ecx = Y scanlines again
        rol     edx,16                  ;save X size /4 into high word
        mov     dx,GIdx                 ;graphic address reg agin
        mov     al,04h                  ;plane mask
        out     dx,ax                   ;set plane mask to desired plane
        mov     al,ah                   ;eax is all plane again
        shr     edx,16                  ;get back X size
        push    esi                     ;save source index again
@@grabvloop2:
        push    ecx
        mov     ecx,edx
        rep     movsb
        add     esi,80
        sub     esi,edx
        pop     ecx
        loopnz  @@grabvloop2
;done 2 loops now set the plane to next plane, reset and do it again        
        pop     esi                     ;set source back to start of plane
        rol     eax,1                   ;next plane
        mov     ecx,ebx                 ;ecx = Y scanlines again
        rol     edx,16                  ;save X size /4 into high word
        mov     dx,GIdx                 ;sequencer address reg agin
        mov     al,04h                  ;map mask
        out     dx,ax                   ;set map mask to desired plane
        mov     al,ah                   ;eax is all plane again
        shr     edx,16                  ;get back X size
        push    esi                     ;save source index again
@@grabvloop3:
        push    ecx
        mov     ecx,edx
        rep     movsb
        add     esi,80
        sub     esi,edx
        pop     ecx
        loopnz  @@grabvloop3
;done 3 loops now set the plane to next plane, reset and do it again        
        pop     esi                     ;set source back to start of plane
        rol     eax,1                   ;next plane
        mov     ecx,ebx                 ;ecx = Y scanlines again
        rol     edx,16                  ;save X size /4 into high word
        mov     dx,GIdx                 ;sequencer address reg agin
        mov     al,04h                  ;map mask
        out     dx,ax                   ;set map mask to desired plane
        mov     al,ah                   ;eax is all plane again
        shr     edx,16                  ;get back X size
        push    esi                     ;save source index again
@@grabvloop4:
        push    ecx
        mov     ecx,edx
        rep     movsb
        add     esi,80
        sub     esi,edx
        pop     ecx
        loopnz  @@grabvloop4
;done all 4 loops, so get outta here!!        
        pop     esi                     ;set source back to start of plane
        popad
        ret
ENDP

public  pSetScreenPointer_
PROC    pSetScreenPointer_
        mov     [_screenptr],eax
        ret
ENDP

; EAX = Y
; ECX = X2
; EBX = X1
; EDX = Colour
; 

public  pHLineY_
PROC    pHLineY_
        mov     edi,[_screenptr]                ;point to screen mem
        mov     eax,[eax*4+YaddTable]           ; add Y offset (table lookup)
        add     edi,eax                         ; add offset
        add     edi,ebx                         ; add X offset
        mov     eax,edx                         ;get colour in eax
        mov     ah,al                           ;set it so we can write words
        cmp     ecx,ebx                         ; if X2=X1
        jne     @@reploop                       ;
        stosb                                   ; write a byte and return
        ret                                     ;
@@reploop:                                      ; otherwise jmp to here
        sub     ecx,ebx                         ; ecx = X2-X1
        clc                                     ; clear carry flag
        shr     ecx,1                           ; ecx = xwidth/2
        jnc     @@dowords                       ; if it was odd
        stosb                                   ;set byte of that colour
@@dowords:                                      ;
        rep     stosw                           ; other wise write words
        ret                                     ; of colour in eax
ENDP        

; EAX = Y
; ECX = X2
; EBX = X1
; EDX = Colour
; 

public  pNewHlineY_
PROC    pNewHlineY_
        mov     edi,[_screenptr]                ;point to screen mem
        mov     eax,[eax*4+YaddTable]           ; add Y offset (table lookup)
        add     edi,eax                         ; add offset
        cmp     ebx,ecx                         ; X2>X1???
        jle     @@nonswap                       ; 
        xchg    ebx,ecx                         ; no so swap them
@@nonswap:
        cmp     ecx,0                           ; clip if both X <0
        jge     @@notoffleft
        ret
@@notoffleft:
        cmp     ebx,319                         ; clip if both X > 320
        jle     @@notoffright
        ret
@@notoffright:        
        cmp     ebx,0                           ; if X1 < 0 X1=0
        jge     @@settozero
        mov     ebx,0
@@settozero:
        cmp     ecx,319                         ; if X2 > 319 X2=319
        jle     @@settomax
        mov     ecx,319
@@settomax:        
        add     edi,ebx                         ; add X offset
        mov     eax,edx                         ;get colour in eax
        mov     ah,al                           ;set it so we can write words
        cmp     cx,bx
        je      @@drawonebyte
        sub     ecx,ebx                         ;ecx = num of bytes
        shr     cx,1
        rep     stosw
        adc     cx,cx
        rep     stosb
        ret
@@drawonebyte:
        stosb
        ret
ENDP        
        
        
public  pHLineYOR_
PROC    pHLineYOR_
;        mov     edi,0a0000h
        mov     edi,[_screenptr]                ;point to screen mem
        mov     eax,[eax*4+YaddTable]           ; add Y offset from table
        add     edi,eax                         ; add that to screen ptr
        add     edi,ebx                         ; add X offset
;        mov     eax,edx                         ; get colour in eax
        mov     esi,edi                         ; point esi to screen mem
        cmp     ecx,ebx                         ; are x1 and x2 the same?
        jne     @@single                        ; if yes, do a single byte
        mov     al,[byte ptr esi]               ; get byte from screen
        or      al,dl                           ; or it with al
        mov     [byte ptr edi],al               ; and save it to same place
        ret
@@single:        
        sub     ecx,ebx                         ; ecx = X2-X1
@@horloop:        
        mov     al,[byte ptr esi]               ; get byte from screen
        or      al,dl                           ; or it with al
        add     edi,1                           ; point to next byte dest
        add     esi,1                           ;                     src
        mov     [byte ptr edi],al               ; and save it to same place
        dec     ecx                             ; loop ecx times
        jnz     @@horloop
        ret
ENDP                

public  pHlineADD_
PROC    pHLineADD_
;        mov     edi,0a0000h
        mov     edi,[_screenptr]                ;point to screen mem
        mov     eax,[eax*4+YaddTable]           ; add Y offset from table
        add     edi,eax                         ; add that to screen ptr
        add     edi,ebx                         ; add X offset
;        mov     eax,edx                         ; get colour in eax
        mov     esi,edi                         ; point esi to screen mem
        cmp     ecx,ebx                         ; are x1 and x2 the same?
        jne     @@single                        ; if yes, do a single byte
        mov     al,[byte ptr esi]               ; get byte from screen
        add     al,dl                           ; or it with al
        mov     [byte ptr edi],al               ; and save it to same place
        ret
@@single:        
        sub     ecx,ebx                         ; ecx = X2-X1
@@horloop:        
        mov     al,[byte ptr esi]               ; get byte from screen
        add     al,dl                           ; or it with al
        add     edi,1                           ; point to next byte dest
        add     esi,1                           ;                     src
        mov     [byte ptr edi],al               ; and save it to same place
        dec     ecx                             ; loop ecx times
        jnz     @@horloop
        ret
ENDP                



; ecx number of bytes to move
; edi destination
; esi source

public  pCopyBytes_
PROC    pCopyBytes_
        rep     movsb
        ret
ENDP
        
public  pCopyWords_
PROC    pCopyWords_
        rep     movsw
        ret
ENDP

public  pZeroScreen_
PROC    pZeroScreen_
        mov     edi,[_screenptr]
        mov     ecx,32000
        mov     eax,0
        rep     stosw
        ret
ENDP
        

public  pSetPixelY_
PROC    pSetPixelY_
        mov     eax,[eax*4+YaddTable]   ; eax=Y*320 (from table)
        add     eax,ebx                 ; add X to that value
        add     eax,[_screenptr]
        mov     [byte ptr eax],cl
        ret
ENDP
            

        
public  pClearScreen_
PROC    pClearScreen_
        pusha
        mov     edi,0a0000h
        add     edi,[_HiddenPage]
        mov     ax,0f02h
        mov     dx,3c4h
        out     dx,ax
        mov     eax,0
        mov     ecx,9600
        rep     stosw
        popa
        ret
ENDP        

; put colour in ebx
public  pClearScreenColour_
PROC    pClearScreenColour_
        pusha
        mov     edi,0a0000h
        add     edi,[_HiddenPage]
        mov     ax,0f02h
        mov     dx,3c4h
        out     dx,ax
        mov     eax,ebx
        mov     ecx,9600
        rep     stosw
        popa
        ret
ENDP        



public pClearDrawingPage_
PROC    pClearDrawingPage_
        pusha
        mov     edi,0a0000h
        add     edi,[_DrawingPage]
        mov     ax,0f02h
        mov     dx,3c4h
        out     dx,ax
        mov     eax,0
        mov     ecx,9600
        rep     stosw
        popa
        ret
ENDP        



public  pCopyBackground_
PROC    pCopyBackground_        
        pushad
        mov     edi,0a0000h
        mov     esi,edi
        add     esi,[_HiddenPage]
        add     edi,[_DrawingPage]
        mov     dx,3ceh
        mov     ax,0008h
        out     dx,ax        ;set to write from latches only
        mov     ax,0f02h
        mov     dx,3c4h
        out     dx,ax        ;set ALL planes to be writable
        mov     ecx,19200
        rep     movsb
;        mov     dx,3cfh
;        mov     ax,0f08h
;        out     dx,ax        ;reset to write to all vga planes
        mov     dx,3cfh
        mov     al,0ffh
        out     dx,al
        popad
        ret
ENDP





public  pTripleBuffer_        
PROC    pTripleBuffer_
        push    eax ebx
        mov     ebx,[_VisualPage]
        mov     eax,[_DrawingPage]
        mov     [_VisualPage],eax
        mov     eax,[_HiddenPage]
        mov     [_DrawingPage],eax
        mov     [_HiddenPage],ebx
        pop     ebx eax
        ret
ENDP
public  pDoubleBuffer_        
PROC    pDoubleBuffer_
        push    eax ebx
        mov     ebx,[_VisualPage]
        mov     eax,[_DrawingPage]
        mov     [_VisualPage],eax
        mov     [_DrawingPage],ebx
        pop     ebx eax
        ret
ENDP


public  pDisplay_
PROC    pDisplay_
    push    edx eax ebx
;    call    pWaitEndRetrace_
    mov     ebx,[_VisualPage]
    mov     dx,3d4h             ;crtc index
    mov     al,0ch
    mov     ah,bh               ;write the HIGH byte
    out     dx,ax
    inc     al
    mov     ah,bl               ;write the LOW byte
    out     dx,ax
    pop     ebx eax edx 
    ret
ENDP
        
    
    ; Waits until verticle retrace starts and then waits for it to end.
    
public pWaitDisplayEnable_
PROC pWaitDisplayEnable_ 
    push    dx ax
    mov     dx,InputStatus1
@@Vr:
    in      al,dx
    test    al,8
    jz      @@Vr                  ;wait until Verticle Retrace starts
@@Nvr:
    in      al,dx
    test    al,8
    jnz     @@Nvr                 ;wait until Verticle Retrace Ends
    pop     ax dx
    ret
ENDP
    
    ; Waits until NON-VR time and then wait for VR to start
    
public pWaitFullRetrace_
PROC pWaitFullRetrace_ 
    push    dx ax
    mov     dx,InputStatus1
@@Vr:
    in      al,dx
    test    al,8
    jnz     @@Vr                  ;wait until Verticle Retrace starts
@@Nvr:
    in      al,dx
    test    al,8
    jz      @@Nvr                 ;wait until Verticle Retrace Ends
    pop     ax dx
    ret
ENDP
    
    ; Waits until VR is true - MAY be missed if interrupts are enabled
    
public pWaitRetraceStart_
PROC pWaitRetraceStart_
    push    dx ax
    mov     dx,InputStatus1
@@Vr:
    in      al,dx
    test    al,8
    jz      @@Vr                  ;wait until Verticle Retrace starts
    pop     ax dx
    ret
ENDP
    
    ; Waits for a NON-VR period
    
public pWaitEndRetrace_
PROC pWaitEndRetrace_
    push    dx ax
    mov     dx,InputStatus1
@@Nvr:
    in      al,dx
    test    al,8
    jnz     @@Nvr                 ;wait until Verticle Retrace Ends
    pop     ax dx
    ret
ENDP
        
;pSetPixelX_ sets a pixel X,Y in mode-x to colour Col (clipped to view)
;ebx = X edx = Y ecx = colour in low byte
public  pSetPixelX_
PROC    pSetPixelX_
        pushad
        mov     edi,0a0000h             ;point to vid mem
        add     edi,[_DrawingPage]        
;        add     edx,edx
;        add     edx,edx
        mov     edx,[edx*4+YTable]        ;edx = Yoffset into vidmem
        add     edi,edx                 ;add it onto start        
        mov     edx,ebx                 ;save X value
        shr     edx,2                   ;divide by 4 (for bytes)
        add     edi,edx                 ;setup the vidmem address to write
        mov     ebx,[ebx*4+Planes]      ;get plane
;        and     ebx,03h                 ;get plane mod 4
        mov     edx,seqadd              ;seq address
        mov     eax,02h                 ;index 2 map mask
        out     dx,al
        inc     edx                     ;data port
        mov     eax,ebx                 ;
        out     dx,al                   ;set the map mask reg to plane
        mov     [byte ptr edi],cl       ;put the byte
        popad
        ret
ENDP               

;pHLineX_ sets a line X1,X2 Y in mode-x to colour Col (clipped to view)
;eax = x1 ebx = X2 edx = Y ecx = colour in low byte
public  pHLineX_
PROC    pHLineX_
        pushad
        cmp     eax,ebx                 ;if X2<X1 swap em
        jle     @@noswapX
        mov     edi,eax
        mov     eax,ebx
        mov     ebx,edi
@@noswapX:
        mov     edi,0a0000h             ;point to vid mem
        add     edi,[_DrawingPage]        
        mov     edx,[edx*4+YTable]        ;edx = Yoffset into vidmem
        add     edi,edx                 ;add it onto start        
        mov     edx,ebx                 ;save X value
        shr     edx,2                   ;divide by 4 (for bytes)
        add     edi,edx                 ;setup the vidmem address to write
        mov     ebx,[ebx*4+Planes]      ;get plane
;        and     ebx,03h                 ;get plane mod 4
        mov     edx,seqadd              ;seq address
        mov     eax,02h                 ;index 2 map mask
        out     dx,al
        inc     edx                     ;data port
        mov     eax,ebx                 ;
        out     dx,al                   ;set the map mask reg to plane
        mov     [byte ptr edi],cl       ;put the byte
        popad
        ret
ENDP               




;pSetPixelXClip_ sets a pixel X,Y in mode-x to colour Col (clipped to view)
;ebx = X edx = Y ecx = colour in low byte
public  pSetPixelXClip_
PROC    pSetPixelXClip_
        pushad
        mov     edi,0a0000h             ;point to vid mem
        cmp     ebx,[_clipleft]
        jl      @dontdraw
        cmp     ebx,[_clipright]
        jg      @dontdraw
        cmp     edx,[_cliptop]
        jl      @dontdraw
        cmp     edx,[_clipbottom]
        jg      @dontdraw             
        add     edi,[_DrawingPage]        
;        add     edx,edx
;        add     edx,edx
        mov     edx,[edx*4+YTable]        ;edx = Yoffset into vidmem
        add     edi,edx                 ;add it onto start        
        mov     edx,ebx                 ;save X value
        shr     edx,2                   ;divide by 4 (for bytes)
        add     edi,edx                 ;setup the vidmem address to write
        mov     ebx,[ebx*4+Planes]       
;        and     ebx,03h                 ;get plane mod 4
        mov     edx,seqadd              ;seq address
        mov     eax,02h                 ;index 2 map mask
        out     dx,al
        inc     edx                     ;data port
        mov     eax,ebx                 ;
        out     dx,al                   ;set the map mask reg to plane
        mov     [byte ptr edi],cl       ;put the byte
@dontdraw:        
        popad
        ret
ENDP               



PUBLIC  pSetMode13h_
PROC    pSetMode13h_
        push  ax
        mov     ax,13h
        int     10h
        pop   ax
        ret
ENDP

PUBLIC  pSetPixel_
PROC    pSetPixel_
        pushad
        mov     [localX],ax
        xor     eax,eax
        mov     [localY],bx
        mov     [loCol],cl
        mov     edi,0a0000h
        mov     ax,bx
        mov     bx,320
        mul     bx
        add     ax,[localX]
        add     edi,eax
        mov     [edi],cl
        popad
        ret
ENDP        

PUBLIC  pMode3h_
PROC    pMode3h_
        push  ax
        mov     ax,3h
        int     10h
        pop   ax
        ret
ENDP

PUBLIC  pSyncVRT_
PROC    pSyncVRT_
    push    dx ax
    mov     dx,3dah
@@pVr:
    in      al,dx
    test    al,8
    jnz     @@pVr                  ;wait until Verticle Retrace starts
@@pNvr:
    in      al,dx
    test    al,8
    jz      @@pNvr                 ;wait until Verticle Retrace Ends
    pop     ax dx
    ret
ENDP

        

    
    
    ; Waits until NON-VR time and then wait for VR to start
    
PROC Wait_FVR1 NEAR
    push    dx ax
    mov     dx,3dah
@@Vr:
    in      al,dx
    test    al,8
    jnz     @@Vr                  ;wait until Verticle Retrace starts
@@Nvr:
    in      al,dx
    test    al,8
    jz      @@Nvr                 ;wait until Verticle Retrace Ends
    pop     ax dx
    ret
ENDP

PROC    CopyDefpal
        push    ecx edi esi
        lea     edi,[pal1]
        lea     esi,[savepal]
        mov     ecx,768
        rep     movsb
        pop     esi edi ecx
        ret
ENDP

;------------------------------------------------------------------------------
; Procedure SETPALETTE
;------------------------------------------------------------------------------

proc    _pSetpalette          ;
        pushad
	mov  dx,03c8h	      ;
	mov  al,0	      ; Tell the vga we are going to start writing
	out  dx,al	      ; to palette register 0
	inc  dx 	      ;
        lea  esi,[pal2]       ; point esi to palbuf data
        mov  ecx,768           ;
        cld
;        call    wait_FVR1        
        cli
        rep  outsb            ; Tell the DACS what the palette is
        sti
        popad
	ret
endp    

;sets a palette pointed to by esi
public  pSetPaletteV2_
PROC    pSetPaletteV2_
        pushad
        mov     dx,03c8h
        mov     al,0
        out     dx,al
        inc     dx
        mov     ecx,768
        cld
        cli
        rep     outsb
        sti
        popad
        ret
ENDP




;------------------------------------------------------------------------------
; Procedure _pResetdefpal
;------------------------------------------------------------------------------

proc    _pResetdefpal            ;
        pushad
	mov  dx,03c8h	      ;
	mov  al,0	      ; Tell the vga we are going to start writing
	out  dx,al	      ; to palette register 0
	inc  dx 	      ;
        lea  esi,[savepal]    ; point esi to palbuf data
        mov  ecx,768           ;
        cld
        cli
        rep  outsb            ; Tell the DACS what the palette is
        sti
        popad
	ret
endp    
        

PROC    Delay
        mov     ecx,[delaycount]
@delloop:
        call    wait_FVR1
        loop    @delloop
        ret
ENDP
;------------------------------------------------------------------------------
; Procedure Savepalette
;------------------------------------------------------------------------------

proc    pSavepalette_            ;
        pushad
        mov  dx,03c7h         ;
        mov  al,0             ; Tell the vga we are going to start reading
        out  dx,al            ; to palette register 0
        inc  dx               ;
        inc  dx
        lea  edi,[pal2]       ; point edi to palbuf data
        mov  ecx,768           ;
        cld
        cli
        rep  insb             ; Tell the DACS what the palette is
        sti
        lea  esi,[pal2]
        lea  edi,[savepal]
        mov  ecx,768
        rep  movsb
        popad
        ret
endp    
        



PROC    _pBlackout 
        pushad
        lea     edi,[pal1]
        mov     al,0
        mov     ah,al
        mov     ecx,768
        rep     stosb
        popad
        ret
ENDP



PROC _pPalFadeTo                                ;Fades the palette pal2 up to pal1
        pushad                                 ;save all regs
        mov     [paldone],0
        mov     edi,768                        ;counter for number of bytes
        mov     edx,offset pal1                ;di pointer to pal1
        mov     ebx,offset pal2                ;si pointer to pal2
        dec     edx
        dec     ebx

@@CLoop:                                      ;colour fade loop (up)
        mov     ah,[byte ptr edx+edi]          ;point to last byte in pal1 in ah
        mov     al,[byte ptr ebx+edi]          ;and to pal2 in al
        cmp     al,ah                         ;compare em
        je      @@equal                       ;if equal goto equal
        cmp     ah,al                         ;not equal so is ah>al?
        jg      @@incal                       ;yeah so increase al
@@decal:
        mov     [paldone],1                   ;not equal palettes so write it!
        mov     cl,al                         ;save al into cl (higher amount)
        sub     cl,ah                         ;take ah from al (actually cl)
        cmp     cl,[palspeed]                 ;is palspeed greater than cl?
        jg      @@normaldec                   ;no so decrement normally
        jmp     @@equal                       ;otherwise make em equal
@@normaldec:
        sub     al,[palspeed]                 ;fade down by palspeed amount
        cmp     al,ah                         ;are they equal now?
        je      @@equal                       ;yeah, so make em equal
        mov     [ebx+edi],al                  ;save the byte back to pal2
        dec     edi                           ;not so dec di and loop again
        jz      @@fadedone                    ;done one loop so exit
        jmp     @@Cloop                       ;otherwise loop again

@@incal:
        mov     [paldone],1                   ;not equal palettes so write it!
        add     al,[palspeed]                 ;fade up by palspeed amount
        cmp     al,ah                         ;are they equal now?
        jge     @@equal                       ;yeah, so make em equal
        mov     [ebx+edi],al                  ;save the byte back to pal2
        dec     edi                           ;not so dec di and loop again
        jz      @@fadedone                    ;done one loop so exit
        jmp     @@Cloop                       ;otherwise loop again
@@equal:                                      ;both were equal
;        mov     [paldone],0                   ;set pal to done.
        mov     [ebx+edi],ah                  ;make it equal
        dec     edi                           ;decrease pointer
        jz      @@fadedone                    ;done one full loop
        jmp     @@Cloop                       ;otherwise do it again
@@fadedone:                                   ;done one full loop
        popad                                 ;restore all regs
        ret                                   ;return
ENDP
MASM
_TEXT   ENDS
 
END 
 
 
 
 
 
 
 
