///////////////////////////////////////////////////////////////////////
// Program to display a fli file on the vga :)) in different ways 
// Copyright 1995 Phil Carlisle
// V0.1a
// for use in MAGE intro only, any other use please contact me :))
// P.Carlisle-iy1i3603@lmu.ac.uk 
//
// History
// -------
//
// Initial version, with bug in fli's with multiple palette's (normally
// I wouldnt worry about this, cus Animator has a command to make a fli
// use one palette which gets round this. but I got some info from the
// guy who wrote Animator about the format anyway..so will get fixed)
//
// Compile Options
// ---------------
//
// works fine with just plain old wcl386 /d2 for debug or /ox for optimise
// dont forget wcl386 /l=pmodew for a pmode-w link (no crappy dos4gw)
// or use the lnk file I gave ya!!! :)
//
// Notes
// -----
//
// Dont forget to make a data file with copy /b filename+filename data.dat
// (or it wont work!! duh!)
///////////////////////////////////////////////////////////////////////

// usual include file stuff.. 

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <graph.h>
#include <string.h>
#include <i86.h>

//#define debug

// fli header (shock horror)
typedef struct {
    int       fli_size;
    short int fli_magic;
    short int fli_frames;
    short int width;
    short int height;
    short int depth;
    short int flags;
    short int speed;
    int       next;
    int       frit;
    unsigned char pad[102];
} FLIHEADER;

// frame header (doh!)
typedef struct {
    int       framesize;
    short int magic;
    short int chunks;
    unsigned char pad[8];
} FRAMEHEADER;

// chunk header 
typedef struct {
    int       size;
    short int type;
} CHUNKHEADER;


// these statics are a crap way to do this, but what the hell, its
// going to be spawned anyways, so it will get released when the program
// quits. (normally you can expect it to pass the buffs as params)
// but this is so much neater. I wonder if you can delete statics?? :))
// I would maybe allocate this vbuffer during initialisation of the game
// anyways, so its not such a bad idea.. only like 70k mem anyway :))


static unsigned char vbuff[64000];  // video buffer (for virtual screen)
static unsigned char palette[768];  // palette from file
static unsigned char target[768];   // target (for fading to etc)
static unsigned char temppal[768];  // temp pal buffer
static signed short int paletteval[768]; // 8.8 fixed point value for pal
static signed short int paletteadd[768]; // 8.8 fixed point vale to add-dec
static unsigned short int fadesteps;     // number of steps to fade in


// Here's the fli playing functions, still some minor bugs, but thats
// what wd is for :))

void fli_brun(unsigned char *brundata);                             // fli brun chunk type decoder
void fli_rc(unsigned char *lcdata);                                 // fli_lc type decoder
void fli_black(void);                                               // fli_black type decoder
void fli_colour(unsigned char *colourdata);                         // fli_colour chunk decoder
void fli_copy(unsigned char *copydata);                             // fli_copy chunk decoder
void fli_readheader(FILE *thisfile,FLIHEADER *thisheader);          // reads a fliheader
int fli_memload(FILE *thisfile,unsigned char *flibuff,int flisize); // load fli
unsigned char * fli_frame(unsigned char *flidata);                  // decodes frame 
unsigned char * decode_chunk(unsigned char *thischunk);             // calls chunk decoders
void setmode(int mode);                                             // sets the video mode
void setpal(char *pal);                                             // sets a palette
void loadandsetpal(char *filename);                                 // loads a palette file
void copybuff(void);                                                // copies the virtual buffer->screen
void zeroscreen(void);                                              // zeroes screen
void readpalfromdac(unsigned char *palbuff);                        // gets palette from vga
void fadeframe(void);                                               // does one frame of a fade loop
void fadetoblack(unsigned short int steps);                         // sets up pals and fades to black
void fadetowhite(unsigned short int steps);                         // same, but to white
void setupfade(unsigned short int numsteps);                        // sets up a fade (8.8 fixed)
void zeropal(unsigned char *pal);                                   // zero a 
void maxpal(unsigned char *pal);
void waitVR(void);                                                  // waits for Retrace period
void copypal(unsigned char *pal1,unsigned char *pal2);              // copies pal->pal
void loadmorph(unsigned char *buffer,int size,int YIndex);          // gets a Xfade tgt
void copymorphbuffers(unsigned char *buffer1,unsigned char *buffer2,int size);
void morphbuffers(unsigned char *buf1,unsigned char *buf2, int size,unsigned 
short int  steps,int Y);                                            // morphs two buffers (Xfade)
void waitframes(int numframes);                                     // waits a specified # of frames
long int filesize(FILE *fp);                                        // returns filesize 
long int flixfade (FILE *fli_file,long int seekpos,int spd);        // does a xfade fli
long int flixfadefull (FILE *fli_file,long int seekpos,int spd);    // 
long int fliplay (FILE *fli_file,long int seekpos,int speed);       //playsflinormally
long int flifade (FILE *fli_file,long int seekpos,int fspd,int hold);

// Hey Bri! I wouldnt normally comment this much! hope it doesnt confuse you

// get filesize of a file, previously opened with fopen.
long int filesize(FILE *fp)
{
    long int save_pos,size_of_file;
    
    save_pos=ftell(fp);
    fseek(fp,0L,SEEK_END);
    size_of_file=ftell(fp);
    fseek(fp,save_pos,SEEK_SET);
    return(size_of_file);
}    

// wait for a specific number of retraces (this can be changed when I stick
// the music player in ray, cus the player sets up a VBL user interrupt.)
void waitframes(int numframes)
{
    int frames;
    
    for (frames=0;frames<numframes;frames++)
    {
        waitVR();
    }
} // end of waitframes


// loads the xfade buffer, from the main fli buffer.. used later    
void loadmorph(unsigned char *buffer, int size,int YIndex)
{
    YIndex*=320;
    memcpy(buffer,&vbuff[YIndex],size);
} // end loadmorph

// copy from xfade buffer one to buffer two.. so it can fade from fli frame
// to fli frame    
void copymorphbuffers(unsigned char *buffer1,unsigned char *buffer2,int size)
{
    memcpy(buffer2,buffer1,size);
}// end copymorphbuffers

///////////////////////////////////////////////////////////////////////////
// this does the xfading.. still a bit slow.. 
// a word about x fading.. basically, it has 2 intensity values, you have
// one set to full intensity, the other set to zero, then for each iteration
// you add a step to the zero and subtract a step from the full, after a 
// number of steps, full is zero, and zero is full!! :))
// for each iteration, you multiply each byte from each buffer by its intensity
// then add em together, and divide by the number of steps, the just store
// the resulting byte into the vbuffer (or screen :)) simple non??
/////////////////////////////////////////////////////////////////////////
void morphbuffers(unsigned char *buf1,unsigned char *buf2, int size,unsigned 
short int steps,int Y)
{
    unsigned short int intense1,intense2;
    unsigned short int data,data2;
    unsigned char morphloop;
    unsigned int dataloop;
    unsigned char *tempbuf1;
    unsigned char *tempbuf2;
    unsigned char *vidbuff;
    
    tempbuf1=buf1;
    tempbuf2=buf2;
    
    Y=Y*320;
    intense1=0;                                   // starting intensities for
    intense2=steps;                               // cross fade buffers
    for (morphloop=0;morphloop<=steps;morphloop++)
    {
     
        vidbuff=&vbuff[Y];                        // ptr->start of fade buffer
        tempbuf1=buf1;                            // ie vid mem  :))
        tempbuf2=buf2;
        
        for (dataloop=0;dataloop<size;dataloop++)
        {
            data=(unsigned short int)*tempbuf1;   // short is to hold all bits
            data*=intense1;                       // byte would cut off
            data2=(unsigned short int)*tempbuf2;
            data2*=intense2;
            data+=data2;
            data/=steps;                          // can use a table here
            *vidbuff=(unsigned char)data;
            vidbuff++;
            tempbuf1++;
            tempbuf2++;
        } // end for dataloop
        waitVR();                                 // sync (take it out?)
        copybuff();                               // show new buffer
        intense1++;                               // adjust intensities
        intense2--;                               // so it x fades..
    } // end for morphloop       
}// end morphbuffers                            

// hmm.. maybe it sets a palette to zero.. (black normally ray :))
void zeropal(unsigned char *pal)
{
    int palcnt;
    signed short int value;
    
    for (palcnt=0;palcnt<768;palcnt++)
    {
        pal[palcnt]=0;
    }
}// end zero pal

// sets a palette buffer to maximum values (white maybe?)
void maxpal(unsigned char *pal)
{
    int palcnt;
    signed short int value;
    
    for (palcnt=0;palcnt<768;palcnt++)
    {
        pal[palcnt]=63;
    }
}// end maxpal

// wont need this when I stick the music system in later or use my own
// vbl timer
void waitVR(void)
{
    while (inp(0x3da) & 8);
    while (!(inp(0x3da) & 8));
}// end waitVR

// copies a palette buffer to another
void copypal(unsigned char *pal1,unsigned char *pal2)
{
    int palcnt;
    signed short int value;
    
    for (palcnt=0;palcnt<768;palcnt++)
    {
        pal2[palcnt]=pal1[palcnt];
    }
}// end copypal

// sets up the mixing palette buffer, so we can fade smoothly, using
// 8.8 fixed point for fading values..
void setupfade(unsigned short int steps)
{
    int palcnt;
    signed short int value;
    
    for (palcnt=0;palcnt<768;palcnt++)
    {
        value=(signed short int) palette[palcnt];
        value=value<<8;
        paletteval[palcnt]=value;
        value-=((signed short int) target[palcnt])<<8;
        value/=(signed short int)steps;
        paletteadd[palcnt]=value;
    }
    fadesteps=steps;
}// end setupfade

// does a frame of already setup fading code, so you can do a little loop
// with youre sprites, and still fade the palette
void fadeframe()
{
    int palcnt;
    if (fadesteps>0)
    {
        for (palcnt=0;palcnt<768;palcnt++)
        {
            paletteval[palcnt]-=paletteadd[palcnt];
            palette[palcnt]=(unsigned char)(paletteval[palcnt]>>8);
        }
        fadesteps--;
        setpal((char *)&palette);
//    waitVR();                         // get rid of this later
    }
}// end fadeframe                                    

// sets up a fade to black from any current palette, sets the target to
// all black, then calls setupfade
void fadetoblack(unsigned short int steps)
{
    int palcnt;
    signed short int value;
    
    readpalfromdac((unsigned char *)&palette);
    zeropal(target);
    setupfade(steps);
    
    for (palcnt=0;palcnt<steps;palcnt++)
    {
        fadeframe();
    }
}// end fadetoblack

// same as above, only to white instead of black :))
void fadetowhite(unsigned short int steps)
{
    int palcnt;
    signed short int value;
    
    readpalfromdac((unsigned char *)&palette);
    maxpal(target);
    setupfade(steps);
    
    for (palcnt=0;palcnt<steps;palcnt++)
    {
        fadeframe();
    }
}// end fadetowhite        

// fades (switches) between two palettes        
void fadepal(unsigned short int steps)
{
    int palcnt;
    signed short int value;
    
    copypal(&temppal[0],&target[0]);
    setupfade(steps);
    
    for (palcnt=0;palcnt<steps;palcnt++)
    {
        fadeframe();
    }
}// end fadepal        

// load a fli file into memory.. best for smaller fli files, I'll
// warn you, you should check mem before calling it..
int fli_memload(FILE *thisfile,unsigned char *flibuff,int flisize)
{
    int bytes;
    
    if (thisfile!=NULL)
    {
        bytes=fread(flibuff,flisize,1,thisfile);
        if (bytes<1)
        {
            printf("error reading into mem buffer for fli \n");
        }
    }
    return(bytes*flisize);
}// end fli_memload         

/* VGA routines */

// sets a screen mode (hehe no mode-x here easy :))
void setmode(int mode)
{
    union REGS r;
    r.h.ah = 0x00;
    r.h.al = mode;
    int386(0x10,&r,&r);
}// end setmode

// sets a palette (need to change this to asm, or do some inline to
// cli sti or it flickers..)
void setpal(char *pal)
{
    int i;
    outp(0x3c8,0x00);
    for (i = 0; i < 3*256; i++)
        outp(0x3c9,pal[i]);
}// end setpal

// just gets the pal from the dac (might need it somewhere...)
void readpalfromdac(unsigned char *pal)
{
    int i;
    outp(0x3c7,0x00);
    for (i = 0; i < 3*256; i++)
    {    
        pal[i]=(unsigned char)inp(0x3c9);
    }
}// end readpalfromdac

/////////////////////////////////////////////////////////////////////
// START THE FLI PLAYER STUFF
//
/////////////////////////////////////////////////////////////////////

// sets a palette chunk (from within a palette frame)
void setpalchunk(char *pal,unsigned char skip,unsigned char numtoset)
{
    int i;
    
    outp(0x3c8,skip);
    for (i=0;i<(numtoset*3);i++)
    outp(0x3c9,pal[i]);
}// end setpalchunk

// load and set a palette from disk (debugging code, not used..)
void loadandsetpal(char *palfilename)
{
    FILE *thisfile;
    char paldata[768];
    int test;
    
    thisfile=fopen(palfilename,"rb");
    if (thisfile==NULL)
    {
        exit(1);
    }
    test=fread(&paldata[0],sizeof(paldata),1,thisfile);
    if (test<1) exit(2);
    setpal(&paldata[0]);
}// end loadandsetpal

// fli frame, decodes one frame of a fli, then returns a pointer to
// next frame (played from mem.. easy to add disk playing..)    
unsigned char *fli_frame(unsigned char *flimembuff)
{
    FRAMEHEADER *thisframe;
    unsigned char *nextframe;
    short int numchunks;
    unsigned char *thischunk;
    
    thisframe=(FRAMEHEADER *) flimembuff;
    nextframe=flimembuff;
    nextframe+=thisframe->framesize;
    thischunk=(flimembuff+sizeof(FRAMEHEADER));
//    if(thisframe->chunks<1) 
//    {
//        printf("empty frame \n");
//        exit(1);
//    }
    for (numchunks=1;numchunks<=thisframe->chunks;numchunks++)
    {
#ifdef debug        
        printf("decoding chunk >%d \n",numchunks);
#endif        
        thischunk=decode_chunk(thischunk);
    }        
    return(nextframe);
}// end fli_frame            

// decode a chunk, find out its chunk type, and call the function where
// appropriate..
unsigned char *decode_chunk(unsigned char *thischunk)
{
    CHUNKHEADER *chunkhead;
    unsigned char *nextchunk;
    unsigned char *chunkdata;
    
    chunkhead=(CHUNKHEADER *)thischunk;
    nextchunk=thischunk+chunkhead->size;
    chunkdata=thischunk+6;
    
    switch (chunkhead->type)
    {
        case 11:
#ifdef debug
printf("calling fli_colour\n");
#endif                    
                    fli_colour(chunkdata);
                    break;
        case 12:
#ifdef debug
printf("calling fli_lc\n");
#endif                    
                    fli_rc(chunkdata);
                    break;
        case 13:
#ifdef debug
printf("calling fli_black\n");
#endif                    
                    fli_black();
                    break;
        case 14:    
#ifdef debug
printf("calling fli_nothing\n");
#endif                    
                    break;
        case 15:    
#ifdef debug
printf("calling fli_brun\n");
#endif                    
                    fli_brun(chunkdata);
                    break;
        case 16:
#ifdef debug
printf("calling fli_copy\n");
#endif                    
                    fli_copy(chunkdata);
                    break;
    }
    return(nextchunk);
}// end decodechunk

// fli_black chunk type, just copies 0's to the offscreen buffer..
void fli_black(void)
{
    unsigned char *vbuffptr;
    unsigned int write;
    
    vbuffptr=&vbuff[0];
    for (write=0;write<64000;write++)
    {
        *vbuffptr=0;
        vbuffptr++;
    }
}// end fliblack

// fli_copy chunk type, copies a screens worth of uncompressed data from
// the input stream to screen    
void fli_copy(unsigned char *data)
{
    unsigned char *vbuffptr;
    unsigned short int write;
    
    vbuffptr=&vbuff[0];
    for (write=0;write<64000;write++)
    {
        *vbuffptr=*data;
        vbuffptr++;
        data++;
    }
}// end fli_copy

// fli_colour chunk, has packets of colour, each packet has a number of 
// colours to skip, and a number to set.. skip val of 0 means set 255 cols..
// for some reason, the non 256 colour setting has a prob.. :))
void fli_colour(unsigned char *cdata)
{
    short int *pktaddress;
    unsigned char skip;
    unsigned char set;
    short int numberpk;
    short int packetcount;
    
    pktaddress=(short int *)cdata;
    cdata++;
    cdata++;
    numberpk=*pktaddress;
    for (packetcount=0;packetcount<numberpk;packetcount++)
    {
        skip=*cdata;
        cdata++;
        set=*cdata;
        cdata++;
        
        if (set==0)
        {
            zeropal(palette);
            copypal(cdata,temppal);
            setpal((char *)palette);
        }
        else
        {
            setpalchunk((char *)cdata,skip,set);
            cdata+=(set*3);
        }
    } // end for packetcount    

}// end fli_colour

// this should be fli_lc but I did an asm version, but this isnt much
// slower, and its simpler to link, so I did this...
// its byte compressed data, like fli_brun with an initial line skip
void fli_rc(unsigned char*lcdata)
{
    short int *addlines;
    short int numlines;
    unsigned char *vbuffptr;
    short int linecount;
    unsigned char pktcount,skip,numpkt,sizecount,databyte;
    signed char size;
    unsigned char *linestart;    
    int clearline;
    
    vbuffptr=&vbuff[0];
    addlines=(short int *) lcdata;
    numlines=*addlines;
    lcdata+=4;
    addlines+=1;
    vbuffptr+=(numlines*320);
    numlines=*addlines;                                 // skip some lines
    
    linestart=vbuffptr;
    for (linecount=0;linecount<numlines;linecount++)    // number of lines
    {                                                   // to decode
    
        vbuffptr=linestart;    
        numpkt=*lcdata;
        lcdata++;
        for (pktcount=0;pktcount<numpkt;pktcount++)     // lines are in pkts
        {                                               // each has a skip
            skip=*lcdata;                               // and a size
            lcdata++;
            vbuffptr+=skip;
            size=(signed char)*lcdata;
            lcdata++;
            if (size>=0)                                // size not negative?
            {
                for (sizecount=0;sizecount<size;sizecount++)
                {
                    *vbuffptr=*lcdata;
                    vbuffptr++;
                    lcdata++;                           // copy size data bytes
                }
            }
            else
            {
                    size=-size;
                    databyte=*lcdata;
                    lcdata++;
                    for (sizecount=0;sizecount<size;sizecount++)
                    {
                        *vbuffptr=databyte;
                        vbuffptr++;                     // else store next byte
                    }                                   // size times
            } // end if
        } // end for packet count
    linestart+=320;
    } // end for line count
} // end fli_rc

// fli_brun (byte run compressed) pretty much as fli_rc without line skip
void fli_brun(unsigned char*brundata)
{
    short int *addlines;
    short int numlines;
    unsigned char *vbuffptr;
    short int linecount;
    unsigned char pktcount,skip,numpkt,sizecount;
    signed char size;
    unsigned char databyte;
    
    vbuffptr=&vbuff[0];
    
    for (numlines=0;numlines<200;numlines++)
    {            
    numpkt=*brundata;
    brundata++;
    for (pktcount=0;pktcount<numpkt;pktcount++)
    {
        size=(signed char)*brundata;
        brundata++;
        if (size>=0)
        {
            for (sizecount=0;sizecount<size;sizecount++)
            {
                *vbuffptr=*brundata;
                vbuffptr++;
                //brundata++; 
            }
        brundata++;
        }
        else
        {
            size=-size;
            for (sizecount=0;sizecount<size;sizecount++)
            {
                *vbuffptr=*brundata;
                vbuffptr++;
                brundata++;
            }
       //     brundata++;
        } // end if
    } // end for packet count
  } // end for numlines
} // end fli_brun

// copies the virual buffer to the screen... (damn, I know I shouldnt use
// that static crap :)) but its just sooo simple :))
void copybuff()
{
    int buffsize=64000;
    char *screen;
    
    screen=(char *) 0xa0000;                   
    memcpy(screen,&vbuff[0],buffsize);
}// end copybuff               
    
// zero's the screen (like fli_black only direct to screen not vbuff)
void zeroscreen()
{
    int buffsize;
    char *screen;
    
    screen=(char *) 0xa0000;                   
    for (buffsize=0;buffsize<64000;buffsize++) screen[buffsize]=0;
}// end zeroscreen               
    
// flixfade.. a proc that uses the other stuff...        
long int flixfade (FILE *fli_file,long int seekpos,int spd)
    {
        int numread;
        FLIHEADER flihead;
        int flisize;
        short int flinumframes;
        unsigned char *flimembuff;
        int flibuffcount;
        short int framecnt;
        unsigned char *framebuff;
        int framesdone;
        unsigned char *morphbuf1;
        unsigned char *morphbuf2;
        unsigned short int morphbyte;
        unsigned char intense1,intense2;
        unsigned char palset;
        unsigned char bothfull;
        
        numread=fread(&flihead,sizeof(FLIHEADER),1,fli_file);
        if (numread<1)
        {
            printf("couldnt read a header! \n");
            exit(1);
        };
          
        flinumframes=flihead.fli_frames;
        flisize=(flihead.fli_size-sizeof(FLIHEADER));
        if (flisize<2000000)
        {
            flimembuff=new unsigned char[flisize];
            if (flimembuff==NULL)
            {
                printf("buffer not allocated for reading in the whole fli \n");
                exit(1);
            }
        };
        
        seekpos+=(long int) flihead.fli_size;  // point to next fli (or whatever)
        
        
        // allocate morphing buffers.. :))
        morphbuf1=new unsigned char[320*70];
        if (morphbuf1==NULL) exit(1);
        morphbuf2=new unsigned char[320*70];
        if (morphbuf2==NULL) exit(1);
        
        
        
        flibuffcount=fli_memload(fli_file,flimembuff,flisize);
        if (flibuffcount<flisize)
        {
            printf("an error occured reading in the fli into mem \n");
            delete (flimembuff);
            exit(1);
        }
        framebuff=flimembuff;
        zeropal(palette);
        palset=0;
        bothfull=0;
      
            framebuff=flimembuff;
            for (framecnt=1;framecnt<=flinumframes;framecnt++)
            {
#ifdef debug            
                printf("doing frame %d \n",framecnt);
#endif            
                framebuff=fli_frame(framebuff); // do a single frame
                if (bothfull==0) copybuff();
                loadmorph(morphbuf1,(320*70),70);
                if (palset==0) fadepal(40);
                palset=1;
//                waitframes(spd);
                
                if (bothfull==1) 
                {
                    morphbuffers(morphbuf1,morphbuf2,(320*70),16,70);
                }
                copymorphbuffers(morphbuf1,morphbuf2,(320*70));
                waitframes(spd);
                
                bothfull=1;
                
            } // end for
        waitframes(spd);
        
        delete morphbuf1;
        delete morphbuf2;
        delete(flimembuff);
        return(seekpos);
} // end flixfade                          

// this version x fade's the full screen between two pix, needs a gradient
// palette to look right :))         
long int flixfadefull (FILE *fli_file,long int seekpos,int spd)
    {
        int numread;
        FLIHEADER flihead;
        int flisize;
        short int flinumframes;
        unsigned char *flimembuff;
        int flibuffcount;
        short int framecnt;
        unsigned char *framebuff;
        int framesdone;
        unsigned char *morphbuf1;
        unsigned char *morphbuf2;
        unsigned short int morphbyte;
        unsigned char intense1,intense2;
        unsigned char palset;
        unsigned char bothfull;
        
        numread=fread(&flihead,sizeof(FLIHEADER),1,fli_file);
        if (numread<1)
        {
            printf("couldnt read a header! \n");
            exit(1);
        };
          
        flinumframes=flihead.fli_frames;
        flisize=(flihead.fli_size-sizeof(FLIHEADER));
        if (flisize<2000000)
        {
            flimembuff=new unsigned char[flisize];
            if (flimembuff==NULL)
            {
                printf("buffer not allocated for reading in the whole fli \n");
                exit(1);
            }
        };
        
        seekpos+=(long int) flihead.fli_size;  // point to next fli (or whatever)
        
        
        // allocate morphing buffers.. :))
        morphbuf1=new unsigned char[64000];    // coulda used malloc :))
        if (morphbuf1==NULL) exit(1);
        morphbuf2=new unsigned char[64000];
        if (morphbuf2==NULL) exit(1);
        
        
        
        flibuffcount=fli_memload(fli_file,flimembuff,flisize);
        if (flibuffcount<flisize)
        {
            printf("an error occured reading in the fli into mem \n");
            delete (flimembuff);
            exit(1);
        }
        framebuff=flimembuff;
        zeropal(palette);
        palset=0;
        bothfull=0;
      
            framebuff=flimembuff;
            for (framecnt=1;framecnt<=flinumframes;framecnt++)
            {
#ifdef debug            
                printf("doing frame %d \n",framecnt);
#endif            
                framebuff=fli_frame(framebuff); // do a single frame
                if (bothfull==0) copybuff();
                loadmorph(morphbuf1,64000,0);
                if (palset==0) fadepal(40);
                palset=1;
//                waitframes(spd);
                
                if (bothfull==1) 
                {
                    morphbuffers(morphbuf1,morphbuf2,64000,16,0);
                }
                copymorphbuffers(morphbuf1,morphbuf2,64000);
                waitframes(spd);
                
                bothfull=1;
                
            } // end for
        waitframes(spd);
        
        delete morphbuf1;
        delete morphbuf2;
        delete(flimembuff);
        return(seekpos);
} // end flixfade                          
        
// fades between pic->black->pic at given speed.. 
// used for titles, credits etc...        
long int flifade (FILE *fli_file,long int seekpos,int fspd,int hold)
    {
        int numread;
        FLIHEADER flihead;
        int flisize;
        short int flinumframes;
        unsigned char *flimembuff;
        int flibuffcount;
        short int framecnt;
        unsigned char *framebuff;
        int framesdone;
        
        framesdone=0;
        
        numread=fread(&flihead,sizeof(FLIHEADER),1,fli_file);
        if (numread<1)
        {
            printf("couldnt read a header! \n");
            exit(1);
        };
            
        flinumframes=flihead.fli_frames;
        flisize=(flihead.fli_size-sizeof(FLIHEADER));
        if (flisize<2000000)
        {
            flimembuff=new unsigned char[flisize];
            if (flimembuff==NULL)
            {
                printf("buffer not allocated for reading in the whole fli \n");
                exit(1);
            }
        };
        seekpos+=(long int) flihead.fli_size;      // point to next fli
        
        
        flibuffcount=fli_memload(fli_file,flimembuff,flisize);
        if (flibuffcount<flisize)
        {
            printf("an error occured reading in the fli into mem \n");
            delete (flimembuff);
            exit(1);
        }
        framebuff=flimembuff;
        zeropal(palette);
        fadetoblack(fspd);
            
            for (framecnt=1;framecnt<=flinumframes;framecnt++)
            {
                framebuff=fli_frame(framebuff); // do a single frame
                copybuff();
                
                fadepal(fspd);
                waitframes(hold);
                fadetoblack(fspd);
            } // end for
        delete(flimembuff);
        return(seekpos);
} // end main                          

// simply play a fli, quite easy really :))        
long int fliplay (FILE *fli_file,long int seekpos,int speed)
    {
        int numread;
        FLIHEADER flihead;
        int flisize;
        short int flinumframes;
        unsigned char *flimembuff;
        int flibuffcount;
        short int framecnt;
        unsigned char *framebuff;
        int framesdone;
        int paldone;
        
        framesdone=0;
        paldone=0;
        
        numread=fread(&flihead,sizeof(FLIHEADER),1,fli_file);
        if (numread<1)
        {
            printf("couldnt read a header! \n");
            exit(1);
        };
            
        flinumframes=flihead.fli_frames;
        flisize=(flihead.fli_size-sizeof(FLIHEADER));
        if (flisize<2000000)
        {
            flimembuff=new unsigned char[flisize];
            if (flimembuff==NULL)
            {
                printf("buffer not allocated for reading in the whole fli \n");
                exit(1);
            }
        };
        seekpos+=(long int) flihead.fli_size;      // point to next fli
        
        
        flibuffcount=fli_memload(fli_file,flimembuff,flisize);
        if (flibuffcount<flisize)
        {
            printf("an error occured reading in the fli into mem \n");
            delete (flimembuff);
            exit(1);
        }
        framebuff=flimembuff;
            for (framecnt=1;framecnt<=flinumframes;framecnt++)
            {
                framebuff=fli_frame(framebuff); // do a single frame
                copybuff();
                if (paldone==0) fadepal(1);
                paldone=1;
                waitframes(speed);
            
            } // end for
        delete(flimembuff);
        return(seekpos);
} // end main                          

// ok, here we go with the main code..         
void main (int argc,char **argv)
    {
        FILE *fli_file;
        long int seekpos;
        long int oldseek;
        
        seekpos=0;
        if (argc<1)
        {
            printf("idiot boy, its X: flifile.fli [flipal.pal]\n");
            printf("where [] are optional \n");
            exit(1);
        };
        
//        fli_file = fopen(argv[1],"rb");
        fli_file = fopen("data.dat","rb");
        if (fli_file==NULL)
        {
            printf("couldnt open the data file you dobie! \n");
            exit(1);
        };
        fli_black();                               // clear vbuff
        zeroscreen();                              // clear screen
        zeropal(palette);                          // clear palette :)
        fadetoblack(10);                           // set pal to black
        zeroscreen();                              // uhm :))
        setmode(19);                               // set mode 13h
        zeroscreen();                              // and again?? OTT
        
///////////////////////////////////////////////////////////////////////////        
// here we are ready to play with some fli's, the data file is just the
// number of fli files you made, using copy /b fliname.fli+fliname.fli data.dat
// then, for each fli file, you just add a section like the ones below, so
// par example, you could fade the first fli, xfade the next, play the next
// just add the required playing routine (each returns a long int so you can
// seek to the next fli within the file, this isnt strictly required, but it
// gives me some peace of mind) so each fli is loaded into mem from the data
// file (could tack it onto the exe if you wanted) and returns the next fli
// offset in the file when all done.       
// anyways, have fun, and talk to me if you have problems..       
///////////////////////////////////////////////////////////////////////////        
        
        
        
        oldseek=seekpos;                           // set to start of fli data
        seekpos=flifade(fli_file,seekpos,60,160);  // fade the first fli
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)                      // if it didnt work
        {
            setmode(3);
            printf("seekpos was the same /n");
            exit(1);
        }
        
/////////// you need the above for each fli in the data file, just change the
/////////// flifade to something else to get a different effect!        
        
        oldseek=seekpos;                           // use new seek pos in file
        fseek(fli_file,seekpos,SEEK_SET);          // just in case 
        seekpos=fliplay(fli_file,seekpos,2);       // play the next fli
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 1 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fseek(fli_file,seekpos,SEEK_SET);
        seekpos=flifade(fli_file,seekpos,40,260);  // fade the next fli
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 2 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fseek(fli_file,seekpos,SEEK_SET);
        fadetoblack(40);
        seekpos=fliplay(fli_file,seekpos,3);       // play next fli etc..
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 3 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fadetoblack(40);
        fseek(fli_file,seekpos,SEEK_SET);
        seekpos=flixfadefull(fli_file,seekpos,1);  // cross fade full screen
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 4 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fadetoblack(40);
        fseek(fli_file,seekpos,SEEK_SET);
        seekpos=flixfade(fli_file,seekpos,1);      // x fade middle screen
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 5 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fadetowhite(40);
        fadetoblack(40);
        fseek(fli_file,seekpos,SEEK_SET);
        seekpos=flixfadefull(fli_file,seekpos,1);  // full screen again
//        printf("seekpos=> %ld \n",seekpos);
        if (seekpos==oldseek)
        {
            setmode(3);
            printf("seekpos 6 was the same /n");
            exit(1);
        }
        oldseek=seekpos;
        fadetoblack(40);
        fseek(fli_file,seekpos,SEEK_SET);
//        printf("seekpos=> %ld \n",seekpos);
        setmode(3);                                
        fclose(fli_file);
        
} // end main                          


