/* Package to draw a predefined button.
   This uses VESA graphics.
*/
#include <stdio.h>
#include <stdlib.h>
#include <graph.h>

#include <svga.h>
#include <vmouse.h>
#include "button.h"

static int    Id = 0;
static BUTTON Button[3];   /* button variables */


typedef  struct
{
   int   x, y, xlen, ylen;
   uchar  *SaveBuf;
} SAVE1;

static void Save( int, int, int, int, SAVE1 * );
static int  PressButton( int code );
static int  PushButton( int x, int y, int xlen, int ylen, int ButtType );
static int  RegisterButton( BUTTON *Bp );

extern uchar cursorPicture[];
extern uchar animPicture[];
extern uchar quitPicture[];


/* Check if a button has been pressed and take action if so.
   Return a non-null number if button is pressed, else zero.
*/
int  BUTTONcheck( int x, int y, int event )
{
  static int  OldMOUSEstatus = 0, LeftButtonDown = 0, PushButtonActive = -1;
  static int  OldX = 0, OldY = 0;
  int         ret_code, i, found;
  BUTTON      *Bp;

  /* Mouse movements:
   * First, check if the user has moved the cursor away from an active
   * pushbutton.  If so, depress this button. This looks very cool.
   * Two ways of depressing button:
   *   1.  Move cursor away from button
   *   2.  Depress mouse button
   */
  found = 0;
  if ( PushButtonActive != -1 )
  {
    Bp = Button;
    Bp += PushButtonActive;    /* go to the active button */
    if ( x > Bp->x && x < ( Bp->x + Bp->xlen ) &&
         y > Bp->y && y < ( Bp->y + Bp->ylen ))
      ;
    else
      found = 1;     /* mouse cursor does not point to button */
  }
  if (( found || (event & VMOUSEleftRele)) && PushButtonActive != -1 )
  {
    PressButton( PushButtonActive );      /* release button */
    PushButtonActive = -1;        
  }

  /*
   * See if any of the registered buttons have been pressed/depressed
   */
  Bp = Button;
  for ( i=0; i < Id; i++, Bp++ )
  {   /* coordinate comparison */
    if ( x > Bp->x && x < ( Bp->x + Bp->xlen ) &&
         y > Bp->y && y < ( Bp->y + Bp->ylen ))
    {
      if ( Bp->Type == PUSHBUTTON  &&  Bp->Id != -1 )
      {
        if ( event & VMOUSEleftPres )
        {
          PressButton( Bp->Id );      /* show press action */
          PushButtonActive = Bp->Id;
          return ( Bp->Id | BUTTONedit);  /* return ID */
        }
        if ( event & VMOUSEleftRele )
        {
//          PushButtonActive = -1;
//          PressButton( Bp->Id );      /* show depress action */
          return ( Bp->Id | BUTTONedit);  /* return ID */
        }
      }
      else if ( Bp->Type == RADIOBUTTON  &&  Bp->Id != -1 )
      {
        if ( event & VMOUSEleftPres ) /* reset mouse press */
          PressButton( Bp->Id );      /* show press action */

        return ( Bp->Id | BUTTONedit );
      }
    }
  }
  return 0;
}




/* 
 * Display button action on press if a button was pressed
 */
static int  PressButton( int code )
{
  int  i = code;

  PushButton( Button[i].x, Button[i].y, Button[i].xlen, Button[i].ylen, 
              Button[i].Type );

  return  code;   /* just return it */
}





/*
 * Push button whose upper left coord. is at (x,y)
 */
#define   PRESSFACTOR  1

static  SAVE1  Push, Radio;
static  int    PushB = 0;
static  int    RadioB = 0;


static int PushButton( int x, int y, int xlen, int ylen, int ButtType )
{
  uchar *MoveBuf, *s;
  int    offs, ShadowColor, BackGndCol;
  int    NextLine;
  int    i, j;
  int    tmp;
  uchar *p;

  if ( ButtType == PUSHBUTTON )
  {
    PushB ^= 1;
    if ( PushB == 0 )   /* depress -> restore original button */
    {
      SVGAdrawBlock( Push.x, Push.y, Push.xlen, Push.ylen, Push.SaveBuf );
      free( Push.SaveBuf );
      return 0;
    }
    else
      Save( x, y, xlen, ylen, &Push );   /* Save orig.button before press*/
  }
  else if ( ButtType == RADIOBUTTON )
  {
    /* Restore previously pressed radiobutton */
    if ( RadioB == 1 )
    {
      SVGAdrawBlock( Radio.x, Radio.y, Radio.xlen, Radio.ylen, Radio.SaveBuf);
      free( Push.SaveBuf );
    }
    Save( x, y, xlen, ylen, &Radio );  /* Save orig.button before press*/
    RadioB = 1;
  }

  /*
   * Show that button is being pressed
   */
  x    += PRESSFACTOR;     y    += PRESSFACTOR;  /*coordinate conditioning*/
  xlen -= (PRESSFACTOR*2); ylen -= (PRESSFACTOR*2);
  /*
   * Copy part of image to move
   */
  if ((s = MoveBuf = SVGAbufferAlloc( xlen, ylen )) == NULL )
  {
    /* error: no more memory */
    return -1;
  }
  SVGAgetBlock( x, y, xlen, ylen, MoveBuf );

  /*
   * move pic 1 right, 1 down
   */
  SVGAdrawBlock( x+1, y+1, xlen, ylen, MoveBuf );
  free( MoveBuf );

  /* 
   * Do postconditioning to remove 2 remaining pixels + add shadows in
   * upper and leftmost row and column
   */
  ShadowColor = SVGAgetPixel( x, y+ylen );
  BackGndCol  = SVGAgetPixel( x+xlen-2, y );
  SVGAputPixel( x+xlen-1, y, BackGndCol );

  SVGAputPixel( x, y+ylen-1, SVGAgetPixel( x, y+ylen-2 ));
/*
  _setcolor( BackGndCol );
  _moveto( x-1, y+ylen );
  _lineto( x-2+xlen+PRESSFACTOR*2, y+ylen );

  _moveto( x+xlen, y );
  _lineto( x+xlen, y+ylen-1+PRESSFACTOR );
*/
  SVGAmoveto( x-1, y+ylen );
  SVGAlineto( x-2+xlen+PRESSFACTOR*2, y+ylen, BackGndCol );

  SVGAmoveto( x+xlen, y );
  SVGAlineto( x+xlen, y+ylen-1+PRESSFACTOR, BackGndCol );

  x -= PRESSFACTOR;  y -= PRESSFACTOR;
  xlen += (PRESSFACTOR*2);  ylen += (PRESSFACTOR*2);
#ifdef ffff
  _setcolor( ShadowColor );    /* hor. upper shadow */
  _moveto( x, y );
  _lineto( x+xlen-1, y );

  _moveto( x, y );             /* left vertical shadow */
  _lineto( x, y+ylen-1 );
#endif
  SVGAmoveto( x, y );
  SVGAlineto( x+xlen-1, y, ShadowColor );    /* hor. upper shadow */

  SVGAmoveto( x, y );
  SVGAlineto( x, y+ylen-1, ShadowColor );    /* left vertical shadow */

  return 0;
}




/*
 * Save the current button, coordinates and size
 */
static  void  Save( int x, int y, int xlen, int ylen, SAVE1 *P )
{
  uchar    *s;

  P->x = x; P->y = y; P->xlen = xlen; P->ylen = ylen;
  if ((s = P->SaveBuf = SVGAbufferAlloc( xlen, ylen )) != NULL )
    SVGAgetBlock( x, y, xlen, ylen, s );
}




/* Initialize the button
*/
int BUTTONinit( int x, int y )
{
  int  id=0;

  Button[id].Buf = animPicture+2;
  Button[id].Id = id;
  Button[id].x = x;
  Button[id].y = y;
  Button[id].xlen = *animPicture;
  Button[id].ylen = *(animPicture+1);
  Button[id].Type = PUSHBUTTON;
//  Button[id].Type = RADIOBUTTON;

  if ( SVGAisTrueColorMode())
    Button[id].Buf = SVGAbufferConvert( Button[id].Buf,
                     Button[id].xlen, Button[id].ylen );
  (void )RegisterButton( &Button[id] );
  id++;

  Button[id].Buf = cursorPicture+2;
  Button[id].Id = id;
  Button[id].x = Button[id-1].x + Button[id-1].xlen + 4;
  Button[id].y = Button[id-1].y;
  Button[id].xlen = *cursorPicture;
  Button[id].ylen = *(cursorPicture+1);
  Button[id].Type = PUSHBUTTON;

  if ( SVGAisTrueColorMode())
    Button[id].Buf = SVGAbufferConvert( Button[id].Buf,
                     Button[id].xlen, Button[id].ylen );
  (void )RegisterButton( &Button[id] );
  id++;

  Button[id].Buf = quitPicture+2;
  Button[id].Id = id;
  Button[id].x = Button[id-1].x + Button[id-1].xlen + 4;
  Button[id].y = Button[id-1].y;
  Button[id].xlen = *quitPicture;
  Button[id].ylen = *(quitPicture+1);
  Button[id].Type = PUSHBUTTON;

  if ( SVGAisTrueColorMode())
    Button[id].Buf = SVGAbufferConvert( Button[id].Buf,
                     Button[id].xlen, Button[id].ylen );
  (void )RegisterButton( &Button[id] );
  id++;

  Id = id;
  return 0;
}



static int RegisterButton( BUTTON *Bp )
{
   int  x, y;

   /* draw button frame */
   x = Bp->x - 1;   y = Bp->y - 1;
   SVGAmoveto( x, y );
   SVGAlineto( x+1+Bp->xlen, y, 4 );
   SVGAlineto( x+1+Bp->xlen, y+1+Bp->ylen, 4 );
   SVGAlineto( x,            y+1+Bp->ylen, 4 );
   SVGAlineto( x, y, 4 );

   /* Display the button */
   return SVGAdrawBlock( Bp->x, Bp->y, Bp->xlen, Bp->ylen, Bp->Buf );
}
