/*
  Graphics routines for support of 256 color paged video modes.
  These modes are not supported by commercial compiler products.
*/

#ifndef _VGAPAGE_H_
#define _VGAPAGE_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif


#include <mytypes.h>


typedef struct
{
  int Xres, Yres;
} VGAPAGEdata;


/* Mode manifest constants for supported video modes
*/
#define  VGAPAGEmode256x256  20
#define  VGAPAGEmode320x200  21
#define  VGAPAGEmode320x240  22  
#define  VGAPAGEmode360x270  23  
#define  VGAPAGEmode400x300  24  
#define  VGAPAGEmode400x600  25  


int   VGAPAGEinit( short mode );
void  VGAPAGEset256x256( void );
void  VGAPAGEset320x200( void );
void  VGAPAGEset320x240( void );
void  VGAPAGEset360x270( void );
void  VGAPAGEset400x300( void );
void  VGAPAGEset400x600( void );

VGAPAGEdata  *VGAPAGEgetData( void );  /* Get paged mode data */

void  VGAPAGEsetActiveStart( int iOffset );
void  VGAPAGEsetActivePage(  int iPage );
void  VGAPAGEsetVisibleStart( int iOffset );
void  VGAPAGEsetVisiblePage(  int iPage );
void  VGAPAGEputPixel( int x, int y, uchar color );
void  VGAPAGEdrawLine( int x, int y, int iLen, uchar *buf );

int   VGAPAGEdrawBlock( int x, int y, int xlen, int ylen, uchar *block );
int   VGAPAGEgetBlock( int x, int y, int xlen, int ylen, uchar *block );
int   VGAPAGEdrawTranspBlock( int x, int y, int xlen, int ylen, uchar *block );

int   VGAPAGEgetPixel( int x, int y );
void  VGAPAGEgetLine(  int x, int y, int iLen, uchar *Buf );

int   VGAPAGEscreenWidth( void );
int   VGAPAGEscreenHeight( void );

void  VGAPAGEsetVideoLineLen( int Pixels );

void  VGAPAGEsetcolor( uchar Color );
void  VGAPAGEmoveto( int x, int y );
void  VGAPAGElineto( int x, int y );


#ifdef __cplusplus
};
#endif

#endif
