/* Unit to implement text in graphics modes.  It uses the font
   stored in the BIOS area (intended used in mode 13h) and
   the SVGA interface to output blocks of text in the current
   graphics mode.
   */
#ifndef _GTXT_H_
#define _GTXT_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif

#include <mytypes.h>

void  GTXTouttext( uchar *str );
void  GTXTgotoxy( int x, int y );
uchar GTXTsetBackground( uchar Color );
uchar GTXTsetForeground( uchar Color );
void  GTXTsetTransparent( int on );


#ifdef __cplusplus
};
#endif

#endif
