/*
 * Function prototypes for bitblt operations
 *
 */
#ifndef _BITB_H_
#define _BITB_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif

#include  "bitb.h"
#include  "mytypes.h"

void  BITBdrawBlock( int old_x, int old_y, int old_xsiz, int old_ysiz,
                     int     x, int y,     int xsiz,     int ysiz,
                     uchar  *backgnd );

void  BITBgetBlock( int old_x, int old_y, int old_xsiz, int old_ysiz,
                    int     x, int y,     int xsiz,     int ysiz,
                    uchar  *backgnd );

void  BITBdrawTranspBlock( int x, int y, int xsiz, int ysiz,  char *buf );

int  BITBupdateBackground(uchar          *old_backgnd, /* IO */
                          uchar          *new_backgnd, /* I */
                          uchar          *sprite,      /* I */
                          int             sprtSiz      /* I */);

void  BITBdropBackground( void );

#ifdef __cplusplus
};
#endif

#endif
