#ifndef _STANDARD_H_
#define _STANDARD_H_

#include <fcntl.h>
#include <sys/stat.h>

#define TRUE    1
#define FALSE	0
#define NULL    0

#define FIXED4(x)   (x << 4)
#define FIXED6(x)   (x << 6)
#define FIXED8(x)   (x << 8)
#define FIXED16(x)  (x << 16)

#define SET_BITS(x, bits)   (x | bits)
#define RESET_BITS(x, bits) (x & ~bits)

#define RED(pal,o)      (pal)[(o)*3+0]
#define GREEN(pal,o)    (pal)[(o)*3+1]
#define BLUE(pal,o)     (pal)[(o)*3+2]

#define SETRED(pal,o,c) (pal)[(o)*3+0]=(c>>16)&0xff
#define SETGREEN(pal,o,c) (pal)[(o)*3+1]=(c>>8)&0xff
#define SETBLUE(pal,o,c) (pal)[(o)*3+2]=c&0xff

#define GETRGB(map, x) (*((map) + ((x) * 3)) << 16) | \
                       (*((map + 1) + ((x) * 3)) << 8) | \
                       *((map + 2) + ((x) * 3))

#define REVERSENUM(a) ((a[0] << 24) + (a[1] << 16) + (a[2] << 8) + a[3])
#define REVERSEWORD(a) (((a) & 0xff00) >> 8) | (((a) & 0x00ff) << 8)
#define DOREVERSE(a, b) a[0] = (b >> 24) & 0xff; \
                        a[1] = (b >> 16) & 0xff; \
                        a[2] = (b >> 8) & 0xff; \
                        a[3] = b & 0xff;

#define SQUARE(x)  ((x) * (x))

#define TEXTLENGTH(x) (current_font->width * (x) + 14)

#define LOBYTE(value) (unsigned char)((value) & 0x00FF)
#define HIBYTE(value) (unsigned char)((value) >> 8)

#define LFBMapRealPointer(p)  (void *)(((p) & 0xffff) + ((unsigned)((p) &0xffff0000) >> 12))

typedef unsigned char      UBYTE;
typedef signed char        BYTE;
typedef unsigned short int UWORD;
typedef short int          WORD;
typedef unsigned int       ULONG;
typedef int                LONG;
typedef char               BOOL;
typedef unsigned int       FIXED;
typedef float              FLOAT;

#endif
#ifndef _VLIB_BMP_H_
#define _VLIB_BMP_H_


//-------------------//
//-- BMP Constants --//
//-------------------//

#define BI_RGB  0
#define BI_RLE8 1



//--------------------//
//-- BMP Structures --//
//--------------------//

typedef struct BMPFileHeader {
    WORD    type;
    ULONG   size;
    WORD    reserved1;
    WORD    reserved2;
    ULONG   offbits;
} BMPFileHeader;

typedef struct BMPInfo {
    ULONG   size;
    LONG    width;
    LONG    height;
    WORD    planes;
    WORD    bitcount;
    ULONG   compression;
    ULONG   sizeimage;
    LONG    xpelspermeter;
    LONG    ypelspermeter;
    ULONG   clrsused;
    ULONG   clrsimportant;
} BMPInfo;

typedef struct BMPHeader {
    BMPFileHeader   bmpfh;
    BMPInfo         bmpih;
} BMPHeader;



//-------------------//
//-- BMP externals --//
//-------------------//

extern BMPHeader bmp_header;



//-----------------------------//
//-- BMP Function Prototypes --//
//-----------------------------//

BOOL GetBMPHeader(UBYTE *filename, BMPHeader *header);
BOOL IsBMP(UBYTE *filename);
BOOL LoadBMP(UBYTE *filename, UBYTE *body_buffer, UBYTE *colormap);
BOOL LoadBMPPalette(UBYTE *filename, UBYTE *colormap);
BOOL SaveBMP(UBYTE *filename, UBYTE *buffer, UWORD width, UWORD height, UBYTE *colormap);

#endif
#ifndef _VLIB_DRAW_H_
#define _VLIB_DRAW_H_



//--------------------//
//-- Draw Constants --//
//--------------------//

#define SHAPE_RECTANGLE 0
#define SHAPE_SMOOTH    1
#define SHAPE_ROUND     2
#define SHAPE_OVAL      3



//---------------------//
//-- Draw Structures --//
//---------------------//

typedef struct Bitmap
{
    UWORD  width;
    UWORD  height;
    UBYTE  *image;
    UBYTE  *palette;
} Bitmap;

typedef struct Dialog
{
    UWORD x;
    UWORD y;
    UWORD width;
    UWORD height;
    UBYTE *title;
    UBYTE *bodytext;
    void  *button1;
    void  *button2;
} Dialog;

typedef struct InputDialog
{
    UWORD x;
    UWORD y;
    UWORD width;
    UWORD height;
    UBYTE *title;
    UBYTE *bodytext;
    void  *textbutton;
    void  *button1;
    void  *button2;
} InputDialog;


extern ULONG diag_white;
extern ULONG diag_dark;
extern ULONG diag_shadow;
extern ULONG diag_backclr;
extern ULONG diag_textclr;
extern ULONG diag_titleclr;
extern ULONG diag_titletextclr;



//------------------------------//
//-- Draw Function Prototypes --//
//------------------------------//

void  BLine(WORD x0, WORD y0, WORD x1, WORD y1, UBYTE color);
LONG  DialogBox(Dialog diag, WORD mousespr);
void  DrawBox(WORD xleft, WORD yleft, WORD xright, WORD yright, UBYTE color);
void  Draw3DBox(UWORD x, UWORD y, UWORD endx, UWORD endy, UBYTE hilite,
                UBYTE shadow, UBYTE boxstyle);
void  Draw3DBoxFilled(UWORD x, UWORD y, UWORD endx, UWORD endy, UBYTE hilite,
                      UBYTE shadow, UBYTE boxcolor, UBYTE boxstyle);
void  DrawBig3DBox(UWORD x, UWORD y, UWORD endx, UWORD endy, UBYTE hilite,
                   UBYTE shadow, UBYTE boxstyle);
void  DrawBig3DBoxFilled(UWORD x, UWORD y, UWORD endx, UWORD endy,
                         UBYTE hilite, UBYTE shadow, UBYTE back, UBYTE boxstyle);
void  DrawFilledBox(WORD xleft, WORD yleft, WORD xright, WORD yright,
                    UBYTE color);
void  DrawHLine(UWORD y, UWORD xstart, UWORD xend, UBYTE color);
void  DrawVLine(UWORD x, UWORD ystart, UWORD yend, UBYTE color);
LONG  FileReq(Dialog diag, WORD mousespr);
UBYTE GetPixel(UWORD x, UWORD y);
LONG  InputBox(InputDialog diag, WORD mousespr);
void  Line(UWORD xstart, UWORD ystart, UWORD xend, UWORD yend, UBYTE color);
LONG PickList(Dialog diag, WORD mousespr, UBYTE *buffer, UBYTE *desttext);
void  SetPixel(UWORD x, UWORD y, UBYTE color);


#endif 
#ifndef _VLIB_BUTTON_H_
#define _VLIB_BUTTON_H_



//----------------------//
//-- Button Constants --//
//----------------------//

#define MAXBUTTONS  1000


//-- Where you hit the slider gadget
#define SLIDER_HIT_BUTTON   1
#define SLIDER_HIT_LEFT     2
#define SLIDER_HIT_RIGHT    3
#define SLIDER_HIT_ABOVE    2
#define SLIDER_HIT_BELOW    3


//-- Button actions after being hit
#define BUTTON_ACTION_POPUP         1
#define BUTTON_ACTION_TOGGLE        2
#define BUTTON_ACTION_HITONRELEASE  4

//-- Flags for style of border or if there is an image
#define BUTTON_STYLE_RECTANGLE  0
#define BUTTON_STYLE_SMOOTH     1
#define BUTTON_STYLE_ROUND      2
#define BUTTON_STYLE_OVAL       3
#define BUTTON_STYLE_MASK       0x03

#define BUTTON_STYLE_TEXTINSIDE 0
#define BUTTON_STYLE_TEXTLEFT   4
#define BUTTON_STYLE_TEXTRIGHT  8
#define BUTTON_STYLE_TEXTABOVE  12
#define BUTTON_STYLE_TEXTMASK   0x0c

#define BUTTON_STYLE_OUTLINE    16
#define BUTTON_STYLE_BORDERLO   32
#define BUTTON_STYLE_BORDERHI   64
#define BUTTON_STYLE_BORDERLESS 128

//-- Flags for the type of button
#define BUTTON_TYPE_BOOLEAN     1
#define BUTTON_TYPE_SLIDER      2
#define BUTTON_TYPE_TEXT        4

//-- The states that a button may be draw in
#define BUTTON_STATE_NORMAL  0
#define BUTTON_STATE_OVER    1
#define BUTTON_STATE_HIT     2

#define BUTTON_FLAG_COLORED  1
#define BUTTON_FLAG_DOWN     2
#define BUTTON_FLAG_ACTIVE   4


//-----------------------//
//-- Button Structures --//
//-----------------------//

typedef struct ButtonColors
{
    ULONG   text;
    ULONG   button;
    ULONG   hilight;
    ULONG   shadow;
    ULONG   textover;
    ULONG   buttonover;
    ULONG   hilightover;
    ULONG   shadowover;
    ULONG   texthit;
    ULONG   buttonhit;
    ULONG   hilighthit;
    ULONG   shadowhit;
    ULONG   outlineback;
} ButtonColors;

typedef struct ButtonClrMap
{
    UBYTE   text;
    UBYTE   button;
    UBYTE   hilight;
    UBYTE   shadow;
    UBYTE   textover;
    UBYTE   buttonover;
    UBYTE   hilightover;
    UBYTE   shadowover;
    UBYTE   texthit;
    UBYTE   buttonhit;
    UBYTE   hilighthit;
    UBYTE   shadowhit;
    UBYTE   outlineback;
} ButtonClrMap;

typedef struct Slider
{
    UWORD   numentries;
    UWORD   currentry;
    UWORD   maxentries;
    UWORD   offset;
    UWORD   minslidersize;
} Slider;

typedef struct Button
{
    UWORD        x;
    UWORD        y;
    UWORD        width;
    UWORD        height;
    Bitmap       *bitmapsrc;
    Bitmap       *bitmapdest;
    ButtonColors *colors;
    ButtonClrMap *clrmap;
    UBYTE        flags;
    UBYTE        action;
    UBYTE        style;
    UBYTE        type;
    UBYTE        borderwidth;
    UBYTE        borderheight;
    LONG         id;
    UBYTE        *text;
    void         *next;
    void         *prev;
    Slider       *slider;
} Button;

typedef struct QuickButton
{
    UWORD x;
    UWORD y;
    UWORD width;
    UWORD height;
    LONG  id;
    UBYTE style;
    UBYTE *text;
} QuickButton;



//----------------------//
//-- Button externals --//
//----------------------//

extern Button *first_button;
extern Button *current_button;
extern Button *last_hit;
extern Button *buttons[];
extern Button *current_textbutton;
extern UBYTE mousebuttonstatus, mousebuttonprev, buttonkey;
extern UWORD lastmousex, lastmousey;

extern ULONG butt_text;
extern ULONG butt_button;
extern ULONG butt_hilite;
extern ULONG butt_shadow;
extern ULONG butt_textover;
extern ULONG butt_buttonover;
extern ULONG butt_hiliteover;
extern ULONG butt_shadowover;
extern ULONG butt_texthit;
extern ULONG butt_buttonhit;
extern ULONG butt_hilitehit;
extern ULONG butt_shadowhit;
extern ULONG butt_outlineback;

//--------------------------------//
//-- Button Function Prototypes --//
//--------------------------------//

Button *AddButton(Button *newbutton);
Button *AddQuickButton(UWORD x, UWORD y, UWORD width, UWORD height, UBYTE style, ULONG id, UBYTE *text);
Button *AddQuickSlider(UWORD x, UWORD y, UWORD width, UWORD height, UWORD entries, UBYTE style, ULONG id);
Button *CheckButtons(void);
void    ColorButton(Button *button, UBYTE *cmap);
BOOL    DrawButton(Button *newbutton, UBYTE style);
void    RemoveButton(LONG buttonid);
UBYTE HitSliderWhere(Button *slider);
UWORD DetermineButtonSize(Button *slider);
UWORD DetermineButtonPage(Button *slider);
BOOL SetSliderOffset(Button *slider);
BOOL SetSliderMaxEntries(Button *slider, UWORD maxentries);
BOOL SetSliderEntries(Button *slider, UWORD entries);
BOOL SetSliderEntry(Button *slider);


#endif 
#ifndef _VLIB_DOS_H_
#define _VLIB_DOS_H_

//#include "button.h"


//-------------------//
//-- DOS Constants --//
//-------------------//

#define MODE_BINARY 0x0200  /* binary file */
#define MODE_READ   0x0000 | MODE_BINARY /* open for read only */
#define TEMP        0x0001 | MODE_BINARY | O_CREAT |O_TRUNC
//#define MODE_WRITE  TEMP | S_IRUSR | S_IWGRP | S_IRGRP /* open for write only */
#define MODE_WRITE  TEMP | S_IWRITE
#define MODE_RDWR   0x0002 | MODE_BINARY /* open for read and write */
#define MODE_APPEND 0x0010 | MODE_BINARY /* writes done at end of file */

#define DOSERR_NONE             0
#define DOSERR_FILENOTFOUND     1
#define DOSERR_CREATEERROR      2
#define DOSERR_READERROR        3
#define DOSERR_WRITEERROR       4
#define DOSERR_SEEKERROR        5
#define DOSERR_PATHNOTFOUND     6
#define DOSERR_NOHANDLES        7
#define DOSERR_ACCESSDENIED     8
#define DOSERR_INVALIDHANDLE    9
#define DOSERR_NOMEMORY         10
#define DOSERR_BADACCESS        11
#define DOSERR_INVALIDDATA      12
#define DOSERR_INVALIDDRIVE     13
#define DOSERR_NOMOREFILES      14
#define DOSERR_WRITEPROTECTED   15
#define DOSERR_DRIVENOTREADY    16
#define DOSERR_DISKSEEKERROR    17
#define DOSERR_SECTORNOTFOUND   18
#define DOSERR_SHARINGVIOLATION 19
#define DOSERR_HANDLEEOF        20
#define DOSERR_DISKFULL         21
#define DOSERR_FILEEXISTS       22
#define DOSERR_MAKEDIRFAILED    23
#define DOSERR_UNKNOWN          24

#define DRIVE_NONE    0
#define DRIVE_FLOPPY  1
#define DRIVE_HDD     2
#define DRIVE_CDROM   3


//-------------------//
//-- DOS Externals --//
//-------------------//
extern UBYTE current_dir[];
extern UBYTE current_file[];
extern UBYTE fullfilename[];

extern BOOL  dos_print_error;
extern UWORD dos_error;
extern UBYTE dos_error_current[];

extern UBYTE *dos_error_text[];
extern UBYTE dos_error_trans[];

extern UBYTE drive_type[];
extern UBYTE cd_drive;
extern BOOL  drives_found;


//--------------------//
//-- DOS Structures --//
//--------------------//




//-----------------------------//
//-- DOS function prototypes --//
//-----------------------------//

BOOL CheckDrive(UBYTE *drive);
void FindDrives(void);
ULONG LargestMemBlock(void);
ULONG GetDirectory(UBYTE *pattern, UBYTE *buffer);
ULONG GetDirectoryf(UBYTE *pattern, UBYTE *buffer);
void  GetDOSError(void);
LONG  GetFileLength(UBYTE *filename);
ULONG ReadWholeFile(UBYTE *filename, void *buffer);


#endif 
#ifndef _VLIB_FLIC_H_
#define _VLIB_FLIC_H_

#include <stdio.h>


//--------------------//
//-- Flic Constants --//
//--------------------//

#define FLI_ID          0xAF11
#define FLC_ID          0xAF12
#define FLIC_FRAME      0xF1FA
#define FLIC_ANNOUNCE   0xF100

#define FLI_COLOR   11
#define FLI_LC      12
#define FLI_BLACK   13
#define FLI_BRUN    15
#define FLI_COPY    16

#define FLI_DELTA       7
#define FLI_256_COLOR   4
#define FLI_MINI        18



//---------------------//
//-- Flic Structures --//
//---------------------//

typedef struct FLIHeader
{
    ULONG size;
    UWORD id;
    UWORD frames;
    UWORD width;
    UWORD height;
    UWORD depth;
    UWORD flags;
    UWORD speed;
    ULONG next;
    ULONG frit;
    UBYTE reserved[102];
} FLIHeader;


typedef struct FLIFrameHeader
{
    ULONG size;
    UWORD id;
    UWORD chunks;
    UBYTE reserved[8];
} FLIFrameHeader;


typedef struct FLIChunkHeader
{
   ULONG size;
   UWORD type;
} FLIChunkHeader;


//--------------------//
//-- Flic Externals --//
//--------------------//

extern FILE *flihandle;
extern FLIHeader fli_header;
extern FLIFrameHeader fli_frame;
extern FLIChunkHeader fli_chunk;
extern UWORD fliwidth, fliheight;
extern UBYTE flidepth;
extern BOOL  fli_palette_changed;
extern BYTE  *flidata;


//---------------------//
//-- Flic Prototypes --//
//---------------------//

BOOL  IsFlic(UBYTE *filename);
BOOL  GetFLIHeader(UBYTE *filename, FLIHeader *header);
UWORD OpenFLI(char *filename);
BOOL  LoadFLIFrame(BYTE *buffer, UBYTE *colormap);
void  CloseFLI(void);

#endif 
#ifndef _VLIB_IFF_H_
#define _VLIB_IFF_H_

#define SPRITEBANK  "SPBK"
#define SOUNDBANK   "SNDB"

#define CMAPCHUNK   "CMAP"


typedef struct Index
{
    UBYTE   name[32];
    LONG    offset;
} Index;

extern BOOL  iffwrite;
extern void  *iffhandle;
extern UBYTE iffbuffer[];
extern ULONG iffchunksize;
extern Index *iffindex;
extern ULONG iffindexsize;

BOOL AllocIFFIndex(ULONG size);
BOOL ChangeIFF(UBYTE *filename);
BOOL CheckChunk(UBYTE *typetext);
BOOL CheckIFF(UBYTE *typetext);
void CloseIFF(void);
BOOL CreateIFF(UBYTE *filename, UBYTE *typetext);
void FreeIFFIndex(void);
BOOL LoadChunk(UBYTE *typetext, void *buffer);
BOOL LoadChunkSearch(UBYTE *typetext, void *buffer);
BOOL OpenIFF(UBYTE *filename);
BOOL ReadFromIFF(void *buffer, ULONG size);
BOOL SeekChunk(UBYTE *typetext);
void SeekIFFFileEnd(void);
void SetIFFPosition(ULONG position);
BOOL WriteChunk(UBYTE *typetext, void *buffer, ULONG size);
BOOL WriteChunks(UBYTE *typetext, void *buffer, ULONG size, void *buffer2,
                 ULONG size2);

#endif 
#ifndef _VLIB_JOY_H_
#define _VLIB_JOY_H_


#define JOYPORT 0x0201
#define JOY1    0x0300
#define JOY2    0x0c00

#define JOY1X       0x01
#define JOY1Y       0x02
#define JOY2X       0x04
#define JOY2Y       0x08
#define JOY1BUTTON1 0x10
#define JOY1BUTTON2 0x20
#define JOY2BUTTON1 0x40
#define JOY2BUTTON2 0x80



extern LONG   joy1x, joy1y, joy1button1, joy1button2;
extern LONG   joy2x, joy2y, joy2button1, joy2button2;

extern LONG   joy1x1, joy1x2, joy1xmin, joy1xmax;
extern LONG   joy1y1, joy1y2, joy1ymin, joy1ymax;
extern LONG   joy1x1div, joy1x2div, joy1y1div, joy1y2div;

extern LONG   joy2x1, joy2x2, joy2xmin, joy2xmax;
extern LONG   joy2y1, joy2y2, joy2ymin, joy2ymax;
extern LONG   joy2x1div, joy2x2div, joy2y1div, joy2y2div;

extern UBYTE   joyrawbuttons;
extern ULONG   joy_max_wait;
extern BOOL    joycalibrated;


BOOL CalibrateJoystick1(void);
BOOL CalibrateJoystick2(void);
BOOL CheckJoystick(ULONG joymask);
void JoystickButtons(void);
void JoystickPos(ULONG joymask);
BOOL LoadJoystickConfig(UBYTE *filename);
BOOL SaveJoystickConfig(UBYTE *filename);


#endif 
#ifndef _VLIB_KEY_H_
#define _VLIB_KEY_H_



//-------------------//
//-- Key Externals --//
//-------------------//

extern UWORD keycode;
extern BOOL  keydown[];
extern BOOL  customkeyisr;


//-------------------//
//-- Key Constants --//
//-------------------//

#define KEYBOARD_INT    0x09
#define KEY_BUFFER      0x60
#define KEY_CONTROL     0x61

#define INT_CONTROL     0x20

#define KEY_ESC     1
#define KEY_1       2
#define KEY_2       3
#define KEY_3       4
#define KEY_4       5
#define KEY_5       6
#define KEY_6       7
#define KEY_7       8
#define KEY_8       9
#define KEY_9       10
#define KEY_0       11
#define KEY_MINUS   12
#define KEY_EQUALS  13
#define KEY_BKSP    14
#define KEY_TAB     15

#define KEY_Q       16
#define KEY_W       17
#define KEY_E       18
#define KEY_R       19
#define KEY_T       20
#define KEY_Y       21
#define KEY_U       22
#define KEY_I       23
#define KEY_O       24
#define KEY_P       25

#define KEY_LFT_BRACKET 26
#define KEY_RGT_BRACKET 27
#define KEY_ENTER   28
#define KEY_CTRL    29

#define KEY_A       30
#define KEY_S       31
#define KEY_D       32
#define KEY_F       33
#define KEY_G       34
#define KEY_H       35
#define KEY_J       36
#define KEY_K       37
#define KEY_L       38

#define KEY_SEMI    39
#define KEY_APOS    40
#define KEY_TILDE   41
#define KEY_LEFT_SHIFT  42
#define KEY_BACK_SLASH  43

#define KEY_Z       44
#define KEY_X       45
#define KEY_C       46
#define KEY_V       47
#define KEY_B       48
#define KEY_N       49
#define KEY_M       50

#define KEY_COMMA   51
#define KEY_PERIOD  52
#define KEY_SLASH   53
#define KEY_RIGHT_SHIFT 54
#define KEY_PRT_SCRN    55
#define KEY_ALT     56
#define KEY_SPACE   57
#define KEY_CAPS_LOCK   58

#define KEY_F1      59
#define KEY_F2      60
#define KEY_F3      61
#define KEY_F4      62
#define KEY_F5      63
#define KEY_F6      64
#define KEY_F7      65
#define KEY_F8      66
#define KEY_F9      67
#define KEY_F10     68
#define KEY_F11     87
#define KEY_F12     88
#define KEY_NUM_LOCK    69
#define KEY_SCROLL_LOCK 70
#define KEY_HOME    71
#define KEY_UP      72
#define KEY_PGUP    73
#define KEY_NUM_MINUS   74
#define KEY_LEFT    75
#define KEY_CENTER  76
#define KEY_RIGHT   77
#define KEY_NUM_PLUS    78
#define KEY_END     79
#define KEY_DOWN    80
#define KEY_PGDN    81
#define KEY_INS     82
#define KEY_DEL     83

//-----------------------------//
//-- Key Function Prototypes --//
//-----------------------------//

UBYTE GetKey(void);
void  InstallKeyboard(void);
void  RestoreKeyboard(void);
void  WaitKey(void);

#endif 
#ifndef _VLIB_LFB_H_
#define _VLIB_LFB_H_



//-------------------//
//-- LFB Externals --//
//-------------------//

extern void far *LFBPtr;
extern ULONG linAddr;
extern BOOL  lfb_direct;
extern BOOL  using_page2;


//-------------------//
//-- LFB Constants --//
//-------------------//

#define vbemempk    4                   // mempk flag
#define vbeUseLFB   0x4000              // vesa mode flag to select a lfb mode
#define lfbmemlimit ((4096 * 1024) - 1) // all lfbs are 4 MB in size!


//----------------//
//-- LFB Macros --//
//----------------//



//--------------------//
//-- LFB Structures --//
//--------------------//

struct _RMWORDREGS {
    UWORD ax, bx, cx, dx, si, di, cflag;
};

struct _RMBYTEREGS {
    UBYTE al, ah, bl, bh, cl, ch, dl, dh;
};

typedef union {
    struct _RMWORDREGS x;
    struct _RMBYTEREGS h;
} RMLFBREGS;

typedef struct {
    UWORD es;
    UWORD cs;
    UWORD ss;
    UWORD ds;
} RMSREGS;



//-----------------//
//-- LFB Pragmas --//
//-----------------//

void LFBMemSet(ULONG sel, ULONG off, ULONG c, ULONG n);
#pragma aux LFBMemSet =     \
    "push   es"             \
    "mov    es,ax"          \
    "shr    ecx,2"          \
    "xor    eax,eax"        \
    "mov    al,bl"          \
    "shl    ebx,8"          \
    "or     ax,bx"          \
    "mov    ebx,eax"        \
    "shl    ebx,16"         \
    "or     eax,ebx"        \
    "rep    stosd"          \
    "pop    es"             \
    parm [eax] [edi] [ebx] [ecx];

void LFBMemCpy(ULONG sel, ULONG off, void *src, ULONG n);
#pragma aux LFBMemCpy =     \
    "push   es"             \
    "mov    es,ax"          \
    "shr    ecx,2"          \
    "rep    movsd"          \
    "pop    es"             \
    parm [eax] [edi] [esi] [ecx];


/*
*/


//--------------------//
//-- LFB Prototypes --//
//--------------------//
BOOL LFBDirect(void);
ULONG DPMIAllocSelector(void);
ULONG DPMIMapPhysicalToLinear(ULONG physAddr, ULONG limit);
void  DPMISetSelectorBase(ULONG sel, ULONG linAddr);
void  DPMISetSelectorLimit(ULONG sel, ULONG limit);
ULONG GetPtrToLFB(ULONG physAddr);

#endif 
#ifndef _VLIB_MOUSE_H_
#define _VLIB_MOUSE_H_



//---------------------//
//-- Mouse externals --//
//---------------------//

extern WORD mouse_xpos, mouse_ypos;
extern UBYTE *mouse_buffer;



//---------------------//
//-- Mouse Constants --//
//---------------------//
#define MOUSEBUTTON_NONE    0
#define MOUSEBUTTON_LEFT    1
#define MOUSEBUTTON_RIGHT   2
#define MOUSEBUTTON_BOTH    3
#define MOUSEBUTTON_MIDDLE  4



//----------------------------//
//-- Mouse Function pragmas --//
//----------------------------//

BOOL  CheckMouse(void);
void  FreeMouseBuffer(void);
void  HideMouseCursor(void);
void  ReadMouse(UWORD *mousex, UWORD *mousey);
UBYTE ReadMouseButton(void);
void  RelMouse(WORD *mousex, WORD *mousey);
void  SetMouseCursor(UWORD *cursor);
void  ShowMouseCursor(void);
void  UpdateMouse(UWORD mousesprite);
void  UpdateMouseBlast(UWORD mousesprite);
void  UpdateMouseCoords(void);
void  WaitMouse(void);
void SetMouseRegion(UWORD x1, UWORD y1, UWORD x2, UWORD y2);
void ResetMouseRegion(void);

#endif 
#ifndef _VLIB_PALETTE_H_
#define _VLIB_PALETTE_H_



//-----------------------//
//-- Palette Constants --//
//-----------------------//

#define PALETTE_MASK        0x3C6
#define PALETTE_REGISTER_RD	0x3C7
#define PALETTE_REGISTER_WR	0x3C8
#define PALETTE_DATA        0x3C9

#define PALETTE_SIZE        768
#define PALETTE_ENTRIES     256

extern UBYTE mouseptrdata[];
extern UBYTE fileicondata[];
extern UBYTE backicondata[];
extern UBYTE foldericondata[];
extern Bitmap mouseptr;
extern Bitmap fileicon;
extern Bitmap backicon;
extern Bitmap foldericon;
extern Bitmap floppyicon;
extern Bitmap hardicon;
extern Bitmap cdicon;

extern UBYTE white;
extern UBYTE black;
extern UBYTE hilight;
extern UBYTE lightpage;
extern UBYTE dark;
extern UBYTE darkpage;
extern UBYTE textclr;
extern UBYTE shadow;
extern UBYTE titleclr;
extern UBYTE titletextclr;


extern UBYTE colormap[];
extern UBYTE defaultcolormap[];


//------------------------------//
//-- Palette function pragmas --//
//------------------------------//

void  CopyPalette(UBYTE *colormap, UBYTE *oldcolormap);
UBYTE FindColor(UBYTE *colormap, ULONG color);
ULONG GetPaletteRegister(UBYTE index);
BOOL  LoadRAWPalette(UBYTE *filename, UBYTE *colormap);
void  RecolorImage(UBYTE *destpal, UBYTE *sourcepal, UBYTE *destimage,
                   UBYTE *sourceimage, UWORD width, UWORD height);
BOOL  SavePalette(UBYTE *filename, UBYTE *colormap);
void  SetMarinePalette(void);
void  SetPalette(UBYTE *colormap);
void  SetPaletteRegister(UBYTE index, UBYTE red, UBYTE green, UBYTE blue);


#endif 
#ifndef _VLIB_PCX_H_
#define _VLIB_PCX_H_

#include <stdio.h>


//--------------------//
//-- PCX Structures --//
//--------------------//

typedef struct PCXHeader {
	char manufacturer;
	char version;
	char encoding;
	char bits_per_pixel;
	short int x,y;
	short int width,height;
	short int horz_res;
	short int vert_res;
	char ega_palette[48];
	char reserved;
	char num_color_planes;
	short int bytes_per_line;
	short int palette_type;
	char padding[58];
} PCXHeader;



//-------------------//
//-- PCX externals --//
//-------------------//

extern PCXHeader pcx_header;
extern FILE *pcxhandle;



//-----------------------------//
//-- PCX Function Prototypes --//
//-----------------------------//

BOOL  EncodePCXLine(UBYTE *buffer, UWORD width);
BOOL  EncodeRun(UBYTE data, ULONG length);
BOOL  GetPCXHeader(UBYTE *filename, PCXHeader *header);
BOOL  IsPCX(UBYTE *filename);
BOOL  LoadPCX(UBYTE *filename, UBYTE *body_buffer, UBYTE *palette_buffer);
BOOL  LoadPCXPalette(UBYTE *filename, UBYTE *colormap);
BOOL  SavePCX(UBYTE *filename, UBYTE *buffer, UWORD width, UWORD height, UBYTE *colormap);


#endif 
#ifndef _VLIB_PIC_H_
#define _VLIB_PIC_H_


//-------------------//
//-- Pic Constants --//
//-------------------//

#define PICTYPE_UNKNOWN 0
#define PICTYPE_PCX     1
#define PICTYPE_TGA     2
#define PICTYPE_BMP     3
#define PICTYPE_PALETTE 4

#define PICTYPE_FLI     20



//--------------------//
//-- Pic Structures --//
//--------------------//

typedef struct PicInfo
{
    UWORD   width, height;
    UBYTE   depth;
    UBYTE   type;
} PicInfo;



//-------------------//
//-- Pic externals --//
//-------------------//

extern PicInfo pic_info;



//-----------------------------//
//-- Pic Function Prototypes --//
//-----------------------------//

BOOL GetPicInfo(UBYTE *filename);
BOOL LoadPalette(UBYTE *filename, UBYTE *palette);
BOOL LoadPic(UBYTE *filename, UBYTE *buffer, UBYTE *palette);


#endif 
#ifndef _VLIB_SB_H_
#define _VLIB_SB_H_

#include <stdio.h>



#define ON  1
#define OFF 0
#define DECIMAL 0
#define HEX     1


#define BLOCK_LENGTH    512   /* Length of digitized sound output block     */
#define VOICES          64     /* Number of available simultaneous voices    */
#define VOLUMES         64    /* Number of volume levels for sound output   */
#define VOLUME_MAX      255

#define BUFFER_LENGTH BLOCK_LENGTH*2


#define SND_8BIT        0
#define SND_16BIT       1
#define SND_SIGNED      0
#define SND_UNSIGNED    1

#define SNDFLAG_8BIT        1       // if 0 this is a 16 bit sound
#define SNDFLAG_MONO        2       // if 0 this is a stereo sound
#define SNDFLAG_DISKFILE    4       // 0 means load the whole sample
#define SNDFLAG_SPOOL       8       // 0 means do not spool
#define SNDFLAG_NEEDMORE    16      // flag to load more of the spooled file
#define SNDFLAG_LOOP        32      // flag to loop the sample


/*
typedef struct
{
    signed   char *soundptr;
    unsigned long soundsize;
} SOUND;


typedef struct
{
    SOUND *sound;
    int   index;
    int   volume;
    int   loop;
    long  curpos;
    int   done;
} VOICE;
*/

typedef struct DiskSoundData
{
    BYTE    *data;
    ULONG   length;
    UWORD   id;
    UWORD   rate;
    UBYTE   flags;
} DiskSoundData;

typedef struct
{
    struct  DiskSoundData;
    UBYTE   pad;
    ULONG   offset;
    FILE    *filehandle;
} Sound;

typedef struct
{
    Sound   *sound;
    ULONG   volume;
    LONG    curpos;
    BOOL    done;
} Voice;



void  CloseCuedFile(Sound *sound);
void  CueFurtherSound(void);
Sound *CueSoundfile(UBYTE *filename);
void  FreeSound(Sound *sound);
void  FreeSoundSystem(void);
BOOL  InitSoundSystem(ULONG rate);
Sound *LoadSound(UBYTE *name);
void  PlaySound(Sound *sound, UBYTE volume);
BOOL  SoundPlaying(UWORD id);
void  StopSound(UWORD id);


extern volatile long intcount;         /* Current count of sound interrupts */
extern volatile int  voicecount;       /* Number of voices currently in use */

extern ULONG sb_baseio, sb_irq, sb_dma, sb_dma16;
extern float dspversion;
extern int   autoinit;
extern int   sixteenbit;
extern ULONG  sampling_rate;

#endif 
#ifndef _VLIB_SCREEN_H_
#define _VLIB_SCREEN_H_



//----------------------//
//-- Screen externals --//
//----------------------//

extern BOOL interlaced_screen;
extern BOOL double_scan;
//extern BOOL double_buffering;

extern UBYTE *double_buffer;
extern UBYTE *triple_buffer;
extern UBYTE *viewport;

extern UWORD drawxmin, drawymin, drawxmax, drawymax;
extern UWORD video_mode;
extern ULONG yoffset[];
extern ULONG xoffset[];

extern ULONG centering_offset;
extern ULONG screen_width;
extern ULONG vram_width;
extern ULONG screen_height;
extern ULONG screen_depth;
extern ULONG screen_size;
extern LONG clip_startx;
extern LONG clip_starty;
extern LONG clip_endx;
extern LONG clip_endy;



//----------------------//
//-- Screen Constants --//
//----------------------//

// These are some BAD defines for using the SetVideoMode command.
// Please, please, please don't use this command any more.  Instead
// channel all screen requests through FindVideoMode OR FindBestVideoMode

#define SVGA400     0x100       // 640 x 400 x 8
#define SVGA480     0x101       // 640 x 480 x 8
#define SVGA800     0x103       // 800 x 600 x 8
#define SVGA1024    0x105       // 1024 x 768 x 8
#define VGA256      0x13        // This is vesa mode 0x13
#define TEXT80      0x03        // This is the default 80 x 25 text mode



//--------------------------------//
//-- Screen Function Prototypes --//
//--------------------------------//

BOOL  AllocDoubleBuffer(ULONG size);
BOOL  AllocTripleBuffer(ULONG size);
void  CopyRect(UWORD xstart, UWORD ystart, UWORD width, UWORD height,
               UBYTE *dest);
void  DoubleBuffer(void);
void  DoubleBufferRect(UWORD xleft, UWORD yleft, UWORD xright, UWORD yright);
void  FreeDoubleBuffer(void);
void  FreeTripleBuffer(void);
UWORD GetVideoMode(void);
void  OverlayBuffer(UBYTE *buffer);
void  ResetClippingRegion(void);
void  RestoreRect(UWORD xstart, UWORD ystart, UWORD width, UWORD height,
                  UBYTE *block);
void  ScreenFill(UBYTE color);
void  SetClippingRegion(UWORD x1, UWORD y1, UWORD x2, UWORD y2);
BOOL  SetVideoMode(UWORD mode);
void  UpdateDirtyRectangle(UWORD x1, UWORD y1, UWORD x2, UWORD y2);
void  WaitVbl(void);


#endif 
#ifndef _VLIB_SERIAL_H_
#define _VLIB_SERIAL_H_



//----------------------//
//-- Serial Constants --//
//----------------------//

#define MODEM_USER_ABORT      -1

#define MODEM_OK              0
#define MODEM_CONNECT         1
#define MODEM_RING            2
#define MODEM_NO_CARRIER      3
#define MODEM_ERROR           4
#define MODEM_CONNECT_1200    5
#define MODEM_NO_DIALTONE     6
#define MODEM_BUSY            7
#define MODEM_NO_ANSWER       8
#define MODEM_CONNECT_0600    9
#define MODEM_CONNECT_2400    10
#define MODEM_CARRIER_2400    11
#define MODEM_CONNECT_4800    12
#define MODEM_CONNECT_9600    13

#define NUM_MODEM_RESPONSES   14

#define DELAY_1_SECOND  18
#define DELAY_2_SECOND  38
#define DELAY_3_SECOND  48


#define SERIAL_RBF        0
#define SERIAL_THR        0
#define SERIAL_IER        1
#define SERIAL_IIR        2
#define SERIAL_LCR        3
#define SERIAL_MCR        4
#define SERIAL_LSR        5
#define SERIAL_MSR        6
#define SERIAL_DLL        0
#define SERIAL_DLH        1


#define SERIAL_BAUD_1200  96
#define SERIAL_BAUD_2400  48
#define SERIAL_BAUD_4800  24
#define SERIAL_BAUD_9600  12
#define SERIAL_BAUD_14400  8
#define SERIAL_BAUD_19200  6
#define SERIAL_BAUD_28800  4
#define SERIAL_BAUD_57600  2
#define SERIAL_BAUD_115200 1


#define SERIAL_STOP_1      0
#define SERIAL_STOP_2      4

#define SERIAL_BITS_5      0
#define SERIAL_BITS_6      1
#define SERIAL_BITS_7      2
#define SERIAL_BITS_8      3

#define SERIAL_PARITY_NONE 0
#define SERIAL_PARITY_ODD  8
#define SERIAL_PARITY_EVEN 24

#define SERIAL_DIV_LATCH_ON 128

#define SERIAL_GP02        8


#define COM_1              0x3F8
#define COM_2              0x2F8
#define COM_3              0x3E8
#define COM_4              0x2E8


#define PIC_IMR    0x21
#define PIC_ICR    0x20

#define INT_SERIAL_PORT_0    0x0C
#define INT_SERIAL_PORT_1    0x0B

#define SERIAL_BUFF_SIZE 1024


#define MODEM_DTR_ON      0
#define MODEM_DTR_OFF     1



//----------------------//
//-- Serial Externals --//
//----------------------//

extern void (interrupt far *OldSerialISR)();


extern BYTE serial_buffer[SERIAL_BUFF_SIZE];

extern LONG serial_end;
extern LONG serial_start;
extern LONG serial_ch;
extern LONG char_ready;
extern LONG old_int_mask;
extern LONG open_port;
extern LONG serial_lock;

extern BYTE *modem_strings[];


//-----------------------------//
//-- Serial function pragmas --//
//-----------------------------//

LONG SerialReady(void);
LONG SerialRead(void);
void SerialWrite(BYTE ch);
void SerialPrint(BYTE *string);
void SerialOpen(LONG port_base, LONG baud, LONG configuration);
void SerialClose(void);
void SerialFlush(void);

/*
void ModemControl(LONG command);
LONG InitializeModem(BYTE *extra_init);
void ModemSendCommand(BYTE *buffer);
LONG SerialReadWait(void);
LONG ModemResult(char *output,int exit_enable);
LONG MakeConnection(BYTE *number);
LONG WaitForConnection(void);
LONG HangUp(void);
*/

#endif 
#ifndef _VLIB_SPRITE_H_
#define _VLIB_SPRITE_H_


//--------------------//
//-- Sprite Defines --//
//--------------------//

#define MAX_SPRITES         3000
#define MAX_SPRITES_FILE    8000

#define SPRFLAG_COMPRESSED  1
#define SPRFLAG_RLETRANS    2
#define SPRFLAG_ISAFRAME    4
#define SPRFLAG_PALETTE     8

#define SPRFLAG_CLONE       64
#define SPRFLAG_ANIMATE     128
#define SPRFLAG_MOVE        256
#define SPRFLAG_REMAP       512
#define SPRFLAG_PARALAX     1024

#define SPRANIM_LOOPING     0
#define SPRANIM_PINGPONG    1
#define SPRANIM_ONESHOT     2

#define SPR_NORMAL    0
#define SPR_FLIP_X    1
#define SPR_FLIP_Y    2
#define SPR_FLIP_XY   3
#define SPR_SCALED    4
#define SPR_TRANSLATE 8
#define SPR_REMAP     16


//-----------------------//
//-- Sprite Structures --//
//-----------------------//


typedef struct DiskSpriteData
{
    UWORD xsize;        // width of object in pixels
    UWORD ysize;        // height of object in pixels
    ULONG bitmapsize;   // size of the object's bitmap data
    UWORD programsize;  // size of the object's program data
    UWORD palettesize;  // size of the object's palette data
    UWORD translatesize;// size of the object's translation data
    ULONG size;         // total size of the object's data
    WORD  hotx;         // x axis position of the object's hotspot
    WORD  hoty;         // y axis position of the object's hotspot
    UWORD flags;        // sprite flags (see defines)
    UWORD spritefps;    // speed that sprite animates in frames per second
    UBYTE numframes;    // number of frames attached to this sprite
    UBYTE animtype;     // type of animation this sprite does (see defines)
    WORD  movex;        // how much to move sprite in x position when drawn
    WORD  movey;        // how much to move sprite in y position when drawn
    UWORD attached;     // link to next attached sprite
    UWORD progcounter;  // offset into program for next instruction
    UWORD loopcounter;  // loop counter for sprite program
    UWORD returnsprite; // sprite that "called" this sprite drawing
    UWORD pad[8];
} DiskSpriteData;


typedef struct SpriteData
{
    struct DiskSpriteData;
    WORD  xpos;             // x position of object on screen
    WORD  ypos;             // y position of object on screen
    UBYTE currentframe;     // current frame number in animation
    BYTE  direction;        // direction of next frame in animation
    UBYTE pad[2];           // padding
    ULONG nextframetime;    // time that next frame will occur
    UBYTE *bitmapptr;       // pointer to bitmap data
    UBYTE *programptr;      // pointer to program data
    UBYTE *paletteptr;      // pointer to the object's palette
    UBYTE *translateptr;    // pointer to the object's translation table(s)
    ULONG *paralaxptr;      // ptr to the object's paralax offset/speed table
} SpriteData;




//----------------------//
//-- Sprite externals --//
//----------------------//

extern void *spritehandle;
extern LONG sprite_buffer_offset, num_sprites, sprite_buffer_size;
extern UBYTE *sprite_buffer;
extern SpriteData spritedata[];
extern DiskSpriteData spritedatadisk;
//extern Index sprindex[];
//extern Index *sprindex;
extern BOOL  clip_sprites;



//--------------------------------//
//-- Sprite Function Prototypes --//
//--------------------------------//

void DrawParalax(LONG bobnum, UBYTE mode);
void BuildTranslationTable(ULONG *colortable, UBYTE *offsettable, UBYTE *palette);
void  MoveSprite(WORD spritenum, WORD xpos, WORD ypos);

WORD  AddBob(UWORD xsize, UWORD ysize, UBYTE *spriteptr);
WORD  AddSprite(UWORD xsize, UWORD ysize, UBYTE *spriteptr, UBYTE *palette);
BOOL  AllocSpriteBuffer(ULONG size);
void  ClearSpriteBuffer(WORD number);
void  DeleteSprite(WORD number);
void  DrawBob(LONG bobnum, UBYTE mode);
void  DrawFilledSprite(UWORD sprnum, WORD xpos, WORD ypos, UBYTE new_color_reg);
void  DrawFlippedBob(UWORD bobnum, UBYTE mode);
void  DrawFlippedScaledBob(UWORD bobnum, UBYTE mode, UWORD width, UWORD height);
void  DrawScaledBob(UWORD bobnum, UBYTE mode, UWORD width, UWORD height);
void  DrawFlippedSprite(UWORD sprnum, UBYTE mode);
void  DrawScaledSprite(UWORD sprnum, UBYTE mode, UWORD width, UWORD height);
void DrawFlippedScaledSprite(UWORD sprnum, UBYTE mode, UWORD width, UWORD height);
UWORD DoSpriteAnim(UWORD sprnum);
void  DrawSprite(UWORD sprnum, UBYTE mode);
void  FreeSpriteBuffer(void);
void  GetSpritePos(WORD sprnum, UWORD *x, UWORD *y);
BOOL OpenSpritebank(char *filename);
void CloseSpritebank(void);
void  RemapSprite(UWORD spritenum, UBYTE *oldpalette, UBYTE *newpalette);
WORD  UpdateSprite(WORD spritenum, UBYTE *buffer);
BOOL SpriteLoader(WORD number);
WORD LoadSprite(UBYTE *name);
BOOL LoadSpritebankPalette(UBYTE *palette);
void DrawSpriteTranslate(UWORD sprnum, UBYTE mode, UBYTE *transtable);
void DrawFlippedSpriteTranslate(UWORD sprnum, UBYTE mode, UBYTE *transtable);
void DrawScaledSpriteTranslate(UWORD sprnum, UBYTE mode, UWORD width,
                               UWORD height, UBYTE *transtable);
void DrawFlippedScaledSpriteTranslate(UWORD sprnum, UBYTE mode, UWORD width,
                                      UWORD height, UBYTE *transtable);
void DrawStillSprite(UWORD sprnum, UBYTE mode);
WORD CloneSprite(WORD spritenum);
void StillSprite(UWORD sprnum);
void AnimateSprite(UWORD sprnum);

#endif 
#ifndef _VLIB_TGA_H_
#define _VLIB_TGA_H_


//-------------------//
//-- TGA Constants --//
//-------------------//

#define TGA_ATTRIBBITS  15
#define TGA_UPPERLEFT   32
#define TGA_DATASTORAGE 192


//--------------------//
//-- TGA Structures --//
//--------------------//

typedef struct TGAHeader {
    UBYTE   idlen;
    UBYTE   palettetype;
    UBYTE   imagetype;
    UWORD   paletteindex;
    UWORD   palettelen;
    UBYTE   entrysize;
    UWORD   xpos;
    UWORD   ypos;
    UWORD   width;
    UWORD   height;
    UBYTE   pixelsize;
    UBYTE   descriptor;
} TGAHeader;



//-------------------//
//-- TGA externals --//
//-------------------//

extern TGAHeader tga_header;



//-----------------------------//
//-- TGA Function Prototypes --//
//-----------------------------//

BOOL IsTGA(UBYTE *filename);
BOOL GetTGAHeader(UBYTE *filename, TGAHeader *header);
BOOL LoadTGA(UBYTE *filename, UBYTE *body_buffer, UBYTE *colormap);
BOOL LoadTGAPalette(UBYTE *filename, UBYTE *colormap);
BOOL SaveTGA(UBYTE *filename, UBYTE *buffer, UWORD width, UWORD height, UBYTE *colormap);
BOOL SaveTGA24(UBYTE *filename, UBYTE *buffer, UWORD width, UWORD height);


#endif 
#ifndef _VLIB_TEXT_H_
#define _VLIB_TEXT_H_


//--------------------//
//-- Text Constants --//
//--------------------//

#define FONT_BITPACKED     1
#define FONT_MONO_BITMAP   2
#define FONT_COLOR_BITMAP  4
#define FONT_FIXED_WIDTH   8
#define FONT_STARTAT32     16

#define ROMFONT_ADDRESS   (UBYTE *)0xffa6e
#define ROMFONT_HEIGHT    8
#define ROMFONT_WIDTH     8
#define ROMFONT_TYPE      FONT_BITPACKED | FONT_FIXED_WIDTH

//#define CBLOCK          95



//---------------------//
//-- Text Structures --//
//---------------------//

typedef struct Font
{
   UBYTE *address;      // address of font bitmap data
   UWORD *widths;       // table of widths for each letter
   ULONG *offsets;      // table of offsets for each letter
   UWORD height;        // (maximum) height of font in pixels
   UWORD width;         // (maximum) width of font in pixels
   UBYTE type;          // font type
} Font;



//--------------------//
//-- Text externals --//
//--------------------//

extern Font *current_font;
extern Font romfont;
extern UBYTE cblock;



//------------------------------//
//-- Text Function Prototypes --//
//------------------------------//

void  CloseFont(Font *fonthandle);
void  GetText(WORD xpos, WORD ypos, UBYTE *text, UBYTE length,
              UBYTE backclr, UBYTE textclr);
void  GetTextDefault(WORD xpos, WORD ypos, UBYTE *text, UBYTE length,
                     UBYTE backclr, UBYTE textclr);
Font *OpenFont(UBYTE *fontname);
void  SetFont(Font *desired_font);
void  Text(UWORD xpos, UWORD ypos, UBYTE *text, ULONG color);

#endif 
#ifndef _VLIB_VESA_H_
#define _VLIB_VESA_H_



//--------------------//
//-- Vesa Constants --//
//--------------------//


#define VESABuffLen     1024     // Size for conventional memory vesa buffers

#define vbeMdAvailable  0x0001
#define vbeMdColorMode  0x0008
#define vbeMdGraphMode  0x0010
#define vbeMdNonBanked  0x0040
#define vbeMdLinear     0x0080


//---------------------//
//-- Vesa structures --//
//---------------------//

typedef struct RPointer
{
   UWORD       segment;
   UWORD       selector;
} RPointer;



typedef struct VesaInfo
{
    BYTE    Signature[4];
    UWORD   Version;
    UWORD   OEMNameOffset;
    UWORD   OEMNameSegment;
    UBYTE   Capabilities[4];
//    UWORD   VideoModeOffset;
//    UWORD   VideoModeSegment;
    ULONG   VideoModePtr;
    UWORD   TotalMemory;

    // VBE 2.0 Extentions
    UWORD   OEMSoftwareRev;
    ULONG   OEMVendorNamePtr;
    ULONG   OEMProductNamePtr;
    ULONG   OEMProductRevPtr;
    UBYTE   reserved[222];
    UBYTE   OEMData[256];
} VesaInfo;



typedef struct VesaModeData
{
    UWORD   ModeAttributes;
    UBYTE   WindowAAttributes;
    UBYTE   WindowBAttributes;
    UWORD   WindowGranularity;
    UWORD   WindowSize;
    UWORD   StartSegmentWindowA;
    UWORD   StartSegmentWindowB;
    void    (*WindowPositioningFunction)(LONG page);
    UWORD   BytesPerScanLine;

	//Remainder of this structure is optional for VESA modes in v1.0/1.1, needed for OEM modes.

    UWORD   PixelWidth;
    UWORD   PixelHeight;
    UBYTE   CharacterCellPixelWidth;
    UBYTE   CharacterCellPixelHeight;
    UBYTE   NumberOfPlanes;
    UBYTE   BitsPerPixel;
    UBYTE   NumberOfBanks;
    UBYTE   MemoryModelType;
    UBYTE   SizeOfBank;
    UBYTE   NumberOfImagePages;
    UBYTE   Reserved1;

    // VBE 1.2 Extentions

    UBYTE   RedMaskSize;
    UBYTE   RedFieldPosition;
    UBYTE   GreenMaskSize;
    UBYTE   GreenFieldPosition;
    UBYTE   BlueMaskSize;
    UBYTE   BlueFieldPosition;
    UBYTE   ReservedMaskSize;
    UBYTE   ReservedFieldPosition;
    UBYTE   DirectColourModeInfo;

    // VBE 2.0 Extentions
    ULONG   PhysBasePtr;
    ULONG   OffScreenMemOffset;
    UWORD   OffScreenMemSize;
    UBYTE   Reserved2[206];
} VesaModeData;



typedef struct RMREGS
{
	ULONG		edi;
	ULONG		esi;
	ULONG		ebp;
	ULONG		reserved;
	ULONG		ebx;
	ULONG		edx;
	ULONG		ecx;
	ULONG		eax;
	UWORD		flags;
	UWORD		es,ds,fs,gs,ip,cs,sp,ss;
} RMREGS;



//--------------------//
//-- Vesa externals --//
//--------------------//

extern RPointer vesa_info_rp;
extern RPointer vesa_mode_data_rp;

extern VesaInfo far *vesa_info;
extern VesaModeData far *vesa_mode_data;

extern UWORD vesa_version;
extern LONG  vesa_granularity;
extern LONG  vesa_page;
extern LONG  vesa_bits_per_pixel;
extern BOOL  vesa_checked;
extern BOOL  using_lfb;
extern BOOL  vbedone;

extern WORD  *mode_list;



//---------------------------//
//-- Vesa function pragmas --//
//---------------------------//

UWORD CheckVesa(void);
void  VesaFree(void);
BOOL  SetVesaMode(UWORD vmode);
BOOL  GetVesaModeInfo(UWORD vmode);
BOOL  FindBestVesaMode(LONG width, LONG height, LONG pixelbits, BOOL lfbflag);
BOOL  FindVesaMode(LONG width, LONG height, LONG pixelbits, BOOL lfbflag);
void  SetVesaPage(LONG vpage);
void  SetDisplayStart(UWORD column, UWORD row);
void SetDisplayStartWait(UWORD column, UWORD row);
void  VesaDoubleBuffer(void);
void  VesaDoubleBufferInterlaced(UWORD xleft, UWORD yleft, UWORD xright, UWORD yright);
void  VesaDoubleBufferRect(UWORD xleft, UWORD yleft, UWORD xright, UWORD yright);
void  VesaTripleBuffer(void);
static void far * AllocDOSMem(RPointer * rp,ULONG bytes_to_allocate);
static void FreeDOSMem(RPointer * rp);


#endif 
#ifndef _VLIB_TIME_H_
#define _VLIB_TIME_H_



//--------------------//
//-- Time externals --//
//--------------------//

extern ULONG fps_frames, initfpstime, time_count, time_rate, oldtime_count, time_other;
extern ULONG lastframetime, currentframetime, time_count_redraw;
extern UWORD time_fraction, frame_rate;
extern float timer_rate;

extern ULONG mainloopfps, fadefps, flifps, palrotatefps;
extern ULONG mainloopprev, fadeprev, fliprev, palrotateprev;

extern BOOL timerinstalled;


//--------------------//
//-- Time Constants --//
//--------------------//

#define GetTicks() *((LONG *)0x46c)

#define TIMER140HZ  0x214a
#define TIMER120HZ  0x26d7
#define TIMER105HZ  0x2c63
#define TIMER90HZ   0x33c9
#define TIMER90HZ   0x33c9
#define TIMER70HZ   0x4295
#define TIMER60HZ   0x4dae
#define TIMER35HZ   0x0001
#define TIMER30HZ   0x0002
#define TIMER18HZ   0xffff

#define INT_CONTROL     0x20


//---------------------//
//-- Time Structures --//
//---------------------//

typedef struct DosTime
{
    UBYTE   hour;
    UBYTE   minute;
    UBYTE   second;
    UBYTE   hsecond;
} DosTime;



//---------------------------//
//-- Time Function pragmas --//
//---------------------------//

void  ChangeTimer(ULONG period);
ULONG CurrentFPS(void);
void  GameTimer(void);
void  InitFPS(void);
void  OldTimer(void);
void  ReportFPS(void);
void  SetFLISpeed(ULONG fps);
void  PaceFLI(void);
void  SetMainloopSpeed(ULONG fps);
void  PaceMainloop(void);


#endif 
#ifndef _VLIB_VLIBINIT_
#define _VLIB_VLIBINIT_

// These are various modules in the vlib library.  These definitions
// represent the high word of the variable global_error.
#define MODULE_CRITICAL     0xffff
#define MODULE_BMP          0x0001
#define MODULE_BUTTON       0x0002
#define MODULE_DOS          0x0003
#define MODULE_DRAW         0x0004
#define MODULE_FLIC         0x0005
#define MODULE_IFF          0x0006
#define MODULE_JOY          0x0007
#define MODULE_KEYBOARD     0x0008
#define MODULE_LFB          0x0009
#define MODULE_MOUSE        0x000a
#define MODULE_PALETTE      0x000b
#define MODULE_PCX          0x000c
#define MODULE_PICTURE      0x000d
#define MODULE_SCREEN       0x000e
#define MODULE_SERIAL       0x000f
#define MODULE_SOUND        0x0010
#define MODULE_SPRITE       0x0011
#define MODULE_TEXT         0x0012
#define MODULE_TGA          0x0013
#define MODULE_TIME         0x0014
#define MODULE_VESA         0x0015
#define MODULE_VLIB         0x0016
#define MODULE_WAVE         0x0017

#define VERROR_BADPTR       0x0000  // pointer not initialized
#define VERROR_STRUCTMEM    0x0001  // not enough mem for structure
#define VERROR_DATAMEM      0x0002  // not enough mem for data
#define VERROR_FILENOTFOUND 0x0003  // input file not found
#define VERROR_SHORTREAD    0x0004  // expecting more data for input
#define VERROR_IMPROPERTYPE 0x0005  // was expecting different data

#define VERROR_SPRITE_SPRITEBANKFULL    0x0101
#define VERROR_SPRITE_PASTLAST          0x0102
#define VERROR_SPRITE_TOOMANY           0x0103
#define VERROR_SPRITE_SPRITENOTFOUND    0x0104

#define INIT_VESA           1
#define INIT_MOUSE          2
#define INIT_JOYSTICK       4
#define INIT_KEYBOARDISR    8
#define INIT_SOUND          16
#define INIT_TIMER          32
#define INIT_SCREEN         64
#define INIT_SPRITES        128
#define INIT_DRIVES         256

#define FADE                32768

#define INIT_COMMON         INIT_MOUSE | INIT_SCREEN | INIT_SPRITES
#define INIT_MOST           INIT_VESA | INIT_MOUSE | INIT_SOUND | INIT_TIMER | INIT_SCREEN | INIT_SPRITES | INIT_DRIVES
#define INIT_ALL            65535

ULONG __far CriticalErrorHandler(ULONG deverr, ULONG errcode, ULONG far *devhdr);
void  FreeVLib(void);
ULONG GetError(void);
void  InitVLib(UWORD flags);


extern ULONG desired_sampling_rate, desired_spritebuffer_size;
extern ULONG desired_screen_width, desired_screen_height;
extern ULONG global_error, device_error;

extern BOOL vlibinit;
extern BOOL mousepresent;
extern BOOL joystickpresent;
extern BOOL soundpresent;
extern BOOL screenpresent;



#endif 
#ifndef _VLIB_WAV_H_
#define _VLIB_WAV_H_

#define WAV_FORMAT_PCM  1


typedef struct WAVHeader {
    UBYTE   rID[4];          // "RIFF"
    ULONG   rLen;            // length of data in this chunk

    UBYTE   wID[4];          // "WAVE"

    UBYTE   fID[4];          // "fmt"
    ULONG   fLen;            // length of chunk
    UWORD   wFormatTag;      // format of sound
    UWORD   nChannels;       // number of channels, 1 = mono, 2 = stereo
    ULONG   nSamplesPerSec;  // playback frequency
    ULONG   nAvgBytesPerSec; // nChannels * nSamplesPerSec * (nBitsPerSample/8)
    UWORD   nBlockAlign;     // nChannels * (nBitsPerSample / 8)
    UWORD   nBitsPerSample;  // number of bits per sample

    UBYTE   dID[4];          // "data"
    ULONG   dLen;            // data size;
} WAVHeader;



extern BOOL  convert_wav;
extern UBYTE snd_size;
extern UBYTE snd_format;

extern WAVHeader wav_header;


BOOL IsWAV(UBYTE *filename);
BOOL GetWAVHeader(UBYTE *filename, WAVHeader *header);
BOOL LoadWAV(UBYTE *filename, UBYTE *buffer);

#endif 
#ifndef _VLIB_LZV_H_
#define _VLIB_LZV_H_


ULONG Compress(UBYTE *outbuffer, UBYTE *inbuff, LONG inlen);
ULONG CompressQuick(UBYTE *outbuffer, UBYTE *inbuff, LONG inlen);
ULONG CompressVeryQuick(UBYTE *outbuffer, UBYTE *inbuff, LONG inlen);
void Decompress(UBYTE *outbuff, UBYTE *inbuff, LONG inlen, ULONG complen);


#endif 
