#include <vlib.h>


ULONG   paralaxtable[1024];
UBYTE text[64];

void main(void)
{
WORD    groundspr, hillsspr, hill2spr, skyspr, manspr, shadowspr;
WORD    cloud[9];
ULONG   speed = 64, loop, hilloff = 0;
static UBYTE   text[7];

    // Allocate buffers and get screen
    AllocDoubleBuffer(640 * 400);
    AllocSpriteBuffer(1500000);

    FindBestVesaMode(640, 400, 8, TRUE);

    GameTimer();
    ChangeTimer(TIMER120HZ);
    // Load sprites and palette
    OpenSpritebank("scenery");

    LoadSpritebankPalette(colormap);
    SetPalette(colormap);

    skyspr = LoadSprite("sky");
    groundspr = LoadSprite("grass");
    hillsspr = LoadSprite("hills");
    hill2spr = CloneSprite(hillsspr);

    for(loop = 1; loop <= 9; loop++) {
        sprintf(text, "cloud%d", loop);
        cloud[loop - 1] = LoadSprite(text);
    }

    manspr = LoadSprite("runningman");
    shadowspr = LoadSprite("shadow");

    // Sky background will stay in one place
    MoveSprite(skyspr, 0, 0);

    // Place clouds
    MoveSprite(cloud[0], 128, 28);
    MoveSprite(cloud[1], 288, -2);
    MoveSprite(cloud[2], 571, 68);
    MoveSprite(cloud[3], -12, 2);
    MoveSprite(cloud[4], 511, 32);
    MoveSprite(cloud[5], 111, 65);
    MoveSprite(cloud[6], 242, 102);
    MoveSprite(cloud[7], 56, 59);
    MoveSprite(cloud[8], -10, 112);

    // So will the ground
    MoveSprite(groundspr, 0, 199);
    // Set ground to paralax
    spritedata[groundspr].flags |= SPRFLAG_PARALAX;
    spritedata[groundspr].spritefps = 2 << 8;
    // Set up pointer to paralax table
    spritedata[groundspr].paralaxptr = (ULONG *)paralaxtable;

    // This sets up a paralax table.  Initial speed is 64 (above)
    // and each line moves 24/256ths faster (the speed value is
    // divided by 256 so you can move .5 pixels per frame with 128)
    for(loop = 0; loop < spritedata[groundspr].ysize; loop++) {
        paralaxtable[loop * 2] = 0;
        paralaxtable[loop * 2 + 1] = speed;
        speed += 24;
    }

    MoveSprite(manspr, 320, 230);
    MoveSprite(shadowspr, 320, 230);
    SetMainloopSpeed(30);
    InitFPS();

    while(1) {

        DrawBob(skyspr, SPR_NORMAL);
        for(loop = 0; loop < 9; loop++)
            DrawSprite(cloud[loop], SPR_NORMAL);

        MoveSprite(hillsspr, 0 - hilloff, 141);
        DrawSprite(hillsspr, SPR_NORMAL);
        if(hilloff + screen_width > spritedata[hillsspr].xsize) {
            MoveSprite(hill2spr, 0 - hilloff + spritedata[hillsspr].xsize, 141);
            DrawSprite(hill2spr, SPR_NORMAL);
        }

        DrawParalax(groundspr, SPR_NORMAL);
        DrawSprite(shadowspr, SPR_NORMAL);
        DrawSprite(manspr, SPR_NORMAL);

        // Uncomment this line to slow to 30 fps and smooth the animation
//        PaceMainloop();
        DoubleBuffer();

        if((fps_frames % 8) == 0)
            hilloff++;
        if(hilloff > spritedata[hillsspr].xsize)
            hilloff = 0;

        for(loop = 0; loop < 9; loop++) {
            if(spritedata[cloud[loop]].xpos < -spritedata[cloud[loop]].xsize)
                MoveSprite(cloud[loop], screen_width,
                           spritedata[cloud[loop]].ypos);
        }

        if(GetKey())
            break;

        if(ReadMouseButton() != 0)
            break;

    }
    SetVideoMode(TEXT80);
    ReportFPS();
    OldTimer();
    ChangeTimer(TIMER18HZ);
    FreeSpriteBuffer();
    FreeDoubleBuffer();
}