#include <vlib.h>


// This is a table of all colors used by all buttons
ButtonColors buttoncolors = {
    0x00ffffff, 0x00707070, 0x00b0b0b0, 0x00303030,
    0x00ffff00, 0x00707070, 0x00b0b0b0, 0x00303030,
    0x00ffffff, 0x00606060, 0x00b0b0b0, 0x00303030,
    0x00555555
};


// This is where the offsets for the above colors will be
ButtonClrMap buttonoffsets;


// Text to place in buttons
UBYTE quittext[] = "Quit";
UBYTE toggtext[] = "Toggle";
UBYTE othrtext[] = "Other";



Button quit = {

    480, 32, 96, 24, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_POPUP, BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE,
    BUTTON_TYPE_BOOLEAN, 0, 0, 0xaaff, quittext, 0, 0, 0
};

Button toggle = {

    16, 32, 92, 24, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_TOGGLE | BUTTON_ACTION_HITONRELEASE,
    BUTTON_STYLE_ROUND | BUTTON_STYLE_OUTLINE | BUTTON_STYLE_BORDERHI,
    BUTTON_TYPE_BOOLEAN, 3, 2, 0x0001, toggtext, 0, 0, 0
};

Button toggle2 = {

    124, 32, 92, 24, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_TOGGLE | BUTTON_ACTION_HITONRELEASE,
    BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE | BUTTON_STYLE_BORDERLO,
    BUTTON_TYPE_BOOLEAN, 3, 2, 0x0002, toggtext, 0, 0, 0
};

Button toggle3 = {

    240, 32, 92, 24, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_TOGGLE | BUTTON_ACTION_HITONRELEASE,
    BUTTON_STYLE_SMOOTH | BUTTON_STYLE_OUTLINE | BUTTON_STYLE_BORDERLO | BUTTON_STYLE_BORDERHI,
    BUTTON_TYPE_BOOLEAN, 5, 3, 0x0003, toggtext, 0, 0, 0
};

Button other = {

    364, 32, 92, 24, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_POPUP, BUTTON_STYLE_SMOOTH,
    BUTTON_TYPE_BOOLEAN, 0, 0, 0x0004, othrtext, 0, 0, 0
};


Slider sliderdata = {
    5, 0, 3864, 0, 64
};


Button spriteslider = {

    64, 96, 512, 14, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, 0, BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE, BUTTON_TYPE_SLIDER,
    0, 0, 0x0100, 0, 0, 0, &sliderdata
};





void main(void)
{
WORD mousespr;
Button *hit_button = NULL, *sliderbutton;

    // Initialize most resources and setup screen/sprite stuff
    InitVLib(INIT_MOST);

    SetMarinePalette();

    // Create a sprite out of the built in mouse pointer data
    mousespr = AddSprite(mouseptr.width, mouseptr.height, mouseptrdata, 0);

    // Clear the screen
    ScreenFill(darkpage);

    // Add the buttons
    AddButton(&quit);
    AddButton(&toggle3);
    AddButton(&toggle2);
    AddButton(&toggle);
    AddButton(&other);
    sliderbutton = AddButton(&spriteslider);

    DoSliderText(sliderbutton);

    // Loop until quit button is hit
    while(hit_button->id != 0xaaff) {

        // Check to see what button was hit
        hit_button = CheckButtons();

        // Print text if it was the slider
        if(hit_button->type & BUTTON_TYPE_SLIDER)
            DoSliderText(hit_button);

        // Move the mouse and call DoubleBuffer
        UpdateMouse(mousespr);

    }

    // Remove the buttons
    RemoveButton(0x0100);
    RemoveButton(0x0001);
    RemoveButton(0x0002);
    RemoveButton(0x0003);
    RemoveButton(0x0004);
    RemoveButton(0xaaff);

    // Free resources and exit program
    FreeVLib();
}


void DoSliderText(Button *slider)
{
static UBYTE text[16];

    DrawFilledBox(64, 85, 196, 94, darkpage);
    sprintf(text, "%d of %d", slider->slider->currentry,
            slider->slider->maxentries - 1);
    Text(64, 85, text, textclr);
}