/*****************************************************************************
 FONTDEMO.C

 Simple program that displays each font it finds in the FONTS subdirectory
 on the screen.  Press any key to go to the next font.  After the last font
 is displayed, it'll exit to DOS.

 Each font that is found is displayed in normal, bold, underline, shadow,
 and italics modes.

 Sorry there are so few fonts, but it took me about 20-30 minutes per font
 to "create" them.

 By the way, the DIGITAL font is so big that it wraps and overlaps in this
 demo.  You can still see what it looks like though.

 Although the fonts are in their own subdirectory, and this demo expects to
 find them there, you don't *have* to have them there in your own programs.
 Neither do they *have* to have a .FON extension.  You can rename them to be
 anything you want.

 If you can supply me a 320x200x256 picture containing the letters of a
 particular font, I can use my quick'n'dirty tools to create a new .FON
 file for you.  I don't mind doing this as it adds to the VGL font list.
 It must have a black (color 0) background.  The characters can be any color.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#include <dir.h>
#include "vgl.h"

void main()
{
   int          k;
   int          x, y;
   struct ffblk fb;
   int          n = 0;

   /* Go into the FONTS subdirectory */
   if( chdir( "fonts" ) )
   {
      printf( "No FONTS subdirectory!\n" );
      return;
   }

   /* Enter mode 13h */
   vglInit();

   /* Set text color to WHITE */
   vglTextColor( 15 );

   /* Set shadow color to GREEN */
   vglShadowColor( 2 );

   /* Set underline color to RED */
   vglUnderlineColor( 4 );

   /* Find the first font */
   if( !findfirst( "*.fon", &fb, 0 ) )
   {
      do
      {
         n++;

         /* Clear to a black screen */
         vglClear( 0 );

         /* Load in a font */
         vglLoadFont( fb.ff_name );

         /* Turn off all the special settings */
         vglBoldOff();
         vglItalicsOff();
         vglShadowOff();
         vglUnderlineOff();

         /* Got to the top left corner of the screen */
         vglGotoXY( 0, 0 );

         /* Display the font's file name */
         vglPuts( fb.ff_name );

         /* New line */
         vglPuts( "\r\n\n" );

         /* Bolded sample */
         vglBoldOn();
         vglPuts( "Bolded" );
         vglBoldOff();

         /* Underlined sample */
         vglGotoXY( 160, vglGetY() );
         vglUnderlineOn( 2 );
         vglPuts( "Underlined\r\n" );
         vglUnderlineOff();

         /* Shadowed sample (Shadow depth = 1 pixel) */
         vglShadowOn( 1 );
         vglPuts( "Shadowed" );
         vglShadowOff();

         /* Italics sample */
         vglGotoXY( 160, vglGetY() );
         vglItalicsOn();
         vglPuts( "Italics\r\n" );
         vglItalicsOff();

         /* Miscellaneous characters */
         vglPuts( "ABCDabcd123!@#$" );

         /* Get a keypress */
         getch();

         /* Find the next font */
      } while( !findnext( &fb ) );
   }

   /* Backup to the parent directory */
   chdir( ".." );

   /* Return to text mode */
   vglTerm();

   printf( "%d fonts\n", n );
}
