/*****************************************************************************
 KEYDEMO.C

 Demo program that shows how to use the VGL keyboard trapping routines.  This
 one simply displays a textual description of which of the 4 arrow keys are
 currently being held down.  Sorry it hasn't got a pretty display, but at
 least you get the idea... I hope.

 You can add additional keys to be trapped by editing the file VGLKEY.C and
 inserting or deleting them from the list.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#include "vgl.h"

main()
{
   int i;

   clrscr();
   gotoxy( 1, 1 );
   cprintf( "Key Trapping Demo - Play with the arrow keys." );

   vglTrapKeys();                       /* Turn on key trapping             */

   while( !kbhit() )                    /* Loop until ESCAPE is hit         */
   {
      gotoxy( 1, 3 );                   /* Display the status bytes         */
      for( i = 0; i < VGL_NUMKEYS; i++ )
         if( vglKeyStatus[i] )
            putch( '*' );
         else
            putch( '-' );

      gotoxy( 1, 5 );                   /* Display a message                */
      if( vglKeyStatus[0] )
         cprintf( "UP-ARROW " );
      if( vglKeyStatus[1] )
         cprintf( "DOWN-ARROW " );
      if( vglKeyStatus[2] )
         cprintf( "LEFT-ARROW " );
      if( vglKeyStatus[3] )
         cprintf( "RIGHT-ARROW " );
      clreol();

      delay( 100 );                     /* Keeps cursor from flickering all */
                                        /* over the place.                  */
   }

   vglReleaseKeys();                    /* Disable keytrapping              */
}
