// #define Uses_TVMemMgr
#define Uses_MsgBox
#define Uses_TFileList
#define Uses_TRect
#define Uses_TSearchRec
#define Uses_TEvent
#define Uses_TGroup
#define Uses_TStreamableClass
#include <tv.h>

#include <dir.h>
#include <errno.h>
#include <ctype.h>
#include <assert.h>
#include <dos.h>
#include <string.h>
#include <libc/dosio.h>
#include <stdio.h>

void fexpand( char * );

TFileList::TFileList( const TRect& bounds,
		      TScrollBar *aScrollBar) :
    TSortedListBox( bounds, 2, aScrollBar )
{
  if (_USE_LFN) numCols = 1;
}

TFileList::~TFileList()
{
   if ( list() )
      destroy ( list() );
}

void TFileList::focusItem( ccIndex item )
{
    TSortedListBox::focusItem( item );
    message( owner, evBroadcast, cmFileFocused, list()->at(item) );
}

void TFileList::getData( void * )
{
}

void TFileList::setData( void * )
{
}

uint32 TFileList::dataSize()
{
    return 0;
}

void* TFileList::getKey( const char *s )
{
static TSearchRec sR;

    if( (shiftState & 0x03) != 0 || *s == '.' )
        sR.attr = FA_DIREC;
    else
        sR.attr = 0;
    strcpy( sR.name, s );
    strupr( sR.name );
    return &sR;
}

void TFileList::getText( char *dest, ccIndex item, short maxChars )
{
	TSearchRec *f = (TSearchRec *)(list()->at(item));

	strncpy( dest, f->name, maxChars );
	dest[maxChars] = '\0';
    if( f->attr & FA_DIREC )
	strcat( dest, DIRSEPARATOR_ );
}

void TFileList::handleEvent( TEvent & event )
{
    if( event.what == evMouseDown && event.mouse.doubleClick )
        {
        event.what = evCommand;
        event.message.command = cmOK;
        putEvent( event );
        clearEvent( event );
        }
    else
        TSortedListBox::handleEvent( event );
}

void TFileList::readDirectory( const char *dir, const char *wildCard )
{
    char path[MAXLFNPATH];
    strcpy( path, dir );
    strcat( path, wildCard );
    readDirectory( path );
}

struct DirSearchRec : public TSearchRec
{

    void *operator new( size_t );

};

void *DirSearchRec::operator new( size_t sz )
{
    void *temp = ::operator new( sz );
#if 0
    if( TVMemMgr::safetyPoolExhausted() )
        {
        delete temp;
        temp = 0;
        }
#endif
    return temp;
}

#if 1
extern "C" {
unsigned short ffattrib(struct ffblk *);
unsigned short ffdate(struct ffblk *);
unsigned short fftime(struct ffblk *);
unsigned long ffsize(struct ffblk *);
char *ffname(struct ffblk *);
}
#define A(s) ffattrib(&s)
#define D(s) ffdate(&s)
#define T(s) fftime(&s)
#define S(s) ffsize(&s)
#define N(s) ffname(&s)
#else
#define A(s) s.ff_attrib
#define D(s) s.ff_fdate
#define T(s) s.ff_ftime
#define S(s) s.ff_fsize
#define N(s) s.ff_name
#endif

static void CopyDirRec(struct ffblk & s,DirSearchRec *p)
{
  p->attr = A(s);
  p->time = ((unsigned long)(D(s))) << 16 | (unsigned short)T(s);
  p->size = S(s);
  strcpy(p->name,N(s));
}

void TFileList::readDirectory( const char *aWildCard )
{
ffblk s;

char path[MAXLFNPATH];
char drive[MAXDRIVE];
char dir[MAXLFNPATH];
char file[MAXLFN];
char ext[MAXLFN];

const unsigned findAttr = FA_RDONLY | FA_ARCH;

    strcpy( path, aWildCard );
    fexpand( path );
    fnsplit( path, drive, dir, file, ext );

    TFileCollection *fileList = new TFileCollection( 5, 5 );
    int res = findfirst( aWildCard, &s, findAttr );
    DirSearchRec *p = (DirSearchRec *)&p;
    while( p != 0 && res == 0 )
        {
        if( (A(s) & FA_DIREC) == 0 )
            {
            p = new DirSearchRec;
            if( p != 0 )
                {
                CopyDirRec(s,p);
                fileList->insert( p );
                }
            }
        res = findnext( &s );
        }

    fnmerge( path, drive, dir, "*", ".*" );

    res = findfirst( path, &s, FA_DIREC );
    while( p != 0 && res == 0 )
        {
        if( (A(s) & FA_DIREC) != 0 && N(s)[0] != '.' )
            {
            p = new DirSearchRec;
            if( p != 0 )
                {
                CopyDirRec(s,p);
                fileList->insert( p );
                }
            }
        res = findnext( &s );
        }

    if( strlen( dir ) > 4 )
        {
        p = new DirSearchRec;
        if( p != 0 )
            {
            if( findfirst( path, &s, FA_DIREC ) == 0 &&
                findnext( &s ) == 0 &&
                strcmp( N(s), ".." ) == 0
            )
            {
                CopyDirRec(s,p);
            }
            else
                {
                strcpy( p->name, ".." );
                p->size = 0;
                p->time = 0x210000uL;
                p->attr = FA_DIREC;
		}
            fileList->insert( p );
            }
        }

    if( p == 0 )
        messageBox( tooManyFiles, mfOKButton | mfWarning );
    newList(fileList);
    if( list()->getCount() > 0 )
        message( owner, evBroadcast, cmFileFocused, list()->at(0) );
    else
        {
        static DirSearchRec noFile;
        message( owner, evBroadcast, cmFileFocused, &noFile );
        }
}

#if !defined(DJGPP) || (DJGPP < 2)
/*
    fexpand:    reimplementation of pascal's FExpand routine.  Takes a
                relative DOS path and makes an absolute path of the form

                    drive:\[subdir\ ...]filename.ext

                works with '/' or '\' as the subdir separator on input;
                changes all to '\' on output.

*/

void squeeze( char *path )
{
    char *dest = path;
    char *src = path;
    while( *src != 0 )
        {
        if( *src != '.' )
            *dest++ = *src++;   // just copy it...
        else
            {
            src++;
            if( *src == '.' )
                {               // have a '..'
                src += 2;       // skip the following '\'
                dest--;         // back up to the previous '\'
		while( *--dest != DIRSEPARATOR ) // back up to the previous '\'
                    ;
                dest++;         // move to the next position
                }
            else
                {
                src++;          // skip the following '\'
                dest += 2;
                }
            }
        }
    *dest = EOS;                // zero terminator
}

void fexpand( char *rpath )
{
char path[MAXPATH];
char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];

    int flags = fnsplit( rpath, drive, dir, file, ext );
    if( (flags & DRIVE) == 0 )
        {
        drive[0] = getdisk() + 'A';
        drive[1] = ':';
        drive[2] = '\0';
        }
    drive[0] = toupper(drive[0]);
    if( (flags & DIRECTORY) == 0 || (dir[0] != DIRSEPARATOR && dir[0] != '/') )
        {
        char curdir[MAXDIR];
        getcurdir( drive[0] - 'A' + 1, curdir );
        strcat( curdir, dir );
	if( *curdir != DIRSEPARATOR && *curdir != '/' )
            {
	    *dir = DIRSEPARATOR;
            strcpy( dir+1, curdir );
            }
        else
            strcpy( dir, curdir );
        }

    squeeze( dir );
    fnmerge( path, drive, dir, file, ext );
    strcpy( rpath, path );
}

#else

extern "C" _fixpath(const char *,char *);

void fexpand( char *rpath )
{
  char path[MAXLFNPATH];
  _fixpath(rpath,path);
  strcpy(rpath,path);
}

#endif

TStreamable *TFileList::build()
{
    return new TFileList( streamableInit );
}
