#define Uses_TVEdMac
#define Uses_TVEdConstant
#define Uses_fpstream
#define Uses_TMacro
#define Uses_TMacroCollection
#define Uses_TEvent
#define Uses_TMacroRec
#include <tv.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <macedit.h>

extern Const_Rec StdConstants[];
extern Const_Rec *UserConstants;
extern int UserConstantsCount;

extern FILE * yyin;

extern int yydebug;
int yyparse();
void DecompileMacro(TMacro &,fpstream &);
char * getstring(const char *,ushort,int,int);
char * getstring(ushort,int);

int CompileMacros(char * fname)
{
  int i;
  TMacroCollection *_macros=macros;
  FILE * inf = fopen(fname,"rb");
  yyin = inf;
  if (!inf) return -1;
  macros = new TMacroCollection();
  i=yyparse();
  fclose(inf);
  if (i==0)
  {
    delete _macros;
  }
  else
  {
    delete macros;
    macros = _macros;
  }
  return i;
}

static void _putstring(const char * text,fpstream & os)
{
  os.writeBytes(text,strlen(text));
}

#define putstring(x) _putstring(x,os)
#define writeln(x) putstring(x); putstring("\r\n");

void DeCompileMacros(char * fname)
{
  int i=0;
  fpstream *fp = new fpstream(fname,ios::out | ios::trunc | 
    ios::bin
  );
  fpstream & os = *fp;
  writeln("// Standardconstants");
  while (StdConstants[i].Name)
  {
    putstring("// ");
    putstring(StdConstants[i].Name);
    putstring(" = ");
    putstring(getstring(StdConstants[i].Name,StdConstants[i].code,0,0));
    writeln(";");
    i++;
  }
  writeln("");
  writeln("// Userconstants");
  for (i=0;i<UserConstantsCount;i++)
  {
    putstring(UserConstants[i].Name);
    putstring(" = ");
    putstring(getstring(UserConstants[i].Name,UserConstants[i].code,1,0));
    writeln(";");
  }
  for (i=0;i<macros->getCount();i++)
  {
    TMacro & macro = *((TMacro *)macros->at(i));
    writeln("");
    putstring("macro ");
    writeln(macro.Macro_Name);
    DecompileMacro(macro,os);
    writeln("endm");
    writeln("");
    putstring(getstring(macro.key,1));
    putstring(" : ");
    putstring(macro.Macro_Name);
    writeln(";");
  }
  delete fp;
}

char * getstring(const char * name,ushort value,int user,int kb)
{
  static char temp[10];
  int i;
  if (user) for (i=0;i<UserConstantsCount;i++)
  {
    if (strcmp(UserConstants[i].Name,name)==0) break;
    if (UserConstants[i].code == value) return UserConstants[i].Name;
  }
  i=0;
  while (StdConstants[i].Name)
  {
    if (strcmp(StdConstants[i].Name,name)==0) break;
    if (StdConstants[i].code == value)
    {
      if (kb) return StdConstants[i].Name;
      if (StdConstants[i].Name[0] != 'k' && StdConstants[i].Name[1] != 'b')
        return StdConstants[i].Name;
    }
    i++;
  }
  sprintf(temp,"%d",value);
  return temp;
}

char * getstring(ushort value,int kb)
{
  static char temp[10];
  int i;
  for (i=0;i<UserConstantsCount;i++)
  {
    if (UserConstants[i].code == value) return UserConstants[i].Name;
  }
  i=0;
  while (StdConstants[i].Name)
  {
    if (StdConstants[i].code == value)
    {
      if (kb) return StdConstants[i].Name;
      if (StdConstants[i].Name[0] != 'k' && StdConstants[i].Name[1] != 'b')
        return StdConstants[i].Name;
    }
    i++;
  }
  sprintf(temp,"%d",value);
  return temp;
}

void DecompileMacro(TMacro & macro,fpstream & os)
{
  int i;
  for (i=0;i<macro.count;i++)
  {
    TMacroRec & mr = *macro.macs[i];
    putstring("\t");
    if (mr.type == Insert_Command)
    {
      putstring("InsertText(\"");
      putstring(mr.data.Macro_Name);
      writeln("\");");
    }
    else
    if (mr.type == Builtin_Command)
    {
      putstring(getstring(mr.data.command,0));
      writeln(";");
    }
    else
    if (mr.type == Macro_Command)
    {
      putstring(mr.data.Macro_Name);
      writeln(";");
    }
  }
}
