#define Uses_ipstream
#define Uses_opstream
#define Uses_TRangeValidator
#define Uses_MsgBox
#include <tv.h>
#include <string.h>
#include <limits.h>
#include <stdio.h>

TRangeValidator::TRangeValidator() : TFilterValidator("0123456789-+")
{
  Min = INT_MIN;
  Max = INT_MAX;
}

TRangeValidator::TRangeValidator(int aMin,int aMax) :
  TFilterValidator("0123456789+-")
{
  Min = aMin;
  Max = aMax;
  if (Min > Max)
  {
    Min = aMax;
    Max = aMin;
  }
  if (Min >= 0) strcpy(ValidChars,"0123456789+");
  if (Max < 0) strcpy(ValidChars,"0123456789-");
}

void TRangeValidator::Error()
{
  messageBox(mfError | mfOKButton,"Value not in the range %d to %d",Min,Max);
}

Boolean TRangeValidator::IsValid(const char *S)
{
  int value;
  if (TFilterValidator::IsValid(S) == False) return False;
  sscanf(S,"%d",&value);
  if (value < Min || value > Max) return False;
  return True;
}

ushort TRangeValidator::Transfer(char *S,void * Buffer,
  TVTransfer Flag)
{
  if (!(Options & voTransfer)) return 0;
  switch (Flag)
  {
    case vtGetData:
      sscanf(S,"%d",(int *)Buffer);
      break;
    case vtSetData:
      sprintf(S,"%d",*((int *)Buffer));
      break;
    default:
      break;
  }
  return sizeof(int);
}

TRangeValidator::TRangeValidator(StreamableInit) :
  TFilterValidator(streamableInit)
{
}

TStreamable * TRangeValidator::build()
{
  return (TStreamable *) new TRangeValidator(streamableInit);
}

void TRangeValidator::write(opstream & os)
{
  TFilterValidator::write(os);
  os << Min << Max;
}

void * TRangeValidator::read(ipstream & is)
{
  TFilterValidator::read(is);
  is >> Min >> Max;
  return this;
}
