#define Uses_TKeys
#define Uses_TEditor
#define Uses_TIndicator
#define Uses_TEvent
#define Uses_TScrollBar
#define Uses_TFindDialogRec
#define Uses_TReplaceDialogRec
#define Uses_opstream
#define Uses_ipstream
#define Uses_TStreamableClass
#define Uses_TMacroCollection
#include <tv.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <dos.h>

inline int isWordChar( int ch )
{
    return isalnum(ch) || ch == '_';
}

const ushort firstKeys[] =
{
    37,
    kbCtrlA, cmWordLeft,
    kbCtrlC, cmPageDown,
    kbCtrlD, cmCharRight,
    kbCtrlE, cmLineUp,
    kbCtrlF, cmWordRight,
    kbCtrlG, cmDelChar,
    kbCtrlH, cmBackSpace,
    kbCtrlK, 0xFF02,
    kbCtrlL, cmSearchAgain,
    kbCtrlM, cmNewLine,
    kbCtrlO, cmIndentMode,
    kbCtrlQ, 0xFF01,
    kbCtrlR, cmPageUp,
    kbCtrlS, cmCharLeft,
    kbCtrlT, cmDelWord,
    kbCtrlU, cmUndo,
    kbCtrlV, cmInsMode,
    kbCtrlX, cmLineDown,
    kbCtrlY, cmDelLine,
    kbLeft, cmCharLeft,
    kbRight, cmCharRight,
    kbCtrlLeft, cmWordLeft,
    kbCtrlRight, cmWordRight,
    kbHome, cmLineStart,
    kbEnd, cmLineEnd,
    kbUp, cmLineUp,
    kbDown, cmLineDown,
    kbPgUp, cmPageUp,
    kbPgDn, cmPageDown,
    kbCtrlPgUp, cmTextStart,
    kbCtrlPgDn, cmTextEnd,
    kbIns, cmInsMode,
    kbDel, cmDelChar,
    kbShiftIns, cmPaste,
    kbShiftDel, cmCut,
    kbCtrlIns, cmCopy,
    kbCtrlDel, cmClear
};

const ushort quickKeys[] =
{   18,
    'A', cmReplace,
    'C', cmTextEnd,
    'D', cmLineEnd,
    'F', cmFind,
    'H', cmDelStart,
    'R', cmTextStart,
    'S', cmLineStart,
    'Y', cmDelEnd,
    '0', cmVaAMarca0,
    '1', cmVaAMarca1,
    '2', cmVaAMarca2,
    '3', cmVaAMarca3,
    '4', cmVaAMarca4,
    '5', cmVaAMarca5,
    '6', cmVaAMarca6,
    '7', cmVaAMarca7,
    '8', cmVaAMarca8,
    '9', cmVaAMarca9
};

const ushort blockKeys[] =
{   17,
    'B', cmStartSelect,
    'C', cmPaste,
    'H', cmHideSelect,
    'K', cmCopy,
    'R', cmReadBlock,
    'W', cmWriteBlock,
    'Y', cmCut,
    '0', cmPonerMarca0,
    '1', cmPonerMarca1,
    '2', cmPonerMarca2,
    '3', cmPonerMarca3,
    '4', cmPonerMarca4,
    '5', cmPonerMarca5,
    '6', cmPonerMarca6,
    '7', cmPonerMarca7,
    '8', cmPonerMarca8,
    '9', cmPonerMarca9
};

const ushort *keyMap[] = { firstKeys, quickKeys, blockKeys };

ushort defEditorDialog( int, ... );

#define KeyMap ((const ushort far *)(keyMap))

ushort scanKeyMap( const void *keyMap, int keyCode )
{
  int i=0;
  ushort bx,cx,dx,ax;
  dx = keyCode;
  cx = KeyMap[i++];
  do
  {
    bx = KeyMap[i++];
    ax = KeyMap[i++];
    if ((bx & 0x00ff) == (dx & 0x00ff))
    {
      if (!(bx & 0xff00)) return ax;
      if ((bx & 0xff00) == (dx & 0xff00)) return ax;
    }
    cx--;
  } while (cx != 0);
  return 0;
}

#define cpEditor    "\x06\x07"

TEditor::TEditor( const TRect& bounds,
		  TScrollBar *aHScrollBar,
		  TScrollBar *aVScrollBar,
		  TIndicator *aIndicator,
		  uint32 aBufSize ) :
    TView( bounds ),
    hScrollBar( aHScrollBar ),
    vScrollBar( aVScrollBar ),
    indicator( aIndicator ),
    bufSize( aBufSize ),
    canUndo( True ),
    selecting( False ),
    overwrite( False ),
    autoIndent( False ) ,
    lockCount( 0 ),
    keyState( 0 )
{
    growMode = gfGrowHiX | gfGrowHiY;
    options |= ofSelectable;
    eventMask = evMouseDown | evKeyDown | evCommand | evBroadcast;
    showCursor();
    initBuffer();
    if( buffer != 0 )
	isValid = True;
    else
    {
	editorDialog( edOutOfMemory );
	bufSize = 0;
	isValid = False;
    }
    setBufLen(0);
}

TEditor::~TEditor()
{
}

void TEditor::shutDown()
{
    doneBuffer();
    TView::shutDown();
}

void TEditor::changeBounds( const TRect& bounds )
{
    setBounds(bounds);
    delta.x = max(0, min(delta.x, limit.x - size.x));
    delta.y = max(0, min(delta.y, limit.y - size.y));
    update(ufView);
}

int TEditor::charPos( uint32 p, uint32 target )
{
    int pos = 0;
    while( p < target )
    {
	if( bufChar(p) == '\x9' )
#if 0
	    pos |= 7;
#else
	    pos += tabSize - (pos % tabSize) -1;
#endif
	pos++;
	p++;
    }
    return pos;
}

uint32 TEditor::charPtr( uint32 p, int target )
{
  int pos = 0;
  while( (pos < target) && (p < bufLen) && (bufChar(p) != '\x0D') && (bufChar(p) != '\x0A') )
    {
    if( bufChar(p) == '\x09' )
#if 0
	    pos |= 7;
#else
	    pos += tabSize - (pos % tabSize) -1;
#endif
    pos++;
    p++;
    }
  if( pos > target )
    p--;
  return p;
}

Boolean TEditor::clipCopy()
{
    Boolean res = False;
    if( (clipboard != 0) && (clipboard != this) )
	{
	res = clipboard->insertFrom(this);
	selecting = False;
	update(ufUpdate);
	}
    return res;
}

void TEditor::clipCut()
{
    if( clipCopy() == True )
	deleteSelect();
}

void TEditor::clipPaste()
{
    if( (clipboard != 0) && (clipboard != this) )
	insertFrom(clipboard);
}

extern unsigned short getshiftstate(void);
#define shiftkeys() getshiftstate()

void TEditor::convertEvent( TEvent& event )
{
    if( event.what == evKeyDown )
	{
	if ( (shiftkeys() & 0x03) != 0 &&
	    event.keyDown.charScan.scanCode >= 0x47 &&
	    event.keyDown.charScan.scanCode <= 0x51
	  )
	    event.keyDown.charScan.charCode = 0;

	ushort key = event.keyDown.keyCode;
	if( keyState != 0 )
	    {
	    if( (key & 0xFF) >= 0x01 && (key & 0xFF) <= 0x1A )
		key += 0x40;
	    if( (key & 0xFF) >= 0x61 && (key & 0xFF) <= 0x7A )
		key -= 0x20;
	    }
	key = scanKeyMap(keyMap[keyState], key);
	keyState = 0;
	if( key != 0 )
	    if( (key & 0xFF00) == 0xFF00 )
		{
		keyState = (key & 0xFF);
		clearEvent(event);
		}
	    else
		{
		event.what = evCommand;
		event.message.command = key;
		}
	}
}

Boolean TEditor::cursorVisible()
{
  return Boolean((curPos.y >= delta.y) && (curPos.y < delta.y + size.y));
}

void TEditor::deleteRange( uint32 startPtr,
			   uint32 endPtr,
			   Boolean delSelect
			 )
{
    if( hasSelection() == True && delSelect == True )
	deleteSelect();
    else
	{
	setSelect(curPtr, endPtr, True);
	deleteSelect();
	setSelect(startPtr, curPtr, False);
	deleteSelect();
	}
}

void TEditor::deleteSelect()
{
    insertText( 0, 0, False );
}

void TEditor::doneBuffer()
{
    delete buffer;
}

void TEditor::doSearchReplace()
{
    int i;
    do  {
	i = cmCancel;
	if( search(findStr, editorFlags) == False )
	    {
	    if( (editorFlags & (efReplaceAll | efDoReplace)) !=
		(efReplaceAll | efDoReplace) )
		    editorDialog( edSearchFailed );
	    }
	else
	    if( (editorFlags & efDoReplace) != 0 )
		{
		i = cmYes;
		if( (editorFlags & efPromptOnReplace) != 0 )
		    {
		    TPoint c = makeGlobal( cursor );
		    i = editorDialog( edReplacePrompt, &c );
		    }
		if( i == cmYes )
		    {
		    lock();
		    insertText( replaceStr, strlen(replaceStr), False);
		    trackCursor(False);
		    unlock();
		    }
		}
	} while( i != cmCancel && (editorFlags & efReplaceAll) != 0 );
}

void TEditor::doUpdate()
{
    if( updateFlags != 0 )
	{
	setCursor(curPos.x - delta.x, curPos.y - delta.y);
	if( (updateFlags & ufView) != 0 )
	    drawView();
	else
	    if( (updateFlags & ufLine) != 0 )
		drawLines( curPos.y-delta.y, 1, lineStart(curPtr) );
	if( hScrollBar != 0 )
	    hScrollBar->setParams(delta.x, 0, limit.x - size.x, size.x / 2, 1);
	if( vScrollBar != 0 )
	    vScrollBar->setParams(delta.y, 0, limit.y - size.y, size.y - 1, 1);
	if( indicator != 0 )
	    indicator->setValue(curPos, modified);
	if( (state & sfActive) != 0 )
	    updateCommands();
	updateFlags = 0;
	}
}

void TEditor::draw()
{
    if( drawLine != delta.y )
	{
	drawPtr = lineMove( drawPtr, delta.y - drawLine );
	drawLine = delta.y;
	}
    drawLines( 0, size.y, drawPtr );
}

void TEditor::drawLines( int y, int count, uint32 linePtr )
{
    ushort color = getColor(0x0201);
    while( count-- > 0 )
	{
	ushort b[maxLineLength];
	formatLine( b, linePtr, delta.x+size.x, color );
	writeBuf(0, y, size.x, 1, &b[delta.x]);
	linePtr = nextLine(linePtr);
	y++;
	}
}

void TEditor::find()
{
    TFindDialogRec findRec( findStr, editorFlags );
    if( editorDialog( edFind, &findRec ) != cmCancel )
	{
	strcpy( findStr, findRec.find );
	editorFlags = findRec.options & ~efDoReplace;
	doSearchReplace();
	}
}

uint32 TEditor::getMousePtr( TPoint m )
{
    TPoint mouse = makeLocal( m );
    mouse.x = max(0, min(mouse.x, size.x - 1));
    mouse.y = max(0, min(mouse.y, size.y - 1));
    return charPtr(lineMove(drawPtr, mouse.y + delta.y - drawLine),
	mouse.x + delta.x);
}

TPalette& TEditor::getPalette() const
{
    static TPalette palette( cpEditor, sizeof( cpEditor )-1 );
    return palette;
}


void TEditor::checkScrollBar( const TEvent& event,
			      TScrollBar *p,
			      int& d
			    )
{
    if( (event.message.infoPtr == p) && (p->value != d) )
	{
	d = p->value;
	update( ufView );
	}
}

void TEditor::handleEvent( TEvent& event )
{
    TView::handleEvent( event );
    if (macros) macros->handleEvent(event,this);
    convertEvent( event );
    Boolean centerCursor = Boolean(!cursorVisible());
    uchar selectMode = 0;
    if( selecting == True || (shiftkeys() & 0x03) != 0 )
	selectMode = smExtend;

    switch( event.what )
	{

	case evMouseDown:
	    if( event.mouse.doubleClick == True )
		selectMode |= smDouble;

	    do  {
		lock();
		if( event.what == evMouseAuto )
		    {
		    TPoint mouse = makeLocal( event.mouse.where );
		    TPoint d = delta;
		    if( mouse.x < 0 )
			d.x--;
		    if( mouse.x >= size.x )
			d.x++;
		    if( mouse.y < 0 )
			d.y--;
		    if( mouse.y >= size.y )
			d.y++;
		    scrollTo(d.x, d.y);
		    }
		setCurPtr(getMousePtr(event.mouse.where), selectMode);
		selectMode |= smExtend;
		unlock();
		} while( mouseEvent(event, evMouseMove + evMouseAuto) );
	    break;

	case evKeyDown:
	    if( event.keyDown.charScan.charCode == 9 ||
		( event.keyDown.charScan.charCode >= 32 && event.keyDown.charScan.charCode < 255 ) )
		    {
		    lock();
		    if( overwrite == True && hasSelection() == False )
			if( curPtr != lineEnd(curPtr) )
			    selEnd = nextChar(curPtr);
		    insertText( &event.keyDown.charScan.charCode, 1, False);
		    trackCursor(centerCursor);
		    unlock();
		    }
	    else
		return;
	    break;

	case evCommand:
	    switch( event.message.command )
		{
		case cmInsertText:
		    insertText(event.message.infoPtr,strlen((char *)event.message.infoPtr),False);
                    break;
		case cmFind:
		    find();
		    break;
		case cmReplace:
		    replace();
		    break;
		case cmSearchAgain:
		    doSearchReplace();
		    break;
		default:
		    lock();
		    switch( event.message.command )
			{
			case cmCut:
			    clipCut();
			    break;
			case cmCopy:
			    clipCopy();
			    break;
			case cmPaste:
			    clipPaste();
			    break;
			case cmUndo:
			    undo();
			    break;
			case cmClear:
			    deleteSelect();
			    break;
			case cmCharLeft:
			    setCurPtr(prevChar(curPtr), selectMode);
			    break;
			case cmCharRight:
			    setCurPtr(nextChar(curPtr), selectMode);
			    break;
			case cmWordLeft:
			    setCurPtr(prevWord(curPtr), selectMode);
			    break;
			case cmWordRight:
			    setCurPtr(nextWord(curPtr), selectMode);
			    break;
			case cmLineStart:
			    setCurPtr(lineStart(curPtr), selectMode);
			    break;
			case cmLineEnd:
			    setCurPtr(lineEnd(curPtr), selectMode);
			    break;
			case cmLineUp:
			    setCurPtr(lineMove(curPtr, -1), selectMode);
			    break;
			case cmLineDown:
			    setCurPtr(lineMove(curPtr, 1), selectMode);
			    break;
			case cmPageUp:
			    lock();
			    setCurPtr(lineMove(curPtr, -size.y), selectMode);
			    if (delta.y - size.y >= 0)
			      delta.y -= size.y;
			    else
			      delta.y = 0;
			    update(ufView);
			    unlock();
			    break;
			case cmPageDown:
			    lock();
			    setCurPtr(lineMove(curPtr, size.y), selectMode);
			    if (delta.y + size.y < limit.y)
			      delta.y += size.y;
			    else
			      delta.y = limit.y - 1 - size.y;
			    update(ufView);
			    unlock();
			    break;
			case cmTextStart:
			    setCurPtr(0, selectMode);
			    break;
			case cmTextEnd:
			    setCurPtr(bufLen, selectMode);
			    break;
			case cmNewLine:
			    newLine();
			    break;
			case cmBackSpace:
			    deleteRange(prevChar(curPtr), curPtr, True);
			    break;
			case cmDelChar:
			    deleteRange(curPtr, nextChar(curPtr), True);
			    break;
			case cmDelWord:
			    deleteRange(curPtr, nextWord(curPtr), False);
			    break;
			case cmDelStart:
			    deleteRange(lineStart(curPtr), curPtr, False);
			    break;
			case cmDelEnd:
			    deleteRange(curPtr, lineEnd(curPtr), False);
			    break;
			case cmDelLine:
			    deleteRange(lineStart(curPtr), nextLine(curPtr), False);
			    break;
			case cmInsMode:
			    toggleInsMode();
			    break;
			case cmStartSelect:
			    startSelect();
			    break;
			case cmHideSelect:
			    hideSelect();
			    break;
			case cmIndentMode:
			    autoIndent = Boolean(!autoIndent);
			    break;
			default:
			    unlock();
			    return;
			}
		    trackCursor(centerCursor);
		    unlock();
		    break;
		}

	case evBroadcast:
	    switch( event.message.command )
		{
		case cmScrollBarChanged:
		    checkScrollBar( event, hScrollBar, delta.x );
		    checkScrollBar( event, vScrollBar, delta.y );
		    break;
		default:
		    return;
		}
	}
    clearEvent(event);
}


// TEDITOR2.CC

// inline int isWordChar( int ch )
// {
//     return isalnum(ch) || ch == '_';
// }

int countLines( void *buf, uint32 count )
{
#ifdef NO_INLINE_ASM
  int ret=0,i=0;
  while (count--) if (((const char *)(buf))[i++] == 0x0a) ret++;
  return ret;
#else
  register long Ret asm ("%eax");

  asm ("pushl %edi");

  asm ("movl  %k0,%%ecx": /* no out */ : "m" (count) );
  asm ("movl  %k0,%%edi": /* no out */ : "m" (buf) );
  asm ("xorl  %edx,%edx");

  asm ("movb  $0xA,%al");

  asm ("cld");

  asm ("countLines__1:");
  asm ("orl %ecx,%ecx");
  asm ("jz  countLines__2");
  asm ("RepNe");
  asm ("Scasb");
  asm ("Jne   countLines__2");
  asm ("Inc   %edx");
  asm ("Jmp   countLines__1");
  asm ("countLines__2:");

  asm ("movl %%edx,%k0" : "r=" (Ret) :);

  asm ("popl %edi");
  return Ret;
#endif
}

#define Block ((const char *)(block))

uint32 scan( const void *block, uint32 size, const char *str )
{
    if (!size) return (UINT_MAX);
    uint32 ret=0;
    while (size--)
    {
      if (Block[ret] == str[0])
      {
	uint32 i=0;
	do
	{
	  i++;
	  if (!str[i]) return (ret);
	  if (size<i) return (UINT_MAX);
	} while (Block[ret+i] == str[i]);
      }
      ret++;
    }
    return (UINT_MAX);
}

uint32 iScan( const void *block, uint32 size, const char *str )
{
    if (!size) return (UINT_MAX);
    uint32 ret=0;
    while (size--)
    {
      if (toupper(Block[ret]) == toupper(str[0]))
      {
	uint32 i=0;
	do
	{
	  i++;
	  if (!str[i]) return (ret);
	  if (size<i) return (UINT_MAX);
	} while (toupper(Block[ret+i]) == toupper(str[i]));
      }
      ret++;
    }
    return (UINT_MAX);
}

Boolean TEditor::hasSelection()
{
    return Boolean(selStart != selEnd);
}

void TEditor::hideSelect()
{
    selecting = False;
    setSelect(curPtr, curPtr, False);
}

void TEditor::initBuffer()
{
    buffer = new char[bufSize];
}

Boolean TEditor::insertBuffer( char *p,
			       uint32 offset,
			       uint32 length,
			       Boolean allowUndo,
			       Boolean selectText
			     )
{
    selecting = False;
    uint32 selLen = selEnd - selStart;
    if( selLen == 0 && length == 0 )
	return True;

    uint32 delLen = 0;
    if( allowUndo == True )
	if( curPtr == selStart )
	    delLen = selLen;
	else
	    if( selLen > insCount )
		delLen = selLen - insCount;

    uint32 newSize = uint32(bufLen + delCount - selLen + delLen) + length;

    if( newSize > bufLen + delCount )
	if( setBufSize((uint32)(newSize)) == False )
	    {
	    editorDialog( edOutOfMemory );
	    return False;
	    }

    uint32 selLines = countLines( &buffer[bufPtr(selStart)], selLen );
    if( curPtr == selEnd )
	{
	if( allowUndo == True )
	    {
	    if( delLen > 0 )
		memmove( 
			 &buffer[curPtr + gapLen - delCount - delLen],
			 &buffer[selStart],
			 delLen
		       );
	    insCount -= selLen - delLen;
	    }
	curPtr = selStart;
	curPos.y -= selLines;
	}
    if( delta.y > curPos.y )
	{
	delta.y -= selLines;
	if( delta.y < curPos.y )
	    delta.y = curPos.y;
	}

    if( length > 0 )
	memmove(
		&buffer[curPtr],
		&p[offset],
		length
	       );

    uint32 lines = countLines( &buffer[curPtr], length );
    curPtr += length;
    curPos.y += lines;
    drawLine = curPos.y;
    drawPtr = lineStart(curPtr);
    curPos.x = charPos(drawPtr, curPtr);
    if( selectText == False )
	selStart = curPtr;
    selEnd = curPtr;
    bufLen += length - selLen;
    gapLen -= length - selLen;
    if( allowUndo == True )
	{
	delCount += delLen;
	insCount += length;
	}
    limit.y += lines - selLines;
    delta.y = max(0, min(delta.y, limit.y - size.y));
    if( isClipboard() == False )
	modified = True;
    setBufSize(bufLen + delCount);
    if( selLines == 0 && lines == 0 )
	update(ufLine);
    else
	update(ufView);
    return True;
}

Boolean TEditor::insertFrom( TEditor *editor )
{
    return insertBuffer( editor->buffer,
			 editor->bufPtr(editor->selStart),
			 editor->selEnd - editor->selStart,
			 canUndo,
			 isClipboard()
			);
}

Boolean TEditor::insertText( const void *text, uint32 length, Boolean selectText )
{
  return insertBuffer( (char *)text, 0, length, canUndo, selectText);
}

Boolean TEditor::isClipboard()
{
    return Boolean(clipboard == this);
}

uint32 TEditor::lineMove( uint32 p, int count )
{
    uint32 i = p;
    p = lineStart(p);
    int pos = charPos(p, i);
    while( count != 0 )
	{
	i = p;
	if( count < 0 )
	    {
	    p = prevLine(p);
	    count++;
	    }
	else
	    {
	    p = nextLine(p);
	    count--;
	    }
	}
    if( p != i )
	p = charPtr(p, pos);
    return p;
}

void TEditor::lock()
{
    lockCount++;
}

void TEditor::newLine()
{
    uint32 p = lineStart(curPtr);
    uint32 i = p;
    while( i < curPtr &&
	   ( (buffer[i] == ' ') || (buffer[i] == '\x9'))
	 )
	 i++;
    insertText("\x0D\x0A", 2, False);
    if( autoIndent == True )
	insertText( &buffer[p], i - p, False);
}

uint32 TEditor::nextLine( uint32 p )
{
    return nextChar(lineEnd(p));
}

uint32 TEditor::nextWord( uint32 p )
{
    while( p < bufLen && isWordChar(bufChar(p)) != 0 )
	p = nextChar(p);
    while( p < bufLen && isWordChar(bufChar(p)) == 0 )
	p = nextChar(p);
    return p;
}

uint32 TEditor::prevLine( uint32 p )
{
  return lineStart(prevChar(p));
}

uint32 TEditor::prevWord( uint32 p )
{
    while( p > 0 && isWordChar(bufChar(prevChar(p))) == 0 )
	p = prevChar(p);
    while( p > 0 && isWordChar(bufChar(prevChar(p))) != 0 )
	p = prevChar(p);
    return p;
}

void TEditor::replace()
{
    TReplaceDialogRec replaceRec( findStr, replaceStr, editorFlags );
    if( editorDialog( edReplace, &replaceRec ) != cmCancel )
	{
	strcpy( findStr, replaceRec.find );
	strcpy( replaceStr, replaceRec.replace );
	editorFlags = replaceRec.options | efDoReplace;
	doSearchReplace();
	}

}

void TEditor::scrollTo( int x, int y )
{
    x = max(0, min(x, limit.x - size.x));
    y = max(0, min(y, limit.y - size.y));
    if( x != delta.x || y != delta.y )
	{
	delta.x = x;
	delta.y = y;
	update(ufView);
	}
}

Boolean TEditor::search( const char *findStr, ushort opts )
{
    uint32 pos = curPtr;
    uint32 i;
    do  {
	if( (opts & efCaseSensitive) != 0 )
	    i = scan( &buffer[bufPtr(pos)], bufLen - pos, findStr);
	else
	    i = iScan( &buffer[bufPtr(pos)], bufLen - pos, findStr);

	if( i != sfSearchFailed )
	    {
	    i += pos;
	    if( (opts & efWholeWordsOnly) == 0 ||
		!(
		    ( i != 0 && isWordChar(bufChar(i - 1)) != 0 ) ||
		    ( i + strlen(findStr) != bufLen &&
			isWordChar(bufChar(i + strlen(findStr)))
		    )
		 ))
		{
		lock();
		setSelect(i, i + strlen(findStr), False);
		trackCursor(Boolean(!cursorVisible()));
		unlock();
		return True;
		}
	    else
		pos = i + 1;
	    }
	} while( i != sfSearchFailed );
    return False;
}

void TEditor::setBufLen( uint32 length )
{
    bufLen = length;
    gapLen = bufSize - length;
    selStart = 0;
    selEnd = 0;
    curPtr = 0;
    delta.x = 0;
    delta.y = 0;
    curPos = delta;
    limit.x = maxLineLength;
    limit.y = countLines( &buffer[gapLen], bufLen ) + 1;
    drawLine = 0;
    drawPtr = 0;
    delCount = 0;
    insCount = 0;
    modified = False;
    update(ufView);
}

Boolean TEditor::setBufSize( uint32 newSize )
{
    return Boolean(newSize <= bufSize);
}

void TEditor::setCmdState( ushort command, Boolean enable )
{
    TCommandSet s;
    s += command;
    if( enable == True && (state & sfActive) != 0 )
	enableCommands(s);
    else
	disableCommands(s);
}

void TEditor::setCurPtr( uint32 p, uchar selectMode )
{
    uint32 anchor;
    if( (selectMode & smExtend) == 0 )
	anchor = p;
    else if( curPtr == selStart )
	anchor = selEnd;
    else
	anchor = selStart;

    if( p < anchor )
	{
	if( (selectMode & smDouble) != 0 )
	    {
	    p = prevLine(nextLine(p));
	    anchor = nextLine(prevLine(anchor));
	    }
	setSelect(p, anchor, True);
	}
    else
	{
	if( (selectMode & smDouble) != 0 )
	    {
	    p = nextLine(p);
	    anchor = prevLine(nextLine(anchor));
	    }
	setSelect(anchor, p, False);
	}
}

void TEditor::setSelect( uint32 newStart, uint32 newEnd, Boolean curStart )
{
    uint32 p;
    if( curStart != 0 )
	p = newStart;
    else
	p = newEnd;

    uchar flags = ufUpdate;

    if( newStart != selStart || newEnd != selEnd )
	if( newStart != newEnd || selStart != selEnd )
	    flags = ufView;

    if( p != curPtr )
	{
	if( p > curPtr )
	    {
	    uint32 l = p - curPtr;
	    memmove( &buffer[curPtr], &buffer[curPtr + gapLen], l);
	    curPos.y += countLines(&buffer[curPtr], l);
	    curPtr = p;
	    }
	else
	    {
	    uint32 l = curPtr - p;
	    curPtr = p;
	    curPos.y -= countLines(&buffer[curPtr], l);
	    memmove( &buffer[curPtr + gapLen], &buffer[curPtr], l);
	    }
	drawLine = curPos.y;
	drawPtr = lineStart(p);
	curPos.x = charPos(drawPtr, p);
	delCount = 0;
	insCount = 0;
	setBufSize(bufLen);
    }
    selStart = newStart;
    selEnd = newEnd;
    update(flags);
}

void TEditor::setState( ushort aState, Boolean enable )
{
    TView::setState(aState, enable);
    switch( aState )
	{
	case sfActive:
	    if( hScrollBar != 0 )
		hScrollBar->setState(sfVisible, enable);
	    if( vScrollBar != 0 )
		vScrollBar->setState(sfVisible, enable);
	    if( indicator != 0 )
		indicator->setState(sfVisible, enable);
	    updateCommands();
	    break;

	case sfExposed:
	    if( enable == True )
		unlock();
	}
}

void TEditor::startSelect()
{
    hideSelect();
    selecting = True;
}

void TEditor::toggleInsMode()
{
    overwrite = Boolean(!overwrite);
    setState(sfCursorIns, Boolean(!getState(sfCursorIns)));
}

void TEditor::trackCursor( Boolean center )
{
    if( center == True )
	scrollTo( curPos.x - size.x + 1, curPos.y - size.y / 2);
    else
	scrollTo( max(curPos.x - size.x + 1, min(delta.x, curPos.x)),
		  max(curPos.y - size.y + 1, min(delta.y, curPos.y)));
}

void TEditor::undo()
{
    if( delCount != 0 || insCount != 0 )
	{
	selStart = curPtr - insCount;
	selEnd = curPtr;
	uint32 length = delCount;
	delCount = 0;
	insCount = 0;
	insertBuffer(buffer, curPtr + gapLen - length, length, False, True);
	}
}

void TEditor::unlock()
{
    if( lockCount > 0 )
	{
	lockCount--;
	if( lockCount == 0 )
	    doUpdate();
	}
}

void TEditor::update( uchar aFlags )
{
    updateFlags |= aFlags;
    if( lockCount == 0 )
	doUpdate();
}

void TEditor::updateCommands()
{
    setCmdState( cmUndo, Boolean( delCount != 0 || insCount != 0 ) );
    if( isClipboard() == False )
	{
	setCmdState(cmCut, hasSelection());
	setCmdState(cmCopy, hasSelection());
	setCmdState(cmPaste,
		    Boolean(clipboard != 0 && (clipboard->hasSelection())) );
	}
    setCmdState(cmClear, hasSelection());
    setCmdState(cmFind, True);
    setCmdState(cmReplace, True);
    setCmdState(cmSearchAgain, True);
}

Boolean TEditor::valid( ushort )
{
  return isValid;
}

void TEditor::write( opstream& os )
{
    TView::write( os );
    os << hScrollBar << vScrollBar << indicator
       << bufSize << (short)canUndo;
}

void *TEditor::read( ipstream& is )
{
    TView::read( is );
    short temp;
    is >> hScrollBar >> vScrollBar >> indicator
       >> bufSize >> temp;
    canUndo = Boolean(temp);
    selecting = False;
    overwrite = False;
    autoIndent = False;
    lockCount = 0;
    keyState = 0;
    initBuffer();
    if( buffer != 0 )
	isValid = True;
    else
	{
	TEditor::editorDialog( edOutOfMemory, 0 );
	bufSize = 0;
	}
    lockCount = 0;
    lock();
    setBufLen( 0 );
    return this;
}

TStreamable *TEditor::build()
{
    return new TEditor( streamableInit );
}

TEditor::TEditor( StreamableInit ) : TView( streamableInit )
{
}


// EDITS.CC

char TEditor::bufChar( uint32 p )
{
  if (p>=curPtr) p+=gapLen;
  return buffer[p];
}

uint32 TEditor::bufPtr(uint32 p)
{
  if (p<curPtr) return p;
  return (p+gapLen);
}

uint32 TEditor::lineEnd(uint32 p)
{
#if 1
  int32 di = p,cx,bx;
  bx = 0;
  cx = curPtr-di;
  if (cx<=0) goto lab1;
//  di += bx;
  while (cx--)
  {
    if (buffer[di++] == 0x0d) goto lab2;
    if (buffer[di-1] == 0x0a) goto lab2;
  }
  di = curPtr;
lab1:
  cx = bufLen;
  cx -= di;
  if (!cx) return di;
  bx += gapLen;
  di += bx;
  while (cx--)
  {
    if (buffer[di++] == 0x0d) goto lab2;
    if (buffer[di-1] == 0x0a) goto lab2;
  }
  goto lab3;
lab2:
  di--;
lab3:
  di-=bx;
  return di;
#else
  if (p == bufLen) return p;
  char c=bufChar(p);
  while (c != 0x0d && c != 0x0a)
  {
    p++;
    if (p == bufLen) return p;
    c = bufChar(p);
  };
  return p;
#endif
}

uint32 TEditor::lineStart(uint32 p)
{
  int32 di = p,cx,bx;
  bx = 0;
  cx = di;
  cx -= curPtr;
  if (cx<=0) goto lab1;
  bx += gapLen;
  di += bx;
  di--;
  while (cx--)
  {
    if (buffer[di--] == 0x0d) goto lab2;
    if (buffer[di+1] == 0x0a) goto lab2;
  }
  bx -= gapLen;
  di = curPtr;
lab1:
  cx = di;
  if (!cx) goto lab4;
  di += bx;
  di--;
  while (cx--)
  {
    if (buffer[di--] == 0x0d) goto lab2;
    if (buffer[di+1] == 0x0a) goto lab2;
  }
  goto lab3;
lab2:
  di++;
  di++;
  di -= bx;
  if ((uint32)di == curPtr) goto lab4;
  if ((uint32)di == bufLen) goto lab4;
  if (buffer[di+bx] != 0x0a) goto lab4;
  di++;
  goto lab4;
lab3:
  di = 0;
lab4:
  return di;
}

uint32 TEditor::nextChar(uint32 p)
{
  uint32 gl=0;
  if (p == bufLen) return p;
  p++;
  if (p == bufLen) return p;
  if (p >= curPtr) gl = gapLen;
  if (buffer[gl+p] == 0x0a && buffer[gl+p-1] == 0x0d) return (p+1);
  return p;
}

uint32 TEditor::prevChar(uint32 p)
{
  uint32 gl=0;
  if (!p) return p;
  p--;
  if (!p) return p;
  if (p >= curPtr) gl = gapLen;
  if (buffer[gl+p] == 0x0a && buffer[gl+p-1] == 0x0d) return (p-1);
  return p;
}

// EDITSTAT.CC

ushort defEditorDialog( int, ... )
{
    return cmCancel;
}

TEditorDialog near TEditor::editorDialog = defEditorDialog;
ushort near TEditor::editorFlags = efBackupFiles | efPromptOnReplace;
char near TEditor::findStr[maxFindStrLen] = "";
char near TEditor::replaceStr[maxReplaceStrLen] = "";
TEditor * near TEditor::clipboard = 0;
uint32 TEditor::tabSize = 8;
