#define Uses_TScreen
#define Uses_TEvent
#define Uses_TFrame
#include <tv.h>

#include <dos.h>
#include <go32.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif

#include <conio.h>
#include <pc.h>
#include <sys/farptr.h>

static ushort Equipment;
static uchar CrtInfo;
static uchar CrtRows;

ushort * TDisplay::equipment = &Equipment;
uchar * TDisplay::crtInfo = &CrtInfo;
uchar * TDisplay::crtRows = &CrtRows;

REGS r_display;

#define r (r_display)
#define AL (r.h.al)
#define BL (r.h.bl)
#define DL (r.h.dl)
#define AH (r.h.ah)
#define BH (r.h.bh)
#define DH (r.h.dh)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

ushort TDisplay::getCursorType()
{
    AH = 3;
    BH = TScreen::GetPage();
    videoInt();
    return CX;
}

void TDisplay::setCursorType( ushort ct )
{
    AH = 1;
    CX = ct;
    BH = TScreen::GetPage();
    videoInt();
}

void TDisplay::clearScreen( uchar w, uchar h )
{
  ScreenClear();
}

void TDisplay::videoInt()
{
    INTR(0x10,r_display);
}

ushort TDisplay::getRows()
{
  return ScreenRows();
}

ushort TDisplay::getCols()
{
  return ScreenCols();
}

ushort TDisplay::getCrtMode()
{
  ushort mode = ScreenMode();
  if (mode == smCO80) switch (getRows())
  {
    case 50: mode += 0x100;
    case 43: mode += 0x100;
    case 40: mode += 0x100;
    case 35: mode += 0x100;
    case 28: mode += 0x100;
      break;
  }
  return mode;
}

extern int emulate_mouse;

void TDisplay::setCrtMode( ushort mode )
{
  if ((mode & 0xFF) == smCO80)
  {
    textmode(C80);
    switch (mode >> 8)
    {
      case 1:
        _set_screen_lines(28);
        break;
      case 2:
        _set_screen_lines(35);
        break;
      case 3:
        _set_screen_lines(40);
        break;
      case 4:
        _set_screen_lines(43);
        break;
      case 5:
        _set_screen_lines(50);
        break;
    }
    emulate_mouse = 0;
  }
  else
  {
    textmode(mode);
    _farpokeb(_dos_ds,0xb8000,'!');
    AX = 0x200;
    BH = 0;
    DX = 0;
    videoInt();
    AH = 0x0A;
    AL = ' ';
    BH = 0;
    CX = 1;
    videoInt();
    if (_farpeekb(_dos_ds,0xb8000) != ' ')
    {
      textmode(0x03);
      emulate_mouse = 0;
    }
    else
    {
      emulate_mouse = 1;
    }
  }
  if (TMouse::present()) TMouse::setRange(getCols()-1,getRows()-1);
}

static unsigned getCodePage()
{
    //  get version number, in the form of a normal number
    AX = 0x3000;
    INTR(0x21,r);
    unsigned ver = (AH) | ((AL && 0xff) << 8);
    if( ver < 0x30C )
        return 437; // United States code page, for all versions before 3.3

    AX = 0x6601;
    INTR(0x21,r);
    return BX;
}

void TDisplay::updateIntlChars()
{
    if(getCodePage() != 437 )
        TFrame::frameChars[30] = '';
}
