#include <io.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <sys/stat.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>

int force=0;
int recurse=0;

int remove_file(const char *name)
{
  int erg;
  struct stat s;
#ifdef DEBUG
  fprintf(stderr,"remove_file: %s\n",name);
#endif
  stat(name,&s);
#define REMOVE(s,n) (s.st_mode & S_IFDIR ? rmdir(n) : remove(n))
  if (s.st_mode & S_IWRITE) REMOVE(s,name);
  else
  {
    int _force = force;
    if (!force)
    {
      char c;
      fprintf(stderr,"remove %s ? [Y/N] ",name);
      fflush(stderr);
      if (toupper(getchar()) == 'Y') _force = 1;
    }
    if (_force)
    {
      chmod(name,S_IREAD|S_IWRITE);
      erg = REMOVE(s,name);
    }
  }
#undef REMOVE
  return erg;
}

static char name[512];

int remove_path(const char *filename)
{
  struct ffblk ffblk;
  int done,retval = 0;
  char *path,*tmp;
  path = (char *)malloc(strlen(filename)+1);
  strcpy(path,filename);
  tmp = strrchr(path,'/');
  if (!tmp) tmp = strrchr(path,'\\');
  if (!tmp) strcpy(path,".");
  else *tmp = 0;
  done = findfirst(filename,&ffblk,FA_DIREC);
  while (!done)
  {
     if (ffblk.ff_name[0] == '.')
     {
       done = findnext(&ffblk);
       continue;
     }
     if (ffblk.ff_attrib & FA_DIREC)
     {
       tmp = (char *)malloc(strlen(path)+strlen(ffblk.ff_name)+6);
       strcpy(tmp,path);
       strcat(tmp,"/");
       strcat(tmp,ffblk.ff_name);
       strcat(tmp,"/*.*");
       if (!recurse)
       {
	 struct ffblk ff;
	 int d=findfirst(tmp,&ff,FA_DIREC),r=0;
	 while (d==0)
	 {
	   if (ff.ff_name[0] == '.')
	   {
	     d = findnext(&ff);
	     continue;
	   }
	   r = 1;
	   break;
	 }
	 if (r)
	 {
	   fprintf(stderr,"%s/%s is a directory and not empty!!\n",path,ffblk.ff_name);
	   retval = 1;
	   done = findnext(&ffblk);
	   free(tmp);
	   continue;
	 }
	 free(tmp);
       }
       else retval |= remove_path(tmp);
       free(tmp);
     }
     strcpy(name,path);
     strcat(name,"/");
     strcat(name,ffblk.ff_name);
     retval |= remove_file(name);
     done = findnext(&ffblk);
  }
  free(path);
  return retval;
}


int main(int argc,char *argv[])
{
  int i;
  int erg;
  char *path,*tmp;
  for (i=1;i<argc;i++)
  {
    if (argv[i][0]=='-')
    {
      char *tmp=argv[i];
      while (*tmp)
      {
	if (*tmp == 'f') force=1;
	else
	if (*tmp == 'r') recurse=1;
	else
	;
	tmp++;
      }
      continue;
    }
#ifdef DEBUG
    fprintf(stderr,"force: %d     recurse: %d\n",force,recurse);
#endif
    erg = remove_path(argv[i]);
#ifdef DEBUG
    fprintf(stderr,"remove_path: %s (%s)\n",argv[i],erg?"not ok":"ok");
#endif
  }
  return 0;
}
