%x string
%x commentC
%x commentCC
%option noyywrap

WS			[\t \n]*

%{
#include <stdio.h>
#include <string.h>
#include "macparse.h"
char octchar(char *);
char hexchar(char *);
char ansichar(char *);
%}

%%

macro			{ return MACROSTART;}
endm			{ return MACROEND;}
InsertText		{ return INSERTTEXT; }
[a-zA-Z\_]+[0-9]*	{ strcpy(yylval.name,yytext); return ID;}
[0-9]+			{ yylval.u = atoi(yytext); return NUM;}
=			{ return EQUAL;}
;			{ return SEMI;}
:			{ return COLON; }
"("			{ return LBRACE; }
")"			{ return RBRACE; }
{WS}
\"			{ BEGIN(string); return STRINGSTART; }
<string>[^\\\"]		{ yylval.c = *yytext; return CHAR; }
<string>\\[0-7]{1,3}	{ yylval.c = octchar(yytext); return CHAR; }
<string>\\x[0-9a-fA-F]{1,2}	{ yylval.c = hexchar(yytext); return CHAR; }
<string>\\[abfnrtv]	{ yylval.c = ansichar(yytext); return CHAR; }
<string>\"		{ BEGIN(INITIAL); return STRINGEND; }
"/*"			BEGIN(commentC);
"//"			BEGIN(commentCC);
<commentC>[^*]*
<commentC>"*"+[^*/]*
<commentC>"*"+"/"{WS}	BEGIN(INITIAL);
<commentCC>[^\n]*
<commentCC>\n		BEGIN(INITIAL);
%%

char octchar(char * text)
{
  int d;
  sscanf(text+1,"%o",&d);
  return (char)d;
}

char hexchar(char * text)
{
  int d;
  sscanf(text+2,"%x",&d);
  return (char)d;
}

char ansichar(char * text)
{
  switch (text[1])
  {
    case 'a' : return '\a';
    case 'b' : return '\b';
    case 'f' : return '\f';
    case 'n' : return '\n';
    case 'r' : return '\r';
    case 't' : return '\t';
    case 'v' : return '\v';
    default : return ' ';
  }
}

