#include <dos.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif

unsigned short getshiftstate(void)
{
  REGS r;
  r.h.ah = 0x12;
  INTR(0x16,r);
  return r.x.ax;
}

unsigned short gkey(void)
{
  REGS r;
  r.h.ah = 0x10;
  INTR(0x16,r);
  if (r.h.al == 0xE0 || r.h.al == 0) r.h.al = 0;
  unsigned short S = getshiftstate();
  switch (r.h.ah)
  {
    case 0x39: if (S & 0x0008) r.x.ax = 0x0200; break; // kbAltSpace
    case 0x92: if (S & 0x0004) r.h.ah = 0x04;   break; // kbCtrlIns
    case 0x52: if (S & 0x0003) r.h.ah = 0x05;   break; // kbShiftIns
    case 0x93: if (S & 0x0004) r.h.ah = 0x06;   break; // kbCtrlDel
    case 0x53: if (S & 0x0003) r.h.ah = 0x07;   break; // kbShiftDel
  }
  return r.x.ax;
}
  
#ifdef TEST
#include <stdio.h>
main()
{
  unsigned short key;
  do
  {
    key = gkey();
    fprintf(stdout,"%04X\n",key);
  } while (1);
}
#endif
