#define Uses_TEvent
#include <tv.h>

#include <dos.h>
#include <stdio.h>

uchar near THWMouse::buttonCount = 0;
Boolean near THWMouse::handlerInstalled = False;
Boolean near THWMouse::noMouse = False;

#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif
#include <conio.h>
#include <sys/farptr.h>
#include <go32.h>

#define AX r.x.ax
#define BX r.x.bx
#define CX r.x.cx
#define DX r.x.dx

static unsigned short mouse_char;
static int last_x = 0,last_y = 0;
static int cols;
static int visible = 0;
int emulate_mouse = 0;

static void get_mouse_char()
{
  mouse_char = _farpeekw(_dos_ds,0xB8000+(last_y*cols+last_x)*2);
}

static void set_mouse_char()
{
  unsigned short c = mouse_char ^ 0x7F00;
  _farpokew(_dos_ds,0xB8000+(last_y*cols+last_x)*2,c);
}

static void reset_mouse_char()
{
  _farpokew(_dos_ds,0xB8000+(last_y*cols+last_x)*2,mouse_char);
}

static void show_mouse_char()
{
  if (!visible) return;
  get_mouse_char();
  set_mouse_char();
}

int draw_mouse(int x,int y)
{
  if (x != last_x || y != last_y)
  {
    if (!emulate_mouse) return 1;
    if (visible) reset_mouse_char();
    last_x = x;
    last_y = y;
    show_mouse_char();
    return 1;
  }
  return 0;
}   

THWMouse::THWMouse()
{
    resume();
}

void THWMouse::resume()
{
    REGS r;
    AX = 0;
    INTR(0x33,r);
    if (!AX)
        return;
    buttonCount = BX & 0x00ff;
    AX = 4;
    CX = DX = 0;
    INTR(0x33,r);
}

THWMouse::~THWMouse()
{
    suspend();
}

void THWMouse::suspend()
{
    if( present() == False )
        return;
    hide();
    if( handlerInstalled == True )
        {
        registerHandler( 0, 0 );
        handlerInstalled = False;
        }
    buttonCount = 0;
}

void THWMouse::show()
{
  if (!emulate_mouse)
  {
    REGS r;
    if ( present() )
    {
      AX = 1;
      INTR(0x33,r);
    }
  }
  else
  {
    if (!present() || visible) return;
    visible = 1;
    show_mouse_char();
  }
}

void THWMouse::hide()
{
  if (!emulate_mouse)
  {
    REGS r;
    if ( buttonCount != 0 )
    {
      AX = 2;
      INTR(0x33,r);
    }
  }
  else
  {
    if (!present() || !visible) return;
    visible = 0;
    reset_mouse_char();
  }
}

void THWMouse::setRange( ushort rx, ushort ry )
{
    cols = (int)rx+1;
    REGS r;
    DX = rx << 3;
    CX = 0;
    AX = 7;
    INTR(0x33,r);
    DX = ry << 3;
    CX = 0;
    AX = 8;
    INTR(0x33,r);
}

void THWMouse::getEvent( MouseEventType& me )
{
    REGS r;
    int x,y;
    AX = 3;
    INTR(0x33,r);
    me.buttons = BX & 0x00ff;
    x = me.where.x = (CX >> 3) & 0xFF;
    y = me.where.y = (DX >> 3) & 0xFF;
    me.doubleClick = False;
    draw_mouse(x,y);
}

extern _go32_dpmi_seginfo mouseIntInfo;
extern _go32_dpmi_registers mouseIntRegs;

void THWMouse::registerHandler( unsigned mask, void (far *func)() )
{
#if defined( ProtectVersion )
  mouseIntRegs.x.ax = 20;
#else
  mouseIntRegs.x.ax = 12;
  mouseIntRegs.x.ax = 20;
#endif
  mouseIntRegs.x.cx = mask;
  if (func == NULL)
  {
    mouseIntRegs.x.dx = 0;
    mouseIntRegs.x.es = 0;
  }
  else
  {
    mouseIntRegs.x.dx = mouseIntInfo.rm_offset;
    mouseIntRegs.x.es = mouseIntInfo.rm_segment;
  }
  __dpmi_int(0x33,&mouseIntRegs);
  handlerInstalled = True;
}

