#define Uses_TDirCollection
#define Uses_TDirEntry
#define Uses_opstream
#define Uses_ipstream
#define Uses_TStreamableClass
#include <tv.h>

#include <dir.h>
#include <string.h>
#include <dos.h>

#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)

Boolean driveValid( char drive )
{
    REGS r;
    r.x.ax = 0x3600;
    r.x.dx = drive - 'A' - 1;
    INTR(0x21,r);
    r.x.ax++;
    if (r.x.ax != 0xFFFF) return True;
    return False;
}

#if 1
extern "C" unsigned short ffattrib(struct ffblk *);
#define A(s) ffattrib(&s)
#else
#define A(s) s.ff_attrib
#endif

Boolean isDir( const char *str )
{
    ffblk ff;
    return Boolean( findfirst( str, &ff, FA_DIREC ) == 0 &&
                    (A(ff) & FA_DIREC) != 0 );
}

Boolean pathValid( const char *path )
{
    char expPath[MAXLFNPATH];
    strcpy( expPath, path );
    fexpand( expPath );
    int len = strlen(expPath);
    if( len <= 3 )
        return driveValid(expPath[0]);

    if( expPath[len-1] == DIRSEPARATOR )
        expPath[len-1] = EOS;

    return isDir( expPath );
}

Boolean validFileName( const char *fileName )
{
    static const char * const illegalChars = ";,=+<>|\"[] "DIRSEPARATOR_;
    char path[MAXLFNPATH];
    char dir[MAXLFNPATH];
    char name[MAXLFN];
    char ext[MAXLFN];
    fnsplit( fileName, path, dir, name, ext );
    strcat( path, dir );
    if( *dir != EOS && !pathValid( path ) )
        return False;
    if( strpbrk( name, illegalChars ) != 0 ||
        (*ext != 0 && (
        strpbrk( ext+1, illegalChars) != 0 ||
        strchr( ext+1, '.' ) != 0
        ))
      )
        return False;
    return True;
}

void getCurDir( char *dir )
{
    dir[0] = getdisk() + 'a';
    dir[1] = ':';
    dir[2] = DIRSEPARATOR;
    getcurdir( 0, dir+3 );
    if( strlen( dir ) > 3 )
	strcat( dir, DIRSEPARATOR_ );
}

Boolean isWild( const char *f )
{
    return Boolean( strpbrk( f, "?*" ) != 0 );
}

TStreamable *TDirCollection::build()
{
    return new TDirCollection( streamableInit );
}

void TDirCollection::writeItem( void *obj, opstream& os )
{
    TDirEntry *item = (TDirEntry *)obj;
    os.writeString( item->text() );
    os.writeString( item->dir() );
}

void *TDirCollection::readItem( ipstream& is )
{
    const char *txt = is.readString();
    const char *dir = is.readString();
    return new TDirEntry( txt, dir );
}
