#define Uses_TCommandSet
#include <tv.h>

unsigned long TCommandSet::masks[32] =
{
    0x00000001,
    0x00000002,
    0x00000004,
    0x00000008,
    0x00000010,
    0x00000020,
    0x00000040,
    0x00000080,
    0x00000100,
    0x00000200,
    0x00000400,
    0x00000800,
    0x00001000,
    0x00002000,
    0x00004000,
    0x00008000,
    0x00010000,
    0x00020000,
    0x00040000,
    0x00080000,
    0x00100000,
    0x00200000,
    0x00400000,
    0x00800000,
    0x01000000,
    0x02000000,
    0x04000000,
    0x08000000,
    0x10000000,
    0x20000000,
    0x40000000,
    0x80000000
};

TCommandSet::TCommandSet()
{
    for( int i = 0; i < 32; i++ )
        cmds[i] = 0;
}

TCommandSet::TCommandSet( const TCommandSet& tc )
{
    for( int i = 0; i < 32; i++ )
        cmds[i] = tc.cmds[i];
}

Boolean TCommandSet::has( int cmd )
{
    return Boolean( (cmds[ loc( cmd ) ] & mask( cmd )) != 0 );
}

void TCommandSet::disableCmd( int cmd )
{
    cmds[ loc( cmd ) ] &= ~mask( cmd );
}

void TCommandSet::enableCmd( const TCommandSet& tc )
{
    for( int i = 0; i < 32; i++ )
        cmds[i] |= tc.cmds[i];
}

void TCommandSet::disableCmd( const TCommandSet& tc )
{
    for( int i = 0; i < 32; i++ )
        cmds[i] &= ~(tc.cmds[i]);
}

void TCommandSet::enableCmd( int cmd )
{
    cmds[ loc( cmd ) ] |= mask( cmd );
}

TCommandSet& TCommandSet::operator &= ( const TCommandSet& tc )
{
    for( int i = 0; i < 32; i++ )
        cmds[i] &= tc.cmds[i];
    return *this;
}

TCommandSet& TCommandSet::operator |= ( const TCommandSet& tc )
{
    for( int i = 0; i < 32; i++ )
        cmds[i] |= tc.cmds[i];
    return *this;
}

TCommandSet operator & ( const TCommandSet& tc1, const TCommandSet& tc2 )
{
    TCommandSet temp( tc1 );
    temp &= tc2;
    return temp;
}

TCommandSet operator | ( const TCommandSet& tc1, const TCommandSet& tc2 )
{
    TCommandSet temp( tc1 );
    temp |= tc2;
    return temp;
}

Boolean TCommandSet::isEmpty()
{
    for( int i = 0; i < 32; i++ )
        if( cmds[i] != 0 )
            return False;
    return True;
}

int operator == ( const TCommandSet& tc1, const TCommandSet& tc2 )
{
    for( int i = 0; i < 32; i++ )
        if( tc1.cmds[i] != tc2.cmds[i] )
            return 0;
    return 1;
}

