#define Uses_TKeys
#define Uses_TColorSelector
#define Uses_TMonoSelector
#define Uses_TColorDisplay
#define Uses_TColorItem
#define Uses_TColorItemList
#define Uses_TColorGroup
#define Uses_TColorGroupList
#define Uses_TColorDialog
#define Uses_TEvent
#define Uses_TDrawBuffer
#define Uses_TGroup
#define Uses_TScrollBar
#define Uses_TLabel
#define Uses_TButton
#define Uses_TRect
#define Uses_opstream
#define Uses_ipstream
#include <tv.h>

#include <string.h>

TColorDialog::TColorDialog( TPalette *aPalette, TColorGroup *aGroups ):
    TDialog( TRect( 0, 0, 61, 18 ), colors )
    , TWindowInit( &TColorDialog::initFrame )
{
    options |= ofCentered;
    pal = aPalette;

    TScrollBar *sb = new TScrollBar( TRect( 18, 3, 19, 14 ) );
    insert( sb );

    groups = new TColorGroupList( TRect( 3, 3, 18, 14 ), sb, aGroups);
    insert( groups );
    insert( new TLabel( TRect( 2, 2, 3+cstrlen(groupText), 3 ), groupText, groups ) );

    sb = new TScrollBar( TRect( 41, 3, 42, 14 ) );
    insert( sb );

    TView *p = new TColorItemList( TRect( 21, 3, 41, 14 ), sb, aGroups->items );
    insert( p );
    insert( new TLabel( TRect( 20, 2, 21+cstrlen(itemText), 3 ), itemText, p ) );

    forSel = new TColorSelector( TRect( 45, 3, 57, 7 ),
                                 TColorSelector::csForeground );
    insert( forSel );
    forLabel = new TLabel( TRect( 45, 2, 46+cstrlen(forText), 3 ), forText, forSel );
    insert( forLabel );

    bakSel = new TColorSelector( TRect( 45, 9, 57, 11 ),
                                 TColorSelector::csBackground );
    insert( bakSel );
    bakLabel = new TLabel( TRect( 45, 8, 46+cstrlen(bakText), 9 ), bakText, bakSel );
    insert( bakLabel );

    display = new TColorDisplay( TRect( 44, 12, 58, 14 ), textText );
    insert( display );

    monoSel = new TMonoSelector( TRect( 44, 3, 59, 8 ) );
    monoSel->hide();
    insert( monoSel );
    monoLabel = new TLabel( TRect( 43, 2, 44+cstrlen(colorText), 3 ), colorText, monoSel );
    monoLabel->hide();
    insert( monoLabel );

    if( aGroups != 0 && aGroups->items != 0 && pal)
        display->setColor( (uchar *)&pal->data[ aGroups->items->index ] );

    insert( new TButton( TRect( 36, 15, 46, 17 ), okText, cmOK, bfDefault ) );
    insert( new TButton( TRect( 48, 15, 58, 17 ),
                         cancelText,
                         cmCancel,
                         bfNormal ) );
    selectNext( False );
}

TColorDialog::~TColorDialog()
{ 
}  

void TColorDialog::handleEvent( TEvent& event )
{
    TDialog::handleEvent( event );
    if( event.what==evBroadcast && event.message.command==cmNewColorIndex )
        display->setColor( (uchar *)&pal->data[event.message.infoByte] );
}

uint32 TColorDialog::dataSize()
{
    return *pal->data + 1;
}

void TColorDialog::getData( void *rec )
{
    memcpy( rec, pal->data, *pal->data+1 );
}

void TColorDialog::setData( void *rec)
{
    TPalette *p = (TPalette *)rec;

    memcpy( pal->data, p->data, *p->data+1 );
    display->setColor( (uchar *)&pal->data[1] );
    groups->focusItem( 0 );
    if( showMarkers )
        {
        forLabel->hide();
        forSel->hide();
        bakLabel->hide();
        bakSel->hide();
        monoLabel->show();
        monoSel->show();
        }
    groups->select();
}

void TColorDialog::write( opstream& os )
{
    TDialog::write( os );
    os << display << groups << forLabel << forSel
       << bakLabel << bakSel << monoLabel << monoSel;
}

void *TColorDialog::read( ipstream& is )
{
    TDialog::read( is );
    is >> display >> groups >> forLabel >> forSel
       >> bakLabel >> bakSel >> monoLabel >> monoSel;
    pal = 0;
    return this;
}

TStreamable *TColorDialog::build()
{
    return new TColorDialog( streamableInit );
}

TColorDialog::TColorDialog( StreamableInit ) :
    TDialog( streamableInit )
    , TWindowInit( &TColorDialog::initFrame )
{
}

