%{
#define Uses_fpstream
#define Uses_TKeys
#define Uses_TMacro
#define Uses_TVEdConstant
#define Uses_TEvent
#define Uses_TMacroCollection
#define Uses_TMacroRec
#include <tv.h>
#include <macedit.h>
#include <string.h>
#include <stdlib.h>
void addconst(char *,unsigned short);
unsigned short getvalue(char *);
int addaction(char *);
int addInsert(char *);
int keybinding(char *,unsigned short);
void startmacro(char *);
void endmacro();
int yylex();
int yyerror(char *);
int Error;
static char String[1000];
static int StringPos;
#define ERROR return Error
%}

%union {
  unsigned short u;
  char name[256];
  char c;
}

%token <u> NUM
%token <name> ID
%token MACROSTART
%token MACROEND
%token <c> CHAR
%type <name> STRING
%token SEMI
%token EQUAL
%token INSERTTEXT
%token LBRACE
%token RBRACE
%token COLON
%token STRINGSTART
%token STRINGEND
%%

input:	  /* empty */
	| input line
;

line:	  decl
	| macro
;

decl:	  ID EQUAL NUM SEMI { addconst($1,$3); }
	| ID EQUAL ID SEMI { unsigned short value=getvalue($3);
			     if (value==USHRT_MAX) ERROR;
			     addconst($1,value); }
	| ID COLON ID SEMI { unsigned short value=getvalue($1);
			     if (value==USHRT_MAX) ERROR;
			     if (!keybinding($3,value)) ERROR; }
;

macro:	  MACROSTART ID { startmacro($2); } expseq MACROEND { endmacro(); }
;

expseq:   expr
	| expseq SEMI expr
;

expr:	  /* empty */
	| ID { if (!addaction($1)) ERROR; }
	| INSERTTEXT LBRACE STRING RBRACE { if (!addInsert($3)) ERROR; }
;

STRING:	  STRINGSTART { StringPos = 0; } CHARS { String[StringPos] = 0; strcpy($$,String); } STRINGEND
;

CHARS:	  CHAR { String[StringPos++] = $1; }
	| CHARS CHAR { String[StringPos++] = $2; }
;

%%

static TMacro * macro;

void addconst(char *name,unsigned short value)
{
  UserConstantsCount++;
  UserConstants = (Const_Rec *)realloc(UserConstants,UserConstantsCount*sizeof(Const_Rec));
  UserConstants[UserConstantsCount-1].code = value;
  UserConstants[UserConstantsCount-1].Name = strdup(name);
#if YYDEBUG != 0
  if (yydebug) printf("AddConst(%s,%d)\n",name,value);
#endif
}

unsigned short getvalue(char *name)
{
  int i=0;
#if YYDEBUG != 0
  if (yydebug) printf("GetValue(%s)\n",name);
#endif
  while (StdConstants[i].Name) {
    if (strcmp(StdConstants[i].Name,name) == 0) return StdConstants[i].code;
    i++;
  };
  for (i=0;i<UserConstantsCount;i++)
  {
    if (strcmp(UserConstants[i].Name,name) == 0) return UserConstants[i].code;
  }
  Error = UNKNOWN_IDENTIFER;
  return USHRT_MAX;
}

int addaction(char *name)
{
  unsigned short value=getvalue(name);
  ccIndex index;
#if YYDEBUG != 0
  if (yydebug) printf("AddAction(%s)\n",name);
#endif
  if (value != USHRT_MAX)
  {
    macro->insert(new TMacroRec(value));
    return 1;
  }
  TMacro * temp = new TMacro(name,kbNoKey);
  if (macros->search(temp,index))
  {
    macro->insert(new TMacroRec(name));
    delete temp;
    return 1;
  }
  delete temp;
  Error = UNKNOWN_MACRO;
  return 0;
}

int addInsert(char * text)
{
  TMacroRec * mr = new TMacroRec(text);
  mr->type = Insert_Command;
  macro->insert(mr);
#if YYDEBUG != 0
  if (yydebug) printf("AddInsert(%s)\n",text);
#endif
  return 1;
}

int keybinding(char * name,unsigned short key)
{
  TMacro * temp = new TMacro(name,kbNoKey);
  ccIndex index;
#if YYDEBUG != 0
  if (yydebug) printf("KeyBinding(%s,%d)\n",name,key);
#endif
  if (macros->search(temp,index))
  {
    ((TMacro *)macros->at(index))->key = key;
    delete temp;
    return 1;
  }
  delete temp;
  Error = UNKNOWN_MACRO;
  return 0;
}

void startmacro(char *name)
{
  macro = new TMacro(name,kbNoKey);
#if YYDEBUG != 0
  if (yydebug) printf("StartMacro(%s)\n",name);
#endif
}

void endmacro()
{
  macros->insert(macro);
#if YYDEBUG != 0
  if (yydebug) printf("EndMacro\n");
#endif
}

int yyerror(char *)
{
  return 1;
}
