#if ( __GNUC_MINOR__ < 7 )
#pragma interface
#endif

/***************************************************************/
/*                                                             */
/*  this header-file was modified by Robert Hoehne             */
/*  to use it with DJ's port of gcc                            */
/*                                                             */
/***************************************************************/


/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   TEXTVIEW.H                                                            */
/*                                                                         */
/*   Copyright (c) Borland International 1991                              */
/*   All Rights Reserved.                                                  */
/*                                                                         */
/*   defines the classes TTextDevice and TTerminal                         */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#if defined( Uses_TTextDevice ) && !defined( __TTextDevice )
#define __TTextDevice

#include <iostream.h>

class far TRect;
class far TScrollBar;

class TTextDevice : public streambuf, public TScroller
/* I have changed the order of the basclasses, because there is a bug in
   the iostream libraray. The functions in this library call the functions
   if of a streambuf object with a this pointer to the streambuf object,
   and not, when the object has multiple base classes, with the this pointer
   to the real object */
{

public:

    TTextDevice( const TRect& bounds,
                 TScrollBar *aHScrollBar,
                 TScrollBar *aVScrollBar
               );

    virtual int do_sputn( const char *s, int count ) = 0;
    virtual int overflow( int = EOF );

};

#endif  // Uses_TTextDevice

#if defined( Uses_TTerminal ) && !defined( __TTerminal )
#define __TTerminal

class far TRect;
class far TScrollBar;

class TTerminal: public TTextDevice
{

public:

    TTerminal( const TRect& bounds,
	       TScrollBar *aHScrollBar,
	       TScrollBar *aVScrollBar,
	       uint32 aBufSize
	     );
    ~TTerminal();

    virtual int do_sputn( const char *s, int count );

    void bufInc( uint32& val );
    Boolean canInsert( uint32 amount );
    short calcWidth();
    virtual void draw();
    uint32 nextLine( uint32 pos );
    uint32 prevLines( uint32 pos, uint32 lines );
    Boolean queEmpty();

protected:

    uint32 bufSize;
    char *buffer;
    uint32 queFront, queBack;
    void bufDec(uint32& val);
};

#endif  // Uses_TTerminal

#if defined( Uses_otstream ) && !defined( __otstream )
#define __otstream

#include <iostream.h>

class otstream : public ostream
{

public:

    otstream( TTerminal * );

};


#endif

