#include <stdio.h>
#include <time.h>

#include "cpu.h"

void main(void)
{
  char vendorName[24];
  char chipName[50];
  int speed;
  struct tm localtime;
  time_t ltime;
  char date[80];

  FILE *cpuidfile = fopen("cpuid.log", "w");

  if (cpuidfile == NULL)
  {
    printf("Couldn't open CPUID.LOG for write\n");
    exit(1);
  }

  // ota aika
  time (&ltime);
  _localtime(&ltime, &localtime);
  _asctime(&localtime, date);

  // ota tiedot
  printf("\nA CPUID sample program - Sampsa Lehtonen 1998\n\n");
  printf("Please wait while detecting...\n\n");
  cpu_getChipInfo(vendorName, chipName, &speed);

  fprintf(cpuidfile, "Log created at %s\n", date);

  // nyt tiedot
  printf("Vendor: %s\nChip: %s\nSpeed:%4.4fMHz\n", vendorName, chipName, speed / 1000000.0);
  printf("CPU Feature flags: %08x\n", cpu_featureFlag());

  fprintf(cpuidfile, "Vendor: %s\nChip: %s\nSpeed:%4.4fMHz\n", vendorName, chipName, speed / 1000000.0);
  fprintf(cpuidfile, "CPU Feature flags: %08x\n", cpu_featureFlag());

  // ota "alkuperiset" tekstit suoraan sirulta
  cpu_getVendorID(vendorName);
  cpu_getChipID(chipName);

  // nyt ne
  printf("\nFull info (on chip):\n");
  printf("  Vendor <%s>\n", vendorName);
  printf("    Chip <%s>\n", chipName);
  printf("   Family %i\n", cpu_lastFamily); 
  printf("    Model %i\n", cpu_lastModel); 
  printf(" Revision %i\n\n", cpu_lastRev);

  fprintf(cpuidfile, "\nFull name info (on chip):\n");
  fprintf(cpuidfile, "  Vendor <%s>\n", vendorName);
  fprintf(cpuidfile, "    Chip <%s>\n", chipName);
  fprintf(cpuidfile, "   Family %i\n", cpu_lastFamily); 
  fprintf(cpuidfile, "    Model %i\n", cpu_lastModel); 
  fprintf(cpuidfile, " Revision %i\n\n", cpu_lastRev);

  // mit lisvarusteita lytyykn tlt?-)
  if (cpu_featureFlag() & CPU_FPU)
  {
    printf("FPU processor present\n");
    fprintf(cpuidfile, "FPU processor present\n");
  }

  if (cpu_featureFlag() & CPU_MM_EXTENSION)
  {
    printf("MMX processor present\n");
    fprintf(cpuidfile, "MMX processor present\n");
  }

  fclose(cpuidfile);
  
}
