/* Record from SB DAC using DMA mode (up to 64K only) */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <alloc.h>
#include <stdlib.h>

#include "sb.h"

extern int optind;    /* index of which argument is next      */
extern char *optarg;  /* pointer to argument of current option */
extern int opterr;    /* allow error message  */
int getopt(int argc, char *argv[], char *optionS);

void main(int argc, char *argv[])
{
    FILE *f;
    signed char far *raw, far *aligned;
    unsigned sl, sr=11000;
    unsigned long physical, aligned_physical;
    int stereo = 0, error = 0;
    char ch;

    while((ch = getopt(argc,argv,"sr:")) != EOF)
    {
	switch(ch)
	{
	    case 's':
		stereo = 1;
		break;
	    case 'r':
		sr = atoi(optarg);
		break;
	    case '?':
		error++;
		break;
	}
    }
    if(error || optind == argc)
    {
	puts("Usage: recdma [-r rate] [-s] sample");
	exit(1);
    }

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    if(Sb_Init())
    {
	printf("Could not find Soundblaster!\n");
	exit(1);
    }
    printf("Found Soundblaster at address %xh, IRQ %d, DMA %d.\n",
	SbIOaddr,SbIRQ,SbDMAchan);

    f = fopen(argv[optind],"wb");
    if(f == NULL)
    {
	printf("Could not open sample file %s\n",argv[optind]);
	exit(1);
    }

    sl = 64000U;

    raw = (signed char far *)farmalloc((unsigned long)sl + 65535L);
    physical = ((unsigned long)FP_OFF(raw)) + (((unsigned long)FP_SEG(raw)) << 4);
    aligned_physical = physical+0x0FFFFL;
    aligned_physical &= 0xF0000L;
    aligned=MK_FP((unsigned )((aligned_physical >> 4) & 0xFFFF),0);

    Sb_Init_Voice_DMA(NULL);   /* Use default interrupt handler */

    sr = Sb_Sample_Rate(sr,RECORD);
    printf("Sample rate = %u Hz\n",sr);
    printf("Input is %s.\n",(stereo) ? "stereo" : "mono");

    Sb_Voice(0);
    printf("Recording sample\n");

    Sb_Voice_DMA(aligned,sl,stereo,RECORD);

    while(!kbhit() && !Sb_DMA_Complete())
	;
    if(!Sb_DMA_Complete())
    {
	Sb_Halt_DMA();
        sl = dma_addr(SbDMAchan);  /* Find the shortened length */
        Sb_Init(); /* Necessary after early termination of a high-speed xfer */
	getch();
    }

    fwrite(aligned,1,sl,f);
    fclose(f);

    printf("Done.\n");

    Sb_DeInit_Voice_DMA();

    farfree(raw);

    exit(0);
}
