/************************************************************************
; *
; *     File        : VESA.H
; *
; *     Description : Vesa header for VESA 2.00
; *
; *     Copyright (C) 1995,96 RealTech
; *
; ************************************************************************/
#ifndef _SUPERVGA
#define _SUPERVGA

#define LfbMapRealPointer(p) (void*)(((unsigned)(p)>>12)+((p) & 0xFFFF))
#define RGBMask(r,g,b) \
( (  (r)>>(8-modebuf.RedMaskSize  )) << modebuf.RedFieldPosition   )\
+ ( ((g)>>(8-modebuf.GreenMaskSize)) << modebuf.GreenFieldPosition )\
+ ( ((b)>>(8-modebuf.BlueMaskSize )) << modebuf.BlueFieldPosition  )
enum {VESACAPA_WideDac=1,VESACAPA_VgaComp=2,VESA_CAPA_Ramdac=4};
enum {VESA_320x200=0x153,VESA_360x200 =0x156,VESA_320x240  =0x154,
      VESA_360x240=0x157,VESA_320x400 =0x155,VESA_360x400  =0x158,
      VESA_640x350=0x11C,VESA_640x400 =0x100,VESA_640x480  =0x101,
      VESA_800x600=0x101,VESA_1024x768=0x105,VESA_1280x1024=107};
enum {VBE_flip,VBE_copy};

typedef struct {
    short int  ModeAttributes;
    unsigned char WinAAttributes;
    unsigned char WinBAttributes;
    short int WinGranularity;
    short int WinSize;
    short int WinASegment;
    short int WinBSegment;
    long int WinFuncPtr;
    short int BytesPerLine;
    short int XResolution;             // horizontal resolution
    short int YResolution ;            // vertical resolution
    unsigned char XCharSize;           // character cell width
    unsigned char YCharSize ;          // character cell height
    unsigned char NumberOfPlanes;      // number of memory planes
    unsigned char BitsPerPixel ;       // bits per pixel
    unsigned char NumberOfBanks;       // number of banks
    unsigned char MemoryModel  ;       // memory model type
    unsigned char BankSize      ;      // bank size in kb
    unsigned char NumberOfImagePages;  // number of images
    unsigned char Res1              ;  // reserved for page function
    unsigned char RedMaskSize   ;      // size of direct color red mask in bits
    unsigned char RedFieldPosition ;   // bit position of LSB of red mask
    unsigned char GreenMaskSize    ;   // size of direct color green mask in bits
    unsigned char GreenFieldPosition ; // bit position of LSB of green mask
    unsigned char BlueMaskSize       ; // size of direct color blue mask in bits
    unsigned char BlueFieldPosition  ; // bit position of LSB of blue mask
    unsigned char RsvdMaskSize       ; // size of direct color reserved mask in bits
    unsigned char RsvdFieldPosition  ; // size of direct color reserved mask in bits
    unsigned char DirectColorModeInfo; // Direct Color mode attributes
    long PhysBasePtr;                  // Physical Address for linear buffer
    long OffScreenMemOffset;
    short OffScreenMemSize;
    char res2[206];
}VesaModeInfo;
typedef struct {
    char VESASignature[4];             // 4 signature bytes
    short int VESAVersion;             // VESA version number
    char *OEMStringPtr;                // Pointer to OEM string
    unsigned char Capabilities[4];     // capabilities of the video environment
    void *VideoModePtr;                // pointer to supported Super VGA modes
    short int memory;                  // Number of 64kb memory blocks on board
    short OemSoftwareRev;
    long OemVendorNamePtr;
    long OemProductNamePtr;
    long OemProductRevPtr;
    char Reserved[222];
    char OemDATA [256];
}VesaInfoBlock;
typedef struct {
    uchar *Video;
    uchar bankshift;
    uchar videocard;
    uchar Linear;
    uchar Policy;
    uchar Page;
    uchar Card;
    uchar LFB_actived;
    uchar DAC8bit;
    ulong  offset;
    char  *CardName;
    short selector;
    char FAR48 *LFBPtr;
}VesaSystem;

#ifdef __cplusplus
extern "C" {
    #endif

    int VBE_get_LFB_infos(void);
    int VBE_set_gfx_mode(int VESAmode);
    int VBE_set_vesa_mode(int VESAmode);
    int VBE_get_infos(int VESAmode);
    int VBE_get_mode_by_infos(int width,int height,int bbp);
    int VBE_set_mode(int mode);
    int VBE_get_OEM_infos(void);
    int VBE_set_vesa_mode(int VESAmode);
    bool VBE_set8BitPalette(void);
    bool VBE_set6BitPalette(void);
    void CALLING_C VBE_set_palette(ulong a, ulong b, void * pal);
    void VBE_get_palette(int start, int num, uchar *palbuf);
    void CALLING_C BITBLT_xflipVESA(void);
    void VBE_set_scanline_length(long newcx);
    void VBE_set_offset(long x,long y);

    extern VesaInfoBlock vesabuf;
    extern VesaModeInfo modebuf;
    extern VesaSystem VESA;

    #ifdef __cplusplus
}
#endif
#endif


