;/************************************************************************
; *
; *     File        :   DPMI.H
; *
; *     Description :   Header for DPMI functions with Watcom
; *
; *     Copyright (C) 1995 Realtech
; *
; ***********************************************************************/
#ifndef __DPMIHT
#define __DPMIHT


typedef struct {
    unsigned char major;
    unsigned char minor;
    unsigned char realmode,paging;
    unsigned char cpu;
    unsigned char master_pic;
    unsigned char slave_pic;
}PM_DPMIInfo;
typedef struct {
	unsigned int len,sel,off,rseg,roff;
}PM_Buffer;


#ifdef __WATCOM__
void PM_memsetf(unsigned long dst_s,unsigned long dst_o,ulong color,unsigned long n);
#pragma aux PM_memsetf = \
"push es"\
"mov es,bx"\
"push ecx"\
"shr ecx,2"\
"rep stosd"\
"pop ecx"\
"and ecx,3"\
"rep stosb"\
"pop es"\
parm [ebx] [edi] [eax] [ecx];
void PM_memcpyfn(unsigned long dst_s,unsigned long dst_o,void *src,unsigned long n);
#pragma aux PM_memcpyfn = \
"push es"\
"mov es,ax"\
"mov eax,ecx"\
"shr ecx,2"\
"rep movsd"\
"mov ecx,eax"\
"and ecx,3"\
"rep movsb"\
"pop es"\
parm [eax] [edi] [esi] [ecx];
void PM_memcpynf(void *dst,unsigned long src_s,unsigned long src_o,unsigned long n);
#pragma aux PM_memcpynf = \
"push ds"\
"mov ds,ax"\
"mov eax,ecx"\
"shr ecx,2"\
"rep movsd"\
"mov ecx,eax"\
"and ecx,3"\
"rep movsb"\
"pop ds"\
parm [edi] [eax] [esi] [ecx];
#else
       // DJGPP Conventions
       #define PM_memcpynf(dst,src_s,src_o,n) dosmemget(src_s, n, dest);
       #define PM_memcpyfn(dst_s,dst_o,src,n) dosmemput(src, n, dst_s);
#endif

#ifdef __cplusplus
extern "C" {
    #endif
    int  PM_allocSelector(void);
    int  PM_mapPhysicalToLinear(long phyAddr,long limit,ulong *newx);
    ulong PM_memory_left(void);
    void PM_specification(PM_DPMIInfo *Dps);
    void PM_callES(uchar Inte,__dpmi_regs *regs,void *buffer,int size);
    void RM_Free(void);
    void RM_Initialize(void);
    extern PM_DPMIInfo Dps;
    extern PM_Buffer PMB;
    #ifdef __cplusplus
}
#endif
#define PHYSIC_ADRESS(x)   ((((long)x>>16)&(0x0000FFFF))<<4)+((long)x & 0x0000FFFF)
#endif

