;/*************************************************************************
; *
; *     File        : DPMI.C
; *
; *     Description : DPMI Functions
; *
; *     Portability : PC / GNU
; *
; *
; *     Copyright (C) 1995,97 RealTech
; *
; ************************************************************************/
#include <dos.h>
#include <string.h>
#include "_standar.h"
#ifdef __WATCOM__
  #include <i86.h>
  #include "_wdpmi.h"
#else
  #include "dpmi.h"
#endif

#include "_dpmi.h"

PM_DPMIInfo Dps;
PM_Buffer PMB={4096,0,0,0,0};
/*------------------------------------------------------------------------
*
* PROTOTYPE  : void RM_Free(void)
*
* DESCRIPTION :
*
*/
void RM_Free(void)
{
    __dpmi_free_dos_memory(PMB.sel);
    return;
}
/*------------------------------------------------------------------------
*
* PROTOTYPE  :
*
* DESCRIPTION :
*
*/
void RM_Initialize(void)
{
    if (PMB.sel==0)
    {
      __dpmi_allocate_dos_memory(PMB.len,(int*)(&PMB.sel));
      PMB.rseg = __tb;
    }
    return;
}
/*------------------------------------------------------------------------
*
* PROTOTYPE  : void PM_callESDI(__dpmi_regs *regs,void *buffer,int size)
*
* DESCRIPTION : Emule l'interruption 0x10 en mode protg
*
*/
void PM_callES(uchar Inte,__dpmi_regs *regs,void *buffer,int size)
{
    if (PMB.sel==0) RM_Initialize();
    regs->x.es = PMB.rseg;
    PM_memcpyfn(PMB.sel,0,buffer,size);
    __dpmi_int(Inte,regs);
    PM_memcpynf(buffer,PMB.sel,0,size);
    return;
}

/*------------------------------------------------------------------------
*
* PROTOTYPE  : void PM_PM_DPMIInfo(PM_DPMIInfo *Dps)
*
* DESCRIPTION : DPMI informations
*
*/

void PM_specification(PM_DPMIInfo *Dps)
{
    __dpmi_version_ret ret;
    __dpmi_get_version(&ret);
    Dps->minor    =  ret.minor;
    Dps->major    =  ret.major;
    Dps->realmode =  ret.flags & 1;
    Dps->paging   = (ret.flags& 2)!=0;
    Dps->cpu      =  ret.cpu;
    return;
}
/*------------------------------------------------------------------------
*
* PROTOTYPE  :
*
* DESCRIPTION :
*
*/

ulong PM_memory_left(void)
{
    __dpmi_free_mem_info MemInfo;
    __dpmi_get_free_memory_information(&MemInfo);
    return MemInfo.largest_available_free_block_in_bytes;
}
