class TEditorCollection : public TCollection
{
public:

 TEditorCollection(ccIndex aLimit, ccIndex aDelta);
 virtual void freeItem(void *item);
 void addEditor(TCEditWindow *p,int SelectHL=0);
 void addNonEditor(TDskWin *p) { atInsert(Editors,p); nonEditors++; };
 void removeEditor(TCEditWindow *p);
 void removeNonEditor(void *p, int type);
 void getText(char *dest, ccIndex item, short maxLen);
 ccIndex search(void *p,int type);
 ccIndex searchEditorName(char *name);
 int Editors;
 int Closed;
 int nonEditors;

 const char *streamableName() const
     { return name; }
 void *readItem( ipstream& is );
 void writeItem( void *p, opstream &os );
 void write( opstream& os );
 void *read(ipstream& is);

protected:

    TEditorCollection( StreamableInit ) : TCollection ( streamableInit ) {};

public:

    static const char *name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TEditorCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TEditorCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TEditorCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TEditorCollection* cl )
    { return os << (TStreamable *)cl; }


class TListEditors : public TListBox
{
public:
 TListEditors(const TRect& bounds, ushort aNumCols, TScrollBar *aScrollBar) :
   TListBox(bounds,aNumCols,aScrollBar) {};
 virtual void getText(char *dest, ccIndex item, short maxLen);
};

