#define Uses_TDialog
#define Uses_TScrollBar
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TWindowList
#define Uses_TListBox
#define Uses_TSOSCol
#define Uses_TSOSListBox
#define Uses_SOStack
#include <settvuti.h>
#include <edmsg.h>
#include <dskwin.h>
#include <dskmessa.h>
#define Uses_SETAppHelper
#include <setapp.h>

#include <string.h>
#include <stdio.h>

static TEdMsgDialog *MsgWindow=NULL;
static TSOSListBox  *MsgList  =NULL;
static SOStack      *Stack    =NULL;
static TSOSCol      *MsgCol   =NULL;
static TRect MsgWindowRect(-1,-1,-1,-1);

TEdMsgDialog::TEdMsgDialog(const TRect &r,const char *t) :
    TDialog(r,t),
    TWindowInit(TEdMsgDialog::initFrame)
{
 TScrollBar *scrollbar;
 TRect r;
 flags = wfMove | wfGrow | wfZoom | wfClose;
 growMode = gfGrowLoY | gfGrowHiX | gfGrowHiY;
 r=getExtent();
 r.grow(-1,-1);
 scrollbar=standardScrollBar(sbVertical | sbHandleKeyboard);
 MsgList = new TSOSListBox(r,1,scrollbar);
 MsgList->growMode = gfGrowHiX | gfGrowHiY;
 scrollbar=standardScrollBar(sbHorizontal | sbHandleKeyboard);
 scrollbar->setParams(0,0,255-(r.b.x-r.a.x),40,1);
 MsgList->hScrollBar = scrollbar;
 insert(MsgList);
}

void TEdMsgDialog::changeBounds(const TRect &r)
{
  TDialog::changeBounds(r);
  MsgWindowRect = r;
}

void TEdMsgDialog::close(void)
{
 hide();
}

static void InsertInHelper(void)
{
 if (!SearchInHelper(dktMessage,MsgWindow))
   {
    TDskWinMessage *p=new TDskWinMessage(MsgWindow);
    AddNonEditorToHelper(p);
   }
}

TEdMsgDialog *EdMessageWindowInit(int Insert)
{
 // If allready initialized return
 if (MsgWindow)
   {
    MsgCol->removeAll();
    Stack->Clean();
    MsgWindow->hide();
    if (Insert)
       InsertInHelper();
    return MsgWindow;
   }
 // Create an stack for the messages:
 Stack=new SOStack;
 if (!Stack)
    return MsgWindow;
 // Create the list:
 MsgCol=new TSOSCol(8,6,Stack);
 if (!MsgCol)
    return MsgWindow;
 // Create the dialog:
 if (MsgWindowRect.a.x==-1)
   {
    MsgWindowRect = TProgram::deskTop->getExtent();
    MsgWindowRect.a.y = MsgWindowRect.b.y-7;
   }
 MsgWindow=new TEdMsgDialog(MsgWindowRect,_("Message Window"));
 if (!MsgWindow)
   return MsgWindow;
 MsgList=MsgWindow->MsgList; // Global alias
 MsgList->newList(MsgCol);

 if (Insert)
   {
    // Insert it hided because is empty
    TProgram::deskTop->lock();
    TProgram::deskTop->insert(MsgWindow);
    MsgWindow->hide();
    TProgram::deskTop->unlock();
    InsertInHelper();
   }

 return MsgWindow;
}

void EdShowMessage(char *msg,Boolean remove_old)
{
 if (!MsgWindow || remove_old)
    EdMessageWindowInit();
 if (!msg)
    return;
 stkHandler aux=Stack->addStr(msg);
 if (aux==stkNULL)
    return;
 MsgCol->insert(aux);

 TProgram::deskTop->lock();
 if (MsgList->hScrollBar)
    MsgList->hScrollBar->setValue(0);
 MsgWindow->show();
 MsgWindow->select();
 MsgList->setRange(MsgCol->getCount());
 MsgList->focusItem(MsgCol->getCount()-1);
 MsgWindow->drawView();
 TProgram::deskTop->unlock();
}

int EdMessageCantMessages(void)
{
 return MsgCol->getCount();
}
