// PLASMA.CPP

// Thomas Hagen 1994
// thomash@edb.tih.no

// This program creates the common plasma-effect. It could be vastly
// improved upon by using tripple-buffering in mode-x, but I just don't feel
// like doing it.

#include <dos.h>
#include <stdio.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <alloc.h>

void main(void)
{
	randomize();
	char *data=(char*)farmalloc(70000l);
	if (!data)
	{
		printf("Not enough free memory.\n\n");
    exit(1);
	}
	for (float x=0; x<256; x++)
	for (float y=0; y<256; y++)
		data[x+256*y]=83*(3+(cos(0.09*sqrt((x-128)*(x-128)+(y-128)*(y-128))))+
		cos(x/21.0)+cos(y/26.0));
	_AX=0x13;
	asm int 0x10
	outportb(0x3c8,0);
	for (int r=0; r<256; r++)
	{
		outportb(0x3c9,(char)(sin(r*M_PI*2/64)*31.0+31));
		outportb(0x3c9,(char)(sin(r*M_PI*2/128)*31.0+31));
		outportb(0x3c9,(char)(sin(r*M_PI*2/256)*31.0+31));
	}
	for (float teller=0;teller<30000; teller++)
	{
		int pl1=48+cos(teller/37)*47.0+256*(int)(48+47*(sin(teller/31)));
		int pl2=48+sin(teller/24)*47.0+256*(int)(48+47*(cos(teller/19)))-pl1;
		_ES=0xa000;
		asm xor di,di
		asm push ds
		asm lds si,data
		asm add si,pl1
		asm mov bx,pl2
		asm pusha
		asm mov cl,100
l1: asm mov dx,160
l2: asm lodsb
		asm add al,[si+bx]
		asm mov ah,al
		asm mov es:[di+320],ax
		asm stosw
		asm dec dx
		asm jnz l2
		asm add si,256-160
		asm add di,320
		asm dec cl
		asm jnz l1
		asm popa
		asm pop ds
		if (kbhit())
			teller=30000;
	}
	farfree(data);
	_AX=3;
	asm int 0x10
}