#include <dir.h>
#include <dos.h>
#include <errno.h>
#include "lm.h"
#include "readdir.h"

#define	SECONDS_MASK	31
#define	MINUTES_SHIFT	5
#define	MINUTES_MASK	63
#define	HOURS_SHIFT		6
#define	DAY_MASK			31
#define	MONTH_SHIFT		5
#define	MONTH_MASK		15
#define	YEAR_SHIFT		4

static struct ffblk ffBlk;

typedef struct {
	struct {
		char	ReadOnly;
		char	Hidden;
		char	System;
		char	Label;
		char	Directory;
		char	Archive;
	} Attr;

	long	Time;
	long	Date;
	long	FileSize;
	char	FileName[12];

} DirType;

/***************
/	CopyEntry()
/***************/
void CopyEntry ( DirType *DirEntry )
{
	register unsigned int X, Seconds, Minutes;


	/* ---------- File Attributes ---------- */
	DirEntry->Attr.ReadOnly		= ffBlk.ff_attrib & FA_RDONLY;
	DirEntry->Attr.Hidden		= ffBlk.ff_attrib & FA_HIDDEN;
	DirEntry->Attr.System		= ffBlk.ff_attrib & FA_SYSTEM;
	DirEntry->Attr.Label			= ffBlk.ff_attrib & FA_LABEL;
	DirEntry->Attr.Directory	= ffBlk.ff_attrib & FA_DIREC;
	DirEntry->Attr.Archive		= ffBlk.ff_attrib & FA_ARCH;

	/* ---------- Creation Time ---------- */
	Seconds			= (X = ffBlk.ff_ftime) & SECONDS_MASK;
	Minutes			= (X >>= MINUTES_SHIFT) & MINUTES_MASK;
	DirEntry->Time	= time2abs((X >>= HOURS_SHIFT), Minutes,
									Seconds, (unsigned) 0);


	/* ---------- Creation Date ---------- */
	#define	Day		Seconds
	#define	Month		Minutes
	Day	= (X = ffBlk.ff_fdate) & DAY_MASK;
	Month = (X >>= MONTH_SHIFT) & MONTH_MASK;
	DirEntry->Date = date2abs(Month, Day, (X >>= YEAR_SHIFT)+1980);
	#undef	Day
	#undef	Month

	/* ---------- File Size ---------- */
	DirEntry->FileSize = ffBlk.ff_fsize;

	/* ---------- File Name ---------- */
	#define InString Seconds
	for (X=0, InString=1; X < sizeof(DirEntry->FileName); X++) {
		if (!ffBlk.ff_name[X]) InString=0;
		DirEntry->FileName[X] = (InString) ? ffBlk.ff_name[X] : ' ';
	}
	#undef InString
}

/****************
/	FindFirstC()
/****************/
void pascal FindFirstC (	char		*MaskParm,
									int		MaskLen,
									DirType	*DirEntry )
{
	char	Mask[13];

	strncpy(Mask, MaskParm, MaskLen);
	Mask[MaskLen] = '\0';

	if (findfirst(Mask, &ffBlk,	FA_RDONLY | FA_HIDDEN | FA_SYSTEM |
											FA_LABEL  | FA_DIREC  | FA_ARCH ) != -1)
		CopyEntry(DirEntry);

	else setclaerr(errno);
}

/***************
/	FindNextC()
/***************/
void pascal FindNextC ( DirType *DirEntry )
{
	if (findnext(&ffBlk) != -1)
		CopyEntry(DirEntry);
	else
		setclaerr(errno);
}

