	PAGE	60,120
;----------------------------------------------------------------------------;
;
;   LEM MODULE: READDIR.ASM
;
;----------------------------------------------------------------------------;
_TEXT	SEGMENT PUBLIC BYTE 'CODE'
_TEXT	ENDS
_DATA	SEGMENT PUBLIC BYTE 'DATA'
_DATA	ENDS
_BSS	SEGMENT PUBLIC BYTE 'BSS'
_BSS	ENDS
_END	SEGMENT PUBLIC BYTE 'LEMEND'
_END	ENDS
DGROUP	GROUP	_TEXT,_DATA,_BSS,_END


; L.E.M.  equates
TSTRING EQU	0			;String
TSHORT	EQU	1			;Signed word (16 bits)
TLONG	EQU	2			;Signed double word (32 bits)
TREAL	EQU	4			;Double precision float (8087)
PROCEDURE	EQU	0		;L.E.M. procedure
FUNCTION	EQU	1		;L.E.M. function
NAMELTH = 0				;Define NAMELTH for macro


;----------------------------------------------------------------------------;
; L.E.M.  macro
;	ROUTINE 'ROUTINE NAME', ROUTINE_PROC_LABEL, ROUTINE_TYPE,
;			NUMBER_OF_PARAMETERS
;----------------------------------------------------------------------------;


ROUTINE MACRO	RNAME, RPROC, RTYPE, RPARMS
	LOCAL	LBLSTRT
LBLSTRT DB	&RNAME
NAMELTH =	$-LBLSTRT		;;Padd name with nulls to 13 bytes
	IF NAMELTH GT 12
	  .ERR
	  %OUT routine name too long
	ELSE
	  DB	13-NAMELTH DUP (0)	;;Rest of name area
	  DW	&RPROC			;;Offset within binary module
	  DB	&RTYPE			;;Routine type = PROCEDURE or FUNCTION
	  DB	&RPARMS			;;Number of parameters
	ENDIF
	ENDM				;;End of macro


;----------------------------------------------------------------------------;
; L.E.M.  macro
;	PARAMETER LABEL_OF_PARAMETER, TYPE_OF_PARAMETER
;----------------------------------------------------------------------------;

PARAMETER	MACRO	PLBL, PTYPE
	DB	&PTYPE			;;Type = STRING, SHORT, LONG, or REAL
&PLBL	DD	0			;;Address of PARAMETER data
&PLBL&L DW	0			;;Length of PARAMETER data
	ENDM


	EXTRN	FINDFIRSTC:NEAR
	EXTRN	FINDNEXTC:NEAR

;------------------------------------------

_TEXT	SEGMENT PUBLIC BYTE 'CODE'
	ASSUME CS:DGROUP,DS:DGROUP

	DB	'BIO'
	PUBLIC	LIBVEC
LIBVEC	DD	0
	DW	DGROUP:BINEND
	DB	 2			;NUMBER OF ROUTINES


;------------------------------------------

	ROUTINE		'FINDFIRST', ASM_FINDFIRST, PROCEDURE, 2
	PARAMETER	ASM_FINDFIRST1,TSTRING
	PARAMETER	ASM_FINDFIRST2,TSTRING

;------------------------------------------

	ROUTINE		'FINDNEXT', ASM_FINDNEXT, PROCEDURE, 1
	PARAMETER	ASM_FINDNEXT1,TSTRING

;------------------------------------------

	PUBLIC	_errno
_errno	DW	0


;------------------------------------------

;	Calling your 'Pascal' function as follows
; findfirstc( (char *) a, (int) a_len, (char *) b );

ASM_FINDFIRST	PROC	FAR
	LES	BX,ASM_FINDFIRST1
	PUSH	ES
	PUSH	BX
	MOV	AX,ASM_FINDFIRST1L
	PUSH	AX

	LES	BX,ASM_FINDFIRST2
	PUSH	ES
	PUSH	BX

	CALL	FINDFIRSTC			;Calling your 'Pascal' function!!!

	RET
ASM_FINDFIRST	ENDP


;------------------------------------------

;	Calling your 'Pascal' function as follows
; findnextc( (char *) a );

ASM_FINDNEXT	PROC	FAR
	LES	BX,ASM_FINDNEXT1
	PUSH	ES
	PUSH	BX

	CALL	FINDNEXTC			;Calling your 'Pascal' function!!!

	RET
ASM_FINDNEXT	ENDP

;----------------------------------------------------------------------------;
; setclaerr(int error_code)
; Set error returned by ERROR() and ERRORCODE()
;----------------------------------------------------------------------------;

	PUBLIC	_setclaerr
_setclaerr PROC NEAR
	PUSH	BP
	MOV	BP,SP
	PUSH	ES		;Save used registers
	PUSH	DI
	MOV	AH,0FFh		;Get address of GLOBERR
	MOV	AL,29
	CALL	DWORD PTR LIBVEC
	MOV	AX,4[BP]	;Get error code
	MOV	ES:[DI],AX	;Set GLOBERR
	POP	DI		;Restore used registers
	POP	ES
	POP	BP
	RET			;Return to caller in L.E.M.
_setclaerr ENDP

_TEXT	ENDS

_END	SEGMENT PUBLIC BYTE 'LEMEND'
BINEND	DB	0
_END	ENDS
	END
